//autogenerated:yes
//nolint:revive,misspell,govet,lll
package asluav

// ASL-fixed-wing controller data
type MessageAslctrlData struct {
	// Timestamp
	Timestamp uint64
	// ASLCTRL control-mode (manual, stabilized, auto, etc...)
	AslctrlMode uint8
	// See sourcecode for a description of these values...
	H     float32
	Href  float32 `mavname:"hRef"`
	HrefT float32 `mavname:"hRef_t"`
	// Pitch angle
	Pitchangle float32 `mavname:"PitchAngle"`
	// Pitch angle reference
	Pitchangleref float32 `mavname:"PitchAngleRef"`
	Q             float32
	Qref          float32 `mavname:"qRef"`
	Uelev         float32 `mavname:"uElev"`
	Uthrot        float32 `mavname:"uThrot"`
	Uthrot2       float32 `mavname:"uThrot2"`
	Nz            float32 `mavname:"nZ"`
	// Airspeed reference
	Airspeedref     float32 `mavname:"AirspeedRef"`
	Spoilersengaged uint8   `mavname:"SpoilersEngaged"`
	// Yaw angle
	Yawangle float32 `mavname:"YawAngle"`
	// Yaw angle reference
	Yawangleref float32 `mavname:"YawAngleRef"`
	// Roll angle
	Rollangle float32 `mavname:"RollAngle"`
	// Roll angle reference
	Rollangleref float32 `mavname:"RollAngleRef"`
	P            float32
	Pref         float32 `mavname:"pRef"`
	R            float32
	Rref         float32 `mavname:"rRef"`
	Uail         float32 `mavname:"uAil"`
	Urud         float32 `mavname:"uRud"`
}

// GetID implements the message.Message interface.
func (*MessageAslctrlData) GetID() uint32 {
	return 8004
}
