//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Actions for reading/writing parameters between persistent and volatile storage when using MAV_CMD_PREFLIGHT_STORAGE.
// (Commonly parameters are loaded from persistent storage (flash/EEPROM) into volatile storage (RAM) on startup and written back when they are changed.)
type PREFLIGHT_STORAGE_PARAMETER_ACTION uint64

const (
	// Read all parameters from persistent storage. Replaces values in volatile storage.
	PARAM_READ_PERSISTENT PREFLIGHT_STORAGE_PARAMETER_ACTION = 0
	// Write all parameter values to persistent storage (flash/EEPROM)
	PARAM_WRITE_PERSISTENT PREFLIGHT_STORAGE_PARAMETER_ACTION = 1
	// Reset all user configurable parameters to their default value (including airframe selection, sensor calibration data, safety settings, and so on). Does not reset values that contain operation counters and vehicle computed statistics.
	PARAM_RESET_CONFIG_DEFAULT PREFLIGHT_STORAGE_PARAMETER_ACTION = 2
	// Reset only sensor calibration parameters to factory defaults (or firmware default if not available)
	PARAM_RESET_SENSOR_DEFAULT PREFLIGHT_STORAGE_PARAMETER_ACTION = 3
	// Reset all parameters, including operation counters, to default values
	PARAM_RESET_ALL_DEFAULT PREFLIGHT_STORAGE_PARAMETER_ACTION = 4
)

var value_to_label_PREFLIGHT_STORAGE_PARAMETER_ACTION = map[PREFLIGHT_STORAGE_PARAMETER_ACTION]string{
	PARAM_READ_PERSISTENT:      "PARAM_READ_PERSISTENT",
	PARAM_WRITE_PERSISTENT:     "PARAM_WRITE_PERSISTENT",
	PARAM_RESET_CONFIG_DEFAULT: "PARAM_RESET_CONFIG_DEFAULT",
	PARAM_RESET_SENSOR_DEFAULT: "PARAM_RESET_SENSOR_DEFAULT",
	PARAM_RESET_ALL_DEFAULT:    "PARAM_RESET_ALL_DEFAULT",
}

var label_to_value_PREFLIGHT_STORAGE_PARAMETER_ACTION = map[string]PREFLIGHT_STORAGE_PARAMETER_ACTION{
	"PARAM_READ_PERSISTENT":      PARAM_READ_PERSISTENT,
	"PARAM_WRITE_PERSISTENT":     PARAM_WRITE_PERSISTENT,
	"PARAM_RESET_CONFIG_DEFAULT": PARAM_RESET_CONFIG_DEFAULT,
	"PARAM_RESET_SENSOR_DEFAULT": PARAM_RESET_SENSOR_DEFAULT,
	"PARAM_RESET_ALL_DEFAULT":    PARAM_RESET_ALL_DEFAULT,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e PREFLIGHT_STORAGE_PARAMETER_ACTION) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_PREFLIGHT_STORAGE_PARAMETER_ACTION[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *PREFLIGHT_STORAGE_PARAMETER_ACTION) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_PREFLIGHT_STORAGE_PARAMETER_ACTION[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = PREFLIGHT_STORAGE_PARAMETER_ACTION(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e PREFLIGHT_STORAGE_PARAMETER_ACTION) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
