//autogenerated:yes
//nolint:revive,misspell,govet,lll
package common

// Battery information that is static, or requires infrequent update.
// This message should requested using MAV_CMD_REQUEST_MESSAGE and/or streamed at very low rate.
// BATTERY_STATUS_V2 is used for higher-rate battery status information.
type MessageBatteryInfo struct {
	// Battery ID
	Id uint8
	// Function of the battery.
	BatteryFunction MAV_BATTERY_FUNCTION `mavenum:"uint8"`
	// Type (chemistry) of the battery.
	Type MAV_BATTERY_TYPE `mavenum:"uint8"`
	// State of Health (SOH) estimate. Typically 100% at the time of manufacture and will decrease over time and use. -1: field not provided.
	StateOfHealth uint8
	// Number of battery cells in series. 0: field not provided.
	CellsInSeries uint8
	// Lifetime count of the number of charge/discharge cycles (https://en.wikipedia.org/wiki/Charge_cycle). UINT16_MAX: field not provided.
	CycleCount uint16
	// Battery weight. 0: field not provided.
	Weight uint16
	// Minimum per-cell voltage when discharging. 0: field not provided.
	DischargeMinimumVoltage float32
	// Minimum per-cell voltage when charging. 0: field not provided.
	ChargingMinimumVoltage float32
	// Minimum per-cell voltage when resting. 0: field not provided.
	RestingMinimumVoltage float32
	// Maximum per-cell voltage when charged. 0: field not provided.
	ChargingMaximumVoltage float32
	// Maximum pack continuous charge current. 0: field not provided.
	ChargingMaximumCurrent float32
	// Battery nominal voltage. Used for conversion between Wh and Ah. 0: field not provided.
	NominalVoltage float32
	// Maximum pack discharge current. 0: field not provided.
	DischargeMaximumCurrent float32
	// Maximum pack discharge burst current. 0: field not provided.
	DischargeMaximumBurstCurrent float32
	// Fully charged design capacity. 0: field not provided.
	DesignCapacity float32
	// Predicted battery capacity when fully charged (accounting for battery degradation). NAN: field not provided.
	FullChargeCapacity float32
	// Manufacture date (DDMMYYYY) in ASCII characters, 0 terminated. All 0: field not provided.
	ManufactureDate string `mavlen:"9"`
	// Serial number in ASCII characters, 0 terminated. All 0: field not provided.
	SerialNumber string `mavlen:"32"`
	// Battery device name. Formatted as manufacturer name then product name, separated with an underscore (in ASCII characters), 0 terminated. All 0: field not provided.
	Name string `mavlen:"50"`
}

// GetID implements the message.Message interface.
func (*MessageBatteryInfo) GetID() uint32 {
	return 372
}
