/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.uuid.impl;

import com.fasterxml.uuid.StringArgGenerator;
import com.fasterxml.uuid.UUIDType;
import com.fasterxml.uuid.impl.LoggerFacade;
import com.fasterxml.uuid.impl.UUIDUtil;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.UUID;

public class NameBasedGenerator
extends StringArgGenerator {
    public static final Charset _utf8 = Charset.forName("UTF-8");
    private final LoggerFacade _logger = LoggerFacade.getLogger(this.getClass());
    public static final UUID NAMESPACE_DNS = UUID.fromString("6ba7b810-9dad-11d1-80b4-00c04fd430c8");
    public static final UUID NAMESPACE_URL = UUID.fromString("6ba7b811-9dad-11d1-80b4-00c04fd430c8");
    public static final UUID NAMESPACE_OID = UUID.fromString("6ba7b812-9dad-11d1-80b4-00c04fd430c8");
    public static final UUID NAMESPACE_X500 = UUID.fromString("6ba7b814-9dad-11d1-80b4-00c04fd430c8");
    protected final UUID _namespace;
    protected final MessageDigest _digester;
    protected final UUIDType _type;

    public NameBasedGenerator(UUID namespace, MessageDigest digester, UUIDType type) {
        this._namespace = namespace;
        if (digester == null) {
            throw new IllegalArgumentException("Digester not optional: cannot pass `null`");
        }
        if (type == null) {
            String typeStr = digester.getAlgorithm();
            if (typeStr.startsWith("MD5")) {
                type = UUIDType.NAME_BASED_MD5;
            } else if (typeStr.startsWith("SHA")) {
                type = UUIDType.NAME_BASED_SHA1;
            } else {
                type = UUIDType.NAME_BASED_SHA1;
                this._logger.warn("Could not determine type of Digester from '%s'; assuming 'SHA-1' type", typeStr);
            }
        }
        this._digester = digester;
        this._type = type;
    }

    @Override
    public UUIDType getType() {
        return this._type;
    }

    public UUID getNamespace() {
        return this._namespace;
    }

    @Override
    public UUID generate(String name) {
        return this.generate(name.getBytes(_utf8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID generate(byte[] nameBytes) {
        byte[] digest;
        MessageDigest messageDigest = this._digester;
        synchronized (messageDigest) {
            this._digester.reset();
            if (this._namespace != null) {
                this._digester.update(UUIDUtil.asByteArray(this._namespace));
            }
            this._digester.update(nameBytes);
            digest = this._digester.digest();
        }
        return UUIDUtil.constructUUID(this._type, digest);
    }
}

