// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlplogs "go.opentelemetry.io/proto/slim/otlp/logs/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyScopeLogs(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeLogs() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewScopeLogs()
				CopyScopeLogs(dest, src)
				assert.Equal(t, src, dest)
				CopyScopeLogs(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyScopeLogsSlice(t *testing.T) {
	src := []ScopeLogs{}
	dest := []ScopeLogs{}
	// Test CopyTo empty
	dest = CopyScopeLogsSlice(dest, src)
	assert.Equal(t, []ScopeLogs{}, dest)

	// Test CopyTo larger slice
	src = GenTestScopeLogsSlice()
	dest = CopyScopeLogsSlice(dest, src)
	assert.Equal(t, GenTestScopeLogsSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyScopeLogsSlice(dest, src)
	assert.Equal(t, GenTestScopeLogsSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyScopeLogsSlice(dest, []ScopeLogs{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyScopeLogsSlice(dest, src)
	assert.Equal(t, GenTestScopeLogsSlice(), dest)
}

func TestCopyScopeLogsPtrSlice(t *testing.T) {
	src := []*ScopeLogs{}
	dest := []*ScopeLogs{}
	// Test CopyTo empty
	dest = CopyScopeLogsPtrSlice(dest, src)
	assert.Equal(t, []*ScopeLogs{}, dest)

	// Test CopyTo larger slice
	src = GenTestScopeLogsPtrSlice()
	dest = CopyScopeLogsPtrSlice(dest, src)
	assert.Equal(t, GenTestScopeLogsPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyScopeLogsPtrSlice(dest, src)
	assert.Equal(t, GenTestScopeLogsPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyScopeLogsPtrSlice(dest, []*ScopeLogs{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyScopeLogsPtrSlice(dest, src)
	assert.Equal(t, GenTestScopeLogsPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONScopeLogsUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewScopeLogs()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewScopeLogs(), dest)
}

func TestMarshalAndUnmarshalJSONScopeLogs(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeLogs() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewScopeLogs()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteScopeLogs(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoScopeLogsFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesScopeLogs() {
		t.Run(name, func(t *testing.T) {
			dest := NewScopeLogs()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoScopeLogsUnknown(t *testing.T) {
	dest := NewScopeLogs()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewScopeLogs(), dest)
}

func TestMarshalAndUnmarshalProtoScopeLogs(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeLogs() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewScopeLogs()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteScopeLogs(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufScopeLogs(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeLogs() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlplogs.ScopeLogs{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewScopeLogs()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesScopeLogs() map[string][]byte {
	return map[string][]byte{
		"invalid_field":              {0x02},
		"Scope/wrong_wire_type":      {0xc},
		"Scope/missing_value":        {0xa},
		"LogRecords/wrong_wire_type": {0x14},
		"LogRecords/missing_value":   {0x12},
		"SchemaUrl/wrong_wire_type":  {0x1c},
		"SchemaUrl/missing_value":    {0x1a},
	}
}

func genTestEncodingValuesScopeLogs() map[string]*ScopeLogs {
	return map[string]*ScopeLogs{
		"empty":           NewScopeLogs(),
		"Scope/test":      {Scope: *GenTestInstrumentationScope()},
		"LogRecords/test": {LogRecords: []*LogRecord{{}, GenTestLogRecord()}},
		"SchemaUrl/test":  {SchemaUrl: "test_schemaurl"},
	}
}
