// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package ptrace

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestSpan_MoveTo(t *testing.T) {
	ms := generateTestSpan()
	dest := NewSpan()
	ms.MoveTo(dest)
	assert.Equal(t, NewSpan(), ms)
	assert.Equal(t, generateTestSpan(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestSpan(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newSpan(internal.NewSpan(), sharedState)) })
	assert.Panics(t, func() { newSpan(internal.NewSpan(), sharedState).MoveTo(dest) })
}

func TestSpan_CopyTo(t *testing.T) {
	ms := NewSpan()
	orig := NewSpan()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestSpan()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newSpan(internal.NewSpan(), sharedState)) })
}

func TestSpan_TraceID(t *testing.T) {
	ms := NewSpan()
	assert.Equal(t, pcommon.TraceID(internal.TraceID([16]byte{})), ms.TraceID())
	testValTraceID := pcommon.TraceID(internal.TraceID([16]byte{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1}))
	ms.SetTraceID(testValTraceID)
	assert.Equal(t, testValTraceID, ms.TraceID())
}

func TestSpan_SpanID(t *testing.T) {
	ms := NewSpan()
	assert.Equal(t, pcommon.SpanID(internal.SpanID([8]byte{})), ms.SpanID())
	testValSpanID := pcommon.SpanID(internal.SpanID([8]byte{8, 7, 6, 5, 4, 3, 2, 1}))
	ms.SetSpanID(testValSpanID)
	assert.Equal(t, testValSpanID, ms.SpanID())
}

func TestSpan_TraceState(t *testing.T) {
	ms := NewSpan()
	assert.Equal(t, pcommon.NewTraceState(), ms.TraceState())
	ms.orig.TraceState = *internal.GenTestTraceState()
	assert.Equal(t, pcommon.TraceState(internal.GenTestTraceStateWrapper()), ms.TraceState())
}

func TestSpan_ParentSpanID(t *testing.T) {
	ms := NewSpan()
	assert.Equal(t, pcommon.SpanID(internal.SpanID([8]byte{})), ms.ParentSpanID())
	testValParentSpanID := pcommon.SpanID(internal.SpanID([8]byte{8, 7, 6, 5, 4, 3, 2, 1}))
	ms.SetParentSpanID(testValParentSpanID)
	assert.Equal(t, testValParentSpanID, ms.ParentSpanID())
}

func TestSpan_Flags(t *testing.T) {
	ms := NewSpan()
	assert.Equal(t, uint32(0), ms.Flags())
	ms.SetFlags(uint32(13))
	assert.Equal(t, uint32(13), ms.Flags())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newSpan(internal.NewSpan(), sharedState).SetFlags(uint32(13)) })
}

func TestSpan_Name(t *testing.T) {
	ms := NewSpan()
	assert.Empty(t, ms.Name())
	ms.SetName("test_name")
	assert.Equal(t, "test_name", ms.Name())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newSpan(internal.NewSpan(), sharedState).SetName("test_name") })
}

func TestSpan_Kind(t *testing.T) {
	ms := NewSpan()
	assert.Equal(t, SpanKind(internal.SpanKind_SPAN_KIND_UNSPECIFIED), ms.Kind())
	testValKind := SpanKind(internal.SpanKind_SPAN_KIND_CLIENT)
	ms.SetKind(testValKind)
	assert.Equal(t, testValKind, ms.Kind())
}

func TestSpan_StartTimestamp(t *testing.T) {
	ms := NewSpan()
	assert.Equal(t, pcommon.Timestamp(0), ms.StartTimestamp())
	testValStartTimestamp := pcommon.Timestamp(1234567890)
	ms.SetStartTimestamp(testValStartTimestamp)
	assert.Equal(t, testValStartTimestamp, ms.StartTimestamp())
}

func TestSpan_EndTimestamp(t *testing.T) {
	ms := NewSpan()
	assert.Equal(t, pcommon.Timestamp(0), ms.EndTimestamp())
	testValEndTimestamp := pcommon.Timestamp(1234567890)
	ms.SetEndTimestamp(testValEndTimestamp)
	assert.Equal(t, testValEndTimestamp, ms.EndTimestamp())
}

func TestSpan_Attributes(t *testing.T) {
	ms := NewSpan()
	assert.Equal(t, pcommon.NewMap(), ms.Attributes())
	ms.orig.Attributes = internal.GenTestKeyValueSlice()
	assert.Equal(t, pcommon.Map(internal.GenTestMapWrapper()), ms.Attributes())
}

func TestSpan_DroppedAttributesCount(t *testing.T) {
	ms := NewSpan()
	assert.Equal(t, uint32(0), ms.DroppedAttributesCount())
	ms.SetDroppedAttributesCount(uint32(13))
	assert.Equal(t, uint32(13), ms.DroppedAttributesCount())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newSpan(internal.NewSpan(), sharedState).SetDroppedAttributesCount(uint32(13)) })
}

func TestSpan_Events(t *testing.T) {
	ms := NewSpan()
	assert.Equal(t, NewSpanEventSlice(), ms.Events())
	ms.orig.Events = internal.GenTestSpanEventPtrSlice()
	assert.Equal(t, generateTestSpanEventSlice(), ms.Events())
}

func TestSpan_DroppedEventsCount(t *testing.T) {
	ms := NewSpan()
	assert.Equal(t, uint32(0), ms.DroppedEventsCount())
	ms.SetDroppedEventsCount(uint32(13))
	assert.Equal(t, uint32(13), ms.DroppedEventsCount())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newSpan(internal.NewSpan(), sharedState).SetDroppedEventsCount(uint32(13)) })
}

func TestSpan_Links(t *testing.T) {
	ms := NewSpan()
	assert.Equal(t, NewSpanLinkSlice(), ms.Links())
	ms.orig.Links = internal.GenTestSpanLinkPtrSlice()
	assert.Equal(t, generateTestSpanLinkSlice(), ms.Links())
}

func TestSpan_DroppedLinksCount(t *testing.T) {
	ms := NewSpan()
	assert.Equal(t, uint32(0), ms.DroppedLinksCount())
	ms.SetDroppedLinksCount(uint32(13))
	assert.Equal(t, uint32(13), ms.DroppedLinksCount())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newSpan(internal.NewSpan(), sharedState).SetDroppedLinksCount(uint32(13)) })
}

func TestSpan_Status(t *testing.T) {
	ms := NewSpan()
	assert.Equal(t, NewStatus(), ms.Status())
	ms.orig.Status = *internal.GenTestStatus()
	assert.Equal(t, generateTestStatus(), ms.Status())
}

func generateTestSpan() Span {
	return newSpan(internal.GenTestSpan(), internal.NewState())
}
