package fetch

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"fmt"
	"strings"

	"github.com/chromedp/cdproto/network"
)

// RequestID unique request identifier. Note that this does not identify
// individual HTTP requests that are part of a network request.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Fetch#type-RequestId
type RequestID string

// String returns the RequestID as string value.
func (t RequestID) String() string {
	return string(t)
}

// RequestStage stages of the request to handle. Request will intercept
// before the request is sent. Response will intercept after the response is
// received (but before response body is received).
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Fetch#type-RequestStage
type RequestStage string

// String returns the RequestStage as string value.
func (t RequestStage) String() string {
	return string(t)
}

// RequestStage values.
const (
	RequestStageRequest  RequestStage = "Request"
	RequestStageResponse RequestStage = "Response"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *RequestStage) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch RequestStage(s) {
	case RequestStageRequest:
		*t = RequestStageRequest
	case RequestStageResponse:
		*t = RequestStageResponse
	default:
		return fmt.Errorf("unknown RequestStage value: %v", s)
	}
	return nil
}

// RequestPattern [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Fetch#type-RequestPattern
type RequestPattern struct {
	URLPattern   string               `json:"urlPattern,omitempty,omitzero"`   // Wildcards ('*' -> zero or more, '?' -> exactly one) are allowed. Escape character is backslash. Omitting is equivalent to "*".
	ResourceType network.ResourceType `json:"resourceType,omitempty,omitzero"` // If set, only requests for matching resource types will be intercepted.
	RequestStage RequestStage         `json:"requestStage,omitempty,omitzero"` // Stage at which to begin intercepting requests. Default is Request.
}

// HeaderEntry response HTTP header entry.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Fetch#type-HeaderEntry
type HeaderEntry struct {
	Name  string `json:"name"`
	Value string `json:"value"`
}

// AuthChallenge authorization challenge for HTTP status code 401 or 407.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Fetch#type-AuthChallenge
type AuthChallenge struct {
	Source AuthChallengeSource `json:"source,omitempty,omitzero"` // Source of the authentication challenge.
	Origin string              `json:"origin"`                    // Origin of the challenger.
	Scheme string              `json:"scheme"`                    // The authentication scheme used, such as basic or digest
	Realm  string              `json:"realm"`                     // The realm of the challenge. May be empty.
}

// AuthChallengeResponse response to an AuthChallenge.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Fetch#type-AuthChallengeResponse
type AuthChallengeResponse struct {
	Response AuthChallengeResponseResponse `json:"response"`                    // The decision on what to do in response to the authorization challenge.  Default means deferring to the default behavior of the net stack, which will likely either the Cancel authentication or display a popup dialog box.
	Username string                        `json:"username,omitempty,omitzero"` // The username to provide, possibly empty. Should only be set if response is ProvideCredentials.
	Password string                        `json:"password,omitempty,omitzero"` // The password to provide, possibly empty. Should only be set if response is ProvideCredentials.
}

// AuthChallengeSource source of the authentication challenge.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Fetch#type-AuthChallenge
type AuthChallengeSource string

// String returns the AuthChallengeSource as string value.
func (t AuthChallengeSource) String() string {
	return string(t)
}

// AuthChallengeSource values.
const (
	AuthChallengeSourceServer AuthChallengeSource = "Server"
	AuthChallengeSourceProxy  AuthChallengeSource = "Proxy"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *AuthChallengeSource) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch AuthChallengeSource(s) {
	case AuthChallengeSourceServer:
		*t = AuthChallengeSourceServer
	case AuthChallengeSourceProxy:
		*t = AuthChallengeSourceProxy
	default:
		return fmt.Errorf("unknown AuthChallengeSource value: %v", s)
	}
	return nil
}

// AuthChallengeResponseResponse the decision on what to do in response to
// the authorization challenge. Default means deferring to the default behavior
// of the net stack, which will likely either the Cancel authentication or
// display a popup dialog box.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Fetch#type-AuthChallengeResponse
type AuthChallengeResponseResponse string

// String returns the AuthChallengeResponseResponse as string value.
func (t AuthChallengeResponseResponse) String() string {
	return string(t)
}

// AuthChallengeResponseResponse values.
const (
	AuthChallengeResponseResponseDefault            AuthChallengeResponseResponse = "Default"
	AuthChallengeResponseResponseCancelAuth         AuthChallengeResponseResponse = "CancelAuth"
	AuthChallengeResponseResponseProvideCredentials AuthChallengeResponseResponse = "ProvideCredentials"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *AuthChallengeResponseResponse) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch AuthChallengeResponseResponse(s) {
	case AuthChallengeResponseResponseDefault:
		*t = AuthChallengeResponseResponseDefault
	case AuthChallengeResponseResponseCancelAuth:
		*t = AuthChallengeResponseResponseCancelAuth
	case AuthChallengeResponseResponseProvideCredentials:
		*t = AuthChallengeResponseResponseProvideCredentials
	default:
		return fmt.Errorf("unknown AuthChallengeResponseResponse value: %v", s)
	}
	return nil
}
