// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/v2/conversation.proto

package dialogflowpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Conversations_CreateConversation_FullMethodName          = "/google.cloud.dialogflow.v2.Conversations/CreateConversation"
	Conversations_ListConversations_FullMethodName           = "/google.cloud.dialogflow.v2.Conversations/ListConversations"
	Conversations_GetConversation_FullMethodName             = "/google.cloud.dialogflow.v2.Conversations/GetConversation"
	Conversations_CompleteConversation_FullMethodName        = "/google.cloud.dialogflow.v2.Conversations/CompleteConversation"
	Conversations_IngestContextReferences_FullMethodName     = "/google.cloud.dialogflow.v2.Conversations/IngestContextReferences"
	Conversations_ListMessages_FullMethodName                = "/google.cloud.dialogflow.v2.Conversations/ListMessages"
	Conversations_SuggestConversationSummary_FullMethodName  = "/google.cloud.dialogflow.v2.Conversations/SuggestConversationSummary"
	Conversations_GenerateStatelessSummary_FullMethodName    = "/google.cloud.dialogflow.v2.Conversations/GenerateStatelessSummary"
	Conversations_GenerateStatelessSuggestion_FullMethodName = "/google.cloud.dialogflow.v2.Conversations/GenerateStatelessSuggestion"
	Conversations_SearchKnowledge_FullMethodName             = "/google.cloud.dialogflow.v2.Conversations/SearchKnowledge"
	Conversations_GenerateSuggestions_FullMethodName         = "/google.cloud.dialogflow.v2.Conversations/GenerateSuggestions"
)

// ConversationsClient is the client API for Conversations service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ConversationsClient interface {
	// Creates a new conversation. Conversations are auto-completed after 24
	// hours.
	//
	// Conversation Lifecycle:
	// There are two stages during a conversation: Automated Agent Stage and
	// Assist Stage.
	//
	// For Automated Agent Stage, there will be a dialogflow agent responding to
	// user queries.
	//
	// For Assist Stage, there's no dialogflow agent responding to user queries.
	// But we will provide suggestions which are generated from conversation.
	//
	// If
	// [Conversation.conversation_profile][google.cloud.dialogflow.v2.Conversation.conversation_profile]
	// is configured for a dialogflow agent, conversation will start from
	// `Automated Agent Stage`, otherwise, it will start from `Assist Stage`. And
	// during `Automated Agent Stage`, once an
	// [Intent][google.cloud.dialogflow.v2.Intent] with
	// [Intent.live_agent_handoff][google.cloud.dialogflow.v2.Intent.live_agent_handoff]
	// is triggered, conversation will transfer to Assist Stage.
	CreateConversation(ctx context.Context, in *CreateConversationRequest, opts ...grpc.CallOption) (*Conversation, error)
	// Returns the list of all conversations in the specified project.
	ListConversations(ctx context.Context, in *ListConversationsRequest, opts ...grpc.CallOption) (*ListConversationsResponse, error)
	// Retrieves the specific conversation.
	GetConversation(ctx context.Context, in *GetConversationRequest, opts ...grpc.CallOption) (*Conversation, error)
	// Completes the specified conversation. Finished conversations are purged
	// from the database after 30 days.
	CompleteConversation(ctx context.Context, in *CompleteConversationRequest, opts ...grpc.CallOption) (*Conversation, error)
	// Data ingestion API.
	// Ingests context references for an existing conversation.
	IngestContextReferences(ctx context.Context, in *IngestContextReferencesRequest, opts ...grpc.CallOption) (*IngestContextReferencesResponse, error)
	// Lists messages that belong to a given conversation.
	// `messages` are ordered by `create_time` in descending order. To fetch
	// updates without duplication, send request with filter
	// `create_time_epoch_microseconds >
	// [first item's create_time of previous request]` and empty page_token.
	ListMessages(ctx context.Context, in *ListMessagesRequest, opts ...grpc.CallOption) (*ListMessagesResponse, error)
	// Suggests summary for a conversation based on specific historical messages.
	// The range of the messages to be used for summary can be specified in the
	// request.
	SuggestConversationSummary(ctx context.Context, in *SuggestConversationSummaryRequest, opts ...grpc.CallOption) (*SuggestConversationSummaryResponse, error)
	// Generates and returns a summary for a conversation that does not have a
	// resource created for it.
	GenerateStatelessSummary(ctx context.Context, in *GenerateStatelessSummaryRequest, opts ...grpc.CallOption) (*GenerateStatelessSummaryResponse, error)
	// Generates and returns a suggestion for a conversation that does not have a
	// resource created for it.
	GenerateStatelessSuggestion(ctx context.Context, in *GenerateStatelessSuggestionRequest, opts ...grpc.CallOption) (*GenerateStatelessSuggestionResponse, error)
	// Get answers for the given query based on knowledge documents.
	SearchKnowledge(ctx context.Context, in *SearchKnowledgeRequest, opts ...grpc.CallOption) (*SearchKnowledgeResponse, error)
	// Generates all the suggestions using generators configured in the
	// conversation profile. A generator is used only if its trigger event is
	// matched.
	GenerateSuggestions(ctx context.Context, in *GenerateSuggestionsRequest, opts ...grpc.CallOption) (*GenerateSuggestionsResponse, error)
}

type conversationsClient struct {
	cc grpc.ClientConnInterface
}

func NewConversationsClient(cc grpc.ClientConnInterface) ConversationsClient {
	return &conversationsClient{cc}
}

func (c *conversationsClient) CreateConversation(ctx context.Context, in *CreateConversationRequest, opts ...grpc.CallOption) (*Conversation, error) {
	out := new(Conversation)
	err := c.cc.Invoke(ctx, Conversations_CreateConversation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationsClient) ListConversations(ctx context.Context, in *ListConversationsRequest, opts ...grpc.CallOption) (*ListConversationsResponse, error) {
	out := new(ListConversationsResponse)
	err := c.cc.Invoke(ctx, Conversations_ListConversations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationsClient) GetConversation(ctx context.Context, in *GetConversationRequest, opts ...grpc.CallOption) (*Conversation, error) {
	out := new(Conversation)
	err := c.cc.Invoke(ctx, Conversations_GetConversation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationsClient) CompleteConversation(ctx context.Context, in *CompleteConversationRequest, opts ...grpc.CallOption) (*Conversation, error) {
	out := new(Conversation)
	err := c.cc.Invoke(ctx, Conversations_CompleteConversation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationsClient) IngestContextReferences(ctx context.Context, in *IngestContextReferencesRequest, opts ...grpc.CallOption) (*IngestContextReferencesResponse, error) {
	out := new(IngestContextReferencesResponse)
	err := c.cc.Invoke(ctx, Conversations_IngestContextReferences_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationsClient) ListMessages(ctx context.Context, in *ListMessagesRequest, opts ...grpc.CallOption) (*ListMessagesResponse, error) {
	out := new(ListMessagesResponse)
	err := c.cc.Invoke(ctx, Conversations_ListMessages_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationsClient) SuggestConversationSummary(ctx context.Context, in *SuggestConversationSummaryRequest, opts ...grpc.CallOption) (*SuggestConversationSummaryResponse, error) {
	out := new(SuggestConversationSummaryResponse)
	err := c.cc.Invoke(ctx, Conversations_SuggestConversationSummary_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationsClient) GenerateStatelessSummary(ctx context.Context, in *GenerateStatelessSummaryRequest, opts ...grpc.CallOption) (*GenerateStatelessSummaryResponse, error) {
	out := new(GenerateStatelessSummaryResponse)
	err := c.cc.Invoke(ctx, Conversations_GenerateStatelessSummary_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationsClient) GenerateStatelessSuggestion(ctx context.Context, in *GenerateStatelessSuggestionRequest, opts ...grpc.CallOption) (*GenerateStatelessSuggestionResponse, error) {
	out := new(GenerateStatelessSuggestionResponse)
	err := c.cc.Invoke(ctx, Conversations_GenerateStatelessSuggestion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationsClient) SearchKnowledge(ctx context.Context, in *SearchKnowledgeRequest, opts ...grpc.CallOption) (*SearchKnowledgeResponse, error) {
	out := new(SearchKnowledgeResponse)
	err := c.cc.Invoke(ctx, Conversations_SearchKnowledge_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationsClient) GenerateSuggestions(ctx context.Context, in *GenerateSuggestionsRequest, opts ...grpc.CallOption) (*GenerateSuggestionsResponse, error) {
	out := new(GenerateSuggestionsResponse)
	err := c.cc.Invoke(ctx, Conversations_GenerateSuggestions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConversationsServer is the server API for Conversations service.
// All implementations should embed UnimplementedConversationsServer
// for forward compatibility
type ConversationsServer interface {
	// Creates a new conversation. Conversations are auto-completed after 24
	// hours.
	//
	// Conversation Lifecycle:
	// There are two stages during a conversation: Automated Agent Stage and
	// Assist Stage.
	//
	// For Automated Agent Stage, there will be a dialogflow agent responding to
	// user queries.
	//
	// For Assist Stage, there's no dialogflow agent responding to user queries.
	// But we will provide suggestions which are generated from conversation.
	//
	// If
	// [Conversation.conversation_profile][google.cloud.dialogflow.v2.Conversation.conversation_profile]
	// is configured for a dialogflow agent, conversation will start from
	// `Automated Agent Stage`, otherwise, it will start from `Assist Stage`. And
	// during `Automated Agent Stage`, once an
	// [Intent][google.cloud.dialogflow.v2.Intent] with
	// [Intent.live_agent_handoff][google.cloud.dialogflow.v2.Intent.live_agent_handoff]
	// is triggered, conversation will transfer to Assist Stage.
	CreateConversation(context.Context, *CreateConversationRequest) (*Conversation, error)
	// Returns the list of all conversations in the specified project.
	ListConversations(context.Context, *ListConversationsRequest) (*ListConversationsResponse, error)
	// Retrieves the specific conversation.
	GetConversation(context.Context, *GetConversationRequest) (*Conversation, error)
	// Completes the specified conversation. Finished conversations are purged
	// from the database after 30 days.
	CompleteConversation(context.Context, *CompleteConversationRequest) (*Conversation, error)
	// Data ingestion API.
	// Ingests context references for an existing conversation.
	IngestContextReferences(context.Context, *IngestContextReferencesRequest) (*IngestContextReferencesResponse, error)
	// Lists messages that belong to a given conversation.
	// `messages` are ordered by `create_time` in descending order. To fetch
	// updates without duplication, send request with filter
	// `create_time_epoch_microseconds >
	// [first item's create_time of previous request]` and empty page_token.
	ListMessages(context.Context, *ListMessagesRequest) (*ListMessagesResponse, error)
	// Suggests summary for a conversation based on specific historical messages.
	// The range of the messages to be used for summary can be specified in the
	// request.
	SuggestConversationSummary(context.Context, *SuggestConversationSummaryRequest) (*SuggestConversationSummaryResponse, error)
	// Generates and returns a summary for a conversation that does not have a
	// resource created for it.
	GenerateStatelessSummary(context.Context, *GenerateStatelessSummaryRequest) (*GenerateStatelessSummaryResponse, error)
	// Generates and returns a suggestion for a conversation that does not have a
	// resource created for it.
	GenerateStatelessSuggestion(context.Context, *GenerateStatelessSuggestionRequest) (*GenerateStatelessSuggestionResponse, error)
	// Get answers for the given query based on knowledge documents.
	SearchKnowledge(context.Context, *SearchKnowledgeRequest) (*SearchKnowledgeResponse, error)
	// Generates all the suggestions using generators configured in the
	// conversation profile. A generator is used only if its trigger event is
	// matched.
	GenerateSuggestions(context.Context, *GenerateSuggestionsRequest) (*GenerateSuggestionsResponse, error)
}

// UnimplementedConversationsServer should be embedded to have forward compatible implementations.
type UnimplementedConversationsServer struct {
}

func (UnimplementedConversationsServer) CreateConversation(context.Context, *CreateConversationRequest) (*Conversation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConversation not implemented")
}
func (UnimplementedConversationsServer) ListConversations(context.Context, *ListConversationsRequest) (*ListConversationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConversations not implemented")
}
func (UnimplementedConversationsServer) GetConversation(context.Context, *GetConversationRequest) (*Conversation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversation not implemented")
}
func (UnimplementedConversationsServer) CompleteConversation(context.Context, *CompleteConversationRequest) (*Conversation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CompleteConversation not implemented")
}
func (UnimplementedConversationsServer) IngestContextReferences(context.Context, *IngestContextReferencesRequest) (*IngestContextReferencesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IngestContextReferences not implemented")
}
func (UnimplementedConversationsServer) ListMessages(context.Context, *ListMessagesRequest) (*ListMessagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMessages not implemented")
}
func (UnimplementedConversationsServer) SuggestConversationSummary(context.Context, *SuggestConversationSummaryRequest) (*SuggestConversationSummaryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SuggestConversationSummary not implemented")
}
func (UnimplementedConversationsServer) GenerateStatelessSummary(context.Context, *GenerateStatelessSummaryRequest) (*GenerateStatelessSummaryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateStatelessSummary not implemented")
}
func (UnimplementedConversationsServer) GenerateStatelessSuggestion(context.Context, *GenerateStatelessSuggestionRequest) (*GenerateStatelessSuggestionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateStatelessSuggestion not implemented")
}
func (UnimplementedConversationsServer) SearchKnowledge(context.Context, *SearchKnowledgeRequest) (*SearchKnowledgeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchKnowledge not implemented")
}
func (UnimplementedConversationsServer) GenerateSuggestions(context.Context, *GenerateSuggestionsRequest) (*GenerateSuggestionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateSuggestions not implemented")
}

// UnsafeConversationsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ConversationsServer will
// result in compilation errors.
type UnsafeConversationsServer interface {
	mustEmbedUnimplementedConversationsServer()
}

func RegisterConversationsServer(s grpc.ServiceRegistrar, srv ConversationsServer) {
	s.RegisterService(&Conversations_ServiceDesc, srv)
}

func _Conversations_CreateConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).CreateConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversations_CreateConversation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).CreateConversation(ctx, req.(*CreateConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversations_ListConversations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).ListConversations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversations_ListConversations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).ListConversations(ctx, req.(*ListConversationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversations_GetConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).GetConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversations_GetConversation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).GetConversation(ctx, req.(*GetConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversations_CompleteConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CompleteConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).CompleteConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversations_CompleteConversation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).CompleteConversation(ctx, req.(*CompleteConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversations_IngestContextReferences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IngestContextReferencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).IngestContextReferences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversations_IngestContextReferences_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).IngestContextReferences(ctx, req.(*IngestContextReferencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversations_ListMessages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMessagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).ListMessages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversations_ListMessages_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).ListMessages(ctx, req.(*ListMessagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversations_SuggestConversationSummary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SuggestConversationSummaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).SuggestConversationSummary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversations_SuggestConversationSummary_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).SuggestConversationSummary(ctx, req.(*SuggestConversationSummaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversations_GenerateStatelessSummary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateStatelessSummaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).GenerateStatelessSummary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversations_GenerateStatelessSummary_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).GenerateStatelessSummary(ctx, req.(*GenerateStatelessSummaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversations_GenerateStatelessSuggestion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateStatelessSuggestionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).GenerateStatelessSuggestion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversations_GenerateStatelessSuggestion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).GenerateStatelessSuggestion(ctx, req.(*GenerateStatelessSuggestionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversations_SearchKnowledge_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchKnowledgeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).SearchKnowledge(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversations_SearchKnowledge_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).SearchKnowledge(ctx, req.(*SearchKnowledgeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Conversations_GenerateSuggestions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateSuggestionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationsServer).GenerateSuggestions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Conversations_GenerateSuggestions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationsServer).GenerateSuggestions(ctx, req.(*GenerateSuggestionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Conversations_ServiceDesc is the grpc.ServiceDesc for Conversations service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Conversations_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.Conversations",
	HandlerType: (*ConversationsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateConversation",
			Handler:    _Conversations_CreateConversation_Handler,
		},
		{
			MethodName: "ListConversations",
			Handler:    _Conversations_ListConversations_Handler,
		},
		{
			MethodName: "GetConversation",
			Handler:    _Conversations_GetConversation_Handler,
		},
		{
			MethodName: "CompleteConversation",
			Handler:    _Conversations_CompleteConversation_Handler,
		},
		{
			MethodName: "IngestContextReferences",
			Handler:    _Conversations_IngestContextReferences_Handler,
		},
		{
			MethodName: "ListMessages",
			Handler:    _Conversations_ListMessages_Handler,
		},
		{
			MethodName: "SuggestConversationSummary",
			Handler:    _Conversations_SuggestConversationSummary_Handler,
		},
		{
			MethodName: "GenerateStatelessSummary",
			Handler:    _Conversations_GenerateStatelessSummary_Handler,
		},
		{
			MethodName: "GenerateStatelessSuggestion",
			Handler:    _Conversations_GenerateStatelessSuggestion_Handler,
		},
		{
			MethodName: "SearchKnowledge",
			Handler:    _Conversations_SearchKnowledge_Handler,
		},
		{
			MethodName: "GenerateSuggestions",
			Handler:    _Conversations_GenerateSuggestions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2/conversation.proto",
}
