// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/cx/v3/agent.proto

package cxpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Agents_ListAgents_FullMethodName               = "/google.cloud.dialogflow.cx.v3.Agents/ListAgents"
	Agents_GetAgent_FullMethodName                 = "/google.cloud.dialogflow.cx.v3.Agents/GetAgent"
	Agents_CreateAgent_FullMethodName              = "/google.cloud.dialogflow.cx.v3.Agents/CreateAgent"
	Agents_UpdateAgent_FullMethodName              = "/google.cloud.dialogflow.cx.v3.Agents/UpdateAgent"
	Agents_DeleteAgent_FullMethodName              = "/google.cloud.dialogflow.cx.v3.Agents/DeleteAgent"
	Agents_ExportAgent_FullMethodName              = "/google.cloud.dialogflow.cx.v3.Agents/ExportAgent"
	Agents_RestoreAgent_FullMethodName             = "/google.cloud.dialogflow.cx.v3.Agents/RestoreAgent"
	Agents_ValidateAgent_FullMethodName            = "/google.cloud.dialogflow.cx.v3.Agents/ValidateAgent"
	Agents_GetAgentValidationResult_FullMethodName = "/google.cloud.dialogflow.cx.v3.Agents/GetAgentValidationResult"
	Agents_GetGenerativeSettings_FullMethodName    = "/google.cloud.dialogflow.cx.v3.Agents/GetGenerativeSettings"
	Agents_UpdateGenerativeSettings_FullMethodName = "/google.cloud.dialogflow.cx.v3.Agents/UpdateGenerativeSettings"
)

// AgentsClient is the client API for Agents service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AgentsClient interface {
	// Returns the list of all agents in the specified location.
	ListAgents(ctx context.Context, in *ListAgentsRequest, opts ...grpc.CallOption) (*ListAgentsResponse, error)
	// Retrieves the specified agent.
	GetAgent(ctx context.Context, in *GetAgentRequest, opts ...grpc.CallOption) (*Agent, error)
	// Creates an agent in the specified location.
	//
	// Note: You should always train flows prior to sending them queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	CreateAgent(ctx context.Context, in *CreateAgentRequest, opts ...grpc.CallOption) (*Agent, error)
	// Updates the specified agent.
	//
	// Note: You should always train flows prior to sending them queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	UpdateAgent(ctx context.Context, in *UpdateAgentRequest, opts ...grpc.CallOption) (*Agent, error)
	// Deletes the specified agent.
	DeleteAgent(ctx context.Context, in *DeleteAgentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Exports the specified agent to a binary file.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`:
	//
	// [ExportAgentResponse][google.cloud.dialogflow.cx.v3.ExportAgentResponse]
	ExportAgent(ctx context.Context, in *ExportAgentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Restores the specified agent from a binary file.
	//
	// Replaces the current agent with a new one. Note that all existing resources
	// in agent (e.g. intents, entity types, flows) will be removed.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	//
	// Note: You should always train flows prior to sending them queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	RestoreAgent(ctx context.Context, in *RestoreAgentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Validates the specified agent and creates or updates validation results.
	// The agent in draft version is validated. Please call this API after the
	// training is completed to get the complete validation results.
	ValidateAgent(ctx context.Context, in *ValidateAgentRequest, opts ...grpc.CallOption) (*AgentValidationResult, error)
	// Gets the latest agent validation result. Agent validation is performed
	// when ValidateAgent is called.
	GetAgentValidationResult(ctx context.Context, in *GetAgentValidationResultRequest, opts ...grpc.CallOption) (*AgentValidationResult, error)
	// Gets the generative settings for the agent.
	GetGenerativeSettings(ctx context.Context, in *GetGenerativeSettingsRequest, opts ...grpc.CallOption) (*GenerativeSettings, error)
	// Updates the generative settings for the agent.
	UpdateGenerativeSettings(ctx context.Context, in *UpdateGenerativeSettingsRequest, opts ...grpc.CallOption) (*GenerativeSettings, error)
}

type agentsClient struct {
	cc grpc.ClientConnInterface
}

func NewAgentsClient(cc grpc.ClientConnInterface) AgentsClient {
	return &agentsClient{cc}
}

func (c *agentsClient) ListAgents(ctx context.Context, in *ListAgentsRequest, opts ...grpc.CallOption) (*ListAgentsResponse, error) {
	out := new(ListAgentsResponse)
	err := c.cc.Invoke(ctx, Agents_ListAgents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) GetAgent(ctx context.Context, in *GetAgentRequest, opts ...grpc.CallOption) (*Agent, error) {
	out := new(Agent)
	err := c.cc.Invoke(ctx, Agents_GetAgent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) CreateAgent(ctx context.Context, in *CreateAgentRequest, opts ...grpc.CallOption) (*Agent, error) {
	out := new(Agent)
	err := c.cc.Invoke(ctx, Agents_CreateAgent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) UpdateAgent(ctx context.Context, in *UpdateAgentRequest, opts ...grpc.CallOption) (*Agent, error) {
	out := new(Agent)
	err := c.cc.Invoke(ctx, Agents_UpdateAgent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) DeleteAgent(ctx context.Context, in *DeleteAgentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Agents_DeleteAgent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) ExportAgent(ctx context.Context, in *ExportAgentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Agents_ExportAgent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) RestoreAgent(ctx context.Context, in *RestoreAgentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Agents_RestoreAgent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) ValidateAgent(ctx context.Context, in *ValidateAgentRequest, opts ...grpc.CallOption) (*AgentValidationResult, error) {
	out := new(AgentValidationResult)
	err := c.cc.Invoke(ctx, Agents_ValidateAgent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) GetAgentValidationResult(ctx context.Context, in *GetAgentValidationResultRequest, opts ...grpc.CallOption) (*AgentValidationResult, error) {
	out := new(AgentValidationResult)
	err := c.cc.Invoke(ctx, Agents_GetAgentValidationResult_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) GetGenerativeSettings(ctx context.Context, in *GetGenerativeSettingsRequest, opts ...grpc.CallOption) (*GenerativeSettings, error) {
	out := new(GenerativeSettings)
	err := c.cc.Invoke(ctx, Agents_GetGenerativeSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) UpdateGenerativeSettings(ctx context.Context, in *UpdateGenerativeSettingsRequest, opts ...grpc.CallOption) (*GenerativeSettings, error) {
	out := new(GenerativeSettings)
	err := c.cc.Invoke(ctx, Agents_UpdateGenerativeSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AgentsServer is the server API for Agents service.
// All implementations should embed UnimplementedAgentsServer
// for forward compatibility
type AgentsServer interface {
	// Returns the list of all agents in the specified location.
	ListAgents(context.Context, *ListAgentsRequest) (*ListAgentsResponse, error)
	// Retrieves the specified agent.
	GetAgent(context.Context, *GetAgentRequest) (*Agent, error)
	// Creates an agent in the specified location.
	//
	// Note: You should always train flows prior to sending them queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	CreateAgent(context.Context, *CreateAgentRequest) (*Agent, error)
	// Updates the specified agent.
	//
	// Note: You should always train flows prior to sending them queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	UpdateAgent(context.Context, *UpdateAgentRequest) (*Agent, error)
	// Deletes the specified agent.
	DeleteAgent(context.Context, *DeleteAgentRequest) (*emptypb.Empty, error)
	// Exports the specified agent to a binary file.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`:
	//
	// [ExportAgentResponse][google.cloud.dialogflow.cx.v3.ExportAgentResponse]
	ExportAgent(context.Context, *ExportAgentRequest) (*longrunningpb.Operation, error)
	// Restores the specified agent from a binary file.
	//
	// Replaces the current agent with a new one. Note that all existing resources
	// in agent (e.g. intents, entity types, flows) will be removed.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	//
	// Note: You should always train flows prior to sending them queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	RestoreAgent(context.Context, *RestoreAgentRequest) (*longrunningpb.Operation, error)
	// Validates the specified agent and creates or updates validation results.
	// The agent in draft version is validated. Please call this API after the
	// training is completed to get the complete validation results.
	ValidateAgent(context.Context, *ValidateAgentRequest) (*AgentValidationResult, error)
	// Gets the latest agent validation result. Agent validation is performed
	// when ValidateAgent is called.
	GetAgentValidationResult(context.Context, *GetAgentValidationResultRequest) (*AgentValidationResult, error)
	// Gets the generative settings for the agent.
	GetGenerativeSettings(context.Context, *GetGenerativeSettingsRequest) (*GenerativeSettings, error)
	// Updates the generative settings for the agent.
	UpdateGenerativeSettings(context.Context, *UpdateGenerativeSettingsRequest) (*GenerativeSettings, error)
}

// UnimplementedAgentsServer should be embedded to have forward compatible implementations.
type UnimplementedAgentsServer struct {
}

func (UnimplementedAgentsServer) ListAgents(context.Context, *ListAgentsRequest) (*ListAgentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAgents not implemented")
}
func (UnimplementedAgentsServer) GetAgent(context.Context, *GetAgentRequest) (*Agent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAgent not implemented")
}
func (UnimplementedAgentsServer) CreateAgent(context.Context, *CreateAgentRequest) (*Agent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAgent not implemented")
}
func (UnimplementedAgentsServer) UpdateAgent(context.Context, *UpdateAgentRequest) (*Agent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAgent not implemented")
}
func (UnimplementedAgentsServer) DeleteAgent(context.Context, *DeleteAgentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAgent not implemented")
}
func (UnimplementedAgentsServer) ExportAgent(context.Context, *ExportAgentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportAgent not implemented")
}
func (UnimplementedAgentsServer) RestoreAgent(context.Context, *RestoreAgentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreAgent not implemented")
}
func (UnimplementedAgentsServer) ValidateAgent(context.Context, *ValidateAgentRequest) (*AgentValidationResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateAgent not implemented")
}
func (UnimplementedAgentsServer) GetAgentValidationResult(context.Context, *GetAgentValidationResultRequest) (*AgentValidationResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAgentValidationResult not implemented")
}
func (UnimplementedAgentsServer) GetGenerativeSettings(context.Context, *GetGenerativeSettingsRequest) (*GenerativeSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGenerativeSettings not implemented")
}
func (UnimplementedAgentsServer) UpdateGenerativeSettings(context.Context, *UpdateGenerativeSettingsRequest) (*GenerativeSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGenerativeSettings not implemented")
}

// UnsafeAgentsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AgentsServer will
// result in compilation errors.
type UnsafeAgentsServer interface {
	mustEmbedUnimplementedAgentsServer()
}

func RegisterAgentsServer(s grpc.ServiceRegistrar, srv AgentsServer) {
	s.RegisterService(&Agents_ServiceDesc, srv)
}

func _Agents_ListAgents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAgentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).ListAgents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Agents_ListAgents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).ListAgents(ctx, req.(*ListAgentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_GetAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).GetAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Agents_GetAgent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).GetAgent(ctx, req.(*GetAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_CreateAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).CreateAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Agents_CreateAgent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).CreateAgent(ctx, req.(*CreateAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_UpdateAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).UpdateAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Agents_UpdateAgent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).UpdateAgent(ctx, req.(*UpdateAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_DeleteAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).DeleteAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Agents_DeleteAgent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).DeleteAgent(ctx, req.(*DeleteAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_ExportAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).ExportAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Agents_ExportAgent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).ExportAgent(ctx, req.(*ExportAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_RestoreAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).RestoreAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Agents_RestoreAgent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).RestoreAgent(ctx, req.(*RestoreAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_ValidateAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).ValidateAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Agents_ValidateAgent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).ValidateAgent(ctx, req.(*ValidateAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_GetAgentValidationResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAgentValidationResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).GetAgentValidationResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Agents_GetAgentValidationResult_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).GetAgentValidationResult(ctx, req.(*GetAgentValidationResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_GetGenerativeSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGenerativeSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).GetGenerativeSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Agents_GetGenerativeSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).GetGenerativeSettings(ctx, req.(*GetGenerativeSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_UpdateGenerativeSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGenerativeSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).UpdateGenerativeSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Agents_UpdateGenerativeSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).UpdateGenerativeSettings(ctx, req.(*UpdateGenerativeSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Agents_ServiceDesc is the grpc.ServiceDesc for Agents service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Agents_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3.Agents",
	HandlerType: (*AgentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListAgents",
			Handler:    _Agents_ListAgents_Handler,
		},
		{
			MethodName: "GetAgent",
			Handler:    _Agents_GetAgent_Handler,
		},
		{
			MethodName: "CreateAgent",
			Handler:    _Agents_CreateAgent_Handler,
		},
		{
			MethodName: "UpdateAgent",
			Handler:    _Agents_UpdateAgent_Handler,
		},
		{
			MethodName: "DeleteAgent",
			Handler:    _Agents_DeleteAgent_Handler,
		},
		{
			MethodName: "ExportAgent",
			Handler:    _Agents_ExportAgent_Handler,
		},
		{
			MethodName: "RestoreAgent",
			Handler:    _Agents_RestoreAgent_Handler,
		},
		{
			MethodName: "ValidateAgent",
			Handler:    _Agents_ValidateAgent_Handler,
		},
		{
			MethodName: "GetAgentValidationResult",
			Handler:    _Agents_GetAgentValidationResult_Handler,
		},
		{
			MethodName: "GetGenerativeSettings",
			Handler:    _Agents_GetGenerativeSettings_Handler,
		},
		{
			MethodName: "UpdateGenerativeSettings",
			Handler:    _Agents_UpdateGenerativeSettings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3/agent.proto",
}
