// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/talent/v4/job_service.proto

package talentpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	JobService_CreateJob_FullMethodName          = "/google.cloud.talent.v4.JobService/CreateJob"
	JobService_BatchCreateJobs_FullMethodName    = "/google.cloud.talent.v4.JobService/BatchCreateJobs"
	JobService_GetJob_FullMethodName             = "/google.cloud.talent.v4.JobService/GetJob"
	JobService_UpdateJob_FullMethodName          = "/google.cloud.talent.v4.JobService/UpdateJob"
	JobService_BatchUpdateJobs_FullMethodName    = "/google.cloud.talent.v4.JobService/BatchUpdateJobs"
	JobService_DeleteJob_FullMethodName          = "/google.cloud.talent.v4.JobService/DeleteJob"
	JobService_BatchDeleteJobs_FullMethodName    = "/google.cloud.talent.v4.JobService/BatchDeleteJobs"
	JobService_ListJobs_FullMethodName           = "/google.cloud.talent.v4.JobService/ListJobs"
	JobService_SearchJobs_FullMethodName         = "/google.cloud.talent.v4.JobService/SearchJobs"
	JobService_SearchJobsForAlert_FullMethodName = "/google.cloud.talent.v4.JobService/SearchJobsForAlert"
)

// JobServiceClient is the client API for JobService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type JobServiceClient interface {
	// Creates a new job.
	//
	// Typically, the job becomes searchable within 10 seconds, but it may take
	// up to 5 minutes.
	CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Begins executing a batch create jobs operation.
	BatchCreateJobs(ctx context.Context, in *BatchCreateJobsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Retrieves the specified job, whose status is OPEN or recently EXPIRED
	// within the last 90 days.
	GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Updates specified job.
	//
	// Typically, updated contents become visible in search results within 10
	// seconds, but it may take up to 5 minutes.
	UpdateJob(ctx context.Context, in *UpdateJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Begins executing a batch update jobs operation.
	BatchUpdateJobs(ctx context.Context, in *BatchUpdateJobsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes the specified job.
	//
	// Typically, the job becomes unsearchable within 10 seconds, but it may take
	// up to 5 minutes.
	DeleteJob(ctx context.Context, in *DeleteJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Begins executing a batch delete jobs operation.
	BatchDeleteJobs(ctx context.Context, in *BatchDeleteJobsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists jobs by filter.
	ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error)
	// Searches for jobs using the provided
	// [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
	//
	// This call constrains the
	// [visibility][google.cloud.talent.v4.Job.visibility] of jobs present in the
	// database, and only returns jobs that the caller has permission to search
	// against.
	SearchJobs(ctx context.Context, in *SearchJobsRequest, opts ...grpc.CallOption) (*SearchJobsResponse, error)
	// Searches for jobs using the provided
	// [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
	//
	// This API call is intended for the use case of targeting passive job
	// seekers (for example, job seekers who have signed up to receive email
	// alerts about potential job opportunities), it has different algorithmic
	// adjustments that are designed to specifically target passive job seekers.
	//
	// This call constrains the
	// [visibility][google.cloud.talent.v4.Job.visibility] of jobs present in the
	// database, and only returns jobs the caller has permission to search
	// against.
	SearchJobsForAlert(ctx context.Context, in *SearchJobsRequest, opts ...grpc.CallOption) (*SearchJobsResponse, error)
}

type jobServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewJobServiceClient(cc grpc.ClientConnInterface) JobServiceClient {
	return &jobServiceClient{cc}
}

func (c *jobServiceClient) CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, JobService_CreateJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) BatchCreateJobs(ctx context.Context, in *BatchCreateJobsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, JobService_BatchCreateJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, JobService_GetJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) UpdateJob(ctx context.Context, in *UpdateJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, JobService_UpdateJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) BatchUpdateJobs(ctx context.Context, in *BatchUpdateJobsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, JobService_BatchUpdateJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) DeleteJob(ctx context.Context, in *DeleteJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, JobService_DeleteJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) BatchDeleteJobs(ctx context.Context, in *BatchDeleteJobsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, JobService_BatchDeleteJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error) {
	out := new(ListJobsResponse)
	err := c.cc.Invoke(ctx, JobService_ListJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) SearchJobs(ctx context.Context, in *SearchJobsRequest, opts ...grpc.CallOption) (*SearchJobsResponse, error) {
	out := new(SearchJobsResponse)
	err := c.cc.Invoke(ctx, JobService_SearchJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) SearchJobsForAlert(ctx context.Context, in *SearchJobsRequest, opts ...grpc.CallOption) (*SearchJobsResponse, error) {
	out := new(SearchJobsResponse)
	err := c.cc.Invoke(ctx, JobService_SearchJobsForAlert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// JobServiceServer is the server API for JobService service.
// All implementations should embed UnimplementedJobServiceServer
// for forward compatibility
type JobServiceServer interface {
	// Creates a new job.
	//
	// Typically, the job becomes searchable within 10 seconds, but it may take
	// up to 5 minutes.
	CreateJob(context.Context, *CreateJobRequest) (*Job, error)
	// Begins executing a batch create jobs operation.
	BatchCreateJobs(context.Context, *BatchCreateJobsRequest) (*longrunningpb.Operation, error)
	// Retrieves the specified job, whose status is OPEN or recently EXPIRED
	// within the last 90 days.
	GetJob(context.Context, *GetJobRequest) (*Job, error)
	// Updates specified job.
	//
	// Typically, updated contents become visible in search results within 10
	// seconds, but it may take up to 5 minutes.
	UpdateJob(context.Context, *UpdateJobRequest) (*Job, error)
	// Begins executing a batch update jobs operation.
	BatchUpdateJobs(context.Context, *BatchUpdateJobsRequest) (*longrunningpb.Operation, error)
	// Deletes the specified job.
	//
	// Typically, the job becomes unsearchable within 10 seconds, but it may take
	// up to 5 minutes.
	DeleteJob(context.Context, *DeleteJobRequest) (*emptypb.Empty, error)
	// Begins executing a batch delete jobs operation.
	BatchDeleteJobs(context.Context, *BatchDeleteJobsRequest) (*longrunningpb.Operation, error)
	// Lists jobs by filter.
	ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error)
	// Searches for jobs using the provided
	// [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
	//
	// This call constrains the
	// [visibility][google.cloud.talent.v4.Job.visibility] of jobs present in the
	// database, and only returns jobs that the caller has permission to search
	// against.
	SearchJobs(context.Context, *SearchJobsRequest) (*SearchJobsResponse, error)
	// Searches for jobs using the provided
	// [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
	//
	// This API call is intended for the use case of targeting passive job
	// seekers (for example, job seekers who have signed up to receive email
	// alerts about potential job opportunities), it has different algorithmic
	// adjustments that are designed to specifically target passive job seekers.
	//
	// This call constrains the
	// [visibility][google.cloud.talent.v4.Job.visibility] of jobs present in the
	// database, and only returns jobs the caller has permission to search
	// against.
	SearchJobsForAlert(context.Context, *SearchJobsRequest) (*SearchJobsResponse, error)
}

// UnimplementedJobServiceServer should be embedded to have forward compatible implementations.
type UnimplementedJobServiceServer struct {
}

func (UnimplementedJobServiceServer) CreateJob(context.Context, *CreateJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateJob not implemented")
}
func (UnimplementedJobServiceServer) BatchCreateJobs(context.Context, *BatchCreateJobsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateJobs not implemented")
}
func (UnimplementedJobServiceServer) GetJob(context.Context, *GetJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJob not implemented")
}
func (UnimplementedJobServiceServer) UpdateJob(context.Context, *UpdateJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateJob not implemented")
}
func (UnimplementedJobServiceServer) BatchUpdateJobs(context.Context, *BatchUpdateJobsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdateJobs not implemented")
}
func (UnimplementedJobServiceServer) DeleteJob(context.Context, *DeleteJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteJob not implemented")
}
func (UnimplementedJobServiceServer) BatchDeleteJobs(context.Context, *BatchDeleteJobsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeleteJobs not implemented")
}
func (UnimplementedJobServiceServer) ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListJobs not implemented")
}
func (UnimplementedJobServiceServer) SearchJobs(context.Context, *SearchJobsRequest) (*SearchJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchJobs not implemented")
}
func (UnimplementedJobServiceServer) SearchJobsForAlert(context.Context, *SearchJobsRequest) (*SearchJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchJobsForAlert not implemented")
}

// UnsafeJobServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to JobServiceServer will
// result in compilation errors.
type UnsafeJobServiceServer interface {
	mustEmbedUnimplementedJobServiceServer()
}

func RegisterJobServiceServer(s grpc.ServiceRegistrar, srv JobServiceServer) {
	s.RegisterService(&JobService_ServiceDesc, srv)
}

func _JobService_CreateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).CreateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_CreateJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).CreateJob(ctx, req.(*CreateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_BatchCreateJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).BatchCreateJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_BatchCreateJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).BatchCreateJobs(ctx, req.(*BatchCreateJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_GetJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetJob(ctx, req.(*GetJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_UpdateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).UpdateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_UpdateJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).UpdateJob(ctx, req.(*UpdateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_BatchUpdateJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).BatchUpdateJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_BatchUpdateJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).BatchUpdateJobs(ctx, req.(*BatchUpdateJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_DeleteJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).DeleteJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_DeleteJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).DeleteJob(ctx, req.(*DeleteJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_BatchDeleteJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).BatchDeleteJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_BatchDeleteJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).BatchDeleteJobs(ctx, req.(*BatchDeleteJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_ListJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).ListJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_ListJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).ListJobs(ctx, req.(*ListJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_SearchJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).SearchJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_SearchJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).SearchJobs(ctx, req.(*SearchJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_SearchJobsForAlert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).SearchJobsForAlert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_SearchJobsForAlert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).SearchJobsForAlert(ctx, req.(*SearchJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// JobService_ServiceDesc is the grpc.ServiceDesc for JobService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var JobService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.talent.v4.JobService",
	HandlerType: (*JobServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateJob",
			Handler:    _JobService_CreateJob_Handler,
		},
		{
			MethodName: "BatchCreateJobs",
			Handler:    _JobService_BatchCreateJobs_Handler,
		},
		{
			MethodName: "GetJob",
			Handler:    _JobService_GetJob_Handler,
		},
		{
			MethodName: "UpdateJob",
			Handler:    _JobService_UpdateJob_Handler,
		},
		{
			MethodName: "BatchUpdateJobs",
			Handler:    _JobService_BatchUpdateJobs_Handler,
		},
		{
			MethodName: "DeleteJob",
			Handler:    _JobService_DeleteJob_Handler,
		},
		{
			MethodName: "BatchDeleteJobs",
			Handler:    _JobService_BatchDeleteJobs_Handler,
		},
		{
			MethodName: "ListJobs",
			Handler:    _JobService_ListJobs_Handler,
		},
		{
			MethodName: "SearchJobs",
			Handler:    _JobService_SearchJobs_Handler,
		},
		{
			MethodName: "SearchJobsForAlert",
			Handler:    _JobService_SearchJobsForAlert_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/talent/v4/job_service.proto",
}
