// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/documentai/v1beta3/document_service.proto

package documentaipb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Documents belonging to a dataset will be split into different groups
// referred to as splits: train, test.
type DatasetSplitType int32

const (
	// Default value if the enum is not set.
	DatasetSplitType_DATASET_SPLIT_TYPE_UNSPECIFIED DatasetSplitType = 0
	// Identifies the train documents.
	DatasetSplitType_DATASET_SPLIT_TRAIN DatasetSplitType = 1
	// Identifies the test documents.
	DatasetSplitType_DATASET_SPLIT_TEST DatasetSplitType = 2
	// Identifies the unassigned documents.
	DatasetSplitType_DATASET_SPLIT_UNASSIGNED DatasetSplitType = 3
)

// Enum value maps for DatasetSplitType.
var (
	DatasetSplitType_name = map[int32]string{
		0: "DATASET_SPLIT_TYPE_UNSPECIFIED",
		1: "DATASET_SPLIT_TRAIN",
		2: "DATASET_SPLIT_TEST",
		3: "DATASET_SPLIT_UNASSIGNED",
	}
	DatasetSplitType_value = map[string]int32{
		"DATASET_SPLIT_TYPE_UNSPECIFIED": 0,
		"DATASET_SPLIT_TRAIN":            1,
		"DATASET_SPLIT_TEST":             2,
		"DATASET_SPLIT_UNASSIGNED":       3,
	}
)

func (x DatasetSplitType) Enum() *DatasetSplitType {
	p := new(DatasetSplitType)
	*p = x
	return p
}

func (x DatasetSplitType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatasetSplitType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1beta3_document_service_proto_enumTypes[0].Descriptor()
}

func (DatasetSplitType) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1beta3_document_service_proto_enumTypes[0]
}

func (x DatasetSplitType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatasetSplitType.Descriptor instead.
func (DatasetSplitType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{0}
}

// Describes the labeling status of a document.
type DocumentLabelingState int32

const (
	// Default value if the enum is not set.
	DocumentLabelingState_DOCUMENT_LABELING_STATE_UNSPECIFIED DocumentLabelingState = 0
	// Document has been labeled.
	DocumentLabelingState_DOCUMENT_LABELED DocumentLabelingState = 1
	// Document has not been labeled.
	DocumentLabelingState_DOCUMENT_UNLABELED DocumentLabelingState = 2
	// Document has been auto-labeled.
	DocumentLabelingState_DOCUMENT_AUTO_LABELED DocumentLabelingState = 3
)

// Enum value maps for DocumentLabelingState.
var (
	DocumentLabelingState_name = map[int32]string{
		0: "DOCUMENT_LABELING_STATE_UNSPECIFIED",
		1: "DOCUMENT_LABELED",
		2: "DOCUMENT_UNLABELED",
		3: "DOCUMENT_AUTO_LABELED",
	}
	DocumentLabelingState_value = map[string]int32{
		"DOCUMENT_LABELING_STATE_UNSPECIFIED": 0,
		"DOCUMENT_LABELED":                    1,
		"DOCUMENT_UNLABELED":                  2,
		"DOCUMENT_AUTO_LABELED":               3,
	}
)

func (x DocumentLabelingState) Enum() *DocumentLabelingState {
	p := new(DocumentLabelingState)
	*p = x
	return p
}

func (x DocumentLabelingState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DocumentLabelingState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1beta3_document_service_proto_enumTypes[1].Descriptor()
}

func (DocumentLabelingState) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1beta3_document_service_proto_enumTypes[1]
}

func (x DocumentLabelingState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DocumentLabelingState.Descriptor instead.
func (DocumentLabelingState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{1}
}

type UpdateDatasetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `name` field of the `Dataset` is used to identify the
	// resource to be updated.
	Dataset *Dataset `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// The update mask applies to the resource.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDatasetRequest) Reset() {
	*x = UpdateDatasetRequest{}
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateDatasetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDatasetRequest) ProtoMessage() {}

func (x *UpdateDatasetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDatasetRequest.ProtoReflect.Descriptor instead.
func (*UpdateDatasetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{0}
}

func (x *UpdateDatasetRequest) GetDataset() *Dataset {
	if x != nil {
		return x.Dataset
	}
	return nil
}

func (x *UpdateDatasetRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

type UpdateDatasetOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The basic metadata of the long-running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
}

func (x *UpdateDatasetOperationMetadata) Reset() {
	*x = UpdateDatasetOperationMetadata{}
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateDatasetOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDatasetOperationMetadata) ProtoMessage() {}

func (x *UpdateDatasetOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDatasetOperationMetadata.ProtoReflect.Descriptor instead.
func (*UpdateDatasetOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{1}
}

func (x *UpdateDatasetOperationMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

type ImportDocumentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The dataset resource name.
	// Format:
	// projects/{project}/locations/{location}/processors/{processor}/dataset
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Required. The Cloud Storage uri containing raw documents that must be
	// imported.
	BatchDocumentsImportConfigs []*ImportDocumentsRequest_BatchDocumentsImportConfig `protobuf:"bytes,4,rep,name=batch_documents_import_configs,json=batchDocumentsImportConfigs,proto3" json:"batch_documents_import_configs,omitempty"`
}

func (x *ImportDocumentsRequest) Reset() {
	*x = ImportDocumentsRequest{}
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportDocumentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDocumentsRequest) ProtoMessage() {}

func (x *ImportDocumentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDocumentsRequest.ProtoReflect.Descriptor instead.
func (*ImportDocumentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{2}
}

func (x *ImportDocumentsRequest) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *ImportDocumentsRequest) GetBatchDocumentsImportConfigs() []*ImportDocumentsRequest_BatchDocumentsImportConfig {
	if x != nil {
		return x.BatchDocumentsImportConfigs
	}
	return nil
}

// Response of the import document operation.
type ImportDocumentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ImportDocumentsResponse) Reset() {
	*x = ImportDocumentsResponse{}
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportDocumentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDocumentsResponse) ProtoMessage() {}

func (x *ImportDocumentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDocumentsResponse.ProtoReflect.Descriptor instead.
func (*ImportDocumentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{3}
}

// Metadata of the import document operation.
type ImportDocumentsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The basic metadata of the long-running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
	// The list of response details of each document.
	IndividualImportStatuses []*ImportDocumentsMetadata_IndividualImportStatus `protobuf:"bytes,2,rep,name=individual_import_statuses,json=individualImportStatuses,proto3" json:"individual_import_statuses,omitempty"`
	// Validation statuses of the batch documents import config.
	ImportConfigValidationResults []*ImportDocumentsMetadata_ImportConfigValidationResult `protobuf:"bytes,4,rep,name=import_config_validation_results,json=importConfigValidationResults,proto3" json:"import_config_validation_results,omitempty"`
	// Total number of the documents that are qualified for importing.
	TotalDocumentCount int32 `protobuf:"varint,3,opt,name=total_document_count,json=totalDocumentCount,proto3" json:"total_document_count,omitempty"`
}

func (x *ImportDocumentsMetadata) Reset() {
	*x = ImportDocumentsMetadata{}
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportDocumentsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDocumentsMetadata) ProtoMessage() {}

func (x *ImportDocumentsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDocumentsMetadata.ProtoReflect.Descriptor instead.
func (*ImportDocumentsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{4}
}

func (x *ImportDocumentsMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

func (x *ImportDocumentsMetadata) GetIndividualImportStatuses() []*ImportDocumentsMetadata_IndividualImportStatus {
	if x != nil {
		return x.IndividualImportStatuses
	}
	return nil
}

func (x *ImportDocumentsMetadata) GetImportConfigValidationResults() []*ImportDocumentsMetadata_ImportConfigValidationResult {
	if x != nil {
		return x.ImportConfigValidationResults
	}
	return nil
}

func (x *ImportDocumentsMetadata) GetTotalDocumentCount() int32 {
	if x != nil {
		return x.TotalDocumentCount
	}
	return 0
}

type GetDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the dataset that the document belongs to .
	// Format:
	// projects/{project}/locations/{location}/processors/{processor}/dataset
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Required. Document identifier.
	DocumentId *DocumentId `protobuf:"bytes,2,opt,name=document_id,json=documentId,proto3" json:"document_id,omitempty"`
	// If set, only fields listed here will be returned. Otherwise, all fields
	// will be returned by default.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
	// List of pages for which the fields specified in the `read_mask` must
	// be served.
	PageRange *DocumentPageRange `protobuf:"bytes,4,opt,name=page_range,json=pageRange,proto3" json:"page_range,omitempty"`
}

func (x *GetDocumentRequest) Reset() {
	*x = GetDocumentRequest{}
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDocumentRequest) ProtoMessage() {}

func (x *GetDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDocumentRequest.ProtoReflect.Descriptor instead.
func (*GetDocumentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{5}
}

func (x *GetDocumentRequest) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *GetDocumentRequest) GetDocumentId() *DocumentId {
	if x != nil {
		return x.DocumentId
	}
	return nil
}

func (x *GetDocumentRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

func (x *GetDocumentRequest) GetPageRange() *DocumentPageRange {
	if x != nil {
		return x.PageRange
	}
	return nil
}

type GetDocumentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
}

func (x *GetDocumentResponse) Reset() {
	*x = GetDocumentResponse{}
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDocumentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDocumentResponse) ProtoMessage() {}

func (x *GetDocumentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDocumentResponse.ProtoReflect.Descriptor instead.
func (*GetDocumentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{6}
}

func (x *GetDocumentResponse) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

type ListDocumentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the dataset to be listed.
	// Format:
	// projects/{project}/locations/{location}/processors/{processor}/dataset
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// The maximum number of documents to return. The service may return
	// fewer than this value.
	// If unspecified, at most 20 documents will be returned.
	// The maximum value is 100; values above 100 will be coerced to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListDocuments` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListDocuments`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Query to filter the documents based on
	// https://google.aip.dev/160.
	// ## Currently support query strings are:
	//
	// `SplitType=DATASET_SPLIT_TEST|DATASET_SPLIT_TRAIN|DATASET_SPLIT_UNASSIGNED`
	// - `LabelingState=DOCUMENT_LABELED|DOCUMENT_UNLABELED|DOCUMENT_AUTO_LABELED`
	// - `DisplayName=\"file_name.pdf\"`
	// - `EntityType=abc/def`
	// - `TagName=\"auto-labeling-running\"|\"sampled\"`
	//
	// Note:
	//   - Only `AND`, `=` and `!=` are supported.
	//     e.g. `DisplayName=file_name AND EntityType!=abc` IS supported.
	//   - Wildcard `*` is supported only in `DisplayName` filter
	//   - No duplicate filter keys are allowed,
	//     e.g. `EntityType=a AND EntityType=b` is NOT supported.
	//   - String match is case sensitive (for filter `DisplayName` & `EntityType`).
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Controls if the request requires a total size of matched
	// documents. See
	// [ListDocumentsResponse.total_size][google.cloud.documentai.v1beta3.ListDocumentsResponse.total_size].
	//
	// Enabling this flag may adversely impact performance.
	//
	// Defaults to false.
	ReturnTotalSize bool `protobuf:"varint,6,opt,name=return_total_size,json=returnTotalSize,proto3" json:"return_total_size,omitempty"`
	// Optional. Number of results to skip beginning from the `page_token` if
	// provided. https://google.aip.dev/158#skipping-results. It must be a
	// non-negative integer. Negative values will be rejected. Note that this is
	// not the number of pages to skip. If this value causes the cursor to move
	// past the end of results,
	// [ListDocumentsResponse.document_metadata][google.cloud.documentai.v1beta3.ListDocumentsResponse.document_metadata]
	// and
	// [ListDocumentsResponse.next_page_token][google.cloud.documentai.v1beta3.ListDocumentsResponse.next_page_token]
	// will be empty.
	Skip int32 `protobuf:"varint,8,opt,name=skip,proto3" json:"skip,omitempty"`
}

func (x *ListDocumentsRequest) Reset() {
	*x = ListDocumentsRequest{}
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDocumentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDocumentsRequest) ProtoMessage() {}

func (x *ListDocumentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDocumentsRequest.ProtoReflect.Descriptor instead.
func (*ListDocumentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{7}
}

func (x *ListDocumentsRequest) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *ListDocumentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDocumentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDocumentsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDocumentsRequest) GetReturnTotalSize() bool {
	if x != nil {
		return x.ReturnTotalSize
	}
	return false
}

func (x *ListDocumentsRequest) GetSkip() int32 {
	if x != nil {
		return x.Skip
	}
	return 0
}

type ListDocumentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Document metadata corresponding to the listed documents.
	DocumentMetadata []*DocumentMetadata `protobuf:"bytes,1,rep,name=document_metadata,json=documentMetadata,proto3" json:"document_metadata,omitempty"`
	// A token, which can be sent as
	// [ListDocumentsRequest.page_token][google.cloud.documentai.v1beta3.ListDocumentsRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Total count of documents queried.
	TotalSize int32 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *ListDocumentsResponse) Reset() {
	*x = ListDocumentsResponse{}
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDocumentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDocumentsResponse) ProtoMessage() {}

func (x *ListDocumentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDocumentsResponse.ProtoReflect.Descriptor instead.
func (*ListDocumentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{8}
}

func (x *ListDocumentsResponse) GetDocumentMetadata() []*DocumentMetadata {
	if x != nil {
		return x.DocumentMetadata
	}
	return nil
}

func (x *ListDocumentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListDocumentsResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

type BatchDeleteDocumentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The dataset resource name.
	// Format:
	// projects/{project}/locations/{location}/processors/{processor}/dataset
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Required. Dataset documents input. If given `filter`, all documents
	// satisfying the filter will be deleted. If given documentIds, a maximum of
	// 50 documents can be deleted in a batch. The request will be rejected if
	// more than 50 document_ids are provided.
	DatasetDocuments *BatchDatasetDocuments `protobuf:"bytes,3,opt,name=dataset_documents,json=datasetDocuments,proto3" json:"dataset_documents,omitempty"`
}

func (x *BatchDeleteDocumentsRequest) Reset() {
	*x = BatchDeleteDocumentsRequest{}
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchDeleteDocumentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeleteDocumentsRequest) ProtoMessage() {}

func (x *BatchDeleteDocumentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeleteDocumentsRequest.ProtoReflect.Descriptor instead.
func (*BatchDeleteDocumentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{9}
}

func (x *BatchDeleteDocumentsRequest) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *BatchDeleteDocumentsRequest) GetDatasetDocuments() *BatchDatasetDocuments {
	if x != nil {
		return x.DatasetDocuments
	}
	return nil
}

// Response of the delete documents operation.
type BatchDeleteDocumentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BatchDeleteDocumentsResponse) Reset() {
	*x = BatchDeleteDocumentsResponse{}
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchDeleteDocumentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeleteDocumentsResponse) ProtoMessage() {}

func (x *BatchDeleteDocumentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeleteDocumentsResponse.ProtoReflect.Descriptor instead.
func (*BatchDeleteDocumentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{10}
}

type BatchDeleteDocumentsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The basic metadata of the long-running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
	// The list of response details of each document.
	IndividualBatchDeleteStatuses []*BatchDeleteDocumentsMetadata_IndividualBatchDeleteStatus `protobuf:"bytes,2,rep,name=individual_batch_delete_statuses,json=individualBatchDeleteStatuses,proto3" json:"individual_batch_delete_statuses,omitempty"`
	// Total number of documents deleting from dataset.
	TotalDocumentCount int32 `protobuf:"varint,3,opt,name=total_document_count,json=totalDocumentCount,proto3" json:"total_document_count,omitempty"`
	// Total number of documents that failed to be deleted in storage.
	ErrorDocumentCount int32 `protobuf:"varint,4,opt,name=error_document_count,json=errorDocumentCount,proto3" json:"error_document_count,omitempty"`
}

func (x *BatchDeleteDocumentsMetadata) Reset() {
	*x = BatchDeleteDocumentsMetadata{}
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchDeleteDocumentsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeleteDocumentsMetadata) ProtoMessage() {}

func (x *BatchDeleteDocumentsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeleteDocumentsMetadata.ProtoReflect.Descriptor instead.
func (*BatchDeleteDocumentsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{11}
}

func (x *BatchDeleteDocumentsMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

func (x *BatchDeleteDocumentsMetadata) GetIndividualBatchDeleteStatuses() []*BatchDeleteDocumentsMetadata_IndividualBatchDeleteStatus {
	if x != nil {
		return x.IndividualBatchDeleteStatuses
	}
	return nil
}

func (x *BatchDeleteDocumentsMetadata) GetTotalDocumentCount() int32 {
	if x != nil {
		return x.TotalDocumentCount
	}
	return 0
}

func (x *BatchDeleteDocumentsMetadata) GetErrorDocumentCount() int32 {
	if x != nil {
		return x.ErrorDocumentCount
	}
	return 0
}

// Request for `GetDatasetSchema`.
type GetDatasetSchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The dataset schema resource name.
	// Format:
	// projects/{project}/locations/{location}/processors/{processor}/dataset/datasetSchema
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set, only returns the visible fields of the schema.
	VisibleFieldsOnly bool `protobuf:"varint,2,opt,name=visible_fields_only,json=visibleFieldsOnly,proto3" json:"visible_fields_only,omitempty"`
}

func (x *GetDatasetSchemaRequest) Reset() {
	*x = GetDatasetSchemaRequest{}
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDatasetSchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDatasetSchemaRequest) ProtoMessage() {}

func (x *GetDatasetSchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDatasetSchemaRequest.ProtoReflect.Descriptor instead.
func (*GetDatasetSchemaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{12}
}

func (x *GetDatasetSchemaRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetDatasetSchemaRequest) GetVisibleFieldsOnly() bool {
	if x != nil {
		return x.VisibleFieldsOnly
	}
	return false
}

// Request for `UpdateDatasetSchema`.
type UpdateDatasetSchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name field of the `DatasetSchema` is used to identify the
	// resource to be updated.
	DatasetSchema *DatasetSchema `protobuf:"bytes,1,opt,name=dataset_schema,json=datasetSchema,proto3" json:"dataset_schema,omitempty"`
	// The update mask applies to the resource.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDatasetSchemaRequest) Reset() {
	*x = UpdateDatasetSchemaRequest{}
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateDatasetSchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDatasetSchemaRequest) ProtoMessage() {}

func (x *UpdateDatasetSchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDatasetSchemaRequest.ProtoReflect.Descriptor instead.
func (*UpdateDatasetSchemaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{13}
}

func (x *UpdateDatasetSchemaRequest) GetDatasetSchema() *DatasetSchema {
	if x != nil {
		return x.DatasetSchema
	}
	return nil
}

func (x *UpdateDatasetSchemaRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Range of pages present in a document.
type DocumentPageRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// First page number (one-based index) to be returned.
	Start int32 `protobuf:"varint,1,opt,name=start,proto3" json:"start,omitempty"`
	// Last page number (one-based index) to be returned.
	End int32 `protobuf:"varint,2,opt,name=end,proto3" json:"end,omitempty"`
}

func (x *DocumentPageRange) Reset() {
	*x = DocumentPageRange{}
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DocumentPageRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentPageRange) ProtoMessage() {}

func (x *DocumentPageRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentPageRange.ProtoReflect.Descriptor instead.
func (*DocumentPageRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{14}
}

func (x *DocumentPageRange) GetStart() int32 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *DocumentPageRange) GetEnd() int32 {
	if x != nil {
		return x.End
	}
	return 0
}

// Metadata about a document.
type DocumentMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Document identifier.
	DocumentId *DocumentId `protobuf:"bytes,1,opt,name=document_id,json=documentId,proto3" json:"document_id,omitempty"`
	// Number of pages in the document.
	PageCount int32 `protobuf:"varint,2,opt,name=page_count,json=pageCount,proto3" json:"page_count,omitempty"`
	// Type of the dataset split to which the document belongs.
	DatasetType DatasetSplitType `protobuf:"varint,3,opt,name=dataset_type,json=datasetType,proto3,enum=google.cloud.documentai.v1beta3.DatasetSplitType" json:"dataset_type,omitempty"`
	// Labeling state of the document.
	LabelingState DocumentLabelingState `protobuf:"varint,5,opt,name=labeling_state,json=labelingState,proto3,enum=google.cloud.documentai.v1beta3.DocumentLabelingState" json:"labeling_state,omitempty"`
	// The display name of the document.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *DocumentMetadata) Reset() {
	*x = DocumentMetadata{}
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DocumentMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentMetadata) ProtoMessage() {}

func (x *DocumentMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentMetadata.ProtoReflect.Descriptor instead.
func (*DocumentMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{15}
}

func (x *DocumentMetadata) GetDocumentId() *DocumentId {
	if x != nil {
		return x.DocumentId
	}
	return nil
}

func (x *DocumentMetadata) GetPageCount() int32 {
	if x != nil {
		return x.PageCount
	}
	return 0
}

func (x *DocumentMetadata) GetDatasetType() DatasetSplitType {
	if x != nil {
		return x.DatasetType
	}
	return DatasetSplitType_DATASET_SPLIT_TYPE_UNSPECIFIED
}

func (x *DocumentMetadata) GetLabelingState() DocumentLabelingState {
	if x != nil {
		return x.LabelingState
	}
	return DocumentLabelingState_DOCUMENT_LABELING_STATE_UNSPECIFIED
}

func (x *DocumentMetadata) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Config for importing documents.
// Each batch can have its own dataset split type.
type ImportDocumentsRequest_BatchDocumentsImportConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to SplitTypeConfig:
	//
	//	*ImportDocumentsRequest_BatchDocumentsImportConfig_DatasetSplit
	//	*ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig_
	SplitTypeConfig isImportDocumentsRequest_BatchDocumentsImportConfig_SplitTypeConfig `protobuf_oneof:"split_type_config"`
	// The common config to specify a set of documents used as input.
	BatchInputConfig *BatchDocumentsInputConfig `protobuf:"bytes,1,opt,name=batch_input_config,json=batchInputConfig,proto3" json:"batch_input_config,omitempty"`
}

func (x *ImportDocumentsRequest_BatchDocumentsImportConfig) Reset() {
	*x = ImportDocumentsRequest_BatchDocumentsImportConfig{}
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportDocumentsRequest_BatchDocumentsImportConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDocumentsRequest_BatchDocumentsImportConfig) ProtoMessage() {}

func (x *ImportDocumentsRequest_BatchDocumentsImportConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDocumentsRequest_BatchDocumentsImportConfig.ProtoReflect.Descriptor instead.
func (*ImportDocumentsRequest_BatchDocumentsImportConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{2, 0}
}

func (m *ImportDocumentsRequest_BatchDocumentsImportConfig) GetSplitTypeConfig() isImportDocumentsRequest_BatchDocumentsImportConfig_SplitTypeConfig {
	if m != nil {
		return m.SplitTypeConfig
	}
	return nil
}

func (x *ImportDocumentsRequest_BatchDocumentsImportConfig) GetDatasetSplit() DatasetSplitType {
	if x, ok := x.GetSplitTypeConfig().(*ImportDocumentsRequest_BatchDocumentsImportConfig_DatasetSplit); ok {
		return x.DatasetSplit
	}
	return DatasetSplitType_DATASET_SPLIT_TYPE_UNSPECIFIED
}

func (x *ImportDocumentsRequest_BatchDocumentsImportConfig) GetAutoSplitConfig() *ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig {
	if x, ok := x.GetSplitTypeConfig().(*ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig_); ok {
		return x.AutoSplitConfig
	}
	return nil
}

func (x *ImportDocumentsRequest_BatchDocumentsImportConfig) GetBatchInputConfig() *BatchDocumentsInputConfig {
	if x != nil {
		return x.BatchInputConfig
	}
	return nil
}

type isImportDocumentsRequest_BatchDocumentsImportConfig_SplitTypeConfig interface {
	isImportDocumentsRequest_BatchDocumentsImportConfig_SplitTypeConfig()
}

type ImportDocumentsRequest_BatchDocumentsImportConfig_DatasetSplit struct {
	// Target dataset split where the documents must be stored.
	DatasetSplit DatasetSplitType `protobuf:"varint,2,opt,name=dataset_split,json=datasetSplit,proto3,enum=google.cloud.documentai.v1beta3.DatasetSplitType,oneof"`
}

type ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig_ struct {
	// If set, documents will be automatically split into training and test
	// split category with the specified ratio.
	AutoSplitConfig *ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig `protobuf:"bytes,3,opt,name=auto_split_config,json=autoSplitConfig,proto3,oneof"`
}

func (*ImportDocumentsRequest_BatchDocumentsImportConfig_DatasetSplit) isImportDocumentsRequest_BatchDocumentsImportConfig_SplitTypeConfig() {
}

func (*ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig_) isImportDocumentsRequest_BatchDocumentsImportConfig_SplitTypeConfig() {
}

// The config for auto-split.
type ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Ratio of training dataset split.
	TrainingSplitRatio float32 `protobuf:"fixed32,1,opt,name=training_split_ratio,json=trainingSplitRatio,proto3" json:"training_split_ratio,omitempty"`
}

func (x *ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig) Reset() {
	*x = ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig{}
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig) ProtoMessage() {}

func (x *ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig.ProtoReflect.Descriptor instead.
func (*ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{2, 0, 0}
}

func (x *ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig) GetTrainingSplitRatio() float32 {
	if x != nil {
		return x.TrainingSplitRatio
	}
	return 0
}

// The status of each individual document in the import process.
type ImportDocumentsMetadata_IndividualImportStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source Cloud Storage URI of the document.
	InputGcsSource string `protobuf:"bytes,1,opt,name=input_gcs_source,json=inputGcsSource,proto3" json:"input_gcs_source,omitempty"`
	// The status of the importing of the document.
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	// The document id of imported document if it was successful, otherwise
	// empty.
	OutputDocumentId *DocumentId `protobuf:"bytes,4,opt,name=output_document_id,json=outputDocumentId,proto3" json:"output_document_id,omitempty"`
}

func (x *ImportDocumentsMetadata_IndividualImportStatus) Reset() {
	*x = ImportDocumentsMetadata_IndividualImportStatus{}
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportDocumentsMetadata_IndividualImportStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDocumentsMetadata_IndividualImportStatus) ProtoMessage() {}

func (x *ImportDocumentsMetadata_IndividualImportStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDocumentsMetadata_IndividualImportStatus.ProtoReflect.Descriptor instead.
func (*ImportDocumentsMetadata_IndividualImportStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{4, 0}
}

func (x *ImportDocumentsMetadata_IndividualImportStatus) GetInputGcsSource() string {
	if x != nil {
		return x.InputGcsSource
	}
	return ""
}

func (x *ImportDocumentsMetadata_IndividualImportStatus) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *ImportDocumentsMetadata_IndividualImportStatus) GetOutputDocumentId() *DocumentId {
	if x != nil {
		return x.OutputDocumentId
	}
	return nil
}

// The validation status of each import config. Status is set to an error if
// there are no documents to import in the `import_config`, or `OK` if the
// operation will try to proceed with at least one document.
type ImportDocumentsMetadata_ImportConfigValidationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source Cloud Storage URI specified in the import config.
	InputGcsSource string `protobuf:"bytes,1,opt,name=input_gcs_source,json=inputGcsSource,proto3" json:"input_gcs_source,omitempty"`
	// The validation status of import config.
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *ImportDocumentsMetadata_ImportConfigValidationResult) Reset() {
	*x = ImportDocumentsMetadata_ImportConfigValidationResult{}
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportDocumentsMetadata_ImportConfigValidationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDocumentsMetadata_ImportConfigValidationResult) ProtoMessage() {}

func (x *ImportDocumentsMetadata_ImportConfigValidationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDocumentsMetadata_ImportConfigValidationResult.ProtoReflect.Descriptor instead.
func (*ImportDocumentsMetadata_ImportConfigValidationResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{4, 1}
}

func (x *ImportDocumentsMetadata_ImportConfigValidationResult) GetInputGcsSource() string {
	if x != nil {
		return x.InputGcsSource
	}
	return ""
}

func (x *ImportDocumentsMetadata_ImportConfigValidationResult) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

// The status of each individual document in the batch delete process.
type BatchDeleteDocumentsMetadata_IndividualBatchDeleteStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The document id of the document.
	DocumentId *DocumentId `protobuf:"bytes,1,opt,name=document_id,json=documentId,proto3" json:"document_id,omitempty"`
	// The status of deleting the document in storage.
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *BatchDeleteDocumentsMetadata_IndividualBatchDeleteStatus) Reset() {
	*x = BatchDeleteDocumentsMetadata_IndividualBatchDeleteStatus{}
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchDeleteDocumentsMetadata_IndividualBatchDeleteStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeleteDocumentsMetadata_IndividualBatchDeleteStatus) ProtoMessage() {}

func (x *BatchDeleteDocumentsMetadata_IndividualBatchDeleteStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeleteDocumentsMetadata_IndividualBatchDeleteStatus.ProtoReflect.Descriptor instead.
func (*BatchDeleteDocumentsMetadata_IndividualBatchDeleteStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP(), []int{11, 0}
}

func (x *BatchDeleteDocumentsMetadata_IndividualBatchDeleteStatus) GetDocumentId() *DocumentId {
	if x != nil {
		return x.DocumentId
	}
	return nil
}

func (x *BatchDeleteDocumentsMetadata_IndividualBatchDeleteStatus) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

var File_google_cloud_documentai_v1beta3_document_service_proto protoreflect.FileDescriptor

var file_google_cloud_documentai_v1beta3_document_service_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9c, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x47, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x83, 0x01, 0x0a, 0x1e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x61, 0x0a, 0x0f, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xcc, 0x05,
	0x0a, 0x16, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x23, 0x0a, 0x21, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x9c, 0x01,
	0x0a, 0x1e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x1b, 0x62, 0x61, 0x74, 0x63, 0x68, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x1a, 0xcd, 0x03, 0x0a,
	0x1a, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x58, 0x0a, 0x0d, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x70, 0x6c, 0x69,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x53, 0x70, 0x6c, 0x69, 0x74, 0x12, 0x90, 0x01, 0x0a, 0x11, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x73,
	0x70, 0x6c, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0f, 0x61, 0x75, 0x74, 0x6f, 0x53, 0x70, 0x6c,
	0x69, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x68, 0x0a, 0x12, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x10, 0x62, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x1a, 0x43, 0x0a, 0x0f, 0x41, 0x75, 0x74, 0x6f, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x30, 0x0a, 0x14, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x5f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x12, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x6c,
	0x69, 0x74, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x42, 0x13, 0x0a, 0x11, 0x73, 0x70, 0x6c, 0x69, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x19, 0x0a, 0x17,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa1, 0x06, 0x0a, 0x17, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x61, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x8d, 0x01, 0x0a, 0x1a, 0x69, 0x6e, 0x64, 0x69, 0x76,
	0x69, 0x64, 0x75, 0x61, 0x6c, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x18, 0x69, 0x6e,
	0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x12, 0x9e, 0x01, 0x0a, 0x20, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x1d, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x12, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0xc9, 0x01, 0x0a, 0x16, 0x49, 0x6e,
	0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x67, 0x63,
	0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2a,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x59, 0x0a, 0x12, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x49, 0x64, 0x52, 0x10, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x49, 0x64, 0x1a, 0x74, 0x0a, 0x1c, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x28, 0x0a, 0x10, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x67,
	0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xb8, 0x02, 0x0a, 0x12,
	0x47, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x43, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x07,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x51, 0x0a, 0x0b, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65,
	0x61, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x12, 0x51, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x61, 0x67, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x22, 0x5c, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a,
	0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x22, 0xfe, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a,
	0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x2f, 0x0a, 0x11, 0x72,
	0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x72, 0x65, 0x74,
	0x75, 0x72, 0x6e, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x17, 0x0a, 0x04,
	0x73, 0x6b, 0x69, 0x70, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x04, 0x73, 0x6b, 0x69, 0x70, 0x22, 0xbe, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x5e, 0x0a, 0x11, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x10, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74,
	0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xa6, 0x01, 0x0a, 0x1b, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x68, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22,
	0x1e, 0x0a, 0x1c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0xa4, 0x04, 0x0a, 0x1c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x61, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x43, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0xa2, 0x01, 0x0a, 0x20, 0x69, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75,
	0x61, 0x6c, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x59,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33,
	0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x49, 0x6e,
	0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x1d, 0x69, 0x6e, 0x64, 0x69, 0x76,
	0x69, 0x64, 0x75, 0x61, 0x6c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x12, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x12, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x97, 0x01, 0x0a,
	0x1b, 0x49, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x4c, 0x0a, 0x0b,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x52, 0x0a,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x8e, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x76, 0x69, 0x73, 0x69, 0x62,
	0x6c, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x76, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x73, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xb5, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5a, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0x3b, 0x0a, 0x11, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x67, 0x65, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x22, 0xd7, 0x02, 0x0a,
	0x10, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x4c, 0x0a, 0x0b, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x49, 0x64, 0x52, 0x0a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x54,
	0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x70,
	0x6c, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x5d, 0x0a, 0x0e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x0d, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x2a, 0x85, 0x01, 0x0a, 0x10, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x44,
	0x41, 0x54, 0x41, 0x53, 0x45, 0x54, 0x5f, 0x53, 0x50, 0x4c, 0x49, 0x54, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x17, 0x0a, 0x13, 0x44, 0x41, 0x54, 0x41, 0x53, 0x45, 0x54, 0x5f, 0x53, 0x50, 0x4c, 0x49, 0x54,
	0x5f, 0x54, 0x52, 0x41, 0x49, 0x4e, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x44, 0x41, 0x54, 0x41,
	0x53, 0x45, 0x54, 0x5f, 0x53, 0x50, 0x4c, 0x49, 0x54, 0x5f, 0x54, 0x45, 0x53, 0x54, 0x10, 0x02,
	0x12, 0x1c, 0x0a, 0x18, 0x44, 0x41, 0x54, 0x41, 0x53, 0x45, 0x54, 0x5f, 0x53, 0x50, 0x4c, 0x49,
	0x54, 0x5f, 0x55, 0x4e, 0x41, 0x53, 0x53, 0x49, 0x47, 0x4e, 0x45, 0x44, 0x10, 0x03, 0x2a, 0x89,
	0x01, 0x0a, 0x15, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x27, 0x0a, 0x23, 0x44, 0x4f, 0x43, 0x55,
	0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x4c, 0x41,
	0x42, 0x45, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x44, 0x4f, 0x43, 0x55, 0x4d,
	0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12,
	0x19, 0x0a, 0x15, 0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x41, 0x55, 0x54, 0x4f,
	0x5f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x32, 0xb3, 0x0e, 0x0a, 0x0f, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xfe,
	0x01, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x96, 0x01, 0xca, 0x41, 0x29, 0x0a, 0x07, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x1e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x13, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x4e, 0x3a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x32, 0x43, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x33, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x7d, 0x12,
	0x84, 0x02, 0x0a, 0x0f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x98, 0x01, 0xca, 0x41,
	0x32, 0x0a, 0x17, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x17, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x53, 0x3a, 0x01, 0x2a, 0x22, 0x4e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33,
	0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x7d, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xd6, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x47, 0x65,
	0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x5c, 0xda, 0x41, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x4c, 0x12, 0x4a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x7b, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0xe1, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x61, 0xda, 0x41, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x51, 0x3a, 0x01, 0x2a, 0x22, 0x4c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f,
	0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x7d, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x9d, 0x02, 0x0a, 0x14, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa7, 0x01, 0xca, 0x41, 0x3c, 0x0a,
	0x1c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1c, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x07, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x58, 0x3a, 0x01, 0x2a, 0x22, 0x53,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x7d, 0x3a, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0xd6, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x22, 0x58, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x4b, 0x12, 0x49, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x7d, 0x12, 0x92, 0x02, 0x0a,
	0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x22, 0x8d, 0x01, 0xda, 0x41, 0x1a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6a, 0x3a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x32, 0x58, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x7d, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x42, 0xf0, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x42, 0x19, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x41, 0x69, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33,
	0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x70, 0x62, 0x3b, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x41, 0x49, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x33, 0xca, 0x02, 0x1f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0xea, 0x02,
	0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_documentai_v1beta3_document_service_proto_rawDescOnce sync.Once
	file_google_cloud_documentai_v1beta3_document_service_proto_rawDescData = file_google_cloud_documentai_v1beta3_document_service_proto_rawDesc
)

func file_google_cloud_documentai_v1beta3_document_service_proto_rawDescGZIP() []byte {
	file_google_cloud_documentai_v1beta3_document_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_documentai_v1beta3_document_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_documentai_v1beta3_document_service_proto_rawDescData)
	})
	return file_google_cloud_documentai_v1beta3_document_service_proto_rawDescData
}

var file_google_cloud_documentai_v1beta3_document_service_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes = make([]protoimpl.MessageInfo, 21)
var file_google_cloud_documentai_v1beta3_document_service_proto_goTypes = []any{
	(DatasetSplitType)(0),                                                     // 0: google.cloud.documentai.v1beta3.DatasetSplitType
	(DocumentLabelingState)(0),                                                // 1: google.cloud.documentai.v1beta3.DocumentLabelingState
	(*UpdateDatasetRequest)(nil),                                              // 2: google.cloud.documentai.v1beta3.UpdateDatasetRequest
	(*UpdateDatasetOperationMetadata)(nil),                                    // 3: google.cloud.documentai.v1beta3.UpdateDatasetOperationMetadata
	(*ImportDocumentsRequest)(nil),                                            // 4: google.cloud.documentai.v1beta3.ImportDocumentsRequest
	(*ImportDocumentsResponse)(nil),                                           // 5: google.cloud.documentai.v1beta3.ImportDocumentsResponse
	(*ImportDocumentsMetadata)(nil),                                           // 6: google.cloud.documentai.v1beta3.ImportDocumentsMetadata
	(*GetDocumentRequest)(nil),                                                // 7: google.cloud.documentai.v1beta3.GetDocumentRequest
	(*GetDocumentResponse)(nil),                                               // 8: google.cloud.documentai.v1beta3.GetDocumentResponse
	(*ListDocumentsRequest)(nil),                                              // 9: google.cloud.documentai.v1beta3.ListDocumentsRequest
	(*ListDocumentsResponse)(nil),                                             // 10: google.cloud.documentai.v1beta3.ListDocumentsResponse
	(*BatchDeleteDocumentsRequest)(nil),                                       // 11: google.cloud.documentai.v1beta3.BatchDeleteDocumentsRequest
	(*BatchDeleteDocumentsResponse)(nil),                                      // 12: google.cloud.documentai.v1beta3.BatchDeleteDocumentsResponse
	(*BatchDeleteDocumentsMetadata)(nil),                                      // 13: google.cloud.documentai.v1beta3.BatchDeleteDocumentsMetadata
	(*GetDatasetSchemaRequest)(nil),                                           // 14: google.cloud.documentai.v1beta3.GetDatasetSchemaRequest
	(*UpdateDatasetSchemaRequest)(nil),                                        // 15: google.cloud.documentai.v1beta3.UpdateDatasetSchemaRequest
	(*DocumentPageRange)(nil),                                                 // 16: google.cloud.documentai.v1beta3.DocumentPageRange
	(*DocumentMetadata)(nil),                                                  // 17: google.cloud.documentai.v1beta3.DocumentMetadata
	(*ImportDocumentsRequest_BatchDocumentsImportConfig)(nil),                 // 18: google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
	(*ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig)(nil), // 19: google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig
	(*ImportDocumentsMetadata_IndividualImportStatus)(nil),                    // 20: google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
	(*ImportDocumentsMetadata_ImportConfigValidationResult)(nil),              // 21: google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
	(*BatchDeleteDocumentsMetadata_IndividualBatchDeleteStatus)(nil),          // 22: google.cloud.documentai.v1beta3.BatchDeleteDocumentsMetadata.IndividualBatchDeleteStatus
	(*Dataset)(nil),                                                           // 23: google.cloud.documentai.v1beta3.Dataset
	(*fieldmaskpb.FieldMask)(nil),                                             // 24: google.protobuf.FieldMask
	(*CommonOperationMetadata)(nil),                                           // 25: google.cloud.documentai.v1beta3.CommonOperationMetadata
	(*DocumentId)(nil),                                                        // 26: google.cloud.documentai.v1beta3.DocumentId
	(*Document)(nil),                                                          // 27: google.cloud.documentai.v1beta3.Document
	(*BatchDatasetDocuments)(nil),                                             // 28: google.cloud.documentai.v1beta3.BatchDatasetDocuments
	(*DatasetSchema)(nil),                                                     // 29: google.cloud.documentai.v1beta3.DatasetSchema
	(*BatchDocumentsInputConfig)(nil),                                         // 30: google.cloud.documentai.v1beta3.BatchDocumentsInputConfig
	(*status.Status)(nil),                                                     // 31: google.rpc.Status
	(*longrunningpb.Operation)(nil),                                           // 32: google.longrunning.Operation
}
var file_google_cloud_documentai_v1beta3_document_service_proto_depIdxs = []int32{
	23, // 0: google.cloud.documentai.v1beta3.UpdateDatasetRequest.dataset:type_name -> google.cloud.documentai.v1beta3.Dataset
	24, // 1: google.cloud.documentai.v1beta3.UpdateDatasetRequest.update_mask:type_name -> google.protobuf.FieldMask
	25, // 2: google.cloud.documentai.v1beta3.UpdateDatasetOperationMetadata.common_metadata:type_name -> google.cloud.documentai.v1beta3.CommonOperationMetadata
	18, // 3: google.cloud.documentai.v1beta3.ImportDocumentsRequest.batch_documents_import_configs:type_name -> google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig
	25, // 4: google.cloud.documentai.v1beta3.ImportDocumentsMetadata.common_metadata:type_name -> google.cloud.documentai.v1beta3.CommonOperationMetadata
	20, // 5: google.cloud.documentai.v1beta3.ImportDocumentsMetadata.individual_import_statuses:type_name -> google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus
	21, // 6: google.cloud.documentai.v1beta3.ImportDocumentsMetadata.import_config_validation_results:type_name -> google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult
	26, // 7: google.cloud.documentai.v1beta3.GetDocumentRequest.document_id:type_name -> google.cloud.documentai.v1beta3.DocumentId
	24, // 8: google.cloud.documentai.v1beta3.GetDocumentRequest.read_mask:type_name -> google.protobuf.FieldMask
	16, // 9: google.cloud.documentai.v1beta3.GetDocumentRequest.page_range:type_name -> google.cloud.documentai.v1beta3.DocumentPageRange
	27, // 10: google.cloud.documentai.v1beta3.GetDocumentResponse.document:type_name -> google.cloud.documentai.v1beta3.Document
	17, // 11: google.cloud.documentai.v1beta3.ListDocumentsResponse.document_metadata:type_name -> google.cloud.documentai.v1beta3.DocumentMetadata
	28, // 12: google.cloud.documentai.v1beta3.BatchDeleteDocumentsRequest.dataset_documents:type_name -> google.cloud.documentai.v1beta3.BatchDatasetDocuments
	25, // 13: google.cloud.documentai.v1beta3.BatchDeleteDocumentsMetadata.common_metadata:type_name -> google.cloud.documentai.v1beta3.CommonOperationMetadata
	22, // 14: google.cloud.documentai.v1beta3.BatchDeleteDocumentsMetadata.individual_batch_delete_statuses:type_name -> google.cloud.documentai.v1beta3.BatchDeleteDocumentsMetadata.IndividualBatchDeleteStatus
	29, // 15: google.cloud.documentai.v1beta3.UpdateDatasetSchemaRequest.dataset_schema:type_name -> google.cloud.documentai.v1beta3.DatasetSchema
	24, // 16: google.cloud.documentai.v1beta3.UpdateDatasetSchemaRequest.update_mask:type_name -> google.protobuf.FieldMask
	26, // 17: google.cloud.documentai.v1beta3.DocumentMetadata.document_id:type_name -> google.cloud.documentai.v1beta3.DocumentId
	0,  // 18: google.cloud.documentai.v1beta3.DocumentMetadata.dataset_type:type_name -> google.cloud.documentai.v1beta3.DatasetSplitType
	1,  // 19: google.cloud.documentai.v1beta3.DocumentMetadata.labeling_state:type_name -> google.cloud.documentai.v1beta3.DocumentLabelingState
	0,  // 20: google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.dataset_split:type_name -> google.cloud.documentai.v1beta3.DatasetSplitType
	19, // 21: google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.auto_split_config:type_name -> google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.AutoSplitConfig
	30, // 22: google.cloud.documentai.v1beta3.ImportDocumentsRequest.BatchDocumentsImportConfig.batch_input_config:type_name -> google.cloud.documentai.v1beta3.BatchDocumentsInputConfig
	31, // 23: google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus.status:type_name -> google.rpc.Status
	26, // 24: google.cloud.documentai.v1beta3.ImportDocumentsMetadata.IndividualImportStatus.output_document_id:type_name -> google.cloud.documentai.v1beta3.DocumentId
	31, // 25: google.cloud.documentai.v1beta3.ImportDocumentsMetadata.ImportConfigValidationResult.status:type_name -> google.rpc.Status
	26, // 26: google.cloud.documentai.v1beta3.BatchDeleteDocumentsMetadata.IndividualBatchDeleteStatus.document_id:type_name -> google.cloud.documentai.v1beta3.DocumentId
	31, // 27: google.cloud.documentai.v1beta3.BatchDeleteDocumentsMetadata.IndividualBatchDeleteStatus.status:type_name -> google.rpc.Status
	2,  // 28: google.cloud.documentai.v1beta3.DocumentService.UpdateDataset:input_type -> google.cloud.documentai.v1beta3.UpdateDatasetRequest
	4,  // 29: google.cloud.documentai.v1beta3.DocumentService.ImportDocuments:input_type -> google.cloud.documentai.v1beta3.ImportDocumentsRequest
	7,  // 30: google.cloud.documentai.v1beta3.DocumentService.GetDocument:input_type -> google.cloud.documentai.v1beta3.GetDocumentRequest
	9,  // 31: google.cloud.documentai.v1beta3.DocumentService.ListDocuments:input_type -> google.cloud.documentai.v1beta3.ListDocumentsRequest
	11, // 32: google.cloud.documentai.v1beta3.DocumentService.BatchDeleteDocuments:input_type -> google.cloud.documentai.v1beta3.BatchDeleteDocumentsRequest
	14, // 33: google.cloud.documentai.v1beta3.DocumentService.GetDatasetSchema:input_type -> google.cloud.documentai.v1beta3.GetDatasetSchemaRequest
	15, // 34: google.cloud.documentai.v1beta3.DocumentService.UpdateDatasetSchema:input_type -> google.cloud.documentai.v1beta3.UpdateDatasetSchemaRequest
	32, // 35: google.cloud.documentai.v1beta3.DocumentService.UpdateDataset:output_type -> google.longrunning.Operation
	32, // 36: google.cloud.documentai.v1beta3.DocumentService.ImportDocuments:output_type -> google.longrunning.Operation
	8,  // 37: google.cloud.documentai.v1beta3.DocumentService.GetDocument:output_type -> google.cloud.documentai.v1beta3.GetDocumentResponse
	10, // 38: google.cloud.documentai.v1beta3.DocumentService.ListDocuments:output_type -> google.cloud.documentai.v1beta3.ListDocumentsResponse
	32, // 39: google.cloud.documentai.v1beta3.DocumentService.BatchDeleteDocuments:output_type -> google.longrunning.Operation
	29, // 40: google.cloud.documentai.v1beta3.DocumentService.GetDatasetSchema:output_type -> google.cloud.documentai.v1beta3.DatasetSchema
	29, // 41: google.cloud.documentai.v1beta3.DocumentService.UpdateDatasetSchema:output_type -> google.cloud.documentai.v1beta3.DatasetSchema
	35, // [35:42] is the sub-list for method output_type
	28, // [28:35] is the sub-list for method input_type
	28, // [28:28] is the sub-list for extension type_name
	28, // [28:28] is the sub-list for extension extendee
	0,  // [0:28] is the sub-list for field type_name
}

func init() { file_google_cloud_documentai_v1beta3_document_service_proto_init() }
func file_google_cloud_documentai_v1beta3_document_service_proto_init() {
	if File_google_cloud_documentai_v1beta3_document_service_proto != nil {
		return
	}
	file_google_cloud_documentai_v1beta3_dataset_proto_init()
	file_google_cloud_documentai_v1beta3_document_proto_init()
	file_google_cloud_documentai_v1beta3_document_io_proto_init()
	file_google_cloud_documentai_v1beta3_operation_metadata_proto_init()
	file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes[16].OneofWrappers = []any{
		(*ImportDocumentsRequest_BatchDocumentsImportConfig_DatasetSplit)(nil),
		(*ImportDocumentsRequest_BatchDocumentsImportConfig_AutoSplitConfig_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_documentai_v1beta3_document_service_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   21,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_documentai_v1beta3_document_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_documentai_v1beta3_document_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_documentai_v1beta3_document_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_documentai_v1beta3_document_service_proto_msgTypes,
	}.Build()
	File_google_cloud_documentai_v1beta3_document_service_proto = out.File
	file_google_cloud_documentai_v1beta3_document_service_proto_rawDesc = nil
	file_google_cloud_documentai_v1beta3_document_service_proto_goTypes = nil
	file_google_cloud_documentai_v1beta3_document_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DocumentServiceClient is the client API for DocumentService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DocumentServiceClient interface {
	// Updates metadata associated with a dataset.
	// Note that this method requires the
	// `documentai.googleapis.com/datasets.update` permission on the project,
	// which is highly privileged. A user or service account with this permission
	// can create new processors that can interact with any gcs bucket in your
	// project.
	UpdateDataset(ctx context.Context, in *UpdateDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Import documents into a dataset.
	ImportDocuments(ctx context.Context, in *ImportDocumentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns relevant fields present in the requested document.
	GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*GetDocumentResponse, error)
	// Returns a list of documents present in the dataset.
	ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error)
	// Deletes a set of documents.
	BatchDeleteDocuments(ctx context.Context, in *BatchDeleteDocumentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the `DatasetSchema` of a `Dataset`.
	GetDatasetSchema(ctx context.Context, in *GetDatasetSchemaRequest, opts ...grpc.CallOption) (*DatasetSchema, error)
	// Updates a `DatasetSchema`.
	UpdateDatasetSchema(ctx context.Context, in *UpdateDatasetSchemaRequest, opts ...grpc.CallOption) (*DatasetSchema, error)
}

type documentServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDocumentServiceClient(cc grpc.ClientConnInterface) DocumentServiceClient {
	return &documentServiceClient{cc}
}

func (c *documentServiceClient) UpdateDataset(ctx context.Context, in *UpdateDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentService/UpdateDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentServiceClient) ImportDocuments(ctx context.Context, in *ImportDocumentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentService/ImportDocuments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentServiceClient) GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*GetDocumentResponse, error) {
	out := new(GetDocumentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentService/GetDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentServiceClient) ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error) {
	out := new(ListDocumentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentService/ListDocuments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentServiceClient) BatchDeleteDocuments(ctx context.Context, in *BatchDeleteDocumentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentService/BatchDeleteDocuments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentServiceClient) GetDatasetSchema(ctx context.Context, in *GetDatasetSchemaRequest, opts ...grpc.CallOption) (*DatasetSchema, error) {
	out := new(DatasetSchema)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentService/GetDatasetSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentServiceClient) UpdateDatasetSchema(ctx context.Context, in *UpdateDatasetSchemaRequest, opts ...grpc.CallOption) (*DatasetSchema, error) {
	out := new(DatasetSchema)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentService/UpdateDatasetSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DocumentServiceServer is the server API for DocumentService service.
type DocumentServiceServer interface {
	// Updates metadata associated with a dataset.
	// Note that this method requires the
	// `documentai.googleapis.com/datasets.update` permission on the project,
	// which is highly privileged. A user or service account with this permission
	// can create new processors that can interact with any gcs bucket in your
	// project.
	UpdateDataset(context.Context, *UpdateDatasetRequest) (*longrunningpb.Operation, error)
	// Import documents into a dataset.
	ImportDocuments(context.Context, *ImportDocumentsRequest) (*longrunningpb.Operation, error)
	// Returns relevant fields present in the requested document.
	GetDocument(context.Context, *GetDocumentRequest) (*GetDocumentResponse, error)
	// Returns a list of documents present in the dataset.
	ListDocuments(context.Context, *ListDocumentsRequest) (*ListDocumentsResponse, error)
	// Deletes a set of documents.
	BatchDeleteDocuments(context.Context, *BatchDeleteDocumentsRequest) (*longrunningpb.Operation, error)
	// Gets the `DatasetSchema` of a `Dataset`.
	GetDatasetSchema(context.Context, *GetDatasetSchemaRequest) (*DatasetSchema, error)
	// Updates a `DatasetSchema`.
	UpdateDatasetSchema(context.Context, *UpdateDatasetSchemaRequest) (*DatasetSchema, error)
}

// UnimplementedDocumentServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDocumentServiceServer struct {
}

func (*UnimplementedDocumentServiceServer) UpdateDataset(context.Context, *UpdateDatasetRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateDataset not implemented")
}
func (*UnimplementedDocumentServiceServer) ImportDocuments(context.Context, *ImportDocumentsRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ImportDocuments not implemented")
}
func (*UnimplementedDocumentServiceServer) GetDocument(context.Context, *GetDocumentRequest) (*GetDocumentResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetDocument not implemented")
}
func (*UnimplementedDocumentServiceServer) ListDocuments(context.Context, *ListDocumentsRequest) (*ListDocumentsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListDocuments not implemented")
}
func (*UnimplementedDocumentServiceServer) BatchDeleteDocuments(context.Context, *BatchDeleteDocumentsRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchDeleteDocuments not implemented")
}
func (*UnimplementedDocumentServiceServer) GetDatasetSchema(context.Context, *GetDatasetSchemaRequest) (*DatasetSchema, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetDatasetSchema not implemented")
}
func (*UnimplementedDocumentServiceServer) UpdateDatasetSchema(context.Context, *UpdateDatasetSchemaRequest) (*DatasetSchema, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateDatasetSchema not implemented")
}

func RegisterDocumentServiceServer(s *grpc.Server, srv DocumentServiceServer) {
	s.RegisterService(&_DocumentService_serviceDesc, srv)
}

func _DocumentService_UpdateDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).UpdateDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentService/UpdateDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).UpdateDataset(ctx, req.(*UpdateDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentService_ImportDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).ImportDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentService/ImportDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).ImportDocuments(ctx, req.(*ImportDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentService_GetDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).GetDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentService/GetDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).GetDocument(ctx, req.(*GetDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentService_ListDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).ListDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentService/ListDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).ListDocuments(ctx, req.(*ListDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentService_BatchDeleteDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).BatchDeleteDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentService/BatchDeleteDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).BatchDeleteDocuments(ctx, req.(*BatchDeleteDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentService_GetDatasetSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatasetSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).GetDatasetSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentService/GetDatasetSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).GetDatasetSchema(ctx, req.(*GetDatasetSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentService_UpdateDatasetSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDatasetSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).UpdateDatasetSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentService/UpdateDatasetSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).UpdateDatasetSchema(ctx, req.(*UpdateDatasetSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DocumentService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.documentai.v1beta3.DocumentService",
	HandlerType: (*DocumentServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "UpdateDataset",
			Handler:    _DocumentService_UpdateDataset_Handler,
		},
		{
			MethodName: "ImportDocuments",
			Handler:    _DocumentService_ImportDocuments_Handler,
		},
		{
			MethodName: "GetDocument",
			Handler:    _DocumentService_GetDocument_Handler,
		},
		{
			MethodName: "ListDocuments",
			Handler:    _DocumentService_ListDocuments_Handler,
		},
		{
			MethodName: "BatchDeleteDocuments",
			Handler:    _DocumentService_BatchDeleteDocuments_Handler,
		},
		{
			MethodName: "GetDatasetSchema",
			Handler:    _DocumentService_GetDatasetSchema_Handler,
		},
		{
			MethodName: "UpdateDatasetSchema",
			Handler:    _DocumentService_UpdateDatasetSchema_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/documentai/v1beta3/document_service.proto",
}
