// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudtrail

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudtrail/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes the settings for the Insights event selectors that you configured for
// your trail or event data store. GetInsightSelectors shows if CloudTrail
// Insights event logging is enabled on the trail or event data store, and if it
// is, which Insights types are enabled. If you run GetInsightSelectors on a trail
// or event data store that does not have Insights events enabled, the operation
// throws the exception InsightNotEnabledException
//
// Specify either the EventDataStore parameter to get Insights event selectors for
// an event data store, or the TrailName parameter to the get Insights event
// selectors for a trail. You cannot specify these parameters together.
//
// For more information, see [Working with CloudTrail Insights] in the CloudTrail User Guide.
//
// [Working with CloudTrail Insights]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html
func (c *Client) GetInsightSelectors(ctx context.Context, params *GetInsightSelectorsInput, optFns ...func(*Options)) (*GetInsightSelectorsOutput, error) {
	if params == nil {
		params = &GetInsightSelectorsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetInsightSelectors", params, optFns, c.addOperationGetInsightSelectorsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetInsightSelectorsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetInsightSelectorsInput struct {

	//  Specifies the ARN (or ID suffix of the ARN) of the event data store for which
	// you want to get Insights selectors.
	//
	// You cannot use this parameter with the TrailName parameter.
	EventDataStore *string

	// Specifies the name of the trail or trail ARN. If you specify a trail name, the
	// string must meet the following requirements:
	//
	//   - Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.),
	//   underscores (_), or dashes (-)
	//
	//   - Start with a letter or number, and end with a letter or number
	//
	//   - Be between 3 and 128 characters
	//
	//   - Have no adjacent periods, underscores or dashes. Names like my-_namespace
	//   and my--namespace are not valid.
	//
	//   - Not be in IP address format (for example, 192.168.5.4)
	//
	// If you specify a trail ARN, it must be in the format:
	//
	//     arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	//
	// You cannot use this parameter with the EventDataStore parameter.
	TrailName *string

	noSmithyDocumentSerde
}

type GetInsightSelectorsOutput struct {

	//  The ARN of the source event data store that enabled Insights events.
	EventDataStoreArn *string

	// A JSON string that contains the Insight types you want to log on a trail or
	// event data store. ApiErrorRateInsight and ApiCallRateInsight are supported as
	// Insights types.
	InsightSelectors []types.InsightSelector

	//  The ARN of the destination event data store that logs Insights events.
	InsightsDestination *string

	// The Amazon Resource Name (ARN) of a trail for which you want to get Insights
	// selectors.
	TrailARN *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetInsightSelectorsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetInsightSelectors{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetInsightSelectors{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetInsightSelectors"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetInsightSelectors(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetInsightSelectors(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetInsightSelectors",
	}
}
