// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: yandex/cloud/mdb/sqlserver/v1/database_service.proto

package sqlserver

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type GetDatabaseRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the SQL Server cluster the database belongs to.
	//
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the SQL Server database to return.
	//
	// To get the name of the database use a [DatabaseService.List] request.
	DatabaseName  string `protobuf:"bytes,2,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetDatabaseRequest) Reset() {
	*x = GetDatabaseRequest{}
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDatabaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDatabaseRequest) ProtoMessage() {}

func (x *GetDatabaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDatabaseRequest.ProtoReflect.Descriptor instead.
func (*GetDatabaseRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetDatabaseRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *GetDatabaseRequest) GetDatabaseName() string {
	if x != nil {
		return x.DatabaseName
	}
	return ""
}

type ListDatabasesRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the SQL Server cluster to list databases in.
	//
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The maximum number of results per page to return.
	//
	// If the number of available results is larger than [page_size], the service returns a [ListDatabasesResponse.next_page_token] that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the [ListDatabasesResponse.next_page_token] returned by the previous list request.
	PageToken     string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListDatabasesRequest) Reset() {
	*x = ListDatabasesRequest{}
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDatabasesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDatabasesRequest) ProtoMessage() {}

func (x *ListDatabasesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDatabasesRequest.ProtoReflect.Descriptor instead.
func (*ListDatabasesRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListDatabasesRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *ListDatabasesRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDatabasesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

type ListDatabasesResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of SQL Server databases.
	Databases []*Database `protobuf:"bytes,1,rep,name=databases,proto3" json:"databases,omitempty"`
	// Token that allows you to get the next page of results for list requests.
	//
	// If the number of results is larger than [ListDatabasesRequest.page_size], use the [next_page_token] as the value for the [ListDatabasesRequest.page_token] parameter in the next list request.
	//
	// Each subsequent list request has its own [next_page_token] to continue paging through the results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListDatabasesResponse) Reset() {
	*x = ListDatabasesResponse{}
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDatabasesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDatabasesResponse) ProtoMessage() {}

func (x *ListDatabasesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDatabasesResponse.ProtoReflect.Descriptor instead.
func (*ListDatabasesResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListDatabasesResponse) GetDatabases() []*Database {
	if x != nil {
		return x.Databases
	}
	return nil
}

func (x *ListDatabasesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type CreateDatabaseRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the SQL Server cluster to create a database in.
	//
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Configuration of the database to create.
	DatabaseSpec  *DatabaseSpec `protobuf:"bytes,2,opt,name=database_spec,json=databaseSpec,proto3" json:"database_spec,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateDatabaseRequest) Reset() {
	*x = CreateDatabaseRequest{}
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateDatabaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDatabaseRequest) ProtoMessage() {}

func (x *CreateDatabaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDatabaseRequest.ProtoReflect.Descriptor instead.
func (*CreateDatabaseRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateDatabaseRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *CreateDatabaseRequest) GetDatabaseSpec() *DatabaseSpec {
	if x != nil {
		return x.DatabaseSpec
	}
	return nil
}

type CreateDatabaseMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the SQL Server cluster where the database is being created.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the SQL Server database being created.
	DatabaseName  string `protobuf:"bytes,2,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateDatabaseMetadata) Reset() {
	*x = CreateDatabaseMetadata{}
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateDatabaseMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDatabaseMetadata) ProtoMessage() {}

func (x *CreateDatabaseMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDatabaseMetadata.ProtoReflect.Descriptor instead.
func (*CreateDatabaseMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDescGZIP(), []int{4}
}

func (x *CreateDatabaseMetadata) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *CreateDatabaseMetadata) GetDatabaseName() string {
	if x != nil {
		return x.DatabaseName
	}
	return ""
}

type DeleteDatabaseRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the SQL Server cluster to delete a database in.
	//
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the database to delete.
	//
	// To get the name of the database, use a [DatabaseService.List] request.
	DatabaseName  string `protobuf:"bytes,2,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteDatabaseRequest) Reset() {
	*x = DeleteDatabaseRequest{}
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteDatabaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDatabaseRequest) ProtoMessage() {}

func (x *DeleteDatabaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDatabaseRequest.ProtoReflect.Descriptor instead.
func (*DeleteDatabaseRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteDatabaseRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *DeleteDatabaseRequest) GetDatabaseName() string {
	if x != nil {
		return x.DatabaseName
	}
	return ""
}

type DeleteDatabaseMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the SQL Server cluster where the database is being deleted.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the SQL Server database being deleted.
	DatabaseName  string `protobuf:"bytes,2,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteDatabaseMetadata) Reset() {
	*x = DeleteDatabaseMetadata{}
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteDatabaseMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDatabaseMetadata) ProtoMessage() {}

func (x *DeleteDatabaseMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDatabaseMetadata.ProtoReflect.Descriptor instead.
func (*DeleteDatabaseMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteDatabaseMetadata) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *DeleteDatabaseMetadata) GetDatabaseName() string {
	if x != nil {
		return x.DatabaseName
	}
	return ""
}

type RestoreDatabaseRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the SQL Server cluster to restore a database in.
	//
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the SQL Server database that is being restored.
	DatabaseName string `protobuf:"bytes,2,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	// Name of the database which backup is used to restore the database.
	FromDatabase string `protobuf:"bytes,3,opt,name=from_database,json=fromDatabase,proto3" json:"from_database,omitempty"`
	// ID of a backup to be used.
	BackupId string `protobuf:"bytes,4,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	// Timestamp which is used for Point-in-Time recovery.
	Time          *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=time,proto3" json:"time,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RestoreDatabaseRequest) Reset() {
	*x = RestoreDatabaseRequest{}
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RestoreDatabaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreDatabaseRequest) ProtoMessage() {}

func (x *RestoreDatabaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreDatabaseRequest.ProtoReflect.Descriptor instead.
func (*RestoreDatabaseRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDescGZIP(), []int{7}
}

func (x *RestoreDatabaseRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *RestoreDatabaseRequest) GetDatabaseName() string {
	if x != nil {
		return x.DatabaseName
	}
	return ""
}

func (x *RestoreDatabaseRequest) GetFromDatabase() string {
	if x != nil {
		return x.FromDatabase
	}
	return ""
}

func (x *RestoreDatabaseRequest) GetBackupId() string {
	if x != nil {
		return x.BackupId
	}
	return ""
}

func (x *RestoreDatabaseRequest) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type RestoreDatabaseMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the SQL Server cluster where a database is being created.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of an SQL Server database that is being created.
	DatabaseName string `protobuf:"bytes,2,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	// Name of the database which backup is used to restore the database.
	FromDatabase string `protobuf:"bytes,3,opt,name=from_database,json=fromDatabase,proto3" json:"from_database,omitempty"`
	// ID of a backup to be used.
	BackupId      string `protobuf:"bytes,4,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RestoreDatabaseMetadata) Reset() {
	*x = RestoreDatabaseMetadata{}
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RestoreDatabaseMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreDatabaseMetadata) ProtoMessage() {}

func (x *RestoreDatabaseMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreDatabaseMetadata.ProtoReflect.Descriptor instead.
func (*RestoreDatabaseMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDescGZIP(), []int{8}
}

func (x *RestoreDatabaseMetadata) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *RestoreDatabaseMetadata) GetDatabaseName() string {
	if x != nil {
		return x.DatabaseName
	}
	return ""
}

func (x *RestoreDatabaseMetadata) GetFromDatabase() string {
	if x != nil {
		return x.FromDatabase
	}
	return ""
}

func (x *RestoreDatabaseMetadata) GetBackupId() string {
	if x != nil {
		return x.BackupId
	}
	return ""
}

type ImportDatabaseBackupRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the SQL Server cluster to import a database in.
	//
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the SQL Server database that is being imported.
	DatabaseName string `protobuf:"bytes,2,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	// Name of object storage bucket to import backups from.
	S3Bucket string `protobuf:"bytes,3,opt,name=s3_bucket,json=s3Bucket,proto3" json:"s3_bucket,omitempty"`
	// Path in object storage bucket to import backups from.
	S3Path string `protobuf:"bytes,4,opt,name=s3_path,json=s3Path,proto3" json:"s3_path,omitempty"`
	// List of .bak files in bucket containing database backup.
	Files         []string `protobuf:"bytes,5,rep,name=files,proto3" json:"files,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ImportDatabaseBackupRequest) Reset() {
	*x = ImportDatabaseBackupRequest{}
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportDatabaseBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDatabaseBackupRequest) ProtoMessage() {}

func (x *ImportDatabaseBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDatabaseBackupRequest.ProtoReflect.Descriptor instead.
func (*ImportDatabaseBackupRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDescGZIP(), []int{9}
}

func (x *ImportDatabaseBackupRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *ImportDatabaseBackupRequest) GetDatabaseName() string {
	if x != nil {
		return x.DatabaseName
	}
	return ""
}

func (x *ImportDatabaseBackupRequest) GetS3Bucket() string {
	if x != nil {
		return x.S3Bucket
	}
	return ""
}

func (x *ImportDatabaseBackupRequest) GetS3Path() string {
	if x != nil {
		return x.S3Path
	}
	return ""
}

func (x *ImportDatabaseBackupRequest) GetFiles() []string {
	if x != nil {
		return x.Files
	}
	return nil
}

type ImportDatabaseBackupMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the SQL Server cluster where a database is being imported.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the SQL Server database that is being imported.
	DatabaseName string `protobuf:"bytes,2,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	// Name of object storage bucket to import backups from.
	S3Bucket string `protobuf:"bytes,3,opt,name=s3_bucket,json=s3Bucket,proto3" json:"s3_bucket,omitempty"`
	// Path in object storage bucket to import backups from.
	S3Path        string `protobuf:"bytes,4,opt,name=s3_path,json=s3Path,proto3" json:"s3_path,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ImportDatabaseBackupMetadata) Reset() {
	*x = ImportDatabaseBackupMetadata{}
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportDatabaseBackupMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDatabaseBackupMetadata) ProtoMessage() {}

func (x *ImportDatabaseBackupMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDatabaseBackupMetadata.ProtoReflect.Descriptor instead.
func (*ImportDatabaseBackupMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDescGZIP(), []int{10}
}

func (x *ImportDatabaseBackupMetadata) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *ImportDatabaseBackupMetadata) GetDatabaseName() string {
	if x != nil {
		return x.DatabaseName
	}
	return ""
}

func (x *ImportDatabaseBackupMetadata) GetS3Bucket() string {
	if x != nil {
		return x.S3Bucket
	}
	return ""
}

func (x *ImportDatabaseBackupMetadata) GetS3Path() string {
	if x != nil {
		return x.S3Path
	}
	return ""
}

type ExportDatabaseBackupRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the SQL Server cluster to export a database from.
	//
	// To get the cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the SQL Server database that is being exported.
	DatabaseName string `protobuf:"bytes,2,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	// Name of object storage bucket to export backups to.
	S3Bucket string `protobuf:"bytes,3,opt,name=s3_bucket,json=s3Bucket,proto3" json:"s3_bucket,omitempty"`
	// Path in object storage bucket to export backups to.
	S3Path string `protobuf:"bytes,4,opt,name=s3_path,json=s3Path,proto3" json:"s3_path,omitempty"`
	// Prefix for .bak files to export.
	Prefix        string `protobuf:"bytes,5,opt,name=prefix,proto3" json:"prefix,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExportDatabaseBackupRequest) Reset() {
	*x = ExportDatabaseBackupRequest{}
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportDatabaseBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportDatabaseBackupRequest) ProtoMessage() {}

func (x *ExportDatabaseBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportDatabaseBackupRequest.ProtoReflect.Descriptor instead.
func (*ExportDatabaseBackupRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDescGZIP(), []int{11}
}

func (x *ExportDatabaseBackupRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *ExportDatabaseBackupRequest) GetDatabaseName() string {
	if x != nil {
		return x.DatabaseName
	}
	return ""
}

func (x *ExportDatabaseBackupRequest) GetS3Bucket() string {
	if x != nil {
		return x.S3Bucket
	}
	return ""
}

func (x *ExportDatabaseBackupRequest) GetS3Path() string {
	if x != nil {
		return x.S3Path
	}
	return ""
}

func (x *ExportDatabaseBackupRequest) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

type ExportDatabaseBackupMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the SQL Server cluster where a database is being exported.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the SQL Server database that is being exported.
	DatabaseName string `protobuf:"bytes,2,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	// Name of object storage bucket to export backups to.
	S3Bucket string `protobuf:"bytes,3,opt,name=s3_bucket,json=s3Bucket,proto3" json:"s3_bucket,omitempty"`
	// Path in object storage bucket to export backups to.
	S3Path        string `protobuf:"bytes,4,opt,name=s3_path,json=s3Path,proto3" json:"s3_path,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExportDatabaseBackupMetadata) Reset() {
	*x = ExportDatabaseBackupMetadata{}
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportDatabaseBackupMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportDatabaseBackupMetadata) ProtoMessage() {}

func (x *ExportDatabaseBackupMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportDatabaseBackupMetadata.ProtoReflect.Descriptor instead.
func (*ExportDatabaseBackupMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDescGZIP(), []int{12}
}

func (x *ExportDatabaseBackupMetadata) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *ExportDatabaseBackupMetadata) GetDatabaseName() string {
	if x != nil {
		return x.DatabaseName
	}
	return ""
}

func (x *ExportDatabaseBackupMetadata) GetS3Bucket() string {
	if x != nil {
		return x.S3Bucket
	}
	return ""
}

func (x *ExportDatabaseBackupMetadata) GetS3Path() string {
	if x != nil {
		return x.S3Path
	}
	return ""
}

var File_yandex_cloud_mdb_sqlserver_v1_database_service_proto protoreflect.FileDescriptor

const file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDesc = "" +
	"\n" +
	"4yandex/cloud/mdb/sqlserver/v1/database_service.proto\x12\x1dyandex.cloud.mdb.sqlserver.v1\x1a\x1cgoogle/api/annotations.proto\x1a\x1fgoogle/protobuf/timestamp.proto\x1a yandex/cloud/api/operation.proto\x1a,yandex/cloud/mdb/sqlserver/v1/database.proto\x1a&yandex/cloud/operation/operation.proto\x1a\x1dyandex/cloud/validation.proto\"\x86\x01\n" +
	"\x12GetDatabaseRequest\x12+\n" +
	"\n" +
	"cluster_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\tclusterId\x12C\n" +
	"\rdatabase_name\x18\x02 \x01(\tB\x1e\xe8\xc71\x01\xf2\xc71\x0e[a-zA-Z0-9_-]*\x8a\xc81\x04<=63R\fdatabaseName\"\x96\x01\n" +
	"\x14ListDatabasesRequest\x12+\n" +
	"\n" +
	"cluster_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\tclusterId\x12'\n" +
	"\tpage_size\x18\x02 \x01(\x03B\n" +
	"\xfa\xc71\x060-1000R\bpageSize\x12(\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tB\t\x8a\xc81\x05<=100R\tpageToken\"\x86\x01\n" +
	"\x15ListDatabasesResponse\x12E\n" +
	"\tdatabases\x18\x01 \x03(\v2'.yandex.cloud.mdb.sqlserver.v1.DatabaseR\tdatabases\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\x9c\x01\n" +
	"\x15CreateDatabaseRequest\x12+\n" +
	"\n" +
	"cluster_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\tclusterId\x12V\n" +
	"\rdatabase_spec\x18\x02 \x01(\v2+.yandex.cloud.mdb.sqlserver.v1.DatabaseSpecB\x04\xe8\xc71\x01R\fdatabaseSpec\"\\\n" +
	"\x16CreateDatabaseMetadata\x12\x1d\n" +
	"\n" +
	"cluster_id\x18\x01 \x01(\tR\tclusterId\x12#\n" +
	"\rdatabase_name\x18\x02 \x01(\tR\fdatabaseName\"\x89\x01\n" +
	"\x15DeleteDatabaseRequest\x12+\n" +
	"\n" +
	"cluster_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\tclusterId\x12C\n" +
	"\rdatabase_name\x18\x02 \x01(\tB\x1e\xe8\xc71\x01\xf2\xc71\x0e[a-zA-Z0-9_-]*\x8a\xc81\x04<=63R\fdatabaseName\"\\\n" +
	"\x16DeleteDatabaseMetadata\x12\x1d\n" +
	"\n" +
	"cluster_id\x18\x01 \x01(\tR\tclusterId\x12#\n" +
	"\rdatabase_name\x18\x02 \x01(\tR\fdatabaseName\"\xfa\x01\n" +
	"\x16RestoreDatabaseRequest\x12+\n" +
	"\n" +
	"cluster_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\tclusterId\x12)\n" +
	"\rdatabase_name\x18\x02 \x01(\tB\x04\xe8\xc71\x01R\fdatabaseName\x12)\n" +
	"\rfrom_database\x18\x03 \x01(\tB\x04\xe8\xc71\x01R\ffromDatabase\x12!\n" +
	"\tbackup_id\x18\x04 \x01(\tB\x04\xe8\xc71\x01R\bbackupId\x124\n" +
	"\x04time\x18\x06 \x01(\v2\x1a.google.protobuf.TimestampB\x04\xe8\xc71\x01R\x04timeJ\x04\b\x05\x10\x06\"\xb7\x01\n" +
	"\x17RestoreDatabaseMetadata\x12#\n" +
	"\n" +
	"cluster_id\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\tclusterId\x12)\n" +
	"\rdatabase_name\x18\x02 \x01(\tB\x04\xe8\xc71\x01R\fdatabaseName\x12)\n" +
	"\rfrom_database\x18\x03 \x01(\tB\x04\xe8\xc71\x01R\ffromDatabase\x12!\n" +
	"\tbackup_id\x18\x04 \x01(\tB\x04\xe8\xc71\x01R\bbackupId\"\xcd\x01\n" +
	"\x1bImportDatabaseBackupRequest\x12+\n" +
	"\n" +
	"cluster_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\tclusterId\x12)\n" +
	"\rdatabase_name\x18\x02 \x01(\tB\x04\xe8\xc71\x01R\fdatabaseName\x12!\n" +
	"\ts3_bucket\x18\x03 \x01(\tB\x04\xe8\xc71\x01R\bs3Bucket\x12\x17\n" +
	"\as3_path\x18\x04 \x01(\tR\x06s3Path\x12\x1a\n" +
	"\x05files\x18\x05 \x03(\tB\x04\xe8\xc71\x01R\x05files\"\xaa\x01\n" +
	"\x1cImportDatabaseBackupMetadata\x12#\n" +
	"\n" +
	"cluster_id\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\tclusterId\x12)\n" +
	"\rdatabase_name\x18\x02 \x01(\tB\x04\xe8\xc71\x01R\fdatabaseName\x12!\n" +
	"\ts3_bucket\x18\x03 \x01(\tB\x04\xe8\xc71\x01R\bs3Bucket\x12\x17\n" +
	"\as3_path\x18\x04 \x01(\tR\x06s3Path\"\xc9\x01\n" +
	"\x1bExportDatabaseBackupRequest\x12+\n" +
	"\n" +
	"cluster_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\tclusterId\x12)\n" +
	"\rdatabase_name\x18\x02 \x01(\tB\x04\xe8\xc71\x01R\fdatabaseName\x12!\n" +
	"\ts3_bucket\x18\x03 \x01(\tB\x04\xe8\xc71\x01R\bs3Bucket\x12\x17\n" +
	"\as3_path\x18\x04 \x01(\tR\x06s3Path\x12\x16\n" +
	"\x06prefix\x18\x05 \x01(\tR\x06prefix\"\xaa\x01\n" +
	"\x1cExportDatabaseBackupMetadata\x12#\n" +
	"\n" +
	"cluster_id\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\tclusterId\x12)\n" +
	"\rdatabase_name\x18\x02 \x01(\tB\x04\xe8\xc71\x01R\fdatabaseName\x12!\n" +
	"\ts3_bucket\x18\x03 \x01(\tB\x04\xe8\xc71\x01R\bs3Bucket\x12\x17\n" +
	"\as3_path\x18\x04 \x01(\tR\x06s3Path2\xbe\v\n" +
	"\x0fDatabaseService\x12\xac\x01\n" +
	"\x03Get\x121.yandex.cloud.mdb.sqlserver.v1.GetDatabaseRequest\x1a'.yandex.cloud.mdb.sqlserver.v1.Database\"I\x82\xd3\xe4\x93\x02C\x12A/mdb/sqlserver/v1/clusters/{cluster_id}/databases/{database_name}\x12\xac\x01\n" +
	"\x04List\x123.yandex.cloud.mdb.sqlserver.v1.ListDatabasesRequest\x1a4.yandex.cloud.mdb.sqlserver.v1.ListDatabasesResponse\"9\x82\xd3\xe4\x93\x023\x121/mdb/sqlserver/v1/clusters/{cluster_id}/databases\x12\xc5\x01\n" +
	"\x06Create\x124.yandex.cloud.mdb.sqlserver.v1.CreateDatabaseRequest\x1a!.yandex.cloud.operation.Operation\"b\xb2\xd2*\"\n" +
	"\x16CreateDatabaseMetadata\x12\bDatabase\x82\xd3\xe4\x93\x026:\x01*\"1/mdb/sqlserver/v1/clusters/{cluster_id}/databases\x12\xd0\x01\n" +
	"\aRestore\x125.yandex.cloud.mdb.sqlserver.v1.RestoreDatabaseRequest\x1a!.yandex.cloud.operation.Operation\"k\xb2\xd2*#\n" +
	"\x17RestoreDatabaseMetadata\x12\bDatabase\x82\xd3\xe4\x93\x02>:\x01*\"9/mdb/sqlserver/v1/clusters/{cluster_id}/databases:restore\x12\xde\x01\n" +
	"\fImportBackup\x12:.yandex.cloud.mdb.sqlserver.v1.ImportDatabaseBackupRequest\x1a!.yandex.cloud.operation.Operation\"o\xb2\xd2*(\n" +
	"\x1cImportDatabaseBackupMetadata\x12\bDatabase\x82\xd3\xe4\x93\x02=:\x01*\"8/mdb/sqlserver/v1/clusters/{cluster_id}/databases:import\x12\xee\x01\n" +
	"\fExportBackup\x12:.yandex.cloud.mdb.sqlserver.v1.ExportDatabaseBackupRequest\x1a!.yandex.cloud.operation.Operation\"\x7f\xb2\xd2*(\n" +
	"\x1cExportDatabaseBackupMetadata\x12\bDatabase\x82\xd3\xe4\x93\x02M:\x01*\"H/mdb/sqlserver/v1/clusters/{cluster_id}/databases/{database_name}:export\x12\xdf\x01\n" +
	"\x06Delete\x124.yandex.cloud.mdb.sqlserver.v1.DeleteDatabaseRequest\x1a!.yandex.cloud.operation.Operation\"|\xb2\xd2*/\n" +
	"\x16DeleteDatabaseMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x02C*A/mdb/sqlserver/v1/clusters/{cluster_id}/databases/{database_name}Bv\n" +
	"!yandex.cloud.api.mdb.sqlserver.v1B\x04PSDSZKgithub.com/yandex-cloud/go-genproto/yandex/cloud/mdb/sqlserver/v1;sqlserverb\x06proto3"

var (
	file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDescOnce sync.Once
	file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDescData []byte
)

func file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDescGZIP() []byte {
	file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDesc), len(file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDesc)))
	})
	return file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDescData
}

var file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_goTypes = []any{
	(*GetDatabaseRequest)(nil),           // 0: yandex.cloud.mdb.sqlserver.v1.GetDatabaseRequest
	(*ListDatabasesRequest)(nil),         // 1: yandex.cloud.mdb.sqlserver.v1.ListDatabasesRequest
	(*ListDatabasesResponse)(nil),        // 2: yandex.cloud.mdb.sqlserver.v1.ListDatabasesResponse
	(*CreateDatabaseRequest)(nil),        // 3: yandex.cloud.mdb.sqlserver.v1.CreateDatabaseRequest
	(*CreateDatabaseMetadata)(nil),       // 4: yandex.cloud.mdb.sqlserver.v1.CreateDatabaseMetadata
	(*DeleteDatabaseRequest)(nil),        // 5: yandex.cloud.mdb.sqlserver.v1.DeleteDatabaseRequest
	(*DeleteDatabaseMetadata)(nil),       // 6: yandex.cloud.mdb.sqlserver.v1.DeleteDatabaseMetadata
	(*RestoreDatabaseRequest)(nil),       // 7: yandex.cloud.mdb.sqlserver.v1.RestoreDatabaseRequest
	(*RestoreDatabaseMetadata)(nil),      // 8: yandex.cloud.mdb.sqlserver.v1.RestoreDatabaseMetadata
	(*ImportDatabaseBackupRequest)(nil),  // 9: yandex.cloud.mdb.sqlserver.v1.ImportDatabaseBackupRequest
	(*ImportDatabaseBackupMetadata)(nil), // 10: yandex.cloud.mdb.sqlserver.v1.ImportDatabaseBackupMetadata
	(*ExportDatabaseBackupRequest)(nil),  // 11: yandex.cloud.mdb.sqlserver.v1.ExportDatabaseBackupRequest
	(*ExportDatabaseBackupMetadata)(nil), // 12: yandex.cloud.mdb.sqlserver.v1.ExportDatabaseBackupMetadata
	(*Database)(nil),                     // 13: yandex.cloud.mdb.sqlserver.v1.Database
	(*DatabaseSpec)(nil),                 // 14: yandex.cloud.mdb.sqlserver.v1.DatabaseSpec
	(*timestamppb.Timestamp)(nil),        // 15: google.protobuf.Timestamp
	(*operation.Operation)(nil),          // 16: yandex.cloud.operation.Operation
}
var file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_depIdxs = []int32{
	13, // 0: yandex.cloud.mdb.sqlserver.v1.ListDatabasesResponse.databases:type_name -> yandex.cloud.mdb.sqlserver.v1.Database
	14, // 1: yandex.cloud.mdb.sqlserver.v1.CreateDatabaseRequest.database_spec:type_name -> yandex.cloud.mdb.sqlserver.v1.DatabaseSpec
	15, // 2: yandex.cloud.mdb.sqlserver.v1.RestoreDatabaseRequest.time:type_name -> google.protobuf.Timestamp
	0,  // 3: yandex.cloud.mdb.sqlserver.v1.DatabaseService.Get:input_type -> yandex.cloud.mdb.sqlserver.v1.GetDatabaseRequest
	1,  // 4: yandex.cloud.mdb.sqlserver.v1.DatabaseService.List:input_type -> yandex.cloud.mdb.sqlserver.v1.ListDatabasesRequest
	3,  // 5: yandex.cloud.mdb.sqlserver.v1.DatabaseService.Create:input_type -> yandex.cloud.mdb.sqlserver.v1.CreateDatabaseRequest
	7,  // 6: yandex.cloud.mdb.sqlserver.v1.DatabaseService.Restore:input_type -> yandex.cloud.mdb.sqlserver.v1.RestoreDatabaseRequest
	9,  // 7: yandex.cloud.mdb.sqlserver.v1.DatabaseService.ImportBackup:input_type -> yandex.cloud.mdb.sqlserver.v1.ImportDatabaseBackupRequest
	11, // 8: yandex.cloud.mdb.sqlserver.v1.DatabaseService.ExportBackup:input_type -> yandex.cloud.mdb.sqlserver.v1.ExportDatabaseBackupRequest
	5,  // 9: yandex.cloud.mdb.sqlserver.v1.DatabaseService.Delete:input_type -> yandex.cloud.mdb.sqlserver.v1.DeleteDatabaseRequest
	13, // 10: yandex.cloud.mdb.sqlserver.v1.DatabaseService.Get:output_type -> yandex.cloud.mdb.sqlserver.v1.Database
	2,  // 11: yandex.cloud.mdb.sqlserver.v1.DatabaseService.List:output_type -> yandex.cloud.mdb.sqlserver.v1.ListDatabasesResponse
	16, // 12: yandex.cloud.mdb.sqlserver.v1.DatabaseService.Create:output_type -> yandex.cloud.operation.Operation
	16, // 13: yandex.cloud.mdb.sqlserver.v1.DatabaseService.Restore:output_type -> yandex.cloud.operation.Operation
	16, // 14: yandex.cloud.mdb.sqlserver.v1.DatabaseService.ImportBackup:output_type -> yandex.cloud.operation.Operation
	16, // 15: yandex.cloud.mdb.sqlserver.v1.DatabaseService.ExportBackup:output_type -> yandex.cloud.operation.Operation
	16, // 16: yandex.cloud.mdb.sqlserver.v1.DatabaseService.Delete:output_type -> yandex.cloud.operation.Operation
	10, // [10:17] is the sub-list for method output_type
	3,  // [3:10] is the sub-list for method input_type
	3,  // [3:3] is the sub-list for extension type_name
	3,  // [3:3] is the sub-list for extension extendee
	0,  // [0:3] is the sub-list for field type_name
}

func init() { file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_init() }
func file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_init() {
	if File_yandex_cloud_mdb_sqlserver_v1_database_service_proto != nil {
		return
	}
	file_yandex_cloud_mdb_sqlserver_v1_database_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDesc), len(file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_depIdxs,
		MessageInfos:      file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_msgTypes,
	}.Build()
	File_yandex_cloud_mdb_sqlserver_v1_database_service_proto = out.File
	file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_goTypes = nil
	file_yandex_cloud_mdb_sqlserver_v1_database_service_proto_depIdxs = nil
}
