// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/video/livestream/v1/service.proto

package livestreampb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	LivestreamService_CreateChannel_FullMethodName     = "/google.cloud.video.livestream.v1.LivestreamService/CreateChannel"
	LivestreamService_ListChannels_FullMethodName      = "/google.cloud.video.livestream.v1.LivestreamService/ListChannels"
	LivestreamService_GetChannel_FullMethodName        = "/google.cloud.video.livestream.v1.LivestreamService/GetChannel"
	LivestreamService_DeleteChannel_FullMethodName     = "/google.cloud.video.livestream.v1.LivestreamService/DeleteChannel"
	LivestreamService_UpdateChannel_FullMethodName     = "/google.cloud.video.livestream.v1.LivestreamService/UpdateChannel"
	LivestreamService_StartChannel_FullMethodName      = "/google.cloud.video.livestream.v1.LivestreamService/StartChannel"
	LivestreamService_StopChannel_FullMethodName       = "/google.cloud.video.livestream.v1.LivestreamService/StopChannel"
	LivestreamService_StartDistribution_FullMethodName = "/google.cloud.video.livestream.v1.LivestreamService/StartDistribution"
	LivestreamService_StopDistribution_FullMethodName  = "/google.cloud.video.livestream.v1.LivestreamService/StopDistribution"
	LivestreamService_CreateInput_FullMethodName       = "/google.cloud.video.livestream.v1.LivestreamService/CreateInput"
	LivestreamService_ListInputs_FullMethodName        = "/google.cloud.video.livestream.v1.LivestreamService/ListInputs"
	LivestreamService_GetInput_FullMethodName          = "/google.cloud.video.livestream.v1.LivestreamService/GetInput"
	LivestreamService_DeleteInput_FullMethodName       = "/google.cloud.video.livestream.v1.LivestreamService/DeleteInput"
	LivestreamService_UpdateInput_FullMethodName       = "/google.cloud.video.livestream.v1.LivestreamService/UpdateInput"
	LivestreamService_PreviewInput_FullMethodName      = "/google.cloud.video.livestream.v1.LivestreamService/PreviewInput"
	LivestreamService_CreateEvent_FullMethodName       = "/google.cloud.video.livestream.v1.LivestreamService/CreateEvent"
	LivestreamService_ListEvents_FullMethodName        = "/google.cloud.video.livestream.v1.LivestreamService/ListEvents"
	LivestreamService_GetEvent_FullMethodName          = "/google.cloud.video.livestream.v1.LivestreamService/GetEvent"
	LivestreamService_DeleteEvent_FullMethodName       = "/google.cloud.video.livestream.v1.LivestreamService/DeleteEvent"
	LivestreamService_ListClips_FullMethodName         = "/google.cloud.video.livestream.v1.LivestreamService/ListClips"
	LivestreamService_GetClip_FullMethodName           = "/google.cloud.video.livestream.v1.LivestreamService/GetClip"
	LivestreamService_CreateClip_FullMethodName        = "/google.cloud.video.livestream.v1.LivestreamService/CreateClip"
	LivestreamService_DeleteClip_FullMethodName        = "/google.cloud.video.livestream.v1.LivestreamService/DeleteClip"
	LivestreamService_CreateDvrSession_FullMethodName  = "/google.cloud.video.livestream.v1.LivestreamService/CreateDvrSession"
	LivestreamService_ListDvrSessions_FullMethodName   = "/google.cloud.video.livestream.v1.LivestreamService/ListDvrSessions"
	LivestreamService_GetDvrSession_FullMethodName     = "/google.cloud.video.livestream.v1.LivestreamService/GetDvrSession"
	LivestreamService_DeleteDvrSession_FullMethodName  = "/google.cloud.video.livestream.v1.LivestreamService/DeleteDvrSession"
	LivestreamService_UpdateDvrSession_FullMethodName  = "/google.cloud.video.livestream.v1.LivestreamService/UpdateDvrSession"
	LivestreamService_CreateAsset_FullMethodName       = "/google.cloud.video.livestream.v1.LivestreamService/CreateAsset"
	LivestreamService_DeleteAsset_FullMethodName       = "/google.cloud.video.livestream.v1.LivestreamService/DeleteAsset"
	LivestreamService_GetAsset_FullMethodName          = "/google.cloud.video.livestream.v1.LivestreamService/GetAsset"
	LivestreamService_ListAssets_FullMethodName        = "/google.cloud.video.livestream.v1.LivestreamService/ListAssets"
	LivestreamService_GetPool_FullMethodName           = "/google.cloud.video.livestream.v1.LivestreamService/GetPool"
	LivestreamService_UpdatePool_FullMethodName        = "/google.cloud.video.livestream.v1.LivestreamService/UpdatePool"
)

// LivestreamServiceClient is the client API for LivestreamService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type LivestreamServiceClient interface {
	// Creates a channel with the provided unique ID in the specified
	// region.
	CreateChannel(ctx context.Context, in *CreateChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns a list of all channels in the specified region.
	ListChannels(ctx context.Context, in *ListChannelsRequest, opts ...grpc.CallOption) (*ListChannelsResponse, error)
	// Returns the specified channel.
	GetChannel(ctx context.Context, in *GetChannelRequest, opts ...grpc.CallOption) (*Channel, error)
	// Deletes the specified channel.
	DeleteChannel(ctx context.Context, in *DeleteChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the specified channel.
	UpdateChannel(ctx context.Context, in *UpdateChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Starts the specified channel. Part of the video pipeline will be created
	// only when the StartChannel request is received by the server.
	StartChannel(ctx context.Context, in *StartChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Stops the specified channel. Part of the video pipeline will be released
	// when the StopChannel request is received by the server.
	StopChannel(ctx context.Context, in *StopChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Starts distribution which delivers outputs to the destination indicated by
	// the Distribution configuration.
	StartDistribution(ctx context.Context, in *StartDistributionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Stops the specified distribution.
	StopDistribution(ctx context.Context, in *StopDistributionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates an input with the provided unique ID in the specified region.
	CreateInput(ctx context.Context, in *CreateInputRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns a list of all inputs in the specified region.
	ListInputs(ctx context.Context, in *ListInputsRequest, opts ...grpc.CallOption) (*ListInputsResponse, error)
	// Returns the specified input.
	GetInput(ctx context.Context, in *GetInputRequest, opts ...grpc.CallOption) (*Input, error)
	// Deletes the specified input.
	DeleteInput(ctx context.Context, in *DeleteInputRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the specified input.
	UpdateInput(ctx context.Context, in *UpdateInputRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Preview the streaming content of the specified input.
	PreviewInput(ctx context.Context, in *PreviewInputRequest, opts ...grpc.CallOption) (*PreviewInputResponse, error)
	// Creates an event with the provided unique ID in the specified channel.
	CreateEvent(ctx context.Context, in *CreateEventRequest, opts ...grpc.CallOption) (*Event, error)
	// Returns a list of all events in the specified channel.
	ListEvents(ctx context.Context, in *ListEventsRequest, opts ...grpc.CallOption) (*ListEventsResponse, error)
	// Returns the specified event.
	GetEvent(ctx context.Context, in *GetEventRequest, opts ...grpc.CallOption) (*Event, error)
	// Deletes the specified event.
	DeleteEvent(ctx context.Context, in *DeleteEventRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns a list of all clips in the specified channel.
	ListClips(ctx context.Context, in *ListClipsRequest, opts ...grpc.CallOption) (*ListClipsResponse, error)
	// Returns the specified clip.
	GetClip(ctx context.Context, in *GetClipRequest, opts ...grpc.CallOption) (*Clip, error)
	// Creates a clip with the provided clip ID in the specified channel.
	CreateClip(ctx context.Context, in *CreateClipRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes the specified clip job resource. This method only deletes the clip
	// job and does not delete the VOD clip stored in Cloud Storage.
	DeleteClip(ctx context.Context, in *DeleteClipRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a DVR session with the provided unique ID in the specified channel.
	CreateDvrSession(ctx context.Context, in *CreateDvrSessionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns a list of all DVR sessions in the specified channel.
	ListDvrSessions(ctx context.Context, in *ListDvrSessionsRequest, opts ...grpc.CallOption) (*ListDvrSessionsResponse, error)
	// Returns the specified DVR session.
	GetDvrSession(ctx context.Context, in *GetDvrSessionRequest, opts ...grpc.CallOption) (*DvrSession, error)
	// Deletes the specified DVR session.
	DeleteDvrSession(ctx context.Context, in *DeleteDvrSessionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the specified DVR session.
	UpdateDvrSession(ctx context.Context, in *UpdateDvrSessionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a Asset with the provided unique ID in the specified
	// region.
	CreateAsset(ctx context.Context, in *CreateAssetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes the specified asset if it is not used.
	DeleteAsset(ctx context.Context, in *DeleteAssetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns the specified asset.
	GetAsset(ctx context.Context, in *GetAssetRequest, opts ...grpc.CallOption) (*Asset, error)
	// Returns a list of all assets in the specified region.
	ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error)
	// Returns the specified pool.
	GetPool(ctx context.Context, in *GetPoolRequest, opts ...grpc.CallOption) (*Pool, error)
	// Updates the specified pool.
	UpdatePool(ctx context.Context, in *UpdatePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type livestreamServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewLivestreamServiceClient(cc grpc.ClientConnInterface) LivestreamServiceClient {
	return &livestreamServiceClient{cc}
}

func (c *livestreamServiceClient) CreateChannel(ctx context.Context, in *CreateChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, LivestreamService_CreateChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) ListChannels(ctx context.Context, in *ListChannelsRequest, opts ...grpc.CallOption) (*ListChannelsResponse, error) {
	out := new(ListChannelsResponse)
	err := c.cc.Invoke(ctx, LivestreamService_ListChannels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) GetChannel(ctx context.Context, in *GetChannelRequest, opts ...grpc.CallOption) (*Channel, error) {
	out := new(Channel)
	err := c.cc.Invoke(ctx, LivestreamService_GetChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) DeleteChannel(ctx context.Context, in *DeleteChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, LivestreamService_DeleteChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) UpdateChannel(ctx context.Context, in *UpdateChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, LivestreamService_UpdateChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) StartChannel(ctx context.Context, in *StartChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, LivestreamService_StartChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) StopChannel(ctx context.Context, in *StopChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, LivestreamService_StopChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) StartDistribution(ctx context.Context, in *StartDistributionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, LivestreamService_StartDistribution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) StopDistribution(ctx context.Context, in *StopDistributionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, LivestreamService_StopDistribution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) CreateInput(ctx context.Context, in *CreateInputRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, LivestreamService_CreateInput_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) ListInputs(ctx context.Context, in *ListInputsRequest, opts ...grpc.CallOption) (*ListInputsResponse, error) {
	out := new(ListInputsResponse)
	err := c.cc.Invoke(ctx, LivestreamService_ListInputs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) GetInput(ctx context.Context, in *GetInputRequest, opts ...grpc.CallOption) (*Input, error) {
	out := new(Input)
	err := c.cc.Invoke(ctx, LivestreamService_GetInput_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) DeleteInput(ctx context.Context, in *DeleteInputRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, LivestreamService_DeleteInput_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) UpdateInput(ctx context.Context, in *UpdateInputRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, LivestreamService_UpdateInput_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) PreviewInput(ctx context.Context, in *PreviewInputRequest, opts ...grpc.CallOption) (*PreviewInputResponse, error) {
	out := new(PreviewInputResponse)
	err := c.cc.Invoke(ctx, LivestreamService_PreviewInput_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) CreateEvent(ctx context.Context, in *CreateEventRequest, opts ...grpc.CallOption) (*Event, error) {
	out := new(Event)
	err := c.cc.Invoke(ctx, LivestreamService_CreateEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) ListEvents(ctx context.Context, in *ListEventsRequest, opts ...grpc.CallOption) (*ListEventsResponse, error) {
	out := new(ListEventsResponse)
	err := c.cc.Invoke(ctx, LivestreamService_ListEvents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) GetEvent(ctx context.Context, in *GetEventRequest, opts ...grpc.CallOption) (*Event, error) {
	out := new(Event)
	err := c.cc.Invoke(ctx, LivestreamService_GetEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) DeleteEvent(ctx context.Context, in *DeleteEventRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, LivestreamService_DeleteEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) ListClips(ctx context.Context, in *ListClipsRequest, opts ...grpc.CallOption) (*ListClipsResponse, error) {
	out := new(ListClipsResponse)
	err := c.cc.Invoke(ctx, LivestreamService_ListClips_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) GetClip(ctx context.Context, in *GetClipRequest, opts ...grpc.CallOption) (*Clip, error) {
	out := new(Clip)
	err := c.cc.Invoke(ctx, LivestreamService_GetClip_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) CreateClip(ctx context.Context, in *CreateClipRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, LivestreamService_CreateClip_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) DeleteClip(ctx context.Context, in *DeleteClipRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, LivestreamService_DeleteClip_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) CreateDvrSession(ctx context.Context, in *CreateDvrSessionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, LivestreamService_CreateDvrSession_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) ListDvrSessions(ctx context.Context, in *ListDvrSessionsRequest, opts ...grpc.CallOption) (*ListDvrSessionsResponse, error) {
	out := new(ListDvrSessionsResponse)
	err := c.cc.Invoke(ctx, LivestreamService_ListDvrSessions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) GetDvrSession(ctx context.Context, in *GetDvrSessionRequest, opts ...grpc.CallOption) (*DvrSession, error) {
	out := new(DvrSession)
	err := c.cc.Invoke(ctx, LivestreamService_GetDvrSession_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) DeleteDvrSession(ctx context.Context, in *DeleteDvrSessionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, LivestreamService_DeleteDvrSession_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) UpdateDvrSession(ctx context.Context, in *UpdateDvrSessionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, LivestreamService_UpdateDvrSession_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) CreateAsset(ctx context.Context, in *CreateAssetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, LivestreamService_CreateAsset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) DeleteAsset(ctx context.Context, in *DeleteAssetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, LivestreamService_DeleteAsset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) GetAsset(ctx context.Context, in *GetAssetRequest, opts ...grpc.CallOption) (*Asset, error) {
	out := new(Asset)
	err := c.cc.Invoke(ctx, LivestreamService_GetAsset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error) {
	out := new(ListAssetsResponse)
	err := c.cc.Invoke(ctx, LivestreamService_ListAssets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) GetPool(ctx context.Context, in *GetPoolRequest, opts ...grpc.CallOption) (*Pool, error) {
	out := new(Pool)
	err := c.cc.Invoke(ctx, LivestreamService_GetPool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livestreamServiceClient) UpdatePool(ctx context.Context, in *UpdatePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, LivestreamService_UpdatePool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LivestreamServiceServer is the server API for LivestreamService service.
// All implementations should embed UnimplementedLivestreamServiceServer
// for forward compatibility
type LivestreamServiceServer interface {
	// Creates a channel with the provided unique ID in the specified
	// region.
	CreateChannel(context.Context, *CreateChannelRequest) (*longrunningpb.Operation, error)
	// Returns a list of all channels in the specified region.
	ListChannels(context.Context, *ListChannelsRequest) (*ListChannelsResponse, error)
	// Returns the specified channel.
	GetChannel(context.Context, *GetChannelRequest) (*Channel, error)
	// Deletes the specified channel.
	DeleteChannel(context.Context, *DeleteChannelRequest) (*longrunningpb.Operation, error)
	// Updates the specified channel.
	UpdateChannel(context.Context, *UpdateChannelRequest) (*longrunningpb.Operation, error)
	// Starts the specified channel. Part of the video pipeline will be created
	// only when the StartChannel request is received by the server.
	StartChannel(context.Context, *StartChannelRequest) (*longrunningpb.Operation, error)
	// Stops the specified channel. Part of the video pipeline will be released
	// when the StopChannel request is received by the server.
	StopChannel(context.Context, *StopChannelRequest) (*longrunningpb.Operation, error)
	// Starts distribution which delivers outputs to the destination indicated by
	// the Distribution configuration.
	StartDistribution(context.Context, *StartDistributionRequest) (*longrunningpb.Operation, error)
	// Stops the specified distribution.
	StopDistribution(context.Context, *StopDistributionRequest) (*longrunningpb.Operation, error)
	// Creates an input with the provided unique ID in the specified region.
	CreateInput(context.Context, *CreateInputRequest) (*longrunningpb.Operation, error)
	// Returns a list of all inputs in the specified region.
	ListInputs(context.Context, *ListInputsRequest) (*ListInputsResponse, error)
	// Returns the specified input.
	GetInput(context.Context, *GetInputRequest) (*Input, error)
	// Deletes the specified input.
	DeleteInput(context.Context, *DeleteInputRequest) (*longrunningpb.Operation, error)
	// Updates the specified input.
	UpdateInput(context.Context, *UpdateInputRequest) (*longrunningpb.Operation, error)
	// Preview the streaming content of the specified input.
	PreviewInput(context.Context, *PreviewInputRequest) (*PreviewInputResponse, error)
	// Creates an event with the provided unique ID in the specified channel.
	CreateEvent(context.Context, *CreateEventRequest) (*Event, error)
	// Returns a list of all events in the specified channel.
	ListEvents(context.Context, *ListEventsRequest) (*ListEventsResponse, error)
	// Returns the specified event.
	GetEvent(context.Context, *GetEventRequest) (*Event, error)
	// Deletes the specified event.
	DeleteEvent(context.Context, *DeleteEventRequest) (*emptypb.Empty, error)
	// Returns a list of all clips in the specified channel.
	ListClips(context.Context, *ListClipsRequest) (*ListClipsResponse, error)
	// Returns the specified clip.
	GetClip(context.Context, *GetClipRequest) (*Clip, error)
	// Creates a clip with the provided clip ID in the specified channel.
	CreateClip(context.Context, *CreateClipRequest) (*longrunningpb.Operation, error)
	// Deletes the specified clip job resource. This method only deletes the clip
	// job and does not delete the VOD clip stored in Cloud Storage.
	DeleteClip(context.Context, *DeleteClipRequest) (*longrunningpb.Operation, error)
	// Creates a DVR session with the provided unique ID in the specified channel.
	CreateDvrSession(context.Context, *CreateDvrSessionRequest) (*longrunningpb.Operation, error)
	// Returns a list of all DVR sessions in the specified channel.
	ListDvrSessions(context.Context, *ListDvrSessionsRequest) (*ListDvrSessionsResponse, error)
	// Returns the specified DVR session.
	GetDvrSession(context.Context, *GetDvrSessionRequest) (*DvrSession, error)
	// Deletes the specified DVR session.
	DeleteDvrSession(context.Context, *DeleteDvrSessionRequest) (*longrunningpb.Operation, error)
	// Updates the specified DVR session.
	UpdateDvrSession(context.Context, *UpdateDvrSessionRequest) (*longrunningpb.Operation, error)
	// Creates a Asset with the provided unique ID in the specified
	// region.
	CreateAsset(context.Context, *CreateAssetRequest) (*longrunningpb.Operation, error)
	// Deletes the specified asset if it is not used.
	DeleteAsset(context.Context, *DeleteAssetRequest) (*longrunningpb.Operation, error)
	// Returns the specified asset.
	GetAsset(context.Context, *GetAssetRequest) (*Asset, error)
	// Returns a list of all assets in the specified region.
	ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error)
	// Returns the specified pool.
	GetPool(context.Context, *GetPoolRequest) (*Pool, error)
	// Updates the specified pool.
	UpdatePool(context.Context, *UpdatePoolRequest) (*longrunningpb.Operation, error)
}

// UnimplementedLivestreamServiceServer should be embedded to have forward compatible implementations.
type UnimplementedLivestreamServiceServer struct {
}

func (UnimplementedLivestreamServiceServer) CreateChannel(context.Context, *CreateChannelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateChannel not implemented")
}
func (UnimplementedLivestreamServiceServer) ListChannels(context.Context, *ListChannelsRequest) (*ListChannelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListChannels not implemented")
}
func (UnimplementedLivestreamServiceServer) GetChannel(context.Context, *GetChannelRequest) (*Channel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetChannel not implemented")
}
func (UnimplementedLivestreamServiceServer) DeleteChannel(context.Context, *DeleteChannelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteChannel not implemented")
}
func (UnimplementedLivestreamServiceServer) UpdateChannel(context.Context, *UpdateChannelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateChannel not implemented")
}
func (UnimplementedLivestreamServiceServer) StartChannel(context.Context, *StartChannelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartChannel not implemented")
}
func (UnimplementedLivestreamServiceServer) StopChannel(context.Context, *StopChannelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopChannel not implemented")
}
func (UnimplementedLivestreamServiceServer) StartDistribution(context.Context, *StartDistributionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartDistribution not implemented")
}
func (UnimplementedLivestreamServiceServer) StopDistribution(context.Context, *StopDistributionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopDistribution not implemented")
}
func (UnimplementedLivestreamServiceServer) CreateInput(context.Context, *CreateInputRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInput not implemented")
}
func (UnimplementedLivestreamServiceServer) ListInputs(context.Context, *ListInputsRequest) (*ListInputsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInputs not implemented")
}
func (UnimplementedLivestreamServiceServer) GetInput(context.Context, *GetInputRequest) (*Input, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInput not implemented")
}
func (UnimplementedLivestreamServiceServer) DeleteInput(context.Context, *DeleteInputRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInput not implemented")
}
func (UnimplementedLivestreamServiceServer) UpdateInput(context.Context, *UpdateInputRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInput not implemented")
}
func (UnimplementedLivestreamServiceServer) PreviewInput(context.Context, *PreviewInputRequest) (*PreviewInputResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PreviewInput not implemented")
}
func (UnimplementedLivestreamServiceServer) CreateEvent(context.Context, *CreateEventRequest) (*Event, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEvent not implemented")
}
func (UnimplementedLivestreamServiceServer) ListEvents(context.Context, *ListEventsRequest) (*ListEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEvents not implemented")
}
func (UnimplementedLivestreamServiceServer) GetEvent(context.Context, *GetEventRequest) (*Event, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEvent not implemented")
}
func (UnimplementedLivestreamServiceServer) DeleteEvent(context.Context, *DeleteEventRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEvent not implemented")
}
func (UnimplementedLivestreamServiceServer) ListClips(context.Context, *ListClipsRequest) (*ListClipsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListClips not implemented")
}
func (UnimplementedLivestreamServiceServer) GetClip(context.Context, *GetClipRequest) (*Clip, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetClip not implemented")
}
func (UnimplementedLivestreamServiceServer) CreateClip(context.Context, *CreateClipRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateClip not implemented")
}
func (UnimplementedLivestreamServiceServer) DeleteClip(context.Context, *DeleteClipRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteClip not implemented")
}
func (UnimplementedLivestreamServiceServer) CreateDvrSession(context.Context, *CreateDvrSessionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDvrSession not implemented")
}
func (UnimplementedLivestreamServiceServer) ListDvrSessions(context.Context, *ListDvrSessionsRequest) (*ListDvrSessionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDvrSessions not implemented")
}
func (UnimplementedLivestreamServiceServer) GetDvrSession(context.Context, *GetDvrSessionRequest) (*DvrSession, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDvrSession not implemented")
}
func (UnimplementedLivestreamServiceServer) DeleteDvrSession(context.Context, *DeleteDvrSessionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDvrSession not implemented")
}
func (UnimplementedLivestreamServiceServer) UpdateDvrSession(context.Context, *UpdateDvrSessionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDvrSession not implemented")
}
func (UnimplementedLivestreamServiceServer) CreateAsset(context.Context, *CreateAssetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAsset not implemented")
}
func (UnimplementedLivestreamServiceServer) DeleteAsset(context.Context, *DeleteAssetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAsset not implemented")
}
func (UnimplementedLivestreamServiceServer) GetAsset(context.Context, *GetAssetRequest) (*Asset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAsset not implemented")
}
func (UnimplementedLivestreamServiceServer) ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAssets not implemented")
}
func (UnimplementedLivestreamServiceServer) GetPool(context.Context, *GetPoolRequest) (*Pool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPool not implemented")
}
func (UnimplementedLivestreamServiceServer) UpdatePool(context.Context, *UpdatePoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePool not implemented")
}

// UnsafeLivestreamServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to LivestreamServiceServer will
// result in compilation errors.
type UnsafeLivestreamServiceServer interface {
	mustEmbedUnimplementedLivestreamServiceServer()
}

func RegisterLivestreamServiceServer(s grpc.ServiceRegistrar, srv LivestreamServiceServer) {
	s.RegisterService(&LivestreamService_ServiceDesc, srv)
}

func _LivestreamService_CreateChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).CreateChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_CreateChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).CreateChannel(ctx, req.(*CreateChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_ListChannels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListChannelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).ListChannels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_ListChannels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).ListChannels(ctx, req.(*ListChannelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_GetChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).GetChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_GetChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).GetChannel(ctx, req.(*GetChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_DeleteChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).DeleteChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_DeleteChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).DeleteChannel(ctx, req.(*DeleteChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_UpdateChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).UpdateChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_UpdateChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).UpdateChannel(ctx, req.(*UpdateChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_StartChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).StartChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_StartChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).StartChannel(ctx, req.(*StartChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_StopChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).StopChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_StopChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).StopChannel(ctx, req.(*StopChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_StartDistribution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartDistributionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).StartDistribution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_StartDistribution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).StartDistribution(ctx, req.(*StartDistributionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_StopDistribution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopDistributionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).StopDistribution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_StopDistribution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).StopDistribution(ctx, req.(*StopDistributionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_CreateInput_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInputRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).CreateInput(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_CreateInput_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).CreateInput(ctx, req.(*CreateInputRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_ListInputs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInputsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).ListInputs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_ListInputs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).ListInputs(ctx, req.(*ListInputsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_GetInput_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInputRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).GetInput(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_GetInput_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).GetInput(ctx, req.(*GetInputRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_DeleteInput_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInputRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).DeleteInput(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_DeleteInput_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).DeleteInput(ctx, req.(*DeleteInputRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_UpdateInput_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInputRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).UpdateInput(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_UpdateInput_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).UpdateInput(ctx, req.(*UpdateInputRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_PreviewInput_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PreviewInputRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).PreviewInput(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_PreviewInput_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).PreviewInput(ctx, req.(*PreviewInputRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_CreateEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).CreateEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_CreateEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).CreateEvent(ctx, req.(*CreateEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_ListEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).ListEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_ListEvents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).ListEvents(ctx, req.(*ListEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_GetEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).GetEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_GetEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).GetEvent(ctx, req.(*GetEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_DeleteEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).DeleteEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_DeleteEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).DeleteEvent(ctx, req.(*DeleteEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_ListClips_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClipsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).ListClips(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_ListClips_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).ListClips(ctx, req.(*ListClipsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_GetClip_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClipRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).GetClip(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_GetClip_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).GetClip(ctx, req.(*GetClipRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_CreateClip_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClipRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).CreateClip(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_CreateClip_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).CreateClip(ctx, req.(*CreateClipRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_DeleteClip_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClipRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).DeleteClip(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_DeleteClip_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).DeleteClip(ctx, req.(*DeleteClipRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_CreateDvrSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDvrSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).CreateDvrSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_CreateDvrSession_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).CreateDvrSession(ctx, req.(*CreateDvrSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_ListDvrSessions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDvrSessionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).ListDvrSessions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_ListDvrSessions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).ListDvrSessions(ctx, req.(*ListDvrSessionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_GetDvrSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDvrSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).GetDvrSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_GetDvrSession_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).GetDvrSession(ctx, req.(*GetDvrSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_DeleteDvrSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDvrSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).DeleteDvrSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_DeleteDvrSession_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).DeleteDvrSession(ctx, req.(*DeleteDvrSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_UpdateDvrSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDvrSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).UpdateDvrSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_UpdateDvrSession_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).UpdateDvrSession(ctx, req.(*UpdateDvrSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_CreateAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).CreateAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_CreateAsset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).CreateAsset(ctx, req.(*CreateAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_DeleteAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).DeleteAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_DeleteAsset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).DeleteAsset(ctx, req.(*DeleteAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_GetAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).GetAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_GetAsset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).GetAsset(ctx, req.(*GetAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_ListAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).ListAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_ListAssets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).ListAssets(ctx, req.(*ListAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_GetPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).GetPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_GetPool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).GetPool(ctx, req.(*GetPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LivestreamService_UpdatePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LivestreamServiceServer).UpdatePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LivestreamService_UpdatePool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LivestreamServiceServer).UpdatePool(ctx, req.(*UpdatePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// LivestreamService_ServiceDesc is the grpc.ServiceDesc for LivestreamService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var LivestreamService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.video.livestream.v1.LivestreamService",
	HandlerType: (*LivestreamServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateChannel",
			Handler:    _LivestreamService_CreateChannel_Handler,
		},
		{
			MethodName: "ListChannels",
			Handler:    _LivestreamService_ListChannels_Handler,
		},
		{
			MethodName: "GetChannel",
			Handler:    _LivestreamService_GetChannel_Handler,
		},
		{
			MethodName: "DeleteChannel",
			Handler:    _LivestreamService_DeleteChannel_Handler,
		},
		{
			MethodName: "UpdateChannel",
			Handler:    _LivestreamService_UpdateChannel_Handler,
		},
		{
			MethodName: "StartChannel",
			Handler:    _LivestreamService_StartChannel_Handler,
		},
		{
			MethodName: "StopChannel",
			Handler:    _LivestreamService_StopChannel_Handler,
		},
		{
			MethodName: "StartDistribution",
			Handler:    _LivestreamService_StartDistribution_Handler,
		},
		{
			MethodName: "StopDistribution",
			Handler:    _LivestreamService_StopDistribution_Handler,
		},
		{
			MethodName: "CreateInput",
			Handler:    _LivestreamService_CreateInput_Handler,
		},
		{
			MethodName: "ListInputs",
			Handler:    _LivestreamService_ListInputs_Handler,
		},
		{
			MethodName: "GetInput",
			Handler:    _LivestreamService_GetInput_Handler,
		},
		{
			MethodName: "DeleteInput",
			Handler:    _LivestreamService_DeleteInput_Handler,
		},
		{
			MethodName: "UpdateInput",
			Handler:    _LivestreamService_UpdateInput_Handler,
		},
		{
			MethodName: "PreviewInput",
			Handler:    _LivestreamService_PreviewInput_Handler,
		},
		{
			MethodName: "CreateEvent",
			Handler:    _LivestreamService_CreateEvent_Handler,
		},
		{
			MethodName: "ListEvents",
			Handler:    _LivestreamService_ListEvents_Handler,
		},
		{
			MethodName: "GetEvent",
			Handler:    _LivestreamService_GetEvent_Handler,
		},
		{
			MethodName: "DeleteEvent",
			Handler:    _LivestreamService_DeleteEvent_Handler,
		},
		{
			MethodName: "ListClips",
			Handler:    _LivestreamService_ListClips_Handler,
		},
		{
			MethodName: "GetClip",
			Handler:    _LivestreamService_GetClip_Handler,
		},
		{
			MethodName: "CreateClip",
			Handler:    _LivestreamService_CreateClip_Handler,
		},
		{
			MethodName: "DeleteClip",
			Handler:    _LivestreamService_DeleteClip_Handler,
		},
		{
			MethodName: "CreateDvrSession",
			Handler:    _LivestreamService_CreateDvrSession_Handler,
		},
		{
			MethodName: "ListDvrSessions",
			Handler:    _LivestreamService_ListDvrSessions_Handler,
		},
		{
			MethodName: "GetDvrSession",
			Handler:    _LivestreamService_GetDvrSession_Handler,
		},
		{
			MethodName: "DeleteDvrSession",
			Handler:    _LivestreamService_DeleteDvrSession_Handler,
		},
		{
			MethodName: "UpdateDvrSession",
			Handler:    _LivestreamService_UpdateDvrSession_Handler,
		},
		{
			MethodName: "CreateAsset",
			Handler:    _LivestreamService_CreateAsset_Handler,
		},
		{
			MethodName: "DeleteAsset",
			Handler:    _LivestreamService_DeleteAsset_Handler,
		},
		{
			MethodName: "GetAsset",
			Handler:    _LivestreamService_GetAsset_Handler,
		},
		{
			MethodName: "ListAssets",
			Handler:    _LivestreamService_ListAssets_Handler,
		},
		{
			MethodName: "GetPool",
			Handler:    _LivestreamService_GetPool_Handler,
		},
		{
			MethodName: "UpdatePool",
			Handler:    _LivestreamService_UpdatePool_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/video/livestream/v1/service.proto",
}
