// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elb_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/elb"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To add tags to a load balancer
// This example adds two tags to the specified load balancer.
func ExampleELB_AddTags_shared00() {
	svc := elb.New(session.New())
	input := &elb.AddTagsInput{
		LoadBalancerNames: []*string{
			aws.String("my-load-balancer"),
		},
		Tags: []*elb.Tag{
			{
				Key:   aws.String("project"),
				Value: aws.String("lima"),
			},
			{
				Key:   aws.String("department"),
				Value: aws.String("digital-media"),
			},
		},
	}

	result, err := svc.AddTags(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodeTooManyTagsException:
				fmt.Println(elb.ErrCodeTooManyTagsException, aerr.Error())
			case elb.ErrCodeDuplicateTagKeysException:
				fmt.Println(elb.ErrCodeDuplicateTagKeysException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate a security group with a load balancer in a VPC
// This example associates a security group with the specified load balancer in a VPC.
func ExampleELB_ApplySecurityGroupsToLoadBalancer_shared00() {
	svc := elb.New(session.New())
	input := &elb.ApplySecurityGroupsToLoadBalancerInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		SecurityGroups: []*string{
			aws.String("sg-fc448899"),
		},
	}

	result, err := svc.ApplySecurityGroupsToLoadBalancer(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elb.ErrCodeInvalidSecurityGroupException:
				fmt.Println(elb.ErrCodeInvalidSecurityGroupException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To attach subnets to a load balancer
// This example adds the specified subnet to the set of configured subnets for the specified
// load balancer.
func ExampleELB_AttachLoadBalancerToSubnets_shared00() {
	svc := elb.New(session.New())
	input := &elb.AttachLoadBalancerToSubnetsInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		Subnets: []*string{
			aws.String("subnet-0ecac448"),
		},
	}

	result, err := svc.AttachLoadBalancerToSubnets(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elb.ErrCodeSubnetNotFoundException:
				fmt.Println(elb.ErrCodeSubnetNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidSubnetException:
				fmt.Println(elb.ErrCodeInvalidSubnetException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To specify the health check settings for your backend EC2 instances
// This example specifies the health check settings used to evaluate the health of your
// backend EC2 instances.
func ExampleELB_ConfigureHealthCheck_shared00() {
	svc := elb.New(session.New())
	input := &elb.ConfigureHealthCheckInput{
		HealthCheck: &elb.HealthCheck{
			HealthyThreshold:   aws.Int64(2),
			Interval:           aws.Int64(30),
			Target:             aws.String("HTTP:80/png"),
			Timeout:            aws.Int64(3),
			UnhealthyThreshold: aws.Int64(2),
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	result, err := svc.ConfigureHealthCheck(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To generate a stickiness policy for your load balancer
// This example generates a stickiness policy that follows the sticky session lifetimes
// of the application-generated cookie.
func ExampleELB_CreateAppCookieStickinessPolicy_shared00() {
	svc := elb.New(session.New())
	input := &elb.CreateAppCookieStickinessPolicyInput{
		CookieName:       aws.String("my-app-cookie"),
		LoadBalancerName: aws.String("my-load-balancer"),
		PolicyName:       aws.String("my-app-cookie-policy"),
	}

	result, err := svc.CreateAppCookieStickinessPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodeDuplicatePolicyNameException:
				fmt.Println(elb.ErrCodeDuplicatePolicyNameException, aerr.Error())
			case elb.ErrCodeTooManyPoliciesException:
				fmt.Println(elb.ErrCodeTooManyPoliciesException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To generate a duration-based stickiness policy for your load balancer
// This example generates a stickiness policy with sticky session lifetimes controlled
// by the specified expiration period.
func ExampleELB_CreateLBCookieStickinessPolicy_shared00() {
	svc := elb.New(session.New())
	input := &elb.CreateLBCookieStickinessPolicyInput{
		CookieExpirationPeriod: aws.Int64(60),
		LoadBalancerName:       aws.String("my-load-balancer"),
		PolicyName:             aws.String("my-duration-cookie-policy"),
	}

	result, err := svc.CreateLBCookieStickinessPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodeDuplicatePolicyNameException:
				fmt.Println(elb.ErrCodeDuplicatePolicyNameException, aerr.Error())
			case elb.ErrCodeTooManyPoliciesException:
				fmt.Println(elb.ErrCodeTooManyPoliciesException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an HTTP load balancer in a VPC
// This example creates a load balancer with an HTTP listener in a VPC.
func ExampleELB_CreateLoadBalancer_shared00() {
	svc := elb.New(session.New())
	input := &elb.CreateLoadBalancerInput{
		Listeners: []*elb.Listener{
			{
				InstancePort:     aws.Int64(80),
				InstanceProtocol: aws.String("HTTP"),
				LoadBalancerPort: aws.Int64(80),
				Protocol:         aws.String("HTTP"),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
		SecurityGroups: []*string{
			aws.String("sg-a61988c3"),
		},
		Subnets: []*string{
			aws.String("subnet-15aaab61"),
		},
	}

	result, err := svc.CreateLoadBalancer(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeDuplicateAccessPointNameException:
				fmt.Println(elb.ErrCodeDuplicateAccessPointNameException, aerr.Error())
			case elb.ErrCodeTooManyAccessPointsException:
				fmt.Println(elb.ErrCodeTooManyAccessPointsException, aerr.Error())
			case elb.ErrCodeCertificateNotFoundException:
				fmt.Println(elb.ErrCodeCertificateNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elb.ErrCodeSubnetNotFoundException:
				fmt.Println(elb.ErrCodeSubnetNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidSubnetException:
				fmt.Println(elb.ErrCodeInvalidSubnetException, aerr.Error())
			case elb.ErrCodeInvalidSecurityGroupException:
				fmt.Println(elb.ErrCodeInvalidSecurityGroupException, aerr.Error())
			case elb.ErrCodeInvalidSchemeException:
				fmt.Println(elb.ErrCodeInvalidSchemeException, aerr.Error())
			case elb.ErrCodeTooManyTagsException:
				fmt.Println(elb.ErrCodeTooManyTagsException, aerr.Error())
			case elb.ErrCodeDuplicateTagKeysException:
				fmt.Println(elb.ErrCodeDuplicateTagKeysException, aerr.Error())
			case elb.ErrCodeUnsupportedProtocolException:
				fmt.Println(elb.ErrCodeUnsupportedProtocolException, aerr.Error())
			case elb.ErrCodeOperationNotPermittedException:
				fmt.Println(elb.ErrCodeOperationNotPermittedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an HTTP load balancer in EC2-Classic
// This example creates a load balancer with an HTTP listener in EC2-Classic.
func ExampleELB_CreateLoadBalancer_shared01() {
	svc := elb.New(session.New())
	input := &elb.CreateLoadBalancerInput{
		AvailabilityZones: []*string{
			aws.String("us-west-2a"),
		},
		Listeners: []*elb.Listener{
			{
				InstancePort:     aws.Int64(80),
				InstanceProtocol: aws.String("HTTP"),
				LoadBalancerPort: aws.Int64(80),
				Protocol:         aws.String("HTTP"),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	result, err := svc.CreateLoadBalancer(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeDuplicateAccessPointNameException:
				fmt.Println(elb.ErrCodeDuplicateAccessPointNameException, aerr.Error())
			case elb.ErrCodeTooManyAccessPointsException:
				fmt.Println(elb.ErrCodeTooManyAccessPointsException, aerr.Error())
			case elb.ErrCodeCertificateNotFoundException:
				fmt.Println(elb.ErrCodeCertificateNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elb.ErrCodeSubnetNotFoundException:
				fmt.Println(elb.ErrCodeSubnetNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidSubnetException:
				fmt.Println(elb.ErrCodeInvalidSubnetException, aerr.Error())
			case elb.ErrCodeInvalidSecurityGroupException:
				fmt.Println(elb.ErrCodeInvalidSecurityGroupException, aerr.Error())
			case elb.ErrCodeInvalidSchemeException:
				fmt.Println(elb.ErrCodeInvalidSchemeException, aerr.Error())
			case elb.ErrCodeTooManyTagsException:
				fmt.Println(elb.ErrCodeTooManyTagsException, aerr.Error())
			case elb.ErrCodeDuplicateTagKeysException:
				fmt.Println(elb.ErrCodeDuplicateTagKeysException, aerr.Error())
			case elb.ErrCodeUnsupportedProtocolException:
				fmt.Println(elb.ErrCodeUnsupportedProtocolException, aerr.Error())
			case elb.ErrCodeOperationNotPermittedException:
				fmt.Println(elb.ErrCodeOperationNotPermittedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an HTTPS load balancer in a VPC
// This example creates a load balancer with an HTTPS listener in a VPC.
func ExampleELB_CreateLoadBalancer_shared02() {
	svc := elb.New(session.New())
	input := &elb.CreateLoadBalancerInput{
		Listeners: []*elb.Listener{
			{
				InstancePort:     aws.Int64(80),
				InstanceProtocol: aws.String("HTTP"),
				LoadBalancerPort: aws.Int64(80),
				Protocol:         aws.String("HTTP"),
			},
			{
				InstancePort:     aws.Int64(80),
				InstanceProtocol: aws.String("HTTP"),
				LoadBalancerPort: aws.Int64(443),
				Protocol:         aws.String("HTTPS"),
				SSLCertificateId: aws.String("arn:aws:iam::123456789012:server-certificate/my-server-cert"),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
		SecurityGroups: []*string{
			aws.String("sg-a61988c3"),
		},
		Subnets: []*string{
			aws.String("subnet-15aaab61"),
		},
	}

	result, err := svc.CreateLoadBalancer(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeDuplicateAccessPointNameException:
				fmt.Println(elb.ErrCodeDuplicateAccessPointNameException, aerr.Error())
			case elb.ErrCodeTooManyAccessPointsException:
				fmt.Println(elb.ErrCodeTooManyAccessPointsException, aerr.Error())
			case elb.ErrCodeCertificateNotFoundException:
				fmt.Println(elb.ErrCodeCertificateNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elb.ErrCodeSubnetNotFoundException:
				fmt.Println(elb.ErrCodeSubnetNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidSubnetException:
				fmt.Println(elb.ErrCodeInvalidSubnetException, aerr.Error())
			case elb.ErrCodeInvalidSecurityGroupException:
				fmt.Println(elb.ErrCodeInvalidSecurityGroupException, aerr.Error())
			case elb.ErrCodeInvalidSchemeException:
				fmt.Println(elb.ErrCodeInvalidSchemeException, aerr.Error())
			case elb.ErrCodeTooManyTagsException:
				fmt.Println(elb.ErrCodeTooManyTagsException, aerr.Error())
			case elb.ErrCodeDuplicateTagKeysException:
				fmt.Println(elb.ErrCodeDuplicateTagKeysException, aerr.Error())
			case elb.ErrCodeUnsupportedProtocolException:
				fmt.Println(elb.ErrCodeUnsupportedProtocolException, aerr.Error())
			case elb.ErrCodeOperationNotPermittedException:
				fmt.Println(elb.ErrCodeOperationNotPermittedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an HTTPS load balancer in EC2-Classic
// This example creates a load balancer with an HTTPS listener in EC2-Classic.
func ExampleELB_CreateLoadBalancer_shared03() {
	svc := elb.New(session.New())
	input := &elb.CreateLoadBalancerInput{
		AvailabilityZones: []*string{
			aws.String("us-west-2a"),
		},
		Listeners: []*elb.Listener{
			{
				InstancePort:     aws.Int64(80),
				InstanceProtocol: aws.String("HTTP"),
				LoadBalancerPort: aws.Int64(80),
				Protocol:         aws.String("HTTP"),
			},
			{
				InstancePort:     aws.Int64(80),
				InstanceProtocol: aws.String("HTTP"),
				LoadBalancerPort: aws.Int64(443),
				Protocol:         aws.String("HTTPS"),
				SSLCertificateId: aws.String("arn:aws:iam::123456789012:server-certificate/my-server-cert"),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	result, err := svc.CreateLoadBalancer(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeDuplicateAccessPointNameException:
				fmt.Println(elb.ErrCodeDuplicateAccessPointNameException, aerr.Error())
			case elb.ErrCodeTooManyAccessPointsException:
				fmt.Println(elb.ErrCodeTooManyAccessPointsException, aerr.Error())
			case elb.ErrCodeCertificateNotFoundException:
				fmt.Println(elb.ErrCodeCertificateNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elb.ErrCodeSubnetNotFoundException:
				fmt.Println(elb.ErrCodeSubnetNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidSubnetException:
				fmt.Println(elb.ErrCodeInvalidSubnetException, aerr.Error())
			case elb.ErrCodeInvalidSecurityGroupException:
				fmt.Println(elb.ErrCodeInvalidSecurityGroupException, aerr.Error())
			case elb.ErrCodeInvalidSchemeException:
				fmt.Println(elb.ErrCodeInvalidSchemeException, aerr.Error())
			case elb.ErrCodeTooManyTagsException:
				fmt.Println(elb.ErrCodeTooManyTagsException, aerr.Error())
			case elb.ErrCodeDuplicateTagKeysException:
				fmt.Println(elb.ErrCodeDuplicateTagKeysException, aerr.Error())
			case elb.ErrCodeUnsupportedProtocolException:
				fmt.Println(elb.ErrCodeUnsupportedProtocolException, aerr.Error())
			case elb.ErrCodeOperationNotPermittedException:
				fmt.Println(elb.ErrCodeOperationNotPermittedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an internal load balancer
// This example creates an internal load balancer with an HTTP listener in a VPC.
func ExampleELB_CreateLoadBalancer_shared04() {
	svc := elb.New(session.New())
	input := &elb.CreateLoadBalancerInput{
		Listeners: []*elb.Listener{
			{
				InstancePort:     aws.Int64(80),
				InstanceProtocol: aws.String("HTTP"),
				LoadBalancerPort: aws.Int64(80),
				Protocol:         aws.String("HTTP"),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
		Scheme:           aws.String("internal"),
		SecurityGroups: []*string{
			aws.String("sg-a61988c3"),
		},
		Subnets: []*string{
			aws.String("subnet-15aaab61"),
		},
	}

	result, err := svc.CreateLoadBalancer(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeDuplicateAccessPointNameException:
				fmt.Println(elb.ErrCodeDuplicateAccessPointNameException, aerr.Error())
			case elb.ErrCodeTooManyAccessPointsException:
				fmt.Println(elb.ErrCodeTooManyAccessPointsException, aerr.Error())
			case elb.ErrCodeCertificateNotFoundException:
				fmt.Println(elb.ErrCodeCertificateNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elb.ErrCodeSubnetNotFoundException:
				fmt.Println(elb.ErrCodeSubnetNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidSubnetException:
				fmt.Println(elb.ErrCodeInvalidSubnetException, aerr.Error())
			case elb.ErrCodeInvalidSecurityGroupException:
				fmt.Println(elb.ErrCodeInvalidSecurityGroupException, aerr.Error())
			case elb.ErrCodeInvalidSchemeException:
				fmt.Println(elb.ErrCodeInvalidSchemeException, aerr.Error())
			case elb.ErrCodeTooManyTagsException:
				fmt.Println(elb.ErrCodeTooManyTagsException, aerr.Error())
			case elb.ErrCodeDuplicateTagKeysException:
				fmt.Println(elb.ErrCodeDuplicateTagKeysException, aerr.Error())
			case elb.ErrCodeUnsupportedProtocolException:
				fmt.Println(elb.ErrCodeUnsupportedProtocolException, aerr.Error())
			case elb.ErrCodeOperationNotPermittedException:
				fmt.Println(elb.ErrCodeOperationNotPermittedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an HTTP listener for a load balancer
// This example creates a listener for your load balancer at port 80 using the HTTP
// protocol.
func ExampleELB_CreateLoadBalancerListeners_shared00() {
	svc := elb.New(session.New())
	input := &elb.CreateLoadBalancerListenersInput{
		Listeners: []*elb.Listener{
			{
				InstancePort:     aws.Int64(80),
				InstanceProtocol: aws.String("HTTP"),
				LoadBalancerPort: aws.Int64(80),
				Protocol:         aws.String("HTTP"),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	result, err := svc.CreateLoadBalancerListeners(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodeDuplicateListenerException:
				fmt.Println(elb.ErrCodeDuplicateListenerException, aerr.Error())
			case elb.ErrCodeCertificateNotFoundException:
				fmt.Println(elb.ErrCodeCertificateNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elb.ErrCodeUnsupportedProtocolException:
				fmt.Println(elb.ErrCodeUnsupportedProtocolException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an HTTPS listener for a load balancer
// This example creates a listener for your load balancer at port 443 using the HTTPS
// protocol.
func ExampleELB_CreateLoadBalancerListeners_shared01() {
	svc := elb.New(session.New())
	input := &elb.CreateLoadBalancerListenersInput{
		Listeners: []*elb.Listener{
			{
				InstancePort:     aws.Int64(80),
				InstanceProtocol: aws.String("HTTP"),
				LoadBalancerPort: aws.Int64(443),
				Protocol:         aws.String("HTTPS"),
				SSLCertificateId: aws.String("arn:aws:iam::123456789012:server-certificate/my-server-cert"),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	result, err := svc.CreateLoadBalancerListeners(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodeDuplicateListenerException:
				fmt.Println(elb.ErrCodeDuplicateListenerException, aerr.Error())
			case elb.ErrCodeCertificateNotFoundException:
				fmt.Println(elb.ErrCodeCertificateNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elb.ErrCodeUnsupportedProtocolException:
				fmt.Println(elb.ErrCodeUnsupportedProtocolException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a policy that enables Proxy Protocol on a load balancer
// This example creates a policy that enables Proxy Protocol on the specified load balancer.
func ExampleELB_CreateLoadBalancerPolicy_shared00() {
	svc := elb.New(session.New())
	input := &elb.CreateLoadBalancerPolicyInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		PolicyAttributes: []*elb.PolicyAttribute{
			{
				AttributeName:  aws.String("ProxyProtocol"),
				AttributeValue: aws.String("true"),
			},
		},
		PolicyName:     aws.String("my-ProxyProtocol-policy"),
		PolicyTypeName: aws.String("ProxyProtocolPolicyType"),
	}

	result, err := svc.CreateLoadBalancerPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodePolicyTypeNotFoundException:
				fmt.Println(elb.ErrCodePolicyTypeNotFoundException, aerr.Error())
			case elb.ErrCodeDuplicatePolicyNameException:
				fmt.Println(elb.ErrCodeDuplicatePolicyNameException, aerr.Error())
			case elb.ErrCodeTooManyPoliciesException:
				fmt.Println(elb.ErrCodeTooManyPoliciesException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a public key policy
// This example creates a public key policy.
func ExampleELB_CreateLoadBalancerPolicy_shared01() {
	svc := elb.New(session.New())
	input := &elb.CreateLoadBalancerPolicyInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		PolicyAttributes: []*elb.PolicyAttribute{
			{
				AttributeName:  aws.String("PublicKey"),
				AttributeValue: aws.String("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwAYUjnfyEyXr1pxjhFWBpMlggUcqoi3kl+dS74kj//c6x7ROtusUaeQCTgIUkayttRDWchuqo1pHC1u+n5xxXnBBe2ejbb2WRsKIQ5rXEeixsjFpFsojpSQKkzhVGI6mJVZBJDVKSHmswnwLBdofLhzvllpovBPTHe+o4haAWvDBALJU0pkSI1FecPHcs2hwxf14zHoXy1e2k36A64nXW43wtfx5qcVSIxtCEOjnYRg7RPvybaGfQ+v6Iaxb/+7J5kEvZhTFQId+bSiJImF1FSUT1W1xwzBZPUbcUkkXDj45vC2s3Z8E+Lk7a3uZhvsQHLZnrfuWjBWGWvZ/MhZYgEXAMPLE"),
			},
		},
		PolicyName:     aws.String("my-PublicKey-policy"),
		PolicyTypeName: aws.String("PublicKeyPolicyType"),
	}

	result, err := svc.CreateLoadBalancerPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodePolicyTypeNotFoundException:
				fmt.Println(elb.ErrCodePolicyTypeNotFoundException, aerr.Error())
			case elb.ErrCodeDuplicatePolicyNameException:
				fmt.Println(elb.ErrCodeDuplicatePolicyNameException, aerr.Error())
			case elb.ErrCodeTooManyPoliciesException:
				fmt.Println(elb.ErrCodeTooManyPoliciesException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a backend server authentication policy
// This example creates a backend server authentication policy that enables authentication
// on your backend instance using a public key policy.
func ExampleELB_CreateLoadBalancerPolicy_shared02() {
	svc := elb.New(session.New())
	input := &elb.CreateLoadBalancerPolicyInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		PolicyAttributes: []*elb.PolicyAttribute{
			{
				AttributeName:  aws.String("PublicKeyPolicyName"),
				AttributeValue: aws.String("my-PublicKey-policy"),
			},
		},
		PolicyName:     aws.String("my-authentication-policy"),
		PolicyTypeName: aws.String("BackendServerAuthenticationPolicyType"),
	}

	result, err := svc.CreateLoadBalancerPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodePolicyTypeNotFoundException:
				fmt.Println(elb.ErrCodePolicyTypeNotFoundException, aerr.Error())
			case elb.ErrCodeDuplicatePolicyNameException:
				fmt.Println(elb.ErrCodeDuplicatePolicyNameException, aerr.Error())
			case elb.ErrCodeTooManyPoliciesException:
				fmt.Println(elb.ErrCodeTooManyPoliciesException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a load balancer
// This example deletes the specified load balancer.
func ExampleELB_DeleteLoadBalancer_shared00() {
	svc := elb.New(session.New())
	input := &elb.DeleteLoadBalancerInput{
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	result, err := svc.DeleteLoadBalancer(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a listener from your load balancer
// This example deletes the listener for the specified port from the specified load
// balancer.
func ExampleELB_DeleteLoadBalancerListeners_shared00() {
	svc := elb.New(session.New())
	input := &elb.DeleteLoadBalancerListenersInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		LoadBalancerPorts: []*int64{
			aws.Int64(80),
		},
	}

	result, err := svc.DeleteLoadBalancerListeners(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a policy from your load balancer
// This example deletes the specified policy from the specified load balancer. The policy
// must not be enabled on any listener.
func ExampleELB_DeleteLoadBalancerPolicy_shared00() {
	svc := elb.New(session.New())
	input := &elb.DeleteLoadBalancerPolicyInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		PolicyName:       aws.String("my-duration-cookie-policy"),
	}

	result, err := svc.DeleteLoadBalancerPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To deregister instances from a load balancer
// This example deregisters the specified instance from the specified load balancer.
func ExampleELB_DeregisterInstancesFromLoadBalancer_shared00() {
	svc := elb.New(session.New())
	input := &elb.DeregisterInstancesFromLoadBalancerInput{
		Instances: []*elb.Instance{
			{
				InstanceId: aws.String("i-d6f6fae3"),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	result, err := svc.DeregisterInstancesFromLoadBalancer(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidEndPointException:
				fmt.Println(elb.ErrCodeInvalidEndPointException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the health of the instances for a load balancer
// This example describes the health of the instances for the specified load balancer.
func ExampleELB_DescribeInstanceHealth_shared00() {
	svc := elb.New(session.New())
	input := &elb.DescribeInstanceHealthInput{
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	result, err := svc.DescribeInstanceHealth(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidEndPointException:
				fmt.Println(elb.ErrCodeInvalidEndPointException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the attributes of a load balancer
// This example describes the attributes of the specified load balancer.
func ExampleELB_DescribeLoadBalancerAttributes_shared00() {
	svc := elb.New(session.New())
	input := &elb.DescribeLoadBalancerAttributesInput{
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	result, err := svc.DescribeLoadBalancerAttributes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodeLoadBalancerAttributeNotFoundException:
				fmt.Println(elb.ErrCodeLoadBalancerAttributeNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a policy associated with a load balancer
// This example describes the specified policy associated with the specified load balancer.
func ExampleELB_DescribeLoadBalancerPolicies_shared00() {
	svc := elb.New(session.New())
	input := &elb.DescribeLoadBalancerPoliciesInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		PolicyNames: []*string{
			aws.String("my-authentication-policy"),
		},
	}

	result, err := svc.DescribeLoadBalancerPolicies(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodePolicyNotFoundException:
				fmt.Println(elb.ErrCodePolicyNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a load balancer policy type defined by Elastic Load Balancing
// This example describes the specified load balancer policy type.
func ExampleELB_DescribeLoadBalancerPolicyTypes_shared00() {
	svc := elb.New(session.New())
	input := &elb.DescribeLoadBalancerPolicyTypesInput{
		PolicyTypeNames: []*string{
			aws.String("ProxyProtocolPolicyType"),
		},
	}

	result, err := svc.DescribeLoadBalancerPolicyTypes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodePolicyTypeNotFoundException:
				fmt.Println(elb.ErrCodePolicyTypeNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe one of your load balancers
// This example describes the specified load balancer.
func ExampleELB_DescribeLoadBalancers_shared00() {
	svc := elb.New(session.New())
	input := &elb.DescribeLoadBalancersInput{
		LoadBalancerNames: []*string{
			aws.String("my-load-balancer"),
		},
	}

	result, err := svc.DescribeLoadBalancers(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodeDependencyThrottleException:
				fmt.Println(elb.ErrCodeDependencyThrottleException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the tags for a load balancer
// This example describes the tags for the specified load balancer.
func ExampleELB_DescribeTags_shared00() {
	svc := elb.New(session.New())
	input := &elb.DescribeTagsInput{
		LoadBalancerNames: []*string{
			aws.String("my-load-balancer"),
		},
	}

	result, err := svc.DescribeTags(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To detach a load balancer from a subnet
// This example detaches the specified load balancer from the specified subnet.
func ExampleELB_DetachLoadBalancerFromSubnets_shared00() {
	svc := elb.New(session.New())
	input := &elb.DetachLoadBalancerFromSubnetsInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		Subnets: []*string{
			aws.String("subnet-0ecac448"),
		},
	}

	result, err := svc.DetachLoadBalancerFromSubnets(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disable an Availability Zone for a load balancer
// This example removes the specified Availability Zone from the set of Availability
// Zones for the specified load balancer.
func ExampleELB_DisableAvailabilityZonesForLoadBalancer_shared00() {
	svc := elb.New(session.New())
	input := &elb.DisableAvailabilityZonesForLoadBalancerInput{
		AvailabilityZones: []*string{
			aws.String("us-west-2a"),
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	result, err := svc.DisableAvailabilityZonesForLoadBalancer(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable an Availability Zone for a load balancer
// This example adds the specified Availability Zone to the specified load balancer.
func ExampleELB_EnableAvailabilityZonesForLoadBalancer_shared00() {
	svc := elb.New(session.New())
	input := &elb.EnableAvailabilityZonesForLoadBalancerInput{
		AvailabilityZones: []*string{
			aws.String("us-west-2b"),
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	result, err := svc.EnableAvailabilityZonesForLoadBalancer(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable cross-zone load balancing
// This example enables cross-zone load balancing for the specified load balancer.
func ExampleELB_ModifyLoadBalancerAttributes_shared00() {
	svc := elb.New(session.New())
	input := &elb.ModifyLoadBalancerAttributesInput{
		LoadBalancerAttributes: &elb.LoadBalancerAttributes{
			CrossZoneLoadBalancing: &elb.CrossZoneLoadBalancing{
				Enabled: aws.Bool(true),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	result, err := svc.ModifyLoadBalancerAttributes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodeLoadBalancerAttributeNotFoundException:
				fmt.Println(elb.ErrCodeLoadBalancerAttributeNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable connection draining
// This example enables connection draining for the specified load balancer.
func ExampleELB_ModifyLoadBalancerAttributes_shared01() {
	svc := elb.New(session.New())
	input := &elb.ModifyLoadBalancerAttributesInput{
		LoadBalancerAttributes: &elb.LoadBalancerAttributes{
			ConnectionDraining: &elb.ConnectionDraining{
				Enabled: aws.Bool(true),
				Timeout: aws.Int64(300),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	result, err := svc.ModifyLoadBalancerAttributes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodeLoadBalancerAttributeNotFoundException:
				fmt.Println(elb.ErrCodeLoadBalancerAttributeNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To register instances with a load balancer
// This example registers the specified instance with the specified load balancer.
func ExampleELB_RegisterInstancesWithLoadBalancer_shared00() {
	svc := elb.New(session.New())
	input := &elb.RegisterInstancesWithLoadBalancerInput{
		Instances: []*elb.Instance{
			{
				InstanceId: aws.String("i-d6f6fae3"),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	result, err := svc.RegisterInstancesWithLoadBalancer(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidEndPointException:
				fmt.Println(elb.ErrCodeInvalidEndPointException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To remove tags from a load balancer
// This example removes the specified tag from the specified load balancer.
func ExampleELB_RemoveTags_shared00() {
	svc := elb.New(session.New())
	input := &elb.RemoveTagsInput{
		LoadBalancerNames: []*string{
			aws.String("my-load-balancer"),
		},
		Tags: []*elb.TagKeyOnly{
			{
				Key: aws.String("project"),
			},
		},
	}

	result, err := svc.RemoveTags(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update the SSL certificate for an HTTPS listener
// This example replaces the existing SSL certificate for the specified HTTPS listener.
func ExampleELB_SetLoadBalancerListenerSSLCertificate_shared00() {
	svc := elb.New(session.New())
	input := &elb.SetLoadBalancerListenerSSLCertificateInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		LoadBalancerPort: aws.Int64(443),
		SSLCertificateId: aws.String("arn:aws:iam::123456789012:server-certificate/new-server-cert"),
	}

	result, err := svc.SetLoadBalancerListenerSSLCertificate(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeCertificateNotFoundException:
				fmt.Println(elb.ErrCodeCertificateNotFoundException, aerr.Error())
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodeListenerNotFoundException:
				fmt.Println(elb.ErrCodeListenerNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elb.ErrCodeUnsupportedProtocolException:
				fmt.Println(elb.ErrCodeUnsupportedProtocolException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To replace the policies associated with a port for a backend instance
// This example replaces the policies that are currently associated with the specified
// port.
func ExampleELB_SetLoadBalancerPoliciesForBackendServer_shared00() {
	svc := elb.New(session.New())
	input := &elb.SetLoadBalancerPoliciesForBackendServerInput{
		InstancePort:     aws.Int64(80),
		LoadBalancerName: aws.String("my-load-balancer"),
		PolicyNames: []*string{
			aws.String("my-ProxyProtocol-policy"),
		},
	}

	result, err := svc.SetLoadBalancerPoliciesForBackendServer(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodePolicyNotFoundException:
				fmt.Println(elb.ErrCodePolicyNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To replace the policies associated with a listener
// This example replaces the policies that are currently associated with the specified
// listener.
func ExampleELB_SetLoadBalancerPoliciesOfListener_shared00() {
	svc := elb.New(session.New())
	input := &elb.SetLoadBalancerPoliciesOfListenerInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		LoadBalancerPort: aws.Int64(80),
		PolicyNames: []*string{
			aws.String("my-SSLNegotiation-policy"),
		},
	}

	result, err := svc.SetLoadBalancerPoliciesOfListener(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elb.ErrCodeAccessPointNotFoundException:
				fmt.Println(elb.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elb.ErrCodePolicyNotFoundException:
				fmt.Println(elb.ErrCodePolicyNotFoundException, aerr.Error())
			case elb.ErrCodeListenerNotFoundException:
				fmt.Println(elb.ErrCodeListenerNotFoundException, aerr.Error())
			case elb.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elb.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
