var process = process || {env: {NODE_ENV: "development"}};
/*
 * Copyright 2016 SimplifyOps, Inc. (http://simplifyops.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var TestHarness = function (name,data) {
    var self = this;
    self.name=name;
    var failed=0;
    var total=0;
    var NDX=Math.floor((Math.random() * 1024));
    var ident='js_test_'+NDX;
    var curPrefix='';
    self.compare=function(expect,val){
        "use strict";
        if(typeof(expect)!=typeof(val)){
            return false;
        }
        if(expect==null && val!=null || expect!=null && val==null){
            return false;
        }
        //todo: array and object compare
        if(expect!=null && val!=null && typeof expect == 'array' && typeof val == 'array'){
            if(expect.length!=val.length){
                return false;
            }
            for(var i=0;i<expect.length;i++){
                if(!self.compare(expect[i],val[i])){
                    return false;
                }
            }
            return true;
        }else if (expect!=null && val!=null && typeof(expect)=='object'){
            if(Object.keys(expect).length!=Object.keys(val).length){
                return false;
            }
            for(var p in expect){
                if(!self.compare(expect[p],val[p])){

                    return false;
                }
            }
            for(var p in val){
                if(!self.compare(expect[p],val[p])){
                    return false;
                }
            }
            return true;
        }
        return expect===val;
    };
    self.error=function(message){
        "use strict";
        jQuery('#'+ident).append(jQuery('<div class="js-test-failure"></div>').append(jQuery('<span class="text-danger"></span>').text(message)));
    };
    self.ok=function(msg){
        "use strict";
        jQuery('#'+ident).append(jQuery('<div></div>').append(jQuery('<span class="text-success"></span>').text("OK: " + msg)));
    };
    self.assert = function (msg, expect, val) {
        total++;
        if(null==expect && null==val && typeof(msg)!='string'){
            expect=true;
            val=msg;
            msg='(assert)';
        }else if(null==val && typeof(expect)=='string' && typeof(msg)=='boolean'){
            val=msg;
            msg=expect;
            expect=true;
        }
        if (!self.compare(expect,val)) {
            failed++;
            var message = "FAIL: " +curPrefix+ msg + ": expected: " + JSON.stringify(expect) + ", was: " + JSON.stringify(val);
            self.error(message);
            try{
                throw new Error("assert failed: "+message);
            }catch(e){
                console.log(e,e.stack);
            }
        } else {
            self.ok(curPrefix+msg);
        }
    };
    self.log = function (msg, data) {
        jQuery('#'+ident).append(jQuery('<div></div>').append(jQuery('<span class="text-' +
            'info"></span>').text("LOG: " + msg)));
        if(data){
            jQuery('#'+ident).append(jQuery('<div></div>').append(jQuery('<span class="text-info"></span>').text(data)));
        }
    };

    self.testMatrix=function(name,dataset,tester){
        "use strict";

        dataset.forEach(function (t,x) {
            var val2 = tester(t[0]);
            self.assert(messageTemplate(name,[JSON.stringify(t[0]),JSON.stringify(t[1]),x]), t[1], val2);
        });
    };
    self.holder={};
    self.prepare=function(){
        "use strict";

        if (typeof(window.Messages) == 'object') {
            self.holder['Messages']= Messages;
            var t={};
            for(var p in Messages){
                t[p]=p;
            }
            window.Messages=t;
        }
    };
    self.restore=function(){
        "use strict";
        window.Messages=self.holder['Messages'];
        self.holder={};
    };


    self.testAll = function () {
        self.prepare();
        jQuery('#section-content').append(jQuery('<div id="'+ident+'" class="collapse in"></div>'));
        var jQuery2 = jQuery('#'+ident);
        self.log("Start: "+self.name);
        for (var i in self) {
            if (i.endsWith('Test')) {
                try {
                    curPrefix= i + ': ';
                    self[i].call(self, i + ': ');
                }catch(e){
                    self.assert('caught error running test: '+e, 'ok', 'exception');
                    console.log("error",e,e.stack);
                }
            }
        }
        curPrefix='';
        if(failed>0){
            jQuery2.prepend(jQuery('<div></div>').append(jQuery('<span class="text-danger"></span>').text("FAIL: " + failed+"/"+total+" assertions failed")));
        }else{
            jQuery2.collapse('hide');
            jQuery('#section-content').append('<div></div>')
                .append('<span class="btn btn-link text-success test-elem" data-toggle="collapse" data-target="#'+ident+'">OK: '+total+' Tests Passed</span>')
        }
        self.restore();
    };
    for(var val in data){
        self[val]=data[val].bind(self);
    }

    jQuery(function () {
        self.testAll();
    });
};

var process = process || {env: {NODE_ENV: "development"}};
/*
 * Copyright 2016 SimplifyOps, Inc. (http://simplifyops.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


/**
 * Selectable value with name/value pair
 * @param data
 * @constructor
 */
function OptionVal(data) {
    "use strict";

    var self = this;
    self.label = ko.observable(data.label || null);
    self.value = ko.observable(data.value || null);
    self.selected = ko.observable(data.selected ? true : false);
    self.editable = ko.observable(data.editable ? true : false);
    self.multival = ko.observable(data.multival ? true : false);
    self.resultValue = ko.computed(function () {
        var sel = self.selected();
        var val = self.value();
        if (sel && val) {
            return val;
        }
        return sel || val ? "" : null;
    });
}
var _option_uid=0;
function Option(data, holder) {
    "use strict";

    var self = this;
    self.parent = holder;
    self.remoteLoadCallback = null;
    self.name = ko.observable(data.name);
    self.label = ko.observable(data.label);
    self.uid = ko.observable(data.uid||(++_option_uid+'_opt'));
    self.description = ko.observable(data.description);
    self.descriptionHtml = ko.observable(data.descriptionHtml);
    self.loading = ko.observable(false);
    self.required = ko.observable(data.required ? true : false);
    self.hidden = ko.observable(data.hidden ? true : false);
    self.enforced = ko.observable(data.enforced ? true : false);
    self.isDate = ko.observable(data.isDate ? true : false);
    self.dateFormat = ko.observable(data.dateFormat);
    /**
     * Type: used for file upload
     */
    self.optionType = ko.observable(data.optionType);
    self.fieldName = ko.observable(data.fieldName);
    self.hasError = ko.observable(data.hasError);
    self.hasRemote = ko.observable(data.hasRemote);
    self.fieldName = ko.observable(data.fieldName);
    self.fieldId = ko.observable(data.fieldId);
    self.fieldLabelId = ko.observable(data.fieldLabelId);
    self.optionDepsMet = ko.observable(data.optionDepsMet);
    self.secureInput = ko.observable(data.secureInput);
    self.multivalued = ko.observable(data.multivalued);
    self.multivalueAllSelected = ko.observable(data.multivalueAllSelected ? true : false);
    self.delimiter = ko.observable(data.delimiter);
    self.value = ko.observable(data.value);
    self.initvalue = ko.observable(data.value);
    self.useinit = ko.observable(data.value ? true : false);
    /**
     * static list of values to choose from
     */
    self.values = ko.observableArray(data.values);
    self.valuesFromPlugin = ko.observableArray(data.valuesFromPlugin);
    self.defaultValue = ko.observable(data.defaultValue);
    /**
     * list of values already selected
     */
    self.selectedMultiValues = ko.observableArray(data.selectedMultiValues);
    /**
     * list of values chosen as default for multivalued
     */
    self.defaultMultiValues = ko.observableArray(data.defaultMultiValues);
    /**
     * list of all multivalue strings to choose from
     */
    self.multiValueList = ko.observableArray(data.multiValueList);

    function emptyValue(val) {
        return (!val || val === '');
    }

    self.setReloadCallback = function (func) {
        self.remoteLoadCallback = func;
    };

    self.reloadRemoteValues = function () {
        if (self.hasRemote() && self.remoteLoadCallback) {
            self.remoteLoadCallback(self.name());
        } else {
            return true;
        }
    };

    //set up multivaluelist if default/selected values
    self.evalMultivalueChange = function () {
        if (self.multiValueList().length > 0) {
            //construct value string from selected multivalue options
            var str = '';
            var strs = [];

            var selected = ko.utils.arrayFilter(self.multiValueList(), function (val) {
                return val.selected() && val.value();
            });
            ko.utils.arrayForEach(selected, function (val) {
                strs.push(val.value());
            });
            self.value(strs.join(self.delimiter()));
            self.selectedMultiValues(strs);
        }
    };
    self.createMultivalueEntry = function (obj) {
        var optionVal = new OptionVal(obj);
        optionVal.resultValue.subscribe(function (newval) {
            if (newval == null) {
                //remove from parent
                self.multiValueList.remove(optionVal);
            } else {
                self.evalMultivalueChange();
            }
        });
        return optionVal;
    };
    self.loadedRemoteValues = ko.observable(false);
    self.remoteValues = ko.observableArray([]);
    if (self.multivalued()) {

        var testselected = function (val) {
            if (self.selectedMultiValues() && self.selectedMultiValues().length > 0) {
                if (self.multivalueAllSelected()) {
                    return true;
                } else {
                    return ko.utils.arrayIndexOf(self.selectedMultiValues(), val) >= 0;
                }
            } else if (self.defaultMultiValues() && self.defaultMultiValues().length > 0) {
                return ko.utils.arrayIndexOf(self.defaultMultiValues(), val) >= 0;
            } else if (self.value()) {
                return self.value() == val;
            } else if (self.defaultValue()) {
                return self.defaultValue() == val;
            } else if (self.multivalueAllSelected()) {
                return true;
            }
            return false;
        };
        if(self.selectedMultiValues().length<1 && self.defaultMultiValues().length>0){
            //automatically select the default values
            self.selectedMultiValues(self.defaultMultiValues());
        }
        var addedExtras = false;
        var addExtraSelected = function (selected) {
            if (!self.enforced() && selected) {
                //add any selectedMultiValues that are not in values list

                ko.utils.arrayForEach(selected, function (val) {
                    if (self.values() != null && ko.utils.arrayIndexOf(self.values(), val) >= 0) {
                        return;
                    }

                    var found = ko.utils.arrayFirst(self.multiValueList(), function (oval) {
                        return oval.value() == val;
                    });
                    if (found) {
                        return;
                    }
                    self.multiValueList.unshift(self.createMultivalueEntry({
                        label: val,
                        value: val,
                        selected: !addedExtras,
                        editable: true,
                        multival: true
                    }));
                });
                addedExtras = true;
            }
        };


        if (self.hasRemote()) {
            //when remote values are loaded, set the multivalue entries with them
            self.remoteValues.subscribe(function (newval) {
                var new_values = [];

                ko.utils.arrayForEach(newval, function (val) {
                    new_values.push(self.createMultivalueEntry({
                        label: val.label(),
                        value: val.value(),
                        selected: testselected(val.value()) || val.selected(),
                        editable: false,
                        multival: true
                    }));
                });
                self.multiValueList(new_values);
            });
        } else {
            addExtraSelected(self.selectedMultiValues());

            if (self.values() != null && self.values().length>0) {
                ko.utils.arrayForEach(self.values(), function (val) {
                    var selected = testselected(val);
                    self.multiValueList.push(self.createMultivalueEntry({
                        label: val,
                        value: val,
                        selected: selected,
                        editable: false,
                        multival: true
                    }));
                });
            } else if (self.valuesFromPlugin() != null && self.valuesFromPlugin().length>0) {
                ko.utils.arrayForEach(self.valuesFromPlugin(), function (val) {
                    var selected = testselected(val.value);
                    self.multiValueList.push(self.createMultivalueEntry({
                        label: val.name,
                        value: val.value,
                        selected: selected,
                        editable: false,
                        multival: true
                    }));
                });
            }
        }
        self.multiValueList.subscribe(self.evalMultivalueChange);
    } else if (self.enforced() && self.values().length == 1 && emptyValue(self.value())) {
        //auto-set the value to only allowed value
        self.value(self.defaultValue() || self.values()[0]);
    }else if (!self.enforced() && emptyValue(self.value()) && !emptyValue(self.defaultValue())) {
        //auto-set the value to only allowed value
        self.value(self.defaultValue());
    }
    self.remoteError = ko.observable();

    self.selectedOptionValue = ko.observable(self.value());
    self.defaultStoragePath = ko.observable(data.defaultStoragePath);
    self.dateFormatErr = ko.computed(function () {
        if (!self.isDate() || !self.value() || !self.dateFormat()) {
            return false;
        }
        try {
            var m = moment(self.value(), self.dateFormat(), true);
            return !m.isValid();
        } catch (e) {
            return true;
        }
    });
    self.truncateDefaultValue = ko.computed(function () {
        var val = self.defaultValue();
        if (!val || val.length < 50) return val;
        return val.substring(0, 50);
    });
    self.setDefault = function () {
        self.value(self.defaultValue());
    };
    self.hasSingleEnforcedValue = ko.computed(function () {
        return self.enforced()
            && self.values() != null
            && self.values().length == 1;
    });
    self.singleEnforcedValue = ko.computed(function () {
        return self.hasSingleEnforcedValue() ? self.values()[0] : null;
    });
    self.hasValue = ko.computed(function () {
        return self.value();
    });
    self.hasValues = ko.computed(function () {
        var values = self.values();
        return values != null && values.length > 0;
    });
    self.hasPluginValues = ko.computed(function () {
        var pluginvalues = self.valuesFromPlugin();
        return pluginvalues != null && pluginvalues.length > 0;
    });
    self.hasExtended = ko.computed(function () {
        return !self.secureInput()
            && (
                self.hasValues()
                || self.multivalued()
                || self.hasRemote() && self.remoteValues().length > 0
                || self.hasPluginValues()
            );
    });
    self.hasTextfield = ko.computed(function () {
        return !self.isMultilineType() && ( !self.enforced()
            && (
                !self.multivalued()
                || (self.hasError() && !self.hasExtended())
            )
            || self.secureInput());
    });
    self.showDefaultButton = ko.computed(function () {
        return !self.enforced()
            && !self.multivalued()
            && !self.secureInput()
            && self.defaultValue()
            && !(
                self.values() != null
                && self.values().indexOf(self.defaultValue()) >= 0
            )
            && self.value() != self.defaultValue();
    });

    self.isFileType=ko.computed(function () {
        return self.optionType() == 'file';
    });

    self.isMultilineType = ko.computed(function () {
        return self.optionType() === 'multiline' && self.parent && self.parent.features() && self.parent.features().multilineJobOptions!==null && self.parent.features().multilineJobOptions() === true;
    });

    /**
     * Return the array of option objects to use for displaying the Select input for this option
     */
    self.selectOptions = ko.computed(function () {
        var arr = [];
        if (!self.enforced() && !self.multivalued()) {
            arr.push(new OptionVal({label: message('option.select.choose.text'), value: ''}));
        }
        var remotevalues = self.remoteValues();
        var localvalues = self.values();
        var pluginvalues = self.valuesFromPlugin();

        if (self.hasRemote() && remotevalues != null) {
            ko.utils.arrayForEach(remotevalues, function (val) {
                arr.push(val);
            });
        } else if (self.hasValues()) {
            ko.utils.arrayForEach(localvalues, function (val) {
                arr.push(new OptionVal({label: val, value: val}));
            });
        } else if (self.hasPluginValues()) {
            ko.utils.arrayForEach(pluginvalues, function (val) {
                arr.push(new OptionVal({label: val.name, value: val.value}));
            });
        }
        return arr;
    });
    self.newMultivalueEntry = function () {
        var arr = self.multiValueList;
        arr.unshift(self.createMultivalueEntry({
            label: '_new',
            value: '',
            selected: true,
            editable: true,
            multival: true
        }));
    };
    self.multivalueFieldKeydown = function (obj,evt) {
        var enterKey = !noenter(evt);
        if (enterKey) {
            self.newMultivalueEntry()
        }
        return !enterKey;
    };

    /**
     * When select box chooses an option value, set the value()
     */
    self.selectedOptionValue.subscribe(function (newval) {
        if (newval && typeof(newval) == 'object' && typeof(newval.value) == 'function' && newval.value()) {
            self.value(newval.value());
        } else if (typeof(newval) == 'string') {
            self.value(newval);
        }
    });

    self.loadRemoteValues = function (values, selvalue) {
        self.loadedRemoteValues(false);
        self.remoteError(null);
        var tvalues = [];
        var tmultivalues = [];
        if (self.useinit() && self.initvalue() && !self.multivalued()) {
            tvalues[1] = (self.initvalue());
            self.useinit(false);
        } else if (self.useinit() && self.multivalued() && self.selectedMultiValues().length > 0) {
            tmultivalues[1] = self.selectedMultiValues();
            self.useinit(false);
        }
        if (selvalue && tvalues.indexOf(selvalue) < 0 && !self.multivalued()) {
            tvalues[0] = selvalue;
        } else if (self.multivalued() && selvalue) {
            tmultivalues[0] = selvalue.split(self.delimiter());
        }
        var rvalues = [];
        var tselected = -1;
        var remoteselectedArr = [];
        ko.utils.arrayForEach(values, function (val) {
            var optval;
            if (typeof(val) === 'object') {
                if (val.selected) {
                    remoteselectedArr.push(val.value)
                }
                optval = new OptionVal({label: val.name, value: val.value, selected: val.selected});
            } else if (typeof(val) === 'string') {
                optval = new OptionVal({label: val, value: val});
            }
            if (optval) {
                rvalues.push(optval);
                if (tvalues.length > 0 && tvalues.indexOf(optval.value()) > tselected) {
                    tselected = tvalues.indexOf(optval.value());
                }
            }
        });

        //choose value to select, by preference:
        //1: init value(s)
        //2: remote "selected" value(s)
        //3: input "selected" value(s)

        if (!self.multivalued()) {
            var touse = tselected === 1 ?
                tvalues[tselected] :
                (
                    (remoteselectedArr.length > 0 && remoteselectedArr[0]) ||
                    (tselected >= 0 ? tvalues[tselected] : null)
                );

            if (touse) {
                //choose correct value
                self.selectedOptionValue(touse);
            }
        } else if (self.multivalued()) {
            var touse =
                tmultivalues[1] ||
                (
                    (remoteselectedArr.length > 0 && remoteselectedArr) ||
                    (tmultivalues[0])
                );

            if (touse && touse.length > 0) {
                //choose correct value
                self.selectedMultiValues(touse);
            }
        }

        //triggers refresh of "selectOptions" populating select box
        self.remoteValues(rvalues);
        self.loadedRemoteValues(true);
    };
    /**
     * Option values data loaded from remote JSON request
     * @param data
     */
    self.loadRemote = function (data) {
        if (data.err && data.err.message) {
            var err = data.err;
            if (err) {
                err.url = data.srcUrl;
            }
            self.remoteError(err);
            self.remoteValues([]);
        } else if (data.values) {
            self.loadRemoteValues(data.values, data.selectedvalue);
        }
    };
    self.animateRemove = function (div) {
        jQuery(div).show().slideUp('fast', 0, function () {
            jQuery(div).remove();
        });
    };
    self.animateAdd = function (div) {
        jQuery(div).hide().slideDown('fast',function(){
            jQuery(div).find('input[type=text]').trigger('focus');
        });
    };
}
function JobOptions(data) {
    "use strict";
    var self = this;
    self.options = ko.observableArray();
    self.features = ko.observable({});
    self.remoteoptions = null;
    self.mapping = {
        options: {
            key: function (data) {
                return ko.utils.unwrapObservable(data.name);
            },
            create: function (options) {
                return new Option(options.data, self);
            }
        }
    };

    ko.mapping.fromJS(data, self.mapping, self);
}

var process = process || {env: {NODE_ENV: "development"}};
/*
 * Copyright 2016 SimplifyOps, Inc. (http://simplifyops.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Manages cascading reloads of remote option values based on a dependency graph
 */
function RemoteOptionController(data) {
    "use strict";
    var self = this;
    self.loader = data.loader;
    /**
     * container for array of Options, keyed by option name
     */
    self.options = {};
    /**
     * container for array of dependent option names, keyed by option name
     */
    self.dependents = {};
    /**
     * container for array of depdency option names, keyed by option name
     */
    self.dependencies = {};
    /**
     * list of option names
     */
    self.names = [];

    /**
     * container of observer subscriptions, keyed by option name
     */
    self.observers = {};

    /**
     * indicates cyclic dependencies
     */
    self.cyclic = false;

    function emptyValue(val) {
        return (!val || val === '');
    }
    /**
     * Setup dependencies using the loaded options
     * @param joboptions
     */
    self.setupOptions = function (joboptions) {
        ko.utils.arrayForEach(joboptions.options(), function (opt) {
            self.addOption(opt);
            if (opt.hasRemote()) {
                opt.setReloadCallback(self.reloadOptionIfRequirementsMet);
            }
        });
    };
    /**
     * register an option with parameters used for Ajax reload of the field (used to call _loadRemoteOptionValues
     * function)
     * @param opt Option object
     */
    self.addOption = function (opt) {
        self.options[opt.name()] = opt;
        self.names.push(opt.name());
    };

    /**
     * Non remote-values option
     * @param name
     */
    self.addLocalOption = function (name) {
        self.names.push(name);
    };

    /**
     * reload the values for an option by name (calls _loadRemoteOptionValues)
     * @param name
     */
    self.loadRemoteOptionValues = function (name) {
        //stop observing option name if doing so
        // self.stopObserving(name);
        var option = self.options[name];
        self.loader.loadRemoteOptionValues(option, self.options).then(function (data) {
            option.loadRemote(data);
        });
    };


    /**
     * define dependent option names for an option
     * @param name
     * @param depsArr
     */
    self.addOptionDeps = function (name, depsArr) {
        self.dependents[name] = depsArr;
    };

    /**
     * define dependency option names for an option
     * @param name
     * @param depsArr
     */
    self.addOptionDependencies = function (name, depsArr) {
        self.dependencies[name] = depsArr;
    };

    /**
     * reload the option values for an option if all required dependencies are set
     * @param name
     */
    self.reloadOptionIfRequirementsMet = function (name) {
        var skip = false;

        // reload iff: all of its required dependencies have a value
        var missing = [];
        if(self.dependencies[name]) {
            for (var j = 0; j < self.dependencies[name].length; j++) {
                var dependencyName = self.dependencies[name][j];
                var option = self.options[dependencyName];
                if (!option.value() && option.required()) {
                    skip = true;
                    missing.push(dependencyName);
                }
            }
        }
        if (!skip) {
            self.loadRemoteOptionValues(name);
        } else if (self.options[name]) {
            self.options[name].remoteError({
                message: message("options.remote.dependency.missing.required", [name, missing.join(", ")])
            });
        }
    };

    /**
     * notify that a value changed for an option by name, will reload dependents if any
     * @param name
     * @param value
     */
    self.optionValueChanged = function (name, value) {
        //trigger reload
        if (self.dependents[name] && !self.cyclic) {
            for (var i = 0; i < self.dependents[name].length; i++) {
                var dependentName = self.dependents[name][i];
                self.reloadOptionIfRequirementsMet(dependentName);
            }
        }
    };
    /**
     * True if the option should force dependent options to load at start
     * @param name
     * @returns {*}
     */
    self.shouldAutoReload = function (name) {
        var option = self.options[name];
        if (option.hasRemote()) {
            return !!(!self.cyclic && (self.dependents[name] || !emptyValue(option.value())));
        } else {
            return !!((self.dependents[name] && option.enforced()) || !emptyValue(option.value()));
        }
    };
    /**
     * True if The option should load remote values at start
     * @param name
     * @returns {*|boolean}
     */
    self.shouldLoadOnStart = function (name) {
        return self.options[name].hasRemote() && (!self.dependencies[name] || self.cyclic);
    };

    /**
     * Auto reload dependent options if necessary
     * @param name
     * @returns {boolean}
     */
    self.doOptionAutoReload = function (name) {
        if (self.shouldAutoReload(name)) {
            //trigger change immediately
            var value = self.options[name].value();
            self.optionValueChanged(name, value);
            return true;
        }
        return false;
    };

    /**
     * load remote option dataset from json data
     * @param data
     */
    self.loadData = function (data) {
        if(!data){
            return;
        }
        if (data['optionsDependenciesCyclic']) {
            self.cyclic = data['optionsDependenciesCyclic'];
        }
        for (var opt in data.options) {
            var params = data.options[opt];
            if (params['optionDependencies']) {
                self.addOptionDependencies(opt, params['optionDependencies']);
            }
            if (params['optionDeps']) {
                self.addOptionDeps(opt, params['optionDeps']);
            }

        }
    };

    self.unsubscribeAll = function () {
        "use strict";
        for(var p in self.observers){
            self.observers[p].dispose();
        }
        self.observers={};
    };
    /**
     * starts observing changes for option field by name
     * @param name
     */
    self.observeChangesFor = function (name) {
        // this.stopObserving(name);
        //observe field value change and trigger reloads
        self.observers[name] = self.options[name].value.subscribe(function (newval) {
            self.optionValueChanged(name, newval);
        });
    };
    /**
     * begin by loading on start values, reloading autoreload values, and then observe
     * changes.
     */
    self.begin = function () {
        for (var i = 0; i < self.names.length; i++) {
            var name = self.names[i];
            if (self.shouldLoadOnStart(name)) {
                self.loadRemoteOptionValues(name);
            }
            self.doOptionAutoReload(self.names[i]);
        }

        for (var i = 0; i < self.names.length; i++) {
            self.observeChangesFor(self.names[i]);
        }
    };

}

function RemoteOptionLoader(data) {
    "use strict";
    var self = this;
    self.url = data.url;
    self.fieldPrefix = data.fieldPrefix;
    self.id = data.id;
    //load remote values
    self.loadRemoteOptionValues = function (opt, options) {
        opt.loading(true);
        var params = {option: opt.name(), selectedvalue: opt.value(), id: self.id};
        //
        if (null != options) {
            for (var xopt in options) {
                if (xopt != opt.name()) {
                    params[self.fieldPrefix + xopt] = options[xopt].value();
                }
            }
        }
        return jQuery.ajax({
            method: 'GET',
            type: 'json',
            url: _genUrl(self.url, params),
            success: function (data, status, jqxhr) {
                //show loading spinner at least for a little while
                setTimeout(function () {
                    opt.loading(false)
                },200);
            },
            error: function (jqxhr, status, message) {
                setTimeout(function () {
                    opt.loading(false)
                },200);
                opt.remoteError({error: "ERROR loading result from Rundeck server: " + status + ": " + message});
            }
        });
    }
}

var process = process || {env: {NODE_ENV: "development"}};
/*
 * Copyright 2016 SimplifyOps, Inc. (http://simplifyops.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

//= require util/testing
//= require menu/joboptions
//= require menu/job-remote-options

jQuery(function () {
    "use strict";
    function mkopt(data) {
        var defdata = {
            name: 'test',
            description: 'x',
            required: true,
            enforced: true,
            values: ['a', 'b'],
            defaultValue: 'a',
            defaultStoragePath: null,
            multivalued: false,
            defaultMultiValues: null,
            delimiter: null,
            selectedMultiValues: null,
            fieldName: 'extra.option.test',
            fieldId: 'a_bc',
            hasError: null,
            hasRemote: false,
            optionDepsMet: true,
            secureInput: false,
            hasExtended: false,
            value: 'test value'
        };
        if (data) {
            jQuery.extend(defdata, data);
        }
        return new Option(defdata);
    }

    function mkval(v, l) {
        "use strict";
        return new OptionVal({value: v, label: l || v});
    }

    new TestHarness("job-remote-optionsTest.js", {
            initTest: function (pref) {
                var control = new RemoteOptionController({loader: 'xyz'});
                this.assert("names length", 0, control.names.length);
                this.assert("options length", 0, Object.keys(control.options).length);
                this.assert("options length", 0, Object.keys(control.dependents).length);
                this.assert("options length", 0, Object.keys(control.dependencies).length);
                this.assert("options length", 0, Object.keys(control.observers).length);
                this.assert("cyclic", false, control.cyclic);
                this.assert("loader", 'xyz', control.loader);
            },
            setupTest: function (pref) {
                var opts = new JobOptions({});
                var localOpt = mkopt({name: 'opt1'});
                var remoteOpt = mkopt({name: 'opt2', hasRemote: true});
                opts.options([
                    localOpt,
                    remoteOpt
                ]);
                var control = new RemoteOptionController({});
                control.setupOptions(opts);
                this.assert("names length", 2, control.names.length);
                this.assert("options length", 2, Object.keys(control.options).length);
                this.assert("remoteLoadCallback", true, remoteOpt.remoteLoadCallback != null);
                this.assert("remoteLoadCallback", null, localOpt.remoteLoadCallback);
            },
            loadData_cyclicTest: function (pref) {
                var opts = new JobOptions({});
                var localOpt = mkopt({name: 'opt1'});
                var remoteOpt = mkopt({name: 'opt2', hasRemote: true});
                opts.options([
                    localOpt,
                    remoteOpt
                ]);
                var control = new RemoteOptionController({});
                control.setupOptions(opts);
                var optConfig = {
                    optionsDependenciesCyclic: true
                };
                control.loadData(optConfig);

                this.assert("cyclic", true, control.cyclic);
            },
            loadData_basicTest: function (pref) {
                var opts = new JobOptions({});
                var localOpt = mkopt({name: 'opt1'});
                var remoteOpt = mkopt({name: 'opt2', hasRemote: true});
                opts.options([
                    localOpt,
                    remoteOpt
                ]);
                var control = new RemoteOptionController({});
                control.setupOptions(opts);
                var optConfig = {
                    options: {
                        opt1: {
                            optionDependencies: [],
                            optionDeps: ['opt2'],
                            hasUrl: false
                        },
                        opt2: {
                            optionDependencies: ['opt1'],
                            optionDeps: [],
                            hasUrl: true
                        }
                    }
                };
                control.loadData(optConfig);

                this.assert("cyclic", false, control.cyclic);
                this.assert("dependencies", {opt1: [], opt2: ['opt1']}, control.dependencies);
                this.assert("dependents", {opt1: ['opt2'], opt2: []}, control.dependents);

                this.assert("autoreload1", true, control.shouldAutoReload('opt1'));
                this.assert("loadonstart1", false, control.shouldLoadOnStart('opt1'));

                this.assert("autoreload2", true, control.shouldAutoReload('opt2'));
                this.assert("loadonstart2", false, control.shouldLoadOnStart('opt2'));
            },
            reloadOptionIfRequirementsMet_missingRequired_Test: function (pref) {
                var opts = new JobOptions({});
                var opt1 = mkopt({name: 'opt1', required: true, value: ''});
                var opt2 = mkopt({name: 'opt2', required: true, value: 'xyz'});
                var opt3 = mkopt({name: 'opt3', hasRemote: true, value: ''});
                opts.options([
                    opt1,
                    opt2,
                    opt3
                ]);
                var control = new RemoteOptionController({});
                control.setupOptions(opts);
                var optConfig = {
                    options: {
                        opt1: {
                            optionDependencies: [],
                            optionDeps: ['opt3'],
                            optionAutoReload: false,
                            loadonstart: true,
                            hasUrl: false
                        },
                        opt2: {
                            optionDependencies: [],
                            optionDeps: ['opt3'],
                            optionAutoReload: false,
                            loadonstart: true,
                            hasUrl: false
                        },
                        opt3: {
                            optionDependencies: ['opt1', 'opt2'],
                            optionDeps: [],
                            optionAutoReload: true,
                            loadonstart: true,
                            hasUrl: true
                        }
                    }
                };
                control.loadData(optConfig);
                control.reloadOptionIfRequirementsMet('opt3');
                //opt2 should have error
                this.assert("should see dependency error", {message: 'options.remote.dependency.missing.required'}, opt3.remoteError());
            },
            reloadOptionIfRequirementsMet_notmissingRequired_Test: function (pref) {
                var opts = new JobOptions({});
                var opt1 = mkopt({name: 'opt1', required: true, value: 'zzz'});
                var opt2 = mkopt({name: 'opt2', required: true, value: 'xyz'});
                var opt3 = mkopt({name: 'opt3', hasRemote: true, value: ''});
                opts.options([
                    opt1,
                    opt2,
                    opt3
                ]);
                var toload = [];
                var didcallback = false;
                var loader = {
                    loadRemoteOptionValues: function (option, opts) {
                        toload.push(option.name());
                        return {
                            then: function (func) {
                                didcallback = true;
                            }
                        };
                    }
                };
                var control = new RemoteOptionController({loader: loader});
                control.setupOptions(opts);
                var optConfig = {
                    options: {
                        opt1: {
                            optionDependencies: [],
                            optionDeps: ['opt3'],
                            optionAutoReload: false,
                            loadonstart: true,
                            hasUrl: false
                        },
                        opt2: {
                            optionDependencies: [],
                            optionDeps: ['opt3'],
                            optionAutoReload: false,
                            loadonstart: true,
                            hasUrl: false
                        },
                        opt3: {
                            optionDependencies: ['opt1', 'opt2'],
                            optionDeps: [],
                            optionAutoReload: true,
                            loadonstart: true,
                            hasUrl: true
                        }
                    }
                };
                control.loadData(optConfig);
                control.reloadOptionIfRequirementsMet('opt3');
                //opt2 should have error
                this.assert("should load option", ['opt3'], toload);
                this.assert("should do callback", true, didcallback);
            },
        createOption_singleValue_enforced_autodefault_Test: function (pref) {

            var opt1 = mkopt({
                name: 'opt1',
                required: true,
                values: ['abc'],
                enforced: true,
                defaultValue: null,
                value: ''
            });

            this.assert("option value should be set by single allowed value", 'abc', opt1.value());
        },
        createOption_singleValue_enforced_withdefault_Test: function (pref) {

            var opt1 = mkopt({
                name: 'opt1',
                required: true,
                values: ['abc'],
                enforced: true,
                defaultValue: 'abc',
                value: ''
            });

            this.assert("option value should be set by single allowed value", 'abc', opt1.value());
        },
        createOption_singleValue_notenforced_withdefault_Test: function (pref) {

            var opt1 = mkopt({
                name: 'opt1',
                required: true,
                values: ['abc'],
                enforced: false,
                defaultValue: 'abc',
                value: ''
            });

            this.assert("option value should be set by default value", 'abc', opt1.value());
        },
        reloadOptionIfRequirementsMet_singleValue_autoDefault_EnforcedRequired_Test: function (pref) {
            var opts = new JobOptions({});
            var opt1 = mkopt({
                name: 'opt1',
                required: true,
                values: ['abc'],
                enforced: true,
                defaultValue: null,
                value: ''
            });
            var opt3 = mkopt({name: 'opt3', hasRemote: true, value: ''});
            opts.options([
                opt1,
                opt3
            ]);
            var toload = [];
            var didcallback = false;
            var loader = {
                loadRemoteOptionValues: function (option, opts) {
                    toload.push(option.name());
                    return {
                        then: function (func) {
                            didcallback = true;
                        }
                    };
                }
            };
            var control = new RemoteOptionController({loader: loader});
            control.setupOptions(opts);
            var optConfig = {
                options: {
                    opt1: {
                        optionDependencies: [],
                        optionDeps: ['opt3'],
                        optionAutoReload: false,
                        loadonstart: true,
                        hasUrl: false
                    },

                    opt3: {
                        optionDependencies: ['opt1'],
                        optionDeps: [],
                        optionAutoReload: true,
                        loadonstart: true,
                        hasUrl: true
                    }
                }
            };
            control.loadData(optConfig);
            control.reloadOptionIfRequirementsMet('opt3');
            //opt3 should not have error
            this.assert("should load option", ['opt3'], toload);
            this.assert("should do callback", true, didcallback);
        },
        reloadOptionIfRequirementsMet_singleValue_WithDefault_NotEnforcedRequired_Test: function (pref) {
            var opts = new JobOptions({});
            var opt1 = mkopt({
                name: 'opt1',
                required: true,
                values: ['abc'],
                enforced: false,
                defaultValue: 'abc',
                value: ''
            });
            var opt3 = mkopt({name: 'opt3', hasRemote: true, value: '', defaultValue:''});
            opts.options([
                opt1,
                opt3
            ]);
            var toload = [];
            var didcallback = false;
            var loader = {
                loadRemoteOptionValues: function (option, opts) {
                    toload.push(option.name());
                    return {
                        then: function (func) {
                            didcallback = true;
                        }
                    };
                }
            };
            var control = new RemoteOptionController({loader: loader});
            control.setupOptions(opts);
            var optConfig = {
                options: {
                    opt1: {
                        optionDependencies: [],
                        optionDeps: ['opt3'],
                        optionAutoReload: false,
                        loadonstart: true,
                        hasUrl: false
                    },

                    opt3: {
                        optionDependencies: ['opt1'],
                        optionDeps: [],
                        optionAutoReload: true,
                        loadonstart: true,
                        hasUrl: true
                    }
                }
            };
            control.loadData(optConfig);
            control.reloadOptionIfRequirementsMet('opt3');
            //opt3 should not have error
            this.assert("option should have value", 'abc', opt1.value());
            this.assert("should load option", ['opt3'], toload);
            this.assert("should do callback", true, didcallback);
        },
        reloadOptionIfRequirementsMet_singleValue_NotEnforcedRequired_Test: function (pref) {
            var opts = new JobOptions({});
            var opt1 = mkopt({
                name: 'opt1',
                required: true,
                values: ['abc'],
                enforced: false,
                defaultValue: 'abc',
                value: 'abc'
            });
            var opt3 = mkopt({name: 'opt3', hasRemote: true, value: '', defaultValue:'',values:null});
            opts.options([
                opt1,
                opt3
            ]);
            var toload = [];
            var didcallback = false;
            var loader = {
                loadRemoteOptionValues: function (option, opts) {
                    toload.push(option.name());
                    return {
                        then: function (func) {
                            didcallback = true;
                        }
                    };
                }
            };
            var control = new RemoteOptionController({loader: loader});
            control.setupOptions(opts);
            var optConfig = {
                options: {
                    opt1: {
                        optionDependencies: [],
                        optionDeps: ['opt3'],
                        optionAutoReload: false,
                        loadonstart: true,
                        hasUrl: false
                    },

                    opt3: {
                        optionDependencies: ['opt1'],
                        optionDeps: [],
                        optionAutoReload: true,
                        loadonstart: true,
                        hasUrl: true
                    }
                }
            };
            control.loadData(optConfig);
            control.reloadOptionIfRequirementsMet('opt3');
            //opt3 should not have error
            this.assert("option should have value", 'abc', opt1.value());
            this.assert("should load option", ['opt3'], toload);
            this.assert("should do callback", true, didcallback);
        },
        reloadOptionIfRequirementsMet_nullDeps_Test: function (pref) {
            var opts = new JobOptions({});
            var opt1 = mkopt({name: 'opt1', required: true, value: 'zzz'});
            var opt2 = mkopt({name: 'opt2', required: true, value: 'xyz'});
            var opt3 = mkopt({name: 'opt3', hasRemote: true, value: ''});
            opts.options([
                opt1,
                opt2,
                opt3
            ]);
            var toload = [];
            var didcallback = false;
            var loader = {
                loadRemoteOptionValues: function (option, opts) {
                    toload.push(option.name());
                    return {
                        then: function (func) {
                            didcallback = true;
                        }
                    };
                }
            };
            var control = new RemoteOptionController({loader: loader});
            control.setupOptions(opts);
            var optConfig = {
                options: {
                    opt1: {
                        //optionDependencies: [],
                        optionDeps: ['opt3'],
                        optionAutoReload: false,
                        loadonstart: true,
                        hasUrl: false
                    },
                    opt2: {
                        optionDependencies: [],
                        optionDeps: ['opt3'],
                        optionAutoReload: false,
                        loadonstart: true,
                        hasUrl: false
                    },
                    opt3: {
                        optionDependencies: ['opt1', 'opt2'],
                        optionDeps: [],
                        optionAutoReload: true,
                        loadonstart: true,
                        hasUrl: true
                    }
                }
            };
            control.loadData(optConfig);

            this.assert("expect undefined dependencies", undefined, control.dependencies['opt1']);
            
            control.reloadOptionIfRequirementsMet('opt1');
            //opt2 should have error
            this.assert("should load option", ['opt1'], toload);
            this.assert("should do callback", true, didcallback);
        },
            optionValueChanged_Test: function (pref) {
                var self = this;
                this.testMatrix("optionValueChanged({0})", [
                    [{cyclic: false, deps: ['a', 'b']}, ['a', 'b']],
                    [{cyclic: true, deps: ['a', 'b']}, []],
                    [{cyclic: false, deps: []}, []]
                ], function (data) {
                    var control = new RemoteOptionController({loader: 'loader'});
                    var toreload = [];
                    control.reloadOptionIfRequirementsMet = function (name) {
                        toreload.push(name);
                    };
                    control.cyclic = data.cyclic;
                    control.dependents['opt3'] = data.deps;

                    control.optionValueChanged('opt3', 'xyz');
                    return toreload;
                });

            },
            unsubscribeAll_Test: function () {
                var self = this;

                var control = new RemoteOptionController({loader: 'loader'});
                var diddispose = 0;
                var doit = function () {
                    diddispose++;
                };
                control.observers = {
                    a: {
                        dispose: doit
                    }, b: {
                        dispose: doit
                    }
                };
                control.unsubscribeAll();
                self.assert('should unsubscribe all', 2, diddispose);

            }
        }
    )
});
