/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.label.GoodsLabel;
import net.sf.freecol.client.gui.label.MarketLabel;
import net.sf.freecol.client.gui.label.UnitLabel;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.DefaultTransferHandler;
import net.sf.freecol.client.gui.panel.DragListener;
import net.sf.freecol.client.gui.panel.DropListener;
import net.sf.freecol.client.gui.panel.DropTarget;
import net.sf.freecol.client.gui.panel.FreeColButton;
import net.sf.freecol.client.gui.panel.InPortPanel;
import net.sf.freecol.client.gui.panel.PortPanel;
import net.sf.freecol.client.gui.panel.UnitPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.MarketData;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TransactionListener;
import net.sf.freecol.common.model.Unit;

public final class EuropePanel
extends PortPanel {
    private static final Logger logger = Logger.getLogger(EuropePanel.class.getName());
    private DestinationPanel toAmericaPanel;
    private DestinationPanel toEuropePanel;
    private EuropeanDocksPanel europeanDocksPanel;
    private MarketPanel marketPanel;
    private TransactionLog log;
    private JButton exitButton = new EuropeButton(Messages.message("close"), 27, EuropeAction.EXIT.toString(), ae -> this.exitAction()).withButtonStyle(FreeColButton.ButtonStyle.IMPORTANT);
    private JButton trainButton = new EuropeButton(Messages.message("train"), 84, EuropeAction.TRAIN.toString(), ae -> this.getGUI().showTrainPanel());
    private JButton purchaseButton = new EuropeButton(Messages.message("purchase"), 80, EuropeAction.PURCHASE.toString(), ae -> this.getGUI().showPurchasePanel());
    private JButton recruitButton = new EuropeButton(Messages.message("recruit"), 82, EuropeAction.RECRUIT.toString(), ae -> this.getGUI().showRecruitPanel());
    private JButton unloadButton = new EuropeButton(Messages.message("unload"), 85, EuropeAction.UNLOAD.toString(), ae -> this.unloadAction());
    private JButton sailButton = new EuropeButton(Messages.message("setSail"), 83, EuropeAction.SAIL.toString(), ae -> this.sailAction());
    private final Europe europe;

    public EuropePanel(FreeColClient freeColClient, boolean header) {
        super(freeColClient, (LayoutManager)new MigLayout("wrap 3, fill", "[30%:][30%:][15%:]"));
        this.toAmericaPanel = new DestinationPanel();
        this.toEuropePanel = new DestinationPanel();
        this.inPortPanel = new EuropeInPortPanel();
        this.cargoPanel = new CargoPanel(freeColClient, true, false);
        this.europeanDocksPanel = new EuropeanDocksPanel();
        this.marketPanel = new MarketPanel(this);
        this.log = new TransactionLog();
        this.europe = freeColClient.getMyPlayer().getEurope();
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setAlignment(attributes, 2);
        StyleConstants.setBold(attributes, true);
        StyleConstants.setFontSize(attributes, (int)FontLibrary.getMainFontSize());
        this.log.setParagraphAttributes(attributes, true);
        this.defaultTransferHandler = new DefaultTransferHandler(freeColClient, this);
        this.toAmericaPanel.setTransferHandler(this.defaultTransferHandler);
        this.toEuropePanel.setTransferHandler(this.defaultTransferHandler);
        this.inPortPanel.setTransferHandler(this.defaultTransferHandler);
        this.cargoPanel.setTransferHandler(this.defaultTransferHandler);
        this.europeanDocksPanel.setTransferHandler(this.defaultTransferHandler);
        this.marketPanel.setTransferHandler(this.defaultTransferHandler);
        this.pressListener = new DragListener(freeColClient, this);
        DropListener releaseListener = new DropListener();
        this.toAmericaPanel.addMouseListener(releaseListener);
        this.toEuropePanel.addMouseListener(releaseListener);
        this.inPortPanel.addMouseListener(releaseListener);
        this.cargoPanel.addMouseListener(releaseListener);
        this.europeanDocksPanel.addMouseListener(releaseListener);
        this.marketPanel.addMouseListener(releaseListener);
        this.toAmericaPanel.setLayout(new GridLayout(1, 0));
        this.toEuropePanel.setLayout(new GridLayout(1, 0));
        this.inPortPanel.setLayout(new GridLayout(1, 0));
        this.cargoPanel.setLayout(new GridLayout(1, 0));
        this.europeanDocksPanel.setLayout(new GridLayout(0, 5));
        JScrollPane toAmericaScroll = new JScrollPane(this.toAmericaPanel, 21, 30);
        toAmericaScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane toEuropeScroll = new JScrollPane(this.toEuropePanel, 21, 30);
        toEuropeScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane inPortScroll = new JScrollPane(this.inPortPanel, 21, 30);
        inPortScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane cargoScroll = new JScrollPane(this.cargoPanel, 21, 30);
        cargoScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane docksScroll = new JScrollPane(this.europeanDocksPanel, 20, 31);
        docksScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane marketScroll = new JScrollPane(this.marketPanel, 21, 30);
        JScrollPane logScroll = new JScrollPane(this.log, 20, 31);
        logScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.toAmericaPanel.setBorder(Utility.localizedBorder("sailingToAmerica"));
        this.toEuropePanel.setBorder(Utility.localizedBorder("sailingToEurope"));
        this.europeanDocksPanel.setBorder(Utility.localizedBorder("docks"));
        this.inPortPanel.setBorder(Utility.localizedBorder("inPort"));
        this.marketPanel.setBorder(Utility.blankBorder(10, 10, 10, 10));
        this.log.setBorder(Utility.localizedBorder("sales"));
        toAmericaScroll.getViewport().setOpaque(false);
        this.toAmericaPanel.setOpaque(false);
        toEuropeScroll.getViewport().setOpaque(false);
        this.toEuropePanel.setOpaque(false);
        inPortScroll.getViewport().setOpaque(false);
        this.inPortPanel.setOpaque(false);
        cargoScroll.getViewport().setOpaque(false);
        this.cargoPanel.setOpaque(false);
        docksScroll.getViewport().setOpaque(false);
        this.europeanDocksPanel.setOpaque(false);
        marketScroll.getViewport().setOpaque(false);
        this.marketPanel.setOpaque(false);
        logScroll.getViewport().setOpaque(false);
        this.log.setOpaque(false);
        this.initialize(this.europe);
        if (header) {
            this.add((Component)Utility.localizedHeader(this.europe.getNameKey(), Utility.FONTSPEC_TITLE), "span, top, center");
        }
        this.add((Component)toAmericaScroll, "sg, height 15%:, grow");
        this.add((Component)toEuropeScroll, "sg, height 15%:, grow");
        this.add((Component)logScroll, "spany 3, grow");
        this.add((Component)inPortScroll, "sg, height 15%:, grow");
        this.add((Component)docksScroll, "spany 2, grow");
        this.add((Component)cargoScroll, "height 10%:, grow");
        this.add((Component)marketScroll, "span, height 10%:, grow");
        this.add((Component)this.recruitButton, "span, split 6");
        this.add(this.purchaseButton);
        this.add(this.trainButton);
        this.add(this.unloadButton);
        this.add(this.sailButton);
        this.add((Component)this.exitButton, "tag ok");
        Unit u = this.europe.getLastUnit();
        if (u == null) {
            this.setSelectedUnitLabel(null);
        } else {
            this.setSelectedUnit(u);
        }
        int width = this.getImageLibrary().scaleInt(1050);
        int height = this.getImageLibrary().scaleInt(725);
        this.getGUI().restoreSavedSize(this, new Dimension(width, height));
        this.setEscapeAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                EuropePanel.this.exitButton.doClick();
            }
        });
    }

    private void initialize(Europe europe) {
        this.toAmericaPanel.initialize(europe.getGame().getMap());
        this.toEuropePanel.initialize(europe);
        this.cargoPanel.initialize();
        this.inPortPanel.initialize();
        this.marketPanel.initialize();
        this.europeanDocksPanel.initialize();
        this.log.initialize();
    }

    private void cleanup() {
        this.log.cleanup();
        this.europeanDocksPanel.cleanup();
        this.marketPanel.cleanup();
        this.inPortPanel.cleanup();
        this.cargoPanel.cleanup();
        this.toEuropePanel.cleanup();
        this.toAmericaPanel.cleanup();
    }

    @Override
    public void requestFocus() {
        this.exitButton.requestFocus();
    }

    public void refresh() {
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void setSelectedUnitLabel(UnitLabel unitLabel) {
        if (this.selectedUnitLabel != unitLabel) {
            if (this.selectedUnitLabel != null) {
                this.selectedUnitLabel.setSelected(false);
            }
            this.selectedUnitLabel = unitLabel;
            if (unitLabel == null) {
                this.cargoPanel.setCarrier(null);
            } else {
                this.cargoPanel.setCarrier(unitLabel.getUnit());
                unitLabel.setSelected(true);
            }
        }
        this.inPortPanel.revalidate();
        this.inPortPanel.repaint();
    }

    private void exitAction() {
        this.cleanup();
        this.getGUI().removeComponent(this);
        this.igc().nextModelMessage();
    }

    private void unloadAction() {
        Player player = this.getMyPlayer();
        Unit unit = this.getSelectedUnit();
        if (unit != null && unit.isCarrier()) {
            for (Goods g : unit.getCompactGoodsList()) {
                if (player.canTrade(g.getType())) {
                    this.igc().sellGoods(g);
                    continue;
                }
                this.igc().payArrears(g.getType());
            }
            for (Unit u : unit.getUnitList()) {
                this.igc().leaveShip(u);
            }
            this.cargoPanel.update();
            this.europeanDocksPanel.update();
        }
        this.requestFocus();
    }

    private void sailAction() {
        Unit unit = this.getSelectedUnit();
        if (unit != null && this.toAmericaPanel.accepts(unit)) {
            this.toAmericaPanel.add((Component)this.getSelectedUnitLabel(), true);
        }
        this.requestFocus();
    }

    @Override
    public List<Unit> getUnitList() {
        return this.europe.getUnitList();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeAll();
        this.toAmericaPanel = null;
        this.toEuropePanel = null;
        this.europeanDocksPanel = null;
        this.marketPanel = null;
        this.log = null;
        this.sailButton = null;
        this.unloadButton = null;
        this.recruitButton = null;
        this.purchaseButton = null;
        this.trainButton = null;
        this.exitButton = null;
    }

    public static enum EuropeAction {
        EXIT,
        RECRUIT,
        PURCHASE,
        TRAIN,
        UNLOAD,
        SAIL;

    }

    private final class TransactionLog
    extends JTextPane
    implements TransactionListener {
        public TransactionLog() {
            this.setEditable(false);
        }

        public void initialize() {
            EuropePanel.this.getMyPlayer().getMarket().addTransactionListener(this);
            this.setText("");
        }

        public void cleanup() {
            EuropePanel.this.getMyPlayer().getMarket().removeTransactionListener(this);
        }

        private void add(String text) {
            StyledDocument doc = this.getStyledDocument();
            try {
                if (doc.getLength() > 0) {
                    text = "\n\n" + (String)text;
                }
                doc.insertString(doc.getLength(), (String)text, null);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Transaction log update failure", e);
            }
        }

        @Override
        public void logPurchase(GoodsType goodsType, int amount, int price) {
            int total = amount * price;
            Object t1 = ((StringTemplate)((StringTemplate)StringTemplate.template("europePanel.transaction.purchase").addNamed("%goods%", goodsType)).addAmount("%amount%", amount)).addAmount("%gold%", price);
            Object t2 = StringTemplate.template("europePanel.transaction.price").addAmount("%gold%", total);
            this.add(Messages.message(t1) + "\n" + Messages.message(t2));
        }

        @Override
        public void logSale(GoodsType goodsType, int amount, int price, int tax) {
            int totalBeforeTax = amount * price;
            int totalTax = totalBeforeTax * tax / 100;
            int totalAfterTax = totalBeforeTax - totalTax;
            Object t1 = ((StringTemplate)((StringTemplate)StringTemplate.template("europePanel.transaction.sale").addNamed("%goods%", goodsType)).addAmount("%amount%", amount)).addAmount("%gold%", price);
            Object t2 = StringTemplate.template("europePanel.transaction.price").addAmount("%gold%", totalBeforeTax);
            Object t3 = ((StringTemplate)StringTemplate.template("europePanel.transaction.tax").addAmount("%tax%", tax)).addAmount("%gold%", totalTax);
            Object t4 = StringTemplate.template("europePanel.transaction.net").addAmount("%gold%", totalAfterTax);
            this.add(Messages.message(t1) + "\n" + Messages.message(t2) + "\n" + Messages.message(t3) + "\n" + Messages.message(t4));
        }
    }

    private final class MarketPanel
    extends JPanel
    implements DropTarget {
        public MarketPanel(EuropePanel europePanel2) {
            super(new GridLayout(2, 8));
        }

        public void initialize() {
            this.removeAll();
            FreeColClient fcc = EuropePanel.this.getFreeColClient();
            Market market = EuropePanel.this.getMyPlayer().getMarket();
            for (GoodsType goodsType : EuropePanel.this.getSpecification().getStorableGoodsTypeList()) {
                MarketLabel label = new MarketLabel(fcc, goodsType, market);
                label.setTransferHandler(EuropePanel.this.defaultTransferHandler);
                label.addMouseListener(EuropePanel.this.pressListener);
                MarketData md = market.getMarketData(goodsType);
                if (md != null) {
                    md.addPropertyChangeListener(label);
                }
                this.add(label);
            }
        }

        public void cleanup() {
        }

        @Override
        public boolean accepts(Goods goods) {
            return true;
        }

        @Override
        public boolean accepts(GoodsType goodsType) {
            return false;
        }

        @Override
        public boolean accepts(Unit unit) {
            return false;
        }

        @Override
        public Component add(Component comp, boolean editState) {
            if (editState) {
                if (!(comp instanceof GoodsLabel)) {
                    logger.warning("Invalid component: " + comp);
                    return null;
                }
                Goods goods = ((GoodsLabel)comp).getGoods();
                if (EuropePanel.this.getMyPlayer().canTrade(goods.getType())) {
                    EuropePanel.this.igc().sellGoods(goods);
                } else {
                    Constants.BoycottAction act = EuropePanel.this.getGUI().getBoycottChoice(goods, EuropePanel.this.europe);
                    if (act != null) {
                        switch (act) {
                            case BOYCOTT_PAY_ARREARS: {
                                EuropePanel.this.igc().payArrears(goods.getType());
                                break;
                            }
                            case BOYCOTT_DUMP_CARGO: {
                                EuropePanel.this.igc().unloadCargo(goods, true);
                                break;
                            }
                            default: {
                                logger.warning("showBoycottedGoodsDialog fail: " + act);
                            }
                        }
                    }
                }
                EuropePanel.this.cargoPanel.revalidate();
                this.revalidate();
                EuropePanel.this.igc().nextModelMessage();
            }
            EuropePanel.this.refresh();
            return comp;
        }

        @Override
        public void remove(Component comp) {
        }
    }

    private final class EuropeInPortPanel
    extends InPortPanel {
        public EuropeInPortPanel() {
            super(new MigLayout(), EuropePanel.this, "Europe - port", true);
        }

        @Override
        protected void addPropertyChangeListeners() {
            EuropePanel.this.europe.addPropertyChangeListener(this);
        }

        @Override
        protected void removePropertyChangeListeners() {
            EuropePanel.this.europe.removePropertyChangeListener(this);
        }

        @Override
        public boolean accepts(Unit unit) {
            if (!unit.isNaval()) {
                return false;
            }
            switch (unit.getState()) {
                case ACTIVE: 
                case FORTIFIED: 
                case FORTIFYING: 
                case SENTRY: 
                case SKIPPED: {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class EuropeButton
    extends FreeColButton {
        public EuropeButton(String text, int keyEvent, String command, ActionListener listener) {
            this.setOpaque(true);
            this.setText(text);
            this.setActionCommand(command);
            this.addActionListener(listener);
            ComponentInputMap closeInputMap = new ComponentInputMap(this);
            ((InputMap)closeInputMap).put(KeyStroke.getKeyStroke(keyEvent, 0, false), "pressed");
            ((InputMap)closeInputMap).put(KeyStroke.getKeyStroke(keyEvent, 0, true), "released");
            SwingUtilities.replaceUIInputMap(this, 2, closeInputMap);
        }
    }

    public final class EuropeanDocksPanel
    extends UnitPanel
    implements DropTarget {
        public EuropeanDocksPanel() {
            super(null, new MigLayout("wrap 6"), EuropePanel.this, "Europe - docks", true);
        }

        @Override
        public void addPropertyChangeListeners() {
            EuropePanel.this.europe.addPropertyChangeListener(this);
        }

        @Override
        public void removePropertyChangeListeners() {
            EuropePanel.this.europe.removePropertyChangeListener(this);
        }

        @Override
        public void selectLabel() {
        }

        @Override
        public boolean accepts(Goods goods) {
            return false;
        }

        @Override
        public boolean accepts(GoodsType goodsType) {
            return false;
        }

        @Override
        public boolean accepts(Unit unit) {
            return !unit.isNaval();
        }

        @Override
        public Component add(Component comp, boolean editState) {
            Component c = this.add(comp);
            this.update();
            return c;
        }

        @Override
        public int suggested(GoodsType type) {
            return -1;
        }

        @Override
        public void remove(Component comp) {
            this.update();
        }
    }

    private final class DestinationPanel
    extends JPanel
    implements DropTarget {
        private Location destination;

        private DestinationPanel() {
        }

        public void initialize(Location destination) {
            this.destination = destination;
            this.update();
        }

        public void cleanup() {
        }

        public void update() {
            this.removeAll();
            HighSeas highSeas = EuropePanel.this.getMyPlayer().getHighSeas();
            if (highSeas != null) {
                for (Unit unit : highSeas.getUnitList()) {
                    boolean belongs;
                    if (this.destination instanceof Europe) {
                        belongs = unit.getDestination() == this.destination;
                    } else if (this.destination instanceof Map) {
                        belongs = unit.getDestination() == this.destination || unit.getDestination() != null && unit.getDestination().getTile() != null && unit.getDestination().getTile().getMap() == this.destination;
                    } else {
                        logger.warning("Bogus DestinationPanel location: " + this.destination + " for unit: " + unit);
                        belongs = false;
                    }
                    if (!belongs) continue;
                    UnitLabel unitLabel = new UnitLabel(EuropePanel.this.getFreeColClient(), unit);
                    unitLabel.setTransferHandler(EuropePanel.this.defaultTransferHandler);
                    unitLabel.addMouseListener(EuropePanel.this.pressListener);
                    this.add(unitLabel);
                }
            }
            Utility.localizeBorder(this, Unit.getUnitDestinationLabel("ship", this.destination, EuropePanel.this.getMyPlayer()));
            this.revalidate();
        }

        @Override
        public boolean accepts(Goods goods) {
            return false;
        }

        @Override
        public boolean accepts(GoodsType goodsType) {
            return false;
        }

        @Override
        public boolean accepts(Unit unit) {
            return unit.isNaval() && !unit.isDamagedAndUnderForcedRepair();
        }

        @Override
        public Component add(Component comp, boolean editState) {
            if (editState) {
                if (!(comp instanceof UnitLabel)) {
                    logger.warning("Invalid component: " + comp);
                    return null;
                }
                Unit unit = ((UnitLabel)comp).getUnit();
                if (!(unit.getTradeRoute() == null || EuropePanel.this.getGUI().confirmClearTradeRoute(unit) && EuropePanel.this.igc().assignTradeRoute(unit, null))) {
                    return null;
                }
                Location dest = this.destination;
                if (unit.isInEurope() && (dest = EuropePanel.this.getGUI().showSelectDestinationDialog(unit)) == null) {
                    return null;
                }
                ClientOptions co = EuropePanel.this.getClientOptions();
                if (!co.getBoolean("model.option.autoloadEmigrants") && unit.isInEurope() && !(this.destination instanceof Europe) && EuropePanel.this.europeanDocksPanel.getComponentCount() > 0 && unit.hasSpaceLeft()) {
                    StringTemplate locName = this.destination.getLocationLabelFor(unit.getOwner());
                    if (!EuropePanel.this.getGUI().confirm(null, (StringTemplate)StringTemplate.template("europePanel.leaveColonists").addStringTemplate("%newWorld%", locName), unit, "ok", "cancel")) {
                        return null;
                    }
                }
                EuropePanel.this.igc().moveTo(unit, dest);
                if (!(dest instanceof Europe) && unit.isInEurope()) {
                    return null;
                }
                Container parent = comp.getParent();
                if (parent != null) {
                    parent.remove(comp);
                }
                EuropePanel.this.inPortPanel.update();
                EuropePanel.this.europeanDocksPanel.update();
                EuropePanel.this.cargoPanel.update();
                if (unit == EuropePanel.this.cargoPanel.getCarrier()) {
                    EuropePanel.this.cargoPanel.setCarrier(null);
                }
            }
            Component c = this.add(comp);
            this.revalidate();
            EuropePanel.this.refresh();
            return c;
        }

        @Override
        public int suggested(GoodsType type) {
            return -1;
        }
    }
}

