/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.io.File;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;

public class FileOption
extends AbstractOption<File> {
    private static final Logger logger = Logger.getLogger(FileOption.class.getName());
    public static final String TAG = "fileOption";
    private File value = null;
    private String type = null;
    private static final String TYPE_TAG = "type";

    public FileOption(Specification specification) {
        super(specification);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public FileOption cloneOption() {
        FileOption result = new FileOption(this.getSpecification());
        result.setValues(this);
        result.setType(this.getType());
        return result;
    }

    @Override
    public File getValue() {
        return this.value;
    }

    @Override
    public void setValue(File value) {
        File oldValue = this.value;
        this.value = value;
        if (value != oldValue) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    @Override
    public boolean isNullValueOK() {
        return true;
    }

    @Override
    protected void setValue(String valueString, String defaultValueString) {
        this.value = valueString != null ? new File(valueString) : (defaultValueString != null ? new File(defaultValueString) : null);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.value != null) {
            xw.writeAttribute("value", this.value.getAbsolutePath());
        }
        if (this.type != null) {
            xw.writeAttribute(TYPE_TAG, this.type);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.type = xr.getAttribute(TYPE_TAG, null);
        if (this.type == null) {
            this.setType(this.value != null && this.value.getPath().endsWith(".fsm") ? "map" : "save");
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append('[').append(this.getId()).append(" value=").append(this.value == null ? "null" : this.value.getName()).append(" type=").append(this.type == null ? "null" : this.type).append(']');
        return sb.toString();
    }
}

