// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: yandex/cloud/compute/v1/snapshot_service.proto

package compute

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type GetSnapshotRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Snapshot resource to return.
	// To get the snapshot ID, use a [SnapshotService.List] request.
	SnapshotId    string `protobuf:"bytes,1,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetSnapshotRequest) Reset() {
	*x = GetSnapshotRequest{}
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSnapshotRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSnapshotRequest) ProtoMessage() {}

func (x *GetSnapshotRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSnapshotRequest.ProtoReflect.Descriptor instead.
func (*GetSnapshotRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_snapshot_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetSnapshotRequest) GetSnapshotId() string {
	if x != nil {
		return x.SnapshotId
	}
	return ""
}

type ListSnapshotsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the folder to list snapshots in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListSnapshotsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListSnapshotsResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression consists of one or more conditions united by `AND` operator: `<condition1> [AND <condition2> [<...> AND <conditionN>]]`.
	//
	// Each condition has the form `<field> <operator> <value>`, where:
	// 1. `<field>` is the field name. Currently you can use filtering only on the limited number of fields.
	// 2. `<operator>` is a logical operator, one of `=`, `!=`, `IN`, `NOT IN`.
	// 3. `<value>` represents a value.
	// String values should be written in double (`"`) or single (`'`) quotes. C-style escape sequences are supported (`\"` turns to `"`, `\'` to `'`, `\\` to backslash).
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// By which column the listing should be ordered and in which direction,
	// format is "createdAt desc". "id asc" if omitted.
	// The default sorting order is ascending
	OrderBy       string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListSnapshotsRequest) Reset() {
	*x = ListSnapshotsRequest{}
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSnapshotsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSnapshotsRequest) ProtoMessage() {}

func (x *ListSnapshotsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSnapshotsRequest.ProtoReflect.Descriptor instead.
func (*ListSnapshotsRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_snapshot_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListSnapshotsRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *ListSnapshotsRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSnapshotsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSnapshotsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListSnapshotsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

type ListSnapshotsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of snapshots.
	Snapshots []*Snapshot `protobuf:"bytes,1,rep,name=snapshots,proto3" json:"snapshots,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListSnapshotsRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListSnapshotsRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListSnapshotsResponse) Reset() {
	*x = ListSnapshotsResponse{}
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSnapshotsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSnapshotsResponse) ProtoMessage() {}

func (x *ListSnapshotsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSnapshotsResponse.ProtoReflect.Descriptor instead.
func (*ListSnapshotsResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_snapshot_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListSnapshotsResponse) GetSnapshots() []*Snapshot {
	if x != nil {
		return x.Snapshots
	}
	return nil
}

func (x *ListSnapshotsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type CreateSnapshotRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the folder to create a snapshot in.
	// To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// ID of the disk to create the snapshot from.
	// To get the disk ID use a [yandex.cloud.compute.v1.DiskService.List] request.
	DiskId string `protobuf:"bytes,2,opt,name=disk_id,json=diskId,proto3" json:"disk_id,omitempty"`
	// Name of the snapshot.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the snapshot.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Specify the overrides to hardware_generation of a source disk, image or snapshot,
	// or to the default values if the source does not define it.
	HardwareGeneration *HardwareGeneration `protobuf:"bytes,7,opt,name=hardware_generation,json=hardwareGeneration,proto3" json:"hardware_generation,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *CreateSnapshotRequest) Reset() {
	*x = CreateSnapshotRequest{}
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSnapshotRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSnapshotRequest) ProtoMessage() {}

func (x *CreateSnapshotRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSnapshotRequest.ProtoReflect.Descriptor instead.
func (*CreateSnapshotRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_snapshot_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateSnapshotRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *CreateSnapshotRequest) GetDiskId() string {
	if x != nil {
		return x.DiskId
	}
	return ""
}

func (x *CreateSnapshotRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateSnapshotRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CreateSnapshotRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *CreateSnapshotRequest) GetHardwareGeneration() *HardwareGeneration {
	if x != nil {
		return x.HardwareGeneration
	}
	return nil
}

type CreateSnapshotMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the snapshot that is being created.
	SnapshotId string `protobuf:"bytes,1,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	// ID of the source disk used to create this snapshot.
	DiskId        string `protobuf:"bytes,2,opt,name=disk_id,json=diskId,proto3" json:"disk_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateSnapshotMetadata) Reset() {
	*x = CreateSnapshotMetadata{}
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSnapshotMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSnapshotMetadata) ProtoMessage() {}

func (x *CreateSnapshotMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSnapshotMetadata.ProtoReflect.Descriptor instead.
func (*CreateSnapshotMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_snapshot_service_proto_rawDescGZIP(), []int{4}
}

func (x *CreateSnapshotMetadata) GetSnapshotId() string {
	if x != nil {
		return x.SnapshotId
	}
	return ""
}

func (x *CreateSnapshotMetadata) GetDiskId() string {
	if x != nil {
		return x.DiskId
	}
	return ""
}

type UpdateSnapshotRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Snapshot resource to update.
	// To get the snapshot ID use a [SnapshotService.List] request.
	SnapshotId string `protobuf:"bytes,1,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	// Field mask that specifies which fields of the Snapshot resource are going to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the snapshot.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the snapshot.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	//
	// Existing set of `labels` is completely replaced by the provided set.
	Labels        map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateSnapshotRequest) Reset() {
	*x = UpdateSnapshotRequest{}
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateSnapshotRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSnapshotRequest) ProtoMessage() {}

func (x *UpdateSnapshotRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSnapshotRequest.ProtoReflect.Descriptor instead.
func (*UpdateSnapshotRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_snapshot_service_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateSnapshotRequest) GetSnapshotId() string {
	if x != nil {
		return x.SnapshotId
	}
	return ""
}

func (x *UpdateSnapshotRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateSnapshotRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateSnapshotRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *UpdateSnapshotRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type UpdateSnapshotMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Snapshot resource that is being updated.
	SnapshotId    string `protobuf:"bytes,1,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateSnapshotMetadata) Reset() {
	*x = UpdateSnapshotMetadata{}
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateSnapshotMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSnapshotMetadata) ProtoMessage() {}

func (x *UpdateSnapshotMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSnapshotMetadata.ProtoReflect.Descriptor instead.
func (*UpdateSnapshotMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_snapshot_service_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateSnapshotMetadata) GetSnapshotId() string {
	if x != nil {
		return x.SnapshotId
	}
	return ""
}

type DeleteSnapshotRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the snapshot to delete.
	// To get the snapshot ID, use a [SnapshotService.List] request.
	SnapshotId    string `protobuf:"bytes,1,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteSnapshotRequest) Reset() {
	*x = DeleteSnapshotRequest{}
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteSnapshotRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSnapshotRequest) ProtoMessage() {}

func (x *DeleteSnapshotRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSnapshotRequest.ProtoReflect.Descriptor instead.
func (*DeleteSnapshotRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_snapshot_service_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteSnapshotRequest) GetSnapshotId() string {
	if x != nil {
		return x.SnapshotId
	}
	return ""
}

type DeleteSnapshotMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the snapshot that is being deleted.
	SnapshotId    string `protobuf:"bytes,1,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteSnapshotMetadata) Reset() {
	*x = DeleteSnapshotMetadata{}
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteSnapshotMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSnapshotMetadata) ProtoMessage() {}

func (x *DeleteSnapshotMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSnapshotMetadata.ProtoReflect.Descriptor instead.
func (*DeleteSnapshotMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_snapshot_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteSnapshotMetadata) GetSnapshotId() string {
	if x != nil {
		return x.SnapshotId
	}
	return ""
}

type ListSnapshotOperationsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Snapshot resource to list operations for.
	SnapshotId string `protobuf:"bytes,1,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListSnapshotOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListSnapshotOperationsResponse.next_page_token] returned by a previous list request.
	PageToken     string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListSnapshotOperationsRequest) Reset() {
	*x = ListSnapshotOperationsRequest{}
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSnapshotOperationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSnapshotOperationsRequest) ProtoMessage() {}

func (x *ListSnapshotOperationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSnapshotOperationsRequest.ProtoReflect.Descriptor instead.
func (*ListSnapshotOperationsRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_snapshot_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListSnapshotOperationsRequest) GetSnapshotId() string {
	if x != nil {
		return x.SnapshotId
	}
	return ""
}

func (x *ListSnapshotOperationsRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSnapshotOperationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

type ListSnapshotOperationsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of operations for the specified snapshot.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListSnapshotOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListSnapshotOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListSnapshotOperationsResponse) Reset() {
	*x = ListSnapshotOperationsResponse{}
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSnapshotOperationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSnapshotOperationsResponse) ProtoMessage() {}

func (x *ListSnapshotOperationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSnapshotOperationsResponse.ProtoReflect.Descriptor instead.
func (*ListSnapshotOperationsResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_snapshot_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListSnapshotOperationsResponse) GetOperations() []*operation.Operation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *ListSnapshotOperationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_yandex_cloud_compute_v1_snapshot_service_proto protoreflect.FileDescriptor

const file_yandex_cloud_compute_v1_snapshot_service_proto_rawDesc = "" +
	"\n" +
	".yandex/cloud/compute/v1/snapshot_service.proto\x12\x17yandex.cloud.compute.v1\x1a\x1cgoogle/api/annotations.proto\x1a google/protobuf/field_mask.proto\x1a yandex/cloud/access/access.proto\x1a yandex/cloud/api/operation.proto\x1a1yandex/cloud/compute/v1/hardware_generation.proto\x1a&yandex/cloud/compute/v1/snapshot.proto\x1a&yandex/cloud/operation/operation.proto\x1a\x1dyandex/cloud/validation.proto\"C\n" +
	"\x12GetSnapshotRequest\x12-\n" +
	"\vsnapshot_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\n" +
	"snapshotId\"\xde\x01\n" +
	"\x14ListSnapshotsRequest\x12)\n" +
	"\tfolder_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\bfolderId\x12'\n" +
	"\tpage_size\x18\x02 \x01(\x03B\n" +
	"\xfa\xc71\x06<=1000R\bpageSize\x12(\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tB\t\x8a\xc81\x05<=100R\tpageToken\x12\"\n" +
	"\x06filter\x18\x04 \x01(\tB\n" +
	"\x8a\xc81\x06<=1000R\x06filter\x12$\n" +
	"\border_by\x18\x05 \x01(\tB\t\x8a\xc81\x05<=100R\aorderBy\"\x80\x01\n" +
	"\x15ListSnapshotsResponse\x12?\n" +
	"\tsnapshots\x18\x01 \x03(\v2!.yandex.cloud.compute.v1.SnapshotR\tsnapshots\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\x8a\x04\n" +
	"\x15CreateSnapshotRequest\x12)\n" +
	"\tfolder_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\bfolderId\x12%\n" +
	"\adisk_id\x18\x02 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\x06diskId\x129\n" +
	"\x04name\x18\x03 \x01(\tB%\xf2\xc71!|[a-z]([-_a-z0-9]{0,61}[a-z0-9])?R\x04name\x12+\n" +
	"\vdescription\x18\x04 \x01(\tB\t\x8a\xc81\x05<=256R\vdescription\x12\x97\x01\n" +
	"\x06labels\x18\x06 \x03(\v2:.yandex.cloud.compute.v1.CreateSnapshotRequest.LabelsEntryBC\xf2\xc71\x0f[-_./\\@0-9a-z]*\x82\xc81\x04<=64\x8a\xc81\x04<=63\xb2\xc81\x1c\x12\x14[a-z][-_./\\@0-9a-z]*\x1a\x041-63R\x06labels\x12\\\n" +
	"\x13hardware_generation\x18\a \x01(\v2+.yandex.cloud.compute.v1.HardwareGenerationR\x12hardwareGeneration\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01J\x04\b\x05\x10\x06\"R\n" +
	"\x16CreateSnapshotMetadata\x12\x1f\n" +
	"\vsnapshot_id\x18\x01 \x01(\tR\n" +
	"snapshotId\x12\x17\n" +
	"\adisk_id\x18\x02 \x01(\tR\x06diskId\"\xc0\x03\n" +
	"\x15UpdateSnapshotRequest\x12-\n" +
	"\vsnapshot_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\n" +
	"snapshotId\x12;\n" +
	"\vupdate_mask\x18\x02 \x01(\v2\x1a.google.protobuf.FieldMaskR\n" +
	"updateMask\x129\n" +
	"\x04name\x18\x03 \x01(\tB%\xf2\xc71!|[a-z]([-_a-z0-9]{0,61}[a-z0-9])?R\x04name\x12+\n" +
	"\vdescription\x18\x04 \x01(\tB\t\x8a\xc81\x05<=256R\vdescription\x12\x97\x01\n" +
	"\x06labels\x18\x05 \x03(\v2:.yandex.cloud.compute.v1.UpdateSnapshotRequest.LabelsEntryBC\xf2\xc71\x0f[-_./\\@0-9a-z]*\x82\xc81\x04<=64\x8a\xc81\x04<=63\xb2\xc81\x1c\x12\x14[a-z][-_./\\@0-9a-z]*\x1a\x041-63R\x06labels\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"9\n" +
	"\x16UpdateSnapshotMetadata\x12\x1f\n" +
	"\vsnapshot_id\x18\x01 \x01(\tR\n" +
	"snapshotId\"F\n" +
	"\x15DeleteSnapshotRequest\x12-\n" +
	"\vsnapshot_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\n" +
	"snapshotId\"9\n" +
	"\x16DeleteSnapshotMetadata\x12\x1f\n" +
	"\vsnapshot_id\x18\x01 \x01(\tR\n" +
	"snapshotId\"\xa1\x01\n" +
	"\x1dListSnapshotOperationsRequest\x12-\n" +
	"\vsnapshot_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\n" +
	"snapshotId\x12'\n" +
	"\tpage_size\x18\x02 \x01(\x03B\n" +
	"\xfa\xc71\x06<=1000R\bpageSize\x12(\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tB\t\x8a\xc81\x05<=100R\tpageToken\"\x8b\x01\n" +
	"\x1eListSnapshotOperationsResponse\x12A\n" +
	"\n" +
	"operations\x18\x01 \x03(\v2!.yandex.cloud.operation.OperationR\n" +
	"operations\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken2\xa3\r\n" +
	"\x0fSnapshotService\x12\x82\x01\n" +
	"\x03Get\x12+.yandex.cloud.compute.v1.GetSnapshotRequest\x1a!.yandex.cloud.compute.v1.Snapshot\"+\x82\xd3\xe4\x93\x02%\x12#/compute/v1/snapshots/{snapshot_id}\x12\x84\x01\n" +
	"\x04List\x12-.yandex.cloud.compute.v1.ListSnapshotsRequest\x1a..yandex.cloud.compute.v1.ListSnapshotsResponse\"\x1d\x82\xd3\xe4\x93\x02\x17\x12\x15/compute/v1/snapshots\x12\xa3\x01\n" +
	"\x06Create\x12..yandex.cloud.compute.v1.CreateSnapshotRequest\x1a!.yandex.cloud.operation.Operation\"F\xb2\xd2*\"\n" +
	"\x16CreateSnapshotMetadata\x12\bSnapshot\x82\xd3\xe4\x93\x02\x1a:\x01*\"\x15/compute/v1/snapshots\x12\xb1\x01\n" +
	"\x06Update\x12..yandex.cloud.compute.v1.UpdateSnapshotRequest\x1a!.yandex.cloud.operation.Operation\"T\xb2\xd2*\"\n" +
	"\x16UpdateSnapshotMetadata\x12\bSnapshot\x82\xd3\xe4\x93\x02(:\x01*2#/compute/v1/snapshots/{snapshot_id}\x12\xbb\x01\n" +
	"\x06Delete\x12..yandex.cloud.compute.v1.DeleteSnapshotRequest\x1a!.yandex.cloud.operation.Operation\"^\xb2\xd2*/\n" +
	"\x16DeleteSnapshotMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x02%*#/compute/v1/snapshots/{snapshot_id}\x12\xb9\x01\n" +
	"\x0eListOperations\x126.yandex.cloud.compute.v1.ListSnapshotOperationsRequest\x1a7.yandex.cloud.compute.v1.ListSnapshotOperationsResponse\"6\x82\xd3\xe4\x93\x020\x12./compute/v1/snapshots/{snapshot_id}/operations\x12\xb5\x01\n" +
	"\x12ListAccessBindings\x12..yandex.cloud.access.ListAccessBindingsRequest\x1a/.yandex.cloud.access.ListAccessBindingsResponse\">\x82\xd3\xe4\x93\x028\x126/compute/v1/snapshots/{resource_id}:listAccessBindings\x12\xf4\x01\n" +
	"\x11SetAccessBindings\x12-.yandex.cloud.access.SetAccessBindingsRequest\x1a!.yandex.cloud.operation.Operation\"\x8c\x01\xb2\xd2*H\n" +
	" access.SetAccessBindingsMetadata\x12$access.AccessBindingsOperationResult\x82\xd3\xe4\x93\x02::\x01*\"5/compute/v1/snapshots/{resource_id}:setAccessBindings\x12\x80\x02\n" +
	"\x14UpdateAccessBindings\x120.yandex.cloud.access.UpdateAccessBindingsRequest\x1a!.yandex.cloud.operation.Operation\"\x92\x01\xb2\xd2*K\n" +
	"#access.UpdateAccessBindingsMetadata\x12$access.AccessBindingsOperationResult\x82\xd3\xe4\x93\x02=:\x01*\"8/compute/v1/snapshots/{resource_id}:updateAccessBindingsBb\n" +
	"\x1byandex.cloud.api.compute.v1ZCgithub.com/yandex-cloud/go-genproto/yandex/cloud/compute/v1;computeb\x06proto3"

var (
	file_yandex_cloud_compute_v1_snapshot_service_proto_rawDescOnce sync.Once
	file_yandex_cloud_compute_v1_snapshot_service_proto_rawDescData []byte
)

func file_yandex_cloud_compute_v1_snapshot_service_proto_rawDescGZIP() []byte {
	file_yandex_cloud_compute_v1_snapshot_service_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_compute_v1_snapshot_service_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_compute_v1_snapshot_service_proto_rawDesc), len(file_yandex_cloud_compute_v1_snapshot_service_proto_rawDesc)))
	})
	return file_yandex_cloud_compute_v1_snapshot_service_proto_rawDescData
}

var file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_yandex_cloud_compute_v1_snapshot_service_proto_goTypes = []any{
	(*GetSnapshotRequest)(nil),                 // 0: yandex.cloud.compute.v1.GetSnapshotRequest
	(*ListSnapshotsRequest)(nil),               // 1: yandex.cloud.compute.v1.ListSnapshotsRequest
	(*ListSnapshotsResponse)(nil),              // 2: yandex.cloud.compute.v1.ListSnapshotsResponse
	(*CreateSnapshotRequest)(nil),              // 3: yandex.cloud.compute.v1.CreateSnapshotRequest
	(*CreateSnapshotMetadata)(nil),             // 4: yandex.cloud.compute.v1.CreateSnapshotMetadata
	(*UpdateSnapshotRequest)(nil),              // 5: yandex.cloud.compute.v1.UpdateSnapshotRequest
	(*UpdateSnapshotMetadata)(nil),             // 6: yandex.cloud.compute.v1.UpdateSnapshotMetadata
	(*DeleteSnapshotRequest)(nil),              // 7: yandex.cloud.compute.v1.DeleteSnapshotRequest
	(*DeleteSnapshotMetadata)(nil),             // 8: yandex.cloud.compute.v1.DeleteSnapshotMetadata
	(*ListSnapshotOperationsRequest)(nil),      // 9: yandex.cloud.compute.v1.ListSnapshotOperationsRequest
	(*ListSnapshotOperationsResponse)(nil),     // 10: yandex.cloud.compute.v1.ListSnapshotOperationsResponse
	nil,                                        // 11: yandex.cloud.compute.v1.CreateSnapshotRequest.LabelsEntry
	nil,                                        // 12: yandex.cloud.compute.v1.UpdateSnapshotRequest.LabelsEntry
	(*Snapshot)(nil),                           // 13: yandex.cloud.compute.v1.Snapshot
	(*HardwareGeneration)(nil),                 // 14: yandex.cloud.compute.v1.HardwareGeneration
	(*fieldmaskpb.FieldMask)(nil),              // 15: google.protobuf.FieldMask
	(*operation.Operation)(nil),                // 16: yandex.cloud.operation.Operation
	(*access.ListAccessBindingsRequest)(nil),   // 17: yandex.cloud.access.ListAccessBindingsRequest
	(*access.SetAccessBindingsRequest)(nil),    // 18: yandex.cloud.access.SetAccessBindingsRequest
	(*access.UpdateAccessBindingsRequest)(nil), // 19: yandex.cloud.access.UpdateAccessBindingsRequest
	(*access.ListAccessBindingsResponse)(nil),  // 20: yandex.cloud.access.ListAccessBindingsResponse
}
var file_yandex_cloud_compute_v1_snapshot_service_proto_depIdxs = []int32{
	13, // 0: yandex.cloud.compute.v1.ListSnapshotsResponse.snapshots:type_name -> yandex.cloud.compute.v1.Snapshot
	11, // 1: yandex.cloud.compute.v1.CreateSnapshotRequest.labels:type_name -> yandex.cloud.compute.v1.CreateSnapshotRequest.LabelsEntry
	14, // 2: yandex.cloud.compute.v1.CreateSnapshotRequest.hardware_generation:type_name -> yandex.cloud.compute.v1.HardwareGeneration
	15, // 3: yandex.cloud.compute.v1.UpdateSnapshotRequest.update_mask:type_name -> google.protobuf.FieldMask
	12, // 4: yandex.cloud.compute.v1.UpdateSnapshotRequest.labels:type_name -> yandex.cloud.compute.v1.UpdateSnapshotRequest.LabelsEntry
	16, // 5: yandex.cloud.compute.v1.ListSnapshotOperationsResponse.operations:type_name -> yandex.cloud.operation.Operation
	0,  // 6: yandex.cloud.compute.v1.SnapshotService.Get:input_type -> yandex.cloud.compute.v1.GetSnapshotRequest
	1,  // 7: yandex.cloud.compute.v1.SnapshotService.List:input_type -> yandex.cloud.compute.v1.ListSnapshotsRequest
	3,  // 8: yandex.cloud.compute.v1.SnapshotService.Create:input_type -> yandex.cloud.compute.v1.CreateSnapshotRequest
	5,  // 9: yandex.cloud.compute.v1.SnapshotService.Update:input_type -> yandex.cloud.compute.v1.UpdateSnapshotRequest
	7,  // 10: yandex.cloud.compute.v1.SnapshotService.Delete:input_type -> yandex.cloud.compute.v1.DeleteSnapshotRequest
	9,  // 11: yandex.cloud.compute.v1.SnapshotService.ListOperations:input_type -> yandex.cloud.compute.v1.ListSnapshotOperationsRequest
	17, // 12: yandex.cloud.compute.v1.SnapshotService.ListAccessBindings:input_type -> yandex.cloud.access.ListAccessBindingsRequest
	18, // 13: yandex.cloud.compute.v1.SnapshotService.SetAccessBindings:input_type -> yandex.cloud.access.SetAccessBindingsRequest
	19, // 14: yandex.cloud.compute.v1.SnapshotService.UpdateAccessBindings:input_type -> yandex.cloud.access.UpdateAccessBindingsRequest
	13, // 15: yandex.cloud.compute.v1.SnapshotService.Get:output_type -> yandex.cloud.compute.v1.Snapshot
	2,  // 16: yandex.cloud.compute.v1.SnapshotService.List:output_type -> yandex.cloud.compute.v1.ListSnapshotsResponse
	16, // 17: yandex.cloud.compute.v1.SnapshotService.Create:output_type -> yandex.cloud.operation.Operation
	16, // 18: yandex.cloud.compute.v1.SnapshotService.Update:output_type -> yandex.cloud.operation.Operation
	16, // 19: yandex.cloud.compute.v1.SnapshotService.Delete:output_type -> yandex.cloud.operation.Operation
	10, // 20: yandex.cloud.compute.v1.SnapshotService.ListOperations:output_type -> yandex.cloud.compute.v1.ListSnapshotOperationsResponse
	20, // 21: yandex.cloud.compute.v1.SnapshotService.ListAccessBindings:output_type -> yandex.cloud.access.ListAccessBindingsResponse
	16, // 22: yandex.cloud.compute.v1.SnapshotService.SetAccessBindings:output_type -> yandex.cloud.operation.Operation
	16, // 23: yandex.cloud.compute.v1.SnapshotService.UpdateAccessBindings:output_type -> yandex.cloud.operation.Operation
	15, // [15:24] is the sub-list for method output_type
	6,  // [6:15] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	6,  // [6:6] is the sub-list for extension extendee
	0,  // [0:6] is the sub-list for field type_name
}

func init() { file_yandex_cloud_compute_v1_snapshot_service_proto_init() }
func file_yandex_cloud_compute_v1_snapshot_service_proto_init() {
	if File_yandex_cloud_compute_v1_snapshot_service_proto != nil {
		return
	}
	file_yandex_cloud_compute_v1_hardware_generation_proto_init()
	file_yandex_cloud_compute_v1_snapshot_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_compute_v1_snapshot_service_proto_rawDesc), len(file_yandex_cloud_compute_v1_snapshot_service_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_yandex_cloud_compute_v1_snapshot_service_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_compute_v1_snapshot_service_proto_depIdxs,
		MessageInfos:      file_yandex_cloud_compute_v1_snapshot_service_proto_msgTypes,
	}.Build()
	File_yandex_cloud_compute_v1_snapshot_service_proto = out.File
	file_yandex_cloud_compute_v1_snapshot_service_proto_goTypes = nil
	file_yandex_cloud_compute_v1_snapshot_service_proto_depIdxs = nil
}
