// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package billing aliases all exported identifiers in package
// "cloud.google.com/go/billing/apiv1/billingpb".
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package billing

import (
	src "cloud.google.com/go/billing/apiv1/billingpb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/billing/apiv1/billingpb
const (
	AggregationInfo_ACCOUNT                          = src.AggregationInfo_ACCOUNT
	AggregationInfo_AGGREGATION_INTERVAL_UNSPECIFIED = src.AggregationInfo_AGGREGATION_INTERVAL_UNSPECIFIED
	AggregationInfo_AGGREGATION_LEVEL_UNSPECIFIED    = src.AggregationInfo_AGGREGATION_LEVEL_UNSPECIFIED
	AggregationInfo_DAILY                            = src.AggregationInfo_DAILY
	AggregationInfo_MONTHLY                          = src.AggregationInfo_MONTHLY
	AggregationInfo_PROJECT                          = src.AggregationInfo_PROJECT
)

// Deprecated: Please use vars in: cloud.google.com/go/billing/apiv1/billingpb
var (
	AggregationInfo_AggregationInterval_name         = src.AggregationInfo_AggregationInterval_name
	AggregationInfo_AggregationInterval_value        = src.AggregationInfo_AggregationInterval_value
	AggregationInfo_AggregationLevel_name            = src.AggregationInfo_AggregationLevel_name
	AggregationInfo_AggregationLevel_value           = src.AggregationInfo_AggregationLevel_value
	File_google_cloud_billing_v1_cloud_billing_proto = src.File_google_cloud_billing_v1_cloud_billing_proto
	File_google_cloud_billing_v1_cloud_catalog_proto = src.File_google_cloud_billing_v1_cloud_catalog_proto
)

// Represents the aggregation level and interval for pricing of a single SKU.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type AggregationInfo = src.AggregationInfo

// The interval at which usage is aggregated to compute cost. Example:
// "MONTHLY" aggregation interval indicates that usage for tiered pricing is
// aggregated every month.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type AggregationInfo_AggregationInterval = src.AggregationInfo_AggregationInterval

// The level at which usage is aggregated to compute cost. Example: "ACCOUNT"
// aggregation level indicates that usage for tiered pricing is aggregated
// across all projects in a single account.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type AggregationInfo_AggregationLevel = src.AggregationInfo_AggregationLevel

// A billing account in [GCP Console](https://console.cloud.google.com/). You
// can assign a billing account to one or more projects.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type BillingAccount = src.BillingAccount

// Represents the category hierarchy of a SKU.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type Category = src.Category

// CloudBillingClient is the client API for CloudBilling service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type CloudBillingClient = src.CloudBillingClient

// CloudBillingServer is the server API for CloudBilling service.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type CloudBillingServer = src.CloudBillingServer

// CloudCatalogClient is the client API for CloudCatalog service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type CloudCatalogClient = src.CloudCatalogClient

// CloudCatalogServer is the server API for CloudCatalog service.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type CloudCatalogServer = src.CloudCatalogServer

// Request message for `CreateBillingAccount`.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type CreateBillingAccountRequest = src.CreateBillingAccountRequest

// Request message for `GetBillingAccount`.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type GetBillingAccountRequest = src.GetBillingAccountRequest

// Request message for `GetProjectBillingInfo`.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type GetProjectBillingInfoRequest = src.GetProjectBillingInfoRequest

// Request message for `ListBillingAccounts`.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type ListBillingAccountsRequest = src.ListBillingAccountsRequest

// Response message for `ListBillingAccounts`.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type ListBillingAccountsResponse = src.ListBillingAccountsResponse

// Request message for `ListProjectBillingInfo`.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type ListProjectBillingInfoRequest = src.ListProjectBillingInfoRequest

// Request message for `ListProjectBillingInfoResponse`.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type ListProjectBillingInfoResponse = src.ListProjectBillingInfoResponse

// Request message for `ListServices`.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type ListServicesRequest = src.ListServicesRequest

// Response message for `ListServices`.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type ListServicesResponse = src.ListServicesResponse

// Request message for `ListSkus`.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type ListSkusRequest = src.ListSkusRequest

// Response message for `ListSkus`.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type ListSkusResponse = src.ListSkusResponse

// Expresses a mathematical pricing formula. For Example:- `usage_unit: GBy`
// `tiered_rates:` `[start_usage_amount: 20, unit_price: $10]`
// `[start_usage_amount: 100, unit_price: $5]` The above expresses a pricing
// formula where the first 20GB is free, the next 80GB is priced at $10 per GB
// followed by $5 per GB for additional usage.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type PricingExpression = src.PricingExpression

// The price rate indicating starting usage and its corresponding price.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type PricingExpression_TierRate = src.PricingExpression_TierRate

// Represents the pricing information for a SKU at a single point of time.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type PricingInfo = src.PricingInfo

// Encapsulation of billing information for a GCP Console project. A project
// has at most one associated billing account at a time (but a billing account
// can be assigned to multiple projects).
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type ProjectBillingInfo = src.ProjectBillingInfo

// Encapsulates a single service in Google Cloud Platform.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type Service = src.Service

// Encapsulates a single SKU in Google Cloud Platform
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type Sku = src.Sku

// UnimplementedCloudBillingServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type UnimplementedCloudBillingServer = src.UnimplementedCloudBillingServer

// UnimplementedCloudCatalogServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type UnimplementedCloudCatalogServer = src.UnimplementedCloudCatalogServer

// Request message for `UpdateBillingAccount`.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type UpdateBillingAccountRequest = src.UpdateBillingAccountRequest

// Request message for `UpdateProjectBillingInfo`.
//
// Deprecated: Please use types in: cloud.google.com/go/billing/apiv1/billingpb
type UpdateProjectBillingInfoRequest = src.UpdateProjectBillingInfoRequest

// Deprecated: Please use funcs in: cloud.google.com/go/billing/apiv1/billingpb
func NewCloudBillingClient(cc grpc.ClientConnInterface) CloudBillingClient {
	return src.NewCloudBillingClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/billing/apiv1/billingpb
func NewCloudCatalogClient(cc grpc.ClientConnInterface) CloudCatalogClient {
	return src.NewCloudCatalogClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/billing/apiv1/billingpb
func RegisterCloudBillingServer(s *grpc.Server, srv CloudBillingServer) {
	src.RegisterCloudBillingServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/billing/apiv1/billingpb
func RegisterCloudCatalogServer(s *grpc.Server, srv CloudCatalogServer) {
	src.RegisterCloudCatalogServer(s, srv)
}
