#!/usr/bin/env bash

# Copyright 2021 The cert-manager Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

set -eu -o pipefail

# This script fetches the latest sha256 digest of each base image for each architecture we support on servers
# and writes those hashes to Makefile-formatted variables for use in Makefiles.

# This in turn allows us to easily update all base images to their latest versions, while mantaining the use
# of digests rather than tags when we refer to these base images.

CRANE=crane

TARGET=make/base_images.mk

STATIC_BASE=gcr.io/distroless/static-debian12
DYNAMIC_BASE=gcr.io/distroless/base-debian12

mkdir -p make

echo "# +skip_license_check" > $TARGET
echo "# autogenerated by hack/latest-base-images.sh" >> $TARGET

echo "STATIC_BASE_IMAGE_amd64 := $STATIC_BASE@$(crane digest $STATIC_BASE:latest-amd64)" >> $TARGET
echo "STATIC_BASE_IMAGE_arm64 := $STATIC_BASE@$(crane digest $STATIC_BASE:latest-arm64)" >> $TARGET
echo "STATIC_BASE_IMAGE_s390x := $STATIC_BASE@$(crane digest $STATIC_BASE:latest-s390x)" >> $TARGET
echo "STATIC_BASE_IMAGE_arm   := $STATIC_BASE@$(crane digest $STATIC_BASE:latest-arm)" >> $TARGET
echo "STATIC_BASE_IMAGE_ppc64le := $STATIC_BASE@$(crane digest $STATIC_BASE:latest-ppc64le)" >> $TARGET

echo "DYNAMIC_BASE_IMAGE_amd64 := $DYNAMIC_BASE@$(crane digest $DYNAMIC_BASE:latest-amd64)" >> $TARGET
echo "DYNAMIC_BASE_IMAGE_arm64 := $DYNAMIC_BASE@$(crane digest $DYNAMIC_BASE:latest-arm64)" >> $TARGET
echo "DYNAMIC_BASE_IMAGE_s390x := $DYNAMIC_BASE@$(crane digest $DYNAMIC_BASE:latest-s390x)" >> $TARGET
echo "DYNAMIC_BASE_IMAGE_arm   := $DYNAMIC_BASE@$(crane digest $DYNAMIC_BASE:latest-arm)" >> $TARGET
echo "DYNAMIC_BASE_IMAGE_ppc64le := $DYNAMIC_BASE@$(crane digest $DYNAMIC_BASE:latest-ppc64le)" >> $TARGET
