// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
)

func TestCopyOrigExemplarSlice(t *testing.T) {
	src := []otlpmetrics.Exemplar{}
	dest := []otlpmetrics.Exemplar{}
	// Test CopyTo empty
	dest = CopyOrigExemplarSlice(dest, src)
	assert.Equal(t, []otlpmetrics.Exemplar{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestExemplarSlice()
	dest = CopyOrigExemplarSlice(dest, src)
	assert.Equal(t, GenerateOrigTestExemplarSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigExemplarSlice(dest, src)
	assert.Equal(t, GenerateOrigTestExemplarSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigExemplarSlice(dest, []otlpmetrics.Exemplar{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigExemplarSlice(dest, src)
	assert.Equal(t, GenerateOrigTestExemplarSlice(), dest)
}
