// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectormetrics "go.opentelemetry.io/proto/slim/otlp/collector/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpcollectormetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportMetricsServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigExportMetricsServiceResponse()
				CopyOrigExportMetricsServiceResponse(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigExportMetricsServiceResponse(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigExportMetricsServiceResponseUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigExportMetricsServiceResponse()
	UnmarshalJSONOrigExportMetricsServiceResponse(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigExportMetricsServiceResponse(), dest)
}

func TestMarshalAndUnmarshalJSONOrigExportMetricsServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigExportMetricsServiceResponse(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigExportMetricsServiceResponse()
				UnmarshalJSONOrigExportMetricsServiceResponse(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigExportMetricsServiceResponse(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigExportMetricsServiceResponseFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportMetricsServiceResponse() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigExportMetricsServiceResponse()
			require.Error(t, UnmarshalProtoOrigExportMetricsServiceResponse(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportMetricsServiceResponseUnknown(t *testing.T) {
	dest := NewOrigExportMetricsServiceResponse()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigExportMetricsServiceResponse(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigExportMetricsServiceResponse(), dest)
}

func TestMarshalAndUnmarshalProtoOrigExportMetricsServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigExportMetricsServiceResponse(src))
				gotSize := MarshalProtoOrigExportMetricsServiceResponse(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigExportMetricsServiceResponse()
				require.NoError(t, UnmarshalProtoOrigExportMetricsServiceResponse(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigExportMetricsServiceResponse(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportMetricsServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsServiceResponse() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportMetricsServiceResponse(src))
			gotSize := MarshalProtoOrigExportMetricsServiceResponse(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectormetrics.ExportMetricsServiceResponse{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigExportMetricsServiceResponse()
			require.NoError(t, UnmarshalProtoOrigExportMetricsServiceResponse(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportMetricsServiceResponse() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                  {0x02},
		"PartialSuccess/wrong_wire_type": {0xc},
		"PartialSuccess/missing_value":   {0xa},
	}
}

func genTestEncodingValuesExportMetricsServiceResponse() map[string]*otlpcollectormetrics.ExportMetricsServiceResponse {
	return map[string]*otlpcollectormetrics.ExportMetricsServiceResponse{
		"empty":               NewOrigExportMetricsServiceResponse(),
		"PartialSuccess/test": {PartialSuccess: *GenTestOrigExportMetricsPartialSuccess()},
	}
}
