// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
)

func TestCopyOrigHistogramDataPointSlice(t *testing.T) {
	src := []*otlpmetrics.HistogramDataPoint{}
	dest := []*otlpmetrics.HistogramDataPoint{}
	// Test CopyTo empty
	dest = CopyOrigHistogramDataPointSlice(dest, src)
	assert.Equal(t, []*otlpmetrics.HistogramDataPoint{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestHistogramDataPointSlice()
	dest = CopyOrigHistogramDataPointSlice(dest, src)
	assert.Equal(t, GenerateOrigTestHistogramDataPointSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigHistogramDataPointSlice(dest, src)
	assert.Equal(t, GenerateOrigTestHistogramDataPointSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigHistogramDataPointSlice(dest, []*otlpmetrics.HistogramDataPoint{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigHistogramDataPointSlice(dest, src)
	assert.Equal(t, GenerateOrigTestHistogramDataPointSlice(), dest)
}
