// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func TestCopyOrigLineSlice(t *testing.T) {
	src := []*otlpprofiles.Line{}
	dest := []*otlpprofiles.Line{}
	// Test CopyTo empty
	dest = CopyOrigLineSlice(dest, src)
	assert.Equal(t, []*otlpprofiles.Line{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestLineSlice()
	dest = CopyOrigLineSlice(dest, src)
	assert.Equal(t, GenerateOrigTestLineSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigLineSlice(dest, src)
	assert.Equal(t, GenerateOrigTestLineSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigLineSlice(dest, []*otlpprofiles.Line{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigLineSlice(dest, src)
	assert.Equal(t, GenerateOrigTestLineSlice(), dest)
}
