// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func TestCopyOrigResourceProfilesSlice(t *testing.T) {
	src := []*otlpprofiles.ResourceProfiles{}
	dest := []*otlpprofiles.ResourceProfiles{}
	// Test CopyTo empty
	dest = CopyOrigResourceProfilesSlice(dest, src)
	assert.Equal(t, []*otlpprofiles.ResourceProfiles{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestResourceProfilesSlice()
	dest = CopyOrigResourceProfilesSlice(dest, src)
	assert.Equal(t, GenerateOrigTestResourceProfilesSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigResourceProfilesSlice(dest, src)
	assert.Equal(t, GenerateOrigTestResourceProfilesSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigResourceProfilesSlice(dest, []*otlpprofiles.ResourceProfiles{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigResourceProfilesSlice(dest, src)
	assert.Equal(t, GenerateOrigTestResourceProfilesSlice(), dest)
}
