// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
)

func CopyOrigSpan_EventSlice(dest, src []*otlptrace.Span_Event) []*otlptrace.Span_Event {
	var newDest []*otlptrace.Span_Event
	if cap(dest) < len(src) {
		newDest = make([]*otlptrace.Span_Event, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigSpan_Event()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigSpan_Event(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigSpan_Event()
		}
	}
	for i := range src {
		CopyOrigSpan_Event(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestSpan_EventSlice() []*otlptrace.Span_Event {
	orig := make([]*otlptrace.Span_Event, 5)
	orig[0] = NewOrigSpan_Event()
	orig[1] = GenTestOrigSpan_Event()
	orig[2] = NewOrigSpan_Event()
	orig[3] = GenTestOrigSpan_Event()
	orig[4] = NewOrigSpan_Event()
	return orig
}
