// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package ptrace

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
)

func TestStatus_MoveTo(t *testing.T) {
	ms := generateTestStatus()
	dest := NewStatus()
	ms.MoveTo(dest)
	assert.Equal(t, NewStatus(), ms)
	assert.Equal(t, generateTestStatus(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestStatus(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newStatus(internal.NewOrigStatus(), sharedState)) })
	assert.Panics(t, func() { newStatus(internal.NewOrigStatus(), sharedState).MoveTo(dest) })
}

func TestStatus_CopyTo(t *testing.T) {
	ms := NewStatus()
	orig := NewStatus()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestStatus()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newStatus(internal.NewOrigStatus(), sharedState)) })
}

func TestStatus_Message(t *testing.T) {
	ms := NewStatus()
	assert.Empty(t, ms.Message())
	ms.SetMessage("test_message")
	assert.Equal(t, "test_message", ms.Message())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newStatus(&otlptrace.Status{}, sharedState).SetMessage("test_message") })
}

func TestStatus_Code(t *testing.T) {
	ms := NewStatus()
	assert.Equal(t, StatusCode(otlptrace.Status_StatusCode(0)), ms.Code())
	testValCode := StatusCode(otlptrace.Status_StatusCode(1))
	ms.SetCode(testValCode)
	assert.Equal(t, testValCode, ms.Code())
}

func generateTestStatus() Status {
	ms := newStatus(internal.GenTestOrigStatus(), internal.NewState())
	return ms
}
