// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package ptrace

import (
	"go.opentelemetry.io/collector/pdata/internal"
	otlpcollectortrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/trace/v1"
)

// Traces is the top-level struct that is propagated through the traces pipeline.
// Use NewTraces to create new instance, zero-initialized instance is not valid for use.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewTraces function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Traces internal.Traces

func newTraces(orig *otlpcollectortrace.ExportTraceServiceRequest, state *internal.State) Traces {
	return Traces(internal.NewTraces(orig, state))
}

// NewTraces creates a new empty Traces.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewTraces() Traces {
	return newTraces(internal.NewOrigExportTraceServiceRequest(), internal.NewState())
}

// MoveTo moves all properties from the current struct overriding the destination and
// resetting the current instance to its zero value
func (ms Traces) MoveTo(dest Traces) {
	ms.getState().AssertMutable()
	dest.getState().AssertMutable()
	// If they point to the same data, they are the same, nothing to do.
	if ms.getOrig() == dest.getOrig() {
		return
	}
	internal.DeleteOrigExportTraceServiceRequest(dest.getOrig(), false)
	*dest.getOrig(), *ms.getOrig() = *ms.getOrig(), *dest.getOrig()
}

// ResourceSpans returns the ResourceSpans associated with this Traces.
func (ms Traces) ResourceSpans() ResourceSpansSlice {
	return newResourceSpansSlice(&ms.getOrig().ResourceSpans, ms.getState())
}

// CopyTo copies all properties from the current struct overriding the destination.
func (ms Traces) CopyTo(dest Traces) {
	dest.getState().AssertMutable()
	internal.CopyOrigExportTraceServiceRequest(dest.getOrig(), ms.getOrig())
}

func (ms Traces) getOrig() *otlpcollectortrace.ExportTraceServiceRequest {
	return internal.GetOrigTraces(internal.Traces(ms))
}

func (ms Traces) getState() *internal.State {
	return internal.GetTracesState(internal.Traces(ms))
}
