// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Application Dependency Management API
//
// Use the Application Dependency Management API to create knowledge bases and vulnerability audits.  For more information, see ADM (https://docs.oracle.com/iaas/Content/application-dependency-management/home.htm).
//

package adm

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// ApplicationDependencyVulnerabilitySummary An application dependency Vulnerability represents a single dependency in the application.
// An application dependency Vulnerability can be associated with eventual Vulnerabilities.
// Each application dependency is uniquely defined by a nodeId and lists eventual dependencies on which it depends.
type ApplicationDependencyVulnerabilitySummary struct {

	// Group Artifact Version (GAV) identifier (Group:Artifact:Version). Example: org.graalvm.nativeimage:svm:21.1.0.
	// "N/A" for non-maven artifacts.
	Gav *string `mandatory:"true" json:"gav"`

	// Unique identifier of an application dependency, for example nodeId1.
	NodeId *string `mandatory:"true" json:"nodeId"`

	// List of application dependencies on which this application dependency depends, each identified by its nodeId.
	ApplicationDependencyNodeIds []string `mandatory:"true" json:"applicationDependencyNodeIds"`

	// List of vulnerabilities for the application dependency.
	Vulnerabilities []Vulnerability `mandatory:"true" json:"vulnerabilities"`

	// Indicates if the artifact is found in the knowledge base, this field is deprecated and will be removed in the future.
	IsFoundInKnowledgeBase *bool `mandatory:"true" json:"isFoundInKnowledgeBase"`

	// Package URL identifier, e.g. pkg:maven/org.graalvm.nativeimage/svm@21.1.0
	Purl *string `mandatory:"false" json:"purl"`

	// Potential issues in the artifact identifiers (purls) provided by the user, that the user is alerted about. ADM supports the following warnings:
	// - MISSING_VERSION: Missing version
	// - INCORRECT_FORMAT_VERSION: Version can not be parsed according to the ecosystem
	// - UNKNOWN_ECOSYSTEM: The purl's ecosystem is unknown to ADM
	// - INCORRECT_FORMAT_EPOCH: Epoch qualifier can not be parsed according to the ecosystem
	// - MISSING_DISTRO: The distro qualifier is required for the ecosystem, but was not provided in the purl
	// - UNKNOWN_DISTRO: ADM does not have data for the provided distro value for the given ecosystem
	// - MISSING_ARCH: The arch qualifier is required for the ecosystem and distro, but was not provided in the purl
	// - UNKNOWN_ARCH: ADM does not have data for the provided arch value for the given ecosystem and distro
	// - EPOCH_VALUE_MISMATCH: Epoch value in qualifier is not the same as the epoch value in version
	// - INVALID_PURL: The provided PURL could not be parsed
	Warnings []string `mandatory:"false" json:"warnings"`
}

func (m ApplicationDependencyVulnerabilitySummary) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m ApplicationDependencyVulnerabilitySummary) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
