// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Cloud Guard and Security Zones API
//
// Use the Cloud Guard and Security Zones API to automate processes that you would otherwise perform through the Cloud Guard Console or the Security Zones Console. For more information on these services, see the Cloud Guard (https://docs.oracle.com/iaas/cloud-guard/home.htm) and Security Zones (https://docs.oracle.com/iaas/security-zone/home.htm) documentation.
// **Note:** For Cloud Guard, you can perform Create, Update, and Delete operations only from the reporting region of your Cloud Guard tenancy. You can perform Read operations from any region.
//

package cloudguard

import (
	"strings"
)

// DataMaskRuleStatusEnum Enum with underlying type: string
type DataMaskRuleStatusEnum string

// Set of constants representing the allowable values for DataMaskRuleStatusEnum
const (
	DataMaskRuleStatusEnabled  DataMaskRuleStatusEnum = "ENABLED"
	DataMaskRuleStatusDisabled DataMaskRuleStatusEnum = "DISABLED"
)

var mappingDataMaskRuleStatusEnum = map[string]DataMaskRuleStatusEnum{
	"ENABLED":  DataMaskRuleStatusEnabled,
	"DISABLED": DataMaskRuleStatusDisabled,
}

var mappingDataMaskRuleStatusEnumLowerCase = map[string]DataMaskRuleStatusEnum{
	"enabled":  DataMaskRuleStatusEnabled,
	"disabled": DataMaskRuleStatusDisabled,
}

// GetDataMaskRuleStatusEnumValues Enumerates the set of values for DataMaskRuleStatusEnum
func GetDataMaskRuleStatusEnumValues() []DataMaskRuleStatusEnum {
	values := make([]DataMaskRuleStatusEnum, 0)
	for _, v := range mappingDataMaskRuleStatusEnum {
		values = append(values, v)
	}
	return values
}

// GetDataMaskRuleStatusEnumStringValues Enumerates the set of values in String for DataMaskRuleStatusEnum
func GetDataMaskRuleStatusEnumStringValues() []string {
	return []string{
		"ENABLED",
		"DISABLED",
	}
}

// GetMappingDataMaskRuleStatusEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingDataMaskRuleStatusEnum(val string) (DataMaskRuleStatusEnum, bool) {
	enum, ok := mappingDataMaskRuleStatusEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
