// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package objectstorage

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// CreateMultipartUploadRequest wrapper for the CreateMultipartUpload operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/objectstorage/CreateMultipartUpload.go.html to see an example of how to use CreateMultipartUploadRequest.
type CreateMultipartUploadRequest struct {

	// The Object Storage namespace used for the request.
	NamespaceName *string `mandatory:"true" contributesTo:"path" name:"namespaceName"`

	// The name of the bucket. Avoid entering confidential information.
	// Example: `my-new-bucket1`
	BucketName *string `mandatory:"true" contributesTo:"path" name:"bucketName"`

	// Request object for creating a multipart upload.
	CreateMultipartUploadDetails `contributesTo:"body"`

	// The entity tag (ETag) to match with the ETag of an existing resource. If the specified ETag matches the ETag of
	// the existing resource, GET and HEAD requests will return the resource and PUT and POST requests will upload
	// the resource.
	IfMatch *string `mandatory:"false" contributesTo:"header" name:"if-match"`

	// The entity tag (ETag) to avoid matching. The only valid value is '*', which indicates that the request should
	// fail if the resource already exists.
	IfNoneMatch *string `mandatory:"false" contributesTo:"header" name:"if-none-match"`

	// The client request ID for tracing.
	OpcClientRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-client-request-id"`

	// The optional header that specifies "AES256" as the encryption algorithm. For more information, see
	// Using Your Own Keys for Server-Side Encryption (https://docs.oracle.com/iaas/Content/Object/Tasks/usingyourencryptionkeys.htm).
	OpcSseCustomerAlgorithm *string `mandatory:"false" contributesTo:"header" name:"opc-sse-customer-algorithm"`

	// The optional header that specifies the base64-encoded 256-bit encryption key to use to encrypt or
	// decrypt the data. For more information, see
	// Using Your Own Keys for Server-Side Encryption (https://docs.oracle.com/iaas/Content/Object/Tasks/usingyourencryptionkeys.htm).
	OpcSseCustomerKey *string `mandatory:"false" contributesTo:"header" name:"opc-sse-customer-key"`

	// The optional header that specifies the base64-encoded SHA256 hash of the encryption key. This
	// value is used to check the integrity of the encryption key. For more information, see
	// Using Your Own Keys for Server-Side Encryption (https://docs.oracle.com/iaas/Content/Object/Tasks/usingyourencryptionkeys.htm).
	OpcSseCustomerKeySha256 *string `mandatory:"false" contributesTo:"header" name:"opc-sse-customer-key-sha256"`

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a master encryption key used to call the Key
	// Management service to generate a data encryption key or to encrypt or decrypt a data encryption key.
	OpcSseKmsKeyId *string `mandatory:"false" contributesTo:"header" name:"opc-sse-kms-key-id"`

	// The optional checksum algorithm to use to compute and store the checksum of the body of the HTTP request (or the parts in case of multipart uploads),
	// in addition to the default MD5 checksum.
	OpcChecksumAlgorithm CreateMultipartUploadOpcChecksumAlgorithmEnum `mandatory:"false" contributesTo:"header" name:"opc-checksum-algorithm"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request CreateMultipartUploadRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request CreateMultipartUploadRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request CreateMultipartUploadRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// ReplaceMandatoryParamInPath replaces the mandatory parameter in the path with the value provided.
// Not all services are supporting this feature and this method will be a no-op for those services.
func (request CreateMultipartUploadRequest) ReplaceMandatoryParamInPath(client *common.BaseClient, mandatoryParamMap map[string][]common.TemplateParamForPerRealmEndpoint) {
	if mandatoryParamMap["namespaceName"] != nil {
		templateParam := mandatoryParamMap["namespaceName"]
		for _, template := range templateParam {
			replacementParam := *request.NamespaceName
			if template.EndsWithDot {
				replacementParam = replacementParam + "."
			}
			client.Host = strings.Replace(client.Host, template.Template, replacementParam, -1)
		}
	}
	if mandatoryParamMap["bucketName"] != nil {
		templateParam := mandatoryParamMap["bucketName"]
		for _, template := range templateParam {
			replacementParam := *request.BucketName
			if template.EndsWithDot {
				replacementParam = replacementParam + "."
			}
			client.Host = strings.Replace(client.Host, template.Template, replacementParam, -1)
		}
	}
}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request CreateMultipartUploadRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request CreateMultipartUploadRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingCreateMultipartUploadOpcChecksumAlgorithmEnum(string(request.OpcChecksumAlgorithm)); !ok && request.OpcChecksumAlgorithm != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for OpcChecksumAlgorithm: %s. Supported values are: %s.", request.OpcChecksumAlgorithm, strings.Join(GetCreateMultipartUploadOpcChecksumAlgorithmEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// CreateMultipartUploadResponse wrapper for the CreateMultipartUpload operation
type CreateMultipartUploadResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// The MultipartUpload instance
	MultipartUpload `presentIn:"body"`

	// Echoes back the value passed in the opc-client-request-id header, for use by clients when debugging.
	OpcClientRequestId *string `presentIn:"header" name:"opc-client-request-id"`

	// Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a particular
	// request, provide this request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// The full path to the new upload.
	Location *string `presentIn:"header" name:"location"`
}

func (response CreateMultipartUploadResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response CreateMultipartUploadResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// CreateMultipartUploadOpcChecksumAlgorithmEnum Enum with underlying type: string
type CreateMultipartUploadOpcChecksumAlgorithmEnum string

// Set of constants representing the allowable values for CreateMultipartUploadOpcChecksumAlgorithmEnum
const (
	CreateMultipartUploadOpcChecksumAlgorithmCrc32c CreateMultipartUploadOpcChecksumAlgorithmEnum = "CRC32C"
	CreateMultipartUploadOpcChecksumAlgorithmSha256 CreateMultipartUploadOpcChecksumAlgorithmEnum = "SHA256"
	CreateMultipartUploadOpcChecksumAlgorithmSha384 CreateMultipartUploadOpcChecksumAlgorithmEnum = "SHA384"
)

var mappingCreateMultipartUploadOpcChecksumAlgorithmEnum = map[string]CreateMultipartUploadOpcChecksumAlgorithmEnum{
	"CRC32C": CreateMultipartUploadOpcChecksumAlgorithmCrc32c,
	"SHA256": CreateMultipartUploadOpcChecksumAlgorithmSha256,
	"SHA384": CreateMultipartUploadOpcChecksumAlgorithmSha384,
}

var mappingCreateMultipartUploadOpcChecksumAlgorithmEnumLowerCase = map[string]CreateMultipartUploadOpcChecksumAlgorithmEnum{
	"crc32c": CreateMultipartUploadOpcChecksumAlgorithmCrc32c,
	"sha256": CreateMultipartUploadOpcChecksumAlgorithmSha256,
	"sha384": CreateMultipartUploadOpcChecksumAlgorithmSha384,
}

// GetCreateMultipartUploadOpcChecksumAlgorithmEnumValues Enumerates the set of values for CreateMultipartUploadOpcChecksumAlgorithmEnum
func GetCreateMultipartUploadOpcChecksumAlgorithmEnumValues() []CreateMultipartUploadOpcChecksumAlgorithmEnum {
	values := make([]CreateMultipartUploadOpcChecksumAlgorithmEnum, 0)
	for _, v := range mappingCreateMultipartUploadOpcChecksumAlgorithmEnum {
		values = append(values, v)
	}
	return values
}

// GetCreateMultipartUploadOpcChecksumAlgorithmEnumStringValues Enumerates the set of values in String for CreateMultipartUploadOpcChecksumAlgorithmEnum
func GetCreateMultipartUploadOpcChecksumAlgorithmEnumStringValues() []string {
	return []string{
		"CRC32C",
		"SHA256",
		"SHA384",
	}
}

// GetMappingCreateMultipartUploadOpcChecksumAlgorithmEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingCreateMultipartUploadOpcChecksumAlgorithmEnum(val string) (CreateMultipartUploadOpcChecksumAlgorithmEnum, bool) {
	enum, ok := mappingCreateMultipartUploadOpcChecksumAlgorithmEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
