// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// HostEndpointProtectionScanResultEndpointProtection An endpoint protection found in a host scan
type HostEndpointProtectionScanResultEndpointProtection struct {

	// Name of endpoint protection service
	Service *string `mandatory:"true" json:"service"`

	// Configuration information for endpoint protection service at the time of scan
	ConfigurationFinding *string `mandatory:"true" json:"configurationFinding"`

	// Date and time endpoint protection signature was updated, as described in RFC 3339 (https://tools.ietf.org/rfc/rfc3339)
	TimeSignatureUpdated *common.SDKTime `mandatory:"true" json:"timeSignatureUpdated"`

	// Problem severity
	Severity ScanResultProblemSeverityEnum `mandatory:"true" json:"severity"`
}

func (m HostEndpointProtectionScanResultEndpointProtection) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m HostEndpointProtectionScanResultEndpointProtection) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingScanResultProblemSeverityEnum(string(m.Severity)); !ok && m.Severity != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for Severity: %s. Supported values are: %s.", m.Severity, strings.Join(GetScanResultProblemSeverityEnumStringValues(), ",")))
	}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
