// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"strings"
)

// ImpactedHostSortByEnum Enum with underlying type: string
type ImpactedHostSortByEnum string

// Set of constants representing the allowable values for ImpactedHostSortByEnum
const (
	ImpactedHostSortByInstanceId ImpactedHostSortByEnum = "instanceId"
)

var mappingImpactedHostSortByEnum = map[string]ImpactedHostSortByEnum{
	"instanceId": ImpactedHostSortByInstanceId,
}

var mappingImpactedHostSortByEnumLowerCase = map[string]ImpactedHostSortByEnum{
	"instanceid": ImpactedHostSortByInstanceId,
}

// GetImpactedHostSortByEnumValues Enumerates the set of values for ImpactedHostSortByEnum
func GetImpactedHostSortByEnumValues() []ImpactedHostSortByEnum {
	values := make([]ImpactedHostSortByEnum, 0)
	for _, v := range mappingImpactedHostSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetImpactedHostSortByEnumStringValues Enumerates the set of values in String for ImpactedHostSortByEnum
func GetImpactedHostSortByEnumStringValues() []string {
	return []string{
		"instanceId",
	}
}

// GetMappingImpactedHostSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingImpactedHostSortByEnum(val string) (ImpactedHostSortByEnum, bool) {
	enum, ok := mappingImpactedHostSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
