// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"strings"
)

// VulnerabilityTypeEnum Enum with underlying type: string
type VulnerabilityTypeEnum string

// Set of constants representing the allowable values for VulnerabilityTypeEnum
const (
	VulnerabilityTypeCve     VulnerabilityTypeEnum = "CVE"
	VulnerabilityTypeProblem VulnerabilityTypeEnum = "PROBLEM"
)

var mappingVulnerabilityTypeEnum = map[string]VulnerabilityTypeEnum{
	"CVE":     VulnerabilityTypeCve,
	"PROBLEM": VulnerabilityTypeProblem,
}

var mappingVulnerabilityTypeEnumLowerCase = map[string]VulnerabilityTypeEnum{
	"cve":     VulnerabilityTypeCve,
	"problem": VulnerabilityTypeProblem,
}

// GetVulnerabilityTypeEnumValues Enumerates the set of values for VulnerabilityTypeEnum
func GetVulnerabilityTypeEnumValues() []VulnerabilityTypeEnum {
	values := make([]VulnerabilityTypeEnum, 0)
	for _, v := range mappingVulnerabilityTypeEnum {
		values = append(values, v)
	}
	return values
}

// GetVulnerabilityTypeEnumStringValues Enumerates the set of values in String for VulnerabilityTypeEnum
func GetVulnerabilityTypeEnumStringValues() []string {
	return []string{
		"CVE",
		"PROBLEM",
	}
}

// GetMappingVulnerabilityTypeEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingVulnerabilityTypeEnum(val string) (VulnerabilityTypeEnum, bool) {
	enum, ok := mappingVulnerabilityTypeEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
