// Copyright 2023 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package connectors provides access to the Connectors API.
//
// For product documentation, see: https://cloud.google.com/apigee/docs/api-platform/connectors/about-connectors
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/connectors/v2"
//	...
//	ctx := context.Background()
//	connectorsService, err := connectors.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	connectorsService, err := connectors.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	connectorsService, err := connectors.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package connectors // import "google.golang.org/api/connectors/v2"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "connectors:v2"
const apiName = "connectors"
const apiVersion = "v2"
const basePath = "https://connectors.googleapis.com/"
const mtlsBasePath = "https://connectors.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Connections = NewProjectsLocationsConnectionsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Connections *ProjectsLocationsConnectionsService
}

func NewProjectsLocationsConnectionsService(s *Service) *ProjectsLocationsConnectionsService {
	rs := &ProjectsLocationsConnectionsService{s: s}
	rs.Actions = NewProjectsLocationsConnectionsActionsService(s)
	rs.EntityTypes = NewProjectsLocationsConnectionsEntityTypesService(s)
	return rs
}

type ProjectsLocationsConnectionsService struct {
	s *Service

	Actions *ProjectsLocationsConnectionsActionsService

	EntityTypes *ProjectsLocationsConnectionsEntityTypesService
}

func NewProjectsLocationsConnectionsActionsService(s *Service) *ProjectsLocationsConnectionsActionsService {
	rs := &ProjectsLocationsConnectionsActionsService{s: s}
	return rs
}

type ProjectsLocationsConnectionsActionsService struct {
	s *Service
}

func NewProjectsLocationsConnectionsEntityTypesService(s *Service) *ProjectsLocationsConnectionsEntityTypesService {
	rs := &ProjectsLocationsConnectionsEntityTypesService{s: s}
	rs.Entities = NewProjectsLocationsConnectionsEntityTypesEntitiesService(s)
	return rs
}

type ProjectsLocationsConnectionsEntityTypesService struct {
	s *Service

	Entities *ProjectsLocationsConnectionsEntityTypesEntitiesService
}

func NewProjectsLocationsConnectionsEntityTypesEntitiesService(s *Service) *ProjectsLocationsConnectionsEntityTypesEntitiesService {
	rs := &ProjectsLocationsConnectionsEntityTypesEntitiesService{s: s}
	return rs
}

type ProjectsLocationsConnectionsEntityTypesEntitiesService struct {
	s *Service
}

// Action: Action message contains metadata information about a single
// action present in the external system.
type Action struct {
	// Description: Brief Description of action
	Description string `json:"description,omitempty"`

	// DisplayName: Display Name of action to be shown on client side
	DisplayName string `json:"displayName,omitempty"`

	// InputJsonSchema: JsonSchema representation of this actions's input
	// schema
	InputJsonSchema *JsonSchema `json:"inputJsonSchema,omitempty"`

	// InputParameters: List containing input parameter metadata.
	InputParameters []*InputParameter `json:"inputParameters,omitempty"`

	// Name: Name of the action.
	Name string `json:"name,omitempty"`

	// ResultJsonSchema: JsonSchema representation of this actions's result
	// schema
	ResultJsonSchema *JsonSchema `json:"resultJsonSchema,omitempty"`

	// ResultMetadata: List containing the metadata of result fields.
	ResultMetadata []*ResultMetadata `json:"resultMetadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Action) MarshalJSON() ([]byte, error) {
	type NoMethod Action
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For
// instance: service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// Entity: 'Entity row'/ 'Entity' refers to a single row of an entity
// type.
type Entity struct {
	// Fields: Fields of the entity. The key is name of the field and the
	// value contains the applicable `google.protobuf.Value` entry for this
	// field.
	Fields googleapi.RawMessage `json:"fields,omitempty"`

	// Name: Output only. Resource name of the Entity. Format:
	// projects/{project}/locations/{location}/connections/{connection}/entit
	// yTypes/{type}/entities/{id}
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Fields") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Fields") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Entity) MarshalJSON() ([]byte, error) {
	type NoMethod Entity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EntityType: EntityType message contains metadata information about a
// single entity type present in the external system.
type EntityType struct {
	// Fields: List containing metadata information about each field of the
	// entity type.
	Fields []*Field `json:"fields,omitempty"`

	// JsonSchema: JsonSchema representation of this entity's schema
	JsonSchema *JsonSchema `json:"jsonSchema,omitempty"`

	// Name: The name of the entity type.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Fields") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Fields") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EntityType) MarshalJSON() ([]byte, error) {
	type NoMethod EntityType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExecuteActionRequest: Request message for ActionService.ExecuteAction
type ExecuteActionRequest struct {
	// Parameters: Parameters for executing the action. The parameters can
	// be key/value pairs or nested structs.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Parameters") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExecuteActionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExecuteActionRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExecuteActionResponse: Response message for
// ActionService.ExecuteAction
type ExecuteActionResponse struct {
	// Results: In the case of successful invocation of the specified
	// action, the results Struct contains values based on the response of
	// the action invoked. 1. If the action execution produces any entities
	// as a result, they are returned as an array of Structs with the 'key'
	// being the field name and the 'value' being the value of that field in
	// each result row. { 'results': [{'key': 'value'}, ...] }
	Results []googleapi.RawMessage `json:"results,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Results") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Results") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExecuteActionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ExecuteActionResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExecuteSqlQueryRequest: An execute sql query request containing the
// query and the connection to execute it on.
type ExecuteSqlQueryRequest struct {
	// Query: Required. SQL statement passed by clients like Integration
	// Platform, the query is passed as-is to the driver used for
	// interfacing with external systems.
	Query *Query `json:"query,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Query") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Query") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExecuteSqlQueryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExecuteSqlQueryRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExecuteSqlQueryResponse: A response returned by the connection after
// executing the sql query.
type ExecuteSqlQueryResponse struct {
	// Results: In the case of successful execution of the query the
	// response contains results returned by the external system. For
	// example, the result rows of the query are contained in the 'results'
	// Struct list - "results": [ { "field1": "val1", "field2": "val2",..
	// },.. ] Each Struct row can contain fields any type of like nested
	// Structs or lists.
	Results []googleapi.RawMessage `json:"results,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Results") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Results") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExecuteSqlQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ExecuteSqlQueryResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Field: Message contains EntityType's Field metadata.
type Field struct {
	// AdditionalDetails: The following map contains fields that are not
	// explicitly mentioned above,this give connectors the flexibility to
	// add new metadata fields.
	AdditionalDetails googleapi.RawMessage `json:"additionalDetails,omitempty"`

	// DataType: The data type of the Field.
	//
	// Possible values:
	//   "DATA_TYPE_UNSPECIFIED" - Datatype unspecified.
	//   "INT" - Deprecated Int type, use INTEGER type instead.
	//   "SMALLINT" - Small int type.
	//   "DOUBLE" - Double type.
	//   "DATE" - Date type.
	//   "DATETIME" - Deprecated Datetime type.
	//   "TIME" - Time type.
	//   "STRING" - Deprecated string type, use VARCHAR type instead.
	//   "LONG" - Deprecated Long type, use BIGINT type instead.
	//   "BOOLEAN" - Boolean type.
	//   "DECIMAL" - Decimal type.
	//   "UUID" - Deprecated UUID type, use VARCHAR instead.
	//   "BLOB" - Blob type.
	//   "BIT" - Bit type.
	//   "TINYINT" - Tiny int type.
	//   "INTEGER" - Integer type.
	//   "BIGINT" - Big int type.
	//   "FLOAT" - Float type.
	//   "REAL" - Real type.
	//   "NUMERIC" - Numeric type.
	//   "CHAR" - Char type.
	//   "VARCHAR" - Varchar type.
	//   "LONGVARCHAR" - Long varchar type.
	//   "TIMESTAMP" - Timestamp type.
	//   "NCHAR" - Nchar type.
	//   "NVARCHAR" - Nvarchar type.
	//   "LONGNVARCHAR" - Long Nvarchar type.
	//   "NULL" - Null type.
	//   "OTHER" - Other type.
	//   "JAVA_OBJECT" - Java object type.
	//   "DISTINCT" - Distinct type keyword.
	//   "STRUCT" - Struct type.
	//   "ARRAY" - Array type.
	//   "CLOB" - Clob type.
	//   "REF" - Ref type.
	//   "DATALINK" - Datalink type.
	//   "ROWID" - Row ID type.
	//   "BINARY" - Binary type.
	//   "VARBINARY" - Varbinary type.
	//   "LONGVARBINARY" - Long Varbinary type.
	//   "NCLOB" - Nclob type.
	//   "SQLXML" - SQLXML type.
	//   "REF_CURSOR" - Ref_cursor type.
	//   "TIME_WITH_TIMEZONE" - Time with timezone type.
	//   "TIMESTAMP_WITH_TIMEZONE" - Timestamp with timezone type.
	DataType string `json:"dataType,omitempty"`

	// DefaultValue: The following field specifies the default value of the
	// Field provided by the external system if a value is not provided.
	DefaultValue interface{} `json:"defaultValue,omitempty"`

	// Description: A brief description of the Field.
	Description string `json:"description,omitempty"`

	// JsonSchema: JsonSchema of the field, applicable only if field is of
	// type `STRUCT`
	JsonSchema *JsonSchema `json:"jsonSchema,omitempty"`

	// Key: The following boolean field specifies if the current Field acts
	// as a primary key or id if the parent is of type entity.
	Key bool `json:"key,omitempty"`

	// Name: Name of the Field.
	Name string `json:"name,omitempty"`

	// Nullable: Specifies whether a null value is allowed.
	Nullable bool `json:"nullable,omitempty"`

	// Reference: Reference captures the association between two different
	// entity types. Value links to the reference of another entity type.
	Reference *Reference `json:"reference,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdditionalDetails")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalDetails") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Field) MarshalJSON() ([]byte, error) {
	type NoMethod Field
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InputParameter: Input Parameter message contains metadata about the
// parameters required for executing an Action.
type InputParameter struct {
	// AdditionalDetails: The following map contains fields that are not
	// explicitly mentioned above,this give connectors the flexibility to
	// add new metadata fields.
	AdditionalDetails googleapi.RawMessage `json:"additionalDetails,omitempty"`

	// DataType: The data type of the Parameter
	//
	// Possible values:
	//   "DATA_TYPE_UNSPECIFIED" - Datatype unspecified.
	//   "INT" - Deprecated Int type, use INTEGER type instead.
	//   "SMALLINT" - Small int type.
	//   "DOUBLE" - Double type.
	//   "DATE" - Date type.
	//   "DATETIME" - Deprecated Datetime type.
	//   "TIME" - Time type.
	//   "STRING" - Deprecated string type, use VARCHAR type instead.
	//   "LONG" - Deprecated Long type, use BIGINT type instead.
	//   "BOOLEAN" - Boolean type.
	//   "DECIMAL" - Decimal type.
	//   "UUID" - Deprecated UUID type, use VARCHAR instead.
	//   "BLOB" - Blob type.
	//   "BIT" - Bit type.
	//   "TINYINT" - Tiny int type.
	//   "INTEGER" - Integer type.
	//   "BIGINT" - Big int type.
	//   "FLOAT" - Float type.
	//   "REAL" - Real type.
	//   "NUMERIC" - Numeric type.
	//   "CHAR" - Char type.
	//   "VARCHAR" - Varchar type.
	//   "LONGVARCHAR" - Long varchar type.
	//   "TIMESTAMP" - Timestamp type.
	//   "NCHAR" - Nchar type.
	//   "NVARCHAR" - Nvarchar type.
	//   "LONGNVARCHAR" - Long Nvarchar type.
	//   "NULL" - Null type.
	//   "OTHER" - Other type.
	//   "JAVA_OBJECT" - Java object type.
	//   "DISTINCT" - Distinct type keyword.
	//   "STRUCT" - Struct type.
	//   "ARRAY" - Array type.
	//   "CLOB" - Clob type.
	//   "REF" - Ref type.
	//   "DATALINK" - Datalink type.
	//   "ROWID" - Row ID type.
	//   "BINARY" - Binary type.
	//   "VARBINARY" - Varbinary type.
	//   "LONGVARBINARY" - Long Varbinary type.
	//   "NCLOB" - Nclob type.
	//   "SQLXML" - SQLXML type.
	//   "REF_CURSOR" - Ref_cursor type.
	//   "TIME_WITH_TIMEZONE" - Time with timezone type.
	//   "TIMESTAMP_WITH_TIMEZONE" - Timestamp with timezone type.
	DataType string `json:"dataType,omitempty"`

	// DefaultValue: The following field specifies the default value of the
	// Parameter provided by the external system if a value is not provided.
	DefaultValue interface{} `json:"defaultValue,omitempty"`

	// Description: A brief description of the Parameter.
	Description string `json:"description,omitempty"`

	// JsonSchema: JsonSchema of the parameter, applicable only if parameter
	// is of type `STRUCT`
	JsonSchema *JsonSchema `json:"jsonSchema,omitempty"`

	// Name: Name of the Parameter.
	Name string `json:"name,omitempty"`

	// Nullable: Specifies whether a null value is allowed.
	Nullable bool `json:"nullable,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdditionalDetails")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalDetails") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InputParameter) MarshalJSON() ([]byte, error) {
	type NoMethod InputParameter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// JsonSchema: JsonSchema representation of schema metadata
type JsonSchema struct {
	// AdditionalDetails: Additional details apart from standard json schema
	// fields, this gives flexibility to store metadata about the schema
	AdditionalDetails googleapi.RawMessage `json:"additionalDetails,omitempty"`

	// Default: The default value of the field or object described by this
	// schema.
	Default interface{} `json:"default,omitempty"`

	// Description: A description of this schema.
	Description string `json:"description,omitempty"`

	// Enum: Possible values for an enumeration. This works in conjunction
	// with `type` to represent types with a fixed set of legal values
	Enum []interface{} `json:"enum,omitempty"`

	// Format: Format of the value as per
	// https://json-schema.org/understanding-json-schema/reference/string.html#format
	Format string `json:"format,omitempty"`

	// Items: Schema that applies to array values, applicable only if this
	// is of type `array`.
	Items *JsonSchema `json:"items,omitempty"`

	// JdbcType: JDBC datatype of the field.
	//
	// Possible values:
	//   "DATA_TYPE_UNSPECIFIED" - Datatype unspecified.
	//   "INT" - Deprecated Int type, use INTEGER type instead.
	//   "SMALLINT" - Small int type.
	//   "DOUBLE" - Double type.
	//   "DATE" - Date type.
	//   "DATETIME" - Deprecated Datetime type.
	//   "TIME" - Time type.
	//   "STRING" - Deprecated string type, use VARCHAR type instead.
	//   "LONG" - Deprecated Long type, use BIGINT type instead.
	//   "BOOLEAN" - Boolean type.
	//   "DECIMAL" - Decimal type.
	//   "UUID" - Deprecated UUID type, use VARCHAR instead.
	//   "BLOB" - Blob type.
	//   "BIT" - Bit type.
	//   "TINYINT" - Tiny int type.
	//   "INTEGER" - Integer type.
	//   "BIGINT" - Big int type.
	//   "FLOAT" - Float type.
	//   "REAL" - Real type.
	//   "NUMERIC" - Numeric type.
	//   "CHAR" - Char type.
	//   "VARCHAR" - Varchar type.
	//   "LONGVARCHAR" - Long varchar type.
	//   "TIMESTAMP" - Timestamp type.
	//   "NCHAR" - Nchar type.
	//   "NVARCHAR" - Nvarchar type.
	//   "LONGNVARCHAR" - Long Nvarchar type.
	//   "NULL" - Null type.
	//   "OTHER" - Other type.
	//   "JAVA_OBJECT" - Java object type.
	//   "DISTINCT" - Distinct type keyword.
	//   "STRUCT" - Struct type.
	//   "ARRAY" - Array type.
	//   "CLOB" - Clob type.
	//   "REF" - Ref type.
	//   "DATALINK" - Datalink type.
	//   "ROWID" - Row ID type.
	//   "BINARY" - Binary type.
	//   "VARBINARY" - Varbinary type.
	//   "LONGVARBINARY" - Long Varbinary type.
	//   "NCLOB" - Nclob type.
	//   "SQLXML" - SQLXML type.
	//   "REF_CURSOR" - Ref_cursor type.
	//   "TIME_WITH_TIMEZONE" - Time with timezone type.
	//   "TIMESTAMP_WITH_TIMEZONE" - Timestamp with timezone type.
	JdbcType string `json:"jdbcType,omitempty"`

	// Properties: The child schemas, applicable only if this is of type
	// `object`. The key is the name of the property and the value is the
	// json schema that describes that property
	Properties map[string]JsonSchema `json:"properties,omitempty"`

	// Required: Whether this property is required.
	Required []string `json:"required,omitempty"`

	// Type: JSON Schema Validation: A Vocabulary for Structural Validation
	// of JSON
	Type []string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdditionalDetails")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalDetails") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *JsonSchema) MarshalJSON() ([]byte, error) {
	type NoMethod JsonSchema
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListActionsResponse: Response message for ActionService.ListActions
type ListActionsResponse struct {
	// Actions: List of action metadata.
	Actions []*Action `json:"actions,omitempty"`

	// NextPageToken: Next page token if more actions available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// UnsupportedActionNames: List of actions which contain unsupported
	// Datatypes. Check datatype.proto for more information.
	UnsupportedActionNames []string `json:"unsupportedActionNames,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Actions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Actions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListActionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListActionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListEntitiesResponse: Response message for EntityService.ListEntities
type ListEntitiesResponse struct {
	// Entities: List containing entity rows.
	Entities []*Entity `json:"entities,omitempty"`

	// NextPageToken: Next page token if more records are available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entities") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListEntitiesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListEntitiesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListEntityTypesResponse: Response message for
// EntityService.ListEntityTypes
type ListEntityTypesResponse struct {
	// NextPageToken: Next page token if more entity types available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Types: List of metadata related to all entity types.
	Types []*EntityType `json:"types,omitempty"`

	// UnsupportedTypeNames: List of entity type names which contain
	// unsupported Datatypes. Check datatype.proto for more information.
	UnsupportedTypeNames []string `json:"unsupportedTypeNames,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListEntityTypesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Query: A wrapper around the SQL query statement. This is needed so
// that the JSON representation of ExecuteSqlQueryRequest has the
// following format: `{"query":"select *"}`.
type Query struct {
	// MaxRows: Sets the limit for the maximum number of rows returned after
	// the query execution.
	MaxRows int64 `json:"maxRows,omitempty,string"`

	// Query: Required. Sql query to execute.
	Query string `json:"query,omitempty"`

	// QueryParameters: In the struct, the value corresponds to the value of
	// query parameter and date type corresponds to the date type of the
	// query parameter.
	QueryParameters []*QueryParameter `json:"queryParameters,omitempty"`

	// Timeout: Sets the number of seconds the driver will wait for a query
	// to execute.
	Timeout int64 `json:"timeout,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "MaxRows") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxRows") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Query) MarshalJSON() ([]byte, error) {
	type NoMethod Query
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// QueryParameter: Query parameter definition
type QueryParameter struct {
	// Possible values:
	//   "DATA_TYPE_UNSPECIFIED" - Datatype unspecified.
	//   "INT" - Deprecated Int type, use INTEGER type instead.
	//   "SMALLINT" - Small int type.
	//   "DOUBLE" - Double type.
	//   "DATE" - Date type.
	//   "DATETIME" - Deprecated Datetime type.
	//   "TIME" - Time type.
	//   "STRING" - Deprecated string type, use VARCHAR type instead.
	//   "LONG" - Deprecated Long type, use BIGINT type instead.
	//   "BOOLEAN" - Boolean type.
	//   "DECIMAL" - Decimal type.
	//   "UUID" - Deprecated UUID type, use VARCHAR instead.
	//   "BLOB" - Blob type.
	//   "BIT" - Bit type.
	//   "TINYINT" - Tiny int type.
	//   "INTEGER" - Integer type.
	//   "BIGINT" - Big int type.
	//   "FLOAT" - Float type.
	//   "REAL" - Real type.
	//   "NUMERIC" - Numeric type.
	//   "CHAR" - Char type.
	//   "VARCHAR" - Varchar type.
	//   "LONGVARCHAR" - Long varchar type.
	//   "TIMESTAMP" - Timestamp type.
	//   "NCHAR" - Nchar type.
	//   "NVARCHAR" - Nvarchar type.
	//   "LONGNVARCHAR" - Long Nvarchar type.
	//   "NULL" - Null type.
	//   "OTHER" - Other type.
	//   "JAVA_OBJECT" - Java object type.
	//   "DISTINCT" - Distinct type keyword.
	//   "STRUCT" - Struct type.
	//   "ARRAY" - Array type.
	//   "CLOB" - Clob type.
	//   "REF" - Ref type.
	//   "DATALINK" - Datalink type.
	//   "ROWID" - Row ID type.
	//   "BINARY" - Binary type.
	//   "VARBINARY" - Varbinary type.
	//   "LONGVARBINARY" - Long Varbinary type.
	//   "NCLOB" - Nclob type.
	//   "SQLXML" - SQLXML type.
	//   "REF_CURSOR" - Ref_cursor type.
	//   "TIME_WITH_TIMEZONE" - Time with timezone type.
	//   "TIMESTAMP_WITH_TIMEZONE" - Timestamp with timezone type.
	DataType string `json:"dataType,omitempty"`

	Value interface{} `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *QueryParameter) MarshalJSON() ([]byte, error) {
	type NoMethod QueryParameter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type Reference struct {
	// Name: Name of the reference field.
	Name string `json:"name,omitempty"`

	// Type: Name of reference entity type.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Reference) MarshalJSON() ([]byte, error) {
	type NoMethod Reference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ResultMetadata: Result Metadata message contains metadata about the
// result returned after executing an Action.
type ResultMetadata struct {
	// DataType: The data type of the metadata field
	//
	// Possible values:
	//   "DATA_TYPE_UNSPECIFIED" - Datatype unspecified.
	//   "INT" - Deprecated Int type, use INTEGER type instead.
	//   "SMALLINT" - Small int type.
	//   "DOUBLE" - Double type.
	//   "DATE" - Date type.
	//   "DATETIME" - Deprecated Datetime type.
	//   "TIME" - Time type.
	//   "STRING" - Deprecated string type, use VARCHAR type instead.
	//   "LONG" - Deprecated Long type, use BIGINT type instead.
	//   "BOOLEAN" - Boolean type.
	//   "DECIMAL" - Decimal type.
	//   "UUID" - Deprecated UUID type, use VARCHAR instead.
	//   "BLOB" - Blob type.
	//   "BIT" - Bit type.
	//   "TINYINT" - Tiny int type.
	//   "INTEGER" - Integer type.
	//   "BIGINT" - Big int type.
	//   "FLOAT" - Float type.
	//   "REAL" - Real type.
	//   "NUMERIC" - Numeric type.
	//   "CHAR" - Char type.
	//   "VARCHAR" - Varchar type.
	//   "LONGVARCHAR" - Long varchar type.
	//   "TIMESTAMP" - Timestamp type.
	//   "NCHAR" - Nchar type.
	//   "NVARCHAR" - Nvarchar type.
	//   "LONGNVARCHAR" - Long Nvarchar type.
	//   "NULL" - Null type.
	//   "OTHER" - Other type.
	//   "JAVA_OBJECT" - Java object type.
	//   "DISTINCT" - Distinct type keyword.
	//   "STRUCT" - Struct type.
	//   "ARRAY" - Array type.
	//   "CLOB" - Clob type.
	//   "REF" - Ref type.
	//   "DATALINK" - Datalink type.
	//   "ROWID" - Row ID type.
	//   "BINARY" - Binary type.
	//   "VARBINARY" - Varbinary type.
	//   "LONGVARBINARY" - Long Varbinary type.
	//   "NCLOB" - Nclob type.
	//   "SQLXML" - SQLXML type.
	//   "REF_CURSOR" - Ref_cursor type.
	//   "TIME_WITH_TIMEZONE" - Time with timezone type.
	//   "TIMESTAMP_WITH_TIMEZONE" - Timestamp with timezone type.
	DataType string `json:"dataType,omitempty"`

	// Description: A brief description of the metadata field.
	Description string `json:"description,omitempty"`

	// JsonSchema: JsonSchema of the result, applicable only if parameter is
	// of type `STRUCT`
	JsonSchema *JsonSchema `json:"jsonSchema,omitempty"`

	// Name: Name of the metadata field.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ResultMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod ResultMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UpdateEntitiesWithConditionsResponse: Response message for
// EntityService.UpdateEntitiesWithConditions
type UpdateEntitiesWithConditionsResponse struct {
	// Response: Response returned by the external system.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Response") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Response") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UpdateEntitiesWithConditionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateEntitiesWithConditionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "connectors.projects.locations.connections.executeSqlQuery":

type ProjectsLocationsConnectionsExecuteSqlQueryCall struct {
	s                      *Service
	connection             string
	executesqlqueryrequest *ExecuteSqlQueryRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// ExecuteSqlQuery: Executes a SQL statement specified in the body of
// the request. An example of this SQL statement in the case of
// Salesforce connector would be 'select * from Account a, Order o where
// a.Id = o.AccountId'.
//
//   - connection: Resource name of the Connection. Format:
//     projects/{project}/locations/{location}/connections/{connection}.
func (r *ProjectsLocationsConnectionsService) ExecuteSqlQuery(connection string, executesqlqueryrequest *ExecuteSqlQueryRequest) *ProjectsLocationsConnectionsExecuteSqlQueryCall {
	c := &ProjectsLocationsConnectionsExecuteSqlQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.connection = connection
	c.executesqlqueryrequest = executesqlqueryrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConnectionsExecuteSqlQueryCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsExecuteSqlQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConnectionsExecuteSqlQueryCall) Context(ctx context.Context) *ProjectsLocationsConnectionsExecuteSqlQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConnectionsExecuteSqlQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsExecuteSqlQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.executesqlqueryrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+connection}:executeSqlQuery")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"connection": c.connection,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.executeSqlQuery" call.
// Exactly one of *ExecuteSqlQueryResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ExecuteSqlQueryResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsConnectionsExecuteSqlQueryCall) Do(opts ...googleapi.CallOption) (*ExecuteSqlQueryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ExecuteSqlQueryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Executes a SQL statement specified in the body of the request. An example of this SQL statement in the case of Salesforce connector would be 'select * from Account a, Order o where a.Id = o.AccountId'.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}:executeSqlQuery",
	//   "httpMethod": "POST",
	//   "id": "connectors.projects.locations.connections.executeSqlQuery",
	//   "parameterOrder": [
	//     "connection"
	//   ],
	//   "parameters": {
	//     "connection": {
	//       "description": "Required. Resource name of the Connection. Format: projects/{project}/locations/{location}/connections/{connection}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/connections/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+connection}:executeSqlQuery",
	//   "request": {
	//     "$ref": "ExecuteSqlQueryRequest"
	//   },
	//   "response": {
	//     "$ref": "ExecuteSqlQueryResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "connectors.projects.locations.connections.actions.execute":

type ProjectsLocationsConnectionsActionsExecuteCall struct {
	s                    *Service
	name                 string
	executeactionrequest *ExecuteActionRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Execute: Executes an action with the name specified in the request.
// The input parameters for executing the action are passed through the
// body of the ExecuteAction request.
//
//   - name: Resource name of the Action. Format:
//     projects/{project}/locations/{location}/connections/{connection}/act
//     ions/{action}.
func (r *ProjectsLocationsConnectionsActionsService) Execute(name string, executeactionrequest *ExecuteActionRequest) *ProjectsLocationsConnectionsActionsExecuteCall {
	c := &ProjectsLocationsConnectionsActionsExecuteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.executeactionrequest = executeactionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConnectionsActionsExecuteCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsActionsExecuteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConnectionsActionsExecuteCall) Context(ctx context.Context) *ProjectsLocationsConnectionsActionsExecuteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConnectionsActionsExecuteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsActionsExecuteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.executeactionrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:execute")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.actions.execute" call.
// Exactly one of *ExecuteActionResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ExecuteActionResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsConnectionsActionsExecuteCall) Do(opts ...googleapi.CallOption) (*ExecuteActionResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ExecuteActionResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Executes an action with the name specified in the request. The input parameters for executing the action are passed through the body of the ExecuteAction request.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/actions/{actionsId}:execute",
	//   "httpMethod": "POST",
	//   "id": "connectors.projects.locations.connections.actions.execute",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Resource name of the Action. Format: projects/{project}/locations/{location}/connections/{connection}/actions/{action}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/connections/[^/]+/actions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}:execute",
	//   "request": {
	//     "$ref": "ExecuteActionRequest"
	//   },
	//   "response": {
	//     "$ref": "ExecuteActionResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "connectors.projects.locations.connections.actions.get":

type ProjectsLocationsConnectionsActionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the schema of the given action.
//
//   - name: Resource name of the Action. Format:
//     projects/{project}/locations/{location}/connections/{connection}/act
//     ions/{action}.
func (r *ProjectsLocationsConnectionsActionsService) Get(name string) *ProjectsLocationsConnectionsActionsGetCall {
	c := &ProjectsLocationsConnectionsActionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConnectionsActionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsActionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsConnectionsActionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsConnectionsActionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConnectionsActionsGetCall) Context(ctx context.Context) *ProjectsLocationsConnectionsActionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConnectionsActionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsActionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.actions.get" call.
// Exactly one of *Action or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Action.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsConnectionsActionsGetCall) Do(opts ...googleapi.CallOption) (*Action, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Action{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the schema of the given action.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/actions/{actionsId}",
	//   "httpMethod": "GET",
	//   "id": "connectors.projects.locations.connections.actions.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Resource name of the Action. Format: projects/{project}/locations/{location}/connections/{connection}/actions/{action}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/connections/[^/]+/actions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}",
	//   "response": {
	//     "$ref": "Action"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "connectors.projects.locations.connections.actions.list":

type ProjectsLocationsConnectionsActionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Gets the schema of all the actions supported by the connector.
//
//   - parent: Parent resource name of the Action. Format:
//     projects/{project}/locations/{location}/connections/{connection}.
func (r *ProjectsLocationsConnectionsActionsService) List(parent string) *ProjectsLocationsConnectionsActionsListCall {
	c := &ProjectsLocationsConnectionsActionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Number of Actions to
// return. Defaults to 25.
func (c *ProjectsLocationsConnectionsActionsListCall) PageSize(pageSize int64) *ProjectsLocationsConnectionsActionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token, return
// from a previous ListActions call, that can be used retrieve the next
// page of content. If unspecified, the request returns the first page
// of actions.
func (c *ProjectsLocationsConnectionsActionsListCall) PageToken(pageToken string) *ProjectsLocationsConnectionsActionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": Specifies which fields of
// the Action are returned in the response.
//
// Possible values:
//
//	"ACTION_VIEW_UNSPECIFIED" - VIEW_UNSPECIFIED. The unset value
//
// Defaults to FULL View.
//
//	"ACTION_VIEW_BASIC" - Return only action names.
//	"ACTION_VIEW_FULL" - Return actions with schema.
func (c *ProjectsLocationsConnectionsActionsListCall) View(view string) *ProjectsLocationsConnectionsActionsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConnectionsActionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsActionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsConnectionsActionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsConnectionsActionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConnectionsActionsListCall) Context(ctx context.Context) *ProjectsLocationsConnectionsActionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConnectionsActionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsActionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/actions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.actions.list" call.
// Exactly one of *ListActionsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListActionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsConnectionsActionsListCall) Do(opts ...googleapi.CallOption) (*ListActionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListActionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the schema of all the actions supported by the connector.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/actions",
	//   "httpMethod": "GET",
	//   "id": "connectors.projects.locations.connections.actions.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Number of Actions to return. Defaults to 25.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Page token, return from a previous ListActions call, that can be used retrieve the next page of content. If unspecified, the request returns the first page of actions.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Parent resource name of the Action. Format: projects/{project}/locations/{location}/connections/{connection}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/connections/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "Specifies which fields of the Action are returned in the response.",
	//       "enum": [
	//         "ACTION_VIEW_UNSPECIFIED",
	//         "ACTION_VIEW_BASIC",
	//         "ACTION_VIEW_FULL"
	//       ],
	//       "enumDescriptions": [
	//         "VIEW_UNSPECIFIED. The unset value Defaults to FULL View.",
	//         "Return only action names.",
	//         "Return actions with schema."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/actions",
	//   "response": {
	//     "$ref": "ListActionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsConnectionsActionsListCall) Pages(ctx context.Context, f func(*ListActionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "connectors.projects.locations.connections.entityTypes.get":

type ProjectsLocationsConnectionsEntityTypesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets metadata of given entity type
//
//   - name: Resource name of the Entity Type. Format:
//     projects/{project}/locations/{location}/connections/{connection}/ent
//     ityTypes/{entityType}.
func (r *ProjectsLocationsConnectionsEntityTypesService) Get(name string) *ProjectsLocationsConnectionsEntityTypesGetCall {
	c := &ProjectsLocationsConnectionsEntityTypesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConnectionsEntityTypesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsEntityTypesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsConnectionsEntityTypesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsConnectionsEntityTypesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConnectionsEntityTypesGetCall) Context(ctx context.Context) *ProjectsLocationsConnectionsEntityTypesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConnectionsEntityTypesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsEntityTypesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.entityTypes.get" call.
// Exactly one of *EntityType or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *EntityType.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConnectionsEntityTypesGetCall) Do(opts ...googleapi.CallOption) (*EntityType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EntityType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets metadata of given entity type",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/entityTypes/{entityTypesId}",
	//   "httpMethod": "GET",
	//   "id": "connectors.projects.locations.connections.entityTypes.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Resource name of the Entity Type. Format: projects/{project}/locations/{location}/connections/{connection}/entityTypes/{entityType}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/connections/[^/]+/entityTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}",
	//   "response": {
	//     "$ref": "EntityType"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "connectors.projects.locations.connections.entityTypes.list":

type ProjectsLocationsConnectionsEntityTypesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists metadata related to all entity types present in the
// external system.
//
//   - parent: Resource name of the Entity Type. Format:
//     projects/{project}/locations/{location}/connections/{connection}.
func (r *ProjectsLocationsConnectionsEntityTypesService) List(parent string) *ProjectsLocationsConnectionsEntityTypesListCall {
	c := &ProjectsLocationsConnectionsEntityTypesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Number of entity
// types to return. Defaults to 25.
func (c *ProjectsLocationsConnectionsEntityTypesListCall) PageSize(pageSize int64) *ProjectsLocationsConnectionsEntityTypesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token, return
// from a previous ListEntityTypes call, that can be used retrieve the
// next page of content. If unspecified, the request returns the first
// page of entity types.
func (c *ProjectsLocationsConnectionsEntityTypesListCall) PageToken(pageToken string) *ProjectsLocationsConnectionsEntityTypesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": Specifies which fields of
// the Entity Type are returned in the response.
//
// Possible values:
//
//	"ENTITY_TYPE_VIEW_UNSPECIFIED" - VIEW_UNSPECIFIED. The unset value.
//
// Defaults to FULL View.
//
//	"ENTITY_TYPE_VIEW_BASIC" - Return only entity type names.
//	"ENTITY_TYPE_VIEW_FULL" - Return entity types with schema
func (c *ProjectsLocationsConnectionsEntityTypesListCall) View(view string) *ProjectsLocationsConnectionsEntityTypesListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConnectionsEntityTypesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsEntityTypesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsConnectionsEntityTypesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsConnectionsEntityTypesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConnectionsEntityTypesListCall) Context(ctx context.Context) *ProjectsLocationsConnectionsEntityTypesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConnectionsEntityTypesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsEntityTypesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/entityTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.entityTypes.list" call.
// Exactly one of *ListEntityTypesResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListEntityTypesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsConnectionsEntityTypesListCall) Do(opts ...googleapi.CallOption) (*ListEntityTypesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListEntityTypesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists metadata related to all entity types present in the external system.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/entityTypes",
	//   "httpMethod": "GET",
	//   "id": "connectors.projects.locations.connections.entityTypes.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Number of entity types to return. Defaults to 25.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Page token, return from a previous ListEntityTypes call, that can be used retrieve the next page of content. If unspecified, the request returns the first page of entity types.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Resource name of the Entity Type. Format: projects/{project}/locations/{location}/connections/{connection}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/connections/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "Specifies which fields of the Entity Type are returned in the response.",
	//       "enum": [
	//         "ENTITY_TYPE_VIEW_UNSPECIFIED",
	//         "ENTITY_TYPE_VIEW_BASIC",
	//         "ENTITY_TYPE_VIEW_FULL"
	//       ],
	//       "enumDescriptions": [
	//         "VIEW_UNSPECIFIED. The unset value. Defaults to FULL View.",
	//         "Return only entity type names.",
	//         "Return entity types with schema"
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/entityTypes",
	//   "response": {
	//     "$ref": "ListEntityTypesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsConnectionsEntityTypesListCall) Pages(ctx context.Context, f func(*ListEntityTypesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "connectors.projects.locations.connections.entityTypes.entities.create":

type ProjectsLocationsConnectionsEntityTypesEntitiesCreateCall struct {
	s          *Service
	parent     string
	entity     *Entity
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new entity row of the specified entity type in the
// external system. The field values for creating the row are contained
// in the body of the request. The response message contains a `Entity`
// message object returned as a response by the external system.
//
//   - parent: Resource name of the Entity Type. Format:
//     projects/{project}/locations/{location}/connections/{connection}/ent
//     ityTypes/{type}.
func (r *ProjectsLocationsConnectionsEntityTypesEntitiesService) Create(parent string, entity *Entity) *ProjectsLocationsConnectionsEntityTypesEntitiesCreateCall {
	c := &ProjectsLocationsConnectionsEntityTypesEntitiesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.entity = entity
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsEntityTypesEntitiesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesCreateCall) Context(ctx context.Context) *ProjectsLocationsConnectionsEntityTypesEntitiesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsEntityTypesEntitiesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.entity)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/entities")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.entityTypes.entities.create" call.
// Exactly one of *Entity or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Entity.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesCreateCall) Do(opts ...googleapi.CallOption) (*Entity, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Entity{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a new entity row of the specified entity type in the external system. The field values for creating the row are contained in the body of the request. The response message contains a `Entity` message object returned as a response by the external system.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/entityTypes/{entityTypesId}/entities",
	//   "httpMethod": "POST",
	//   "id": "connectors.projects.locations.connections.entityTypes.entities.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Resource name of the Entity Type. Format: projects/{project}/locations/{location}/connections/{connection}/entityTypes/{type}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/connections/[^/]+/entityTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/entities",
	//   "request": {
	//     "$ref": "Entity"
	//   },
	//   "response": {
	//     "$ref": "Entity"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "connectors.projects.locations.connections.entityTypes.entities.delete":

type ProjectsLocationsConnectionsEntityTypesEntitiesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an existing entity row matching the entity type and
// entity id specified in the request.
//
//   - name: Resource name of the Entity Type. Format:
//     projects/{project}/locations/{location}/connections/{connection}/ent
//     ityTypes/{type}/entities/{id}.
func (r *ProjectsLocationsConnectionsEntityTypesEntitiesService) Delete(name string) *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteCall {
	c := &ProjectsLocationsConnectionsEntityTypesEntitiesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteCall) Context(ctx context.Context) *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.entityTypes.entities.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes an existing entity row matching the entity type and entity id specified in the request.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/entityTypes/{entityTypesId}/entities/{entitiesId}",
	//   "httpMethod": "DELETE",
	//   "id": "connectors.projects.locations.connections.entityTypes.entities.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Resource name of the Entity Type. Format: projects/{project}/locations/{location}/connections/{connection}/entityTypes/{type}/entities/{id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/connections/[^/]+/entityTypes/[^/]+/entities/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "connectors.projects.locations.connections.entityTypes.entities.deleteEntitiesWithConditions":

type ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall struct {
	s          *Service
	entityType string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// DeleteEntitiesWithConditions: Deletes entities based on conditions
// specified in the request and not on entity id.
//
//   - entityType: Resource name of the Entity Type. Format:
//     projects/{project}/locations/{location}/connections/{connection}/ent
//     ityTypes/{type}.
func (r *ProjectsLocationsConnectionsEntityTypesEntitiesService) DeleteEntitiesWithConditions(entityType string) *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall {
	c := &ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.entityType = entityType
	return c
}

// Conditions sets the optional parameter "conditions": Required.
// Conditions to be used when deleting entities. From a proto
// standpoint, There are no restrictions on what can be passed using
// this field. The connector documentation should have information about
// what format of filters/conditions are supported. Note: If this
// conditions field is left empty, an exception is thrown. We don't want
// to consider 'empty conditions' to be a match-all case. Connector
// developers can determine and document what a match-all case
// constraint would be.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall) Conditions(conditions string) *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall {
	c.urlParams_.Set("conditions", conditions)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall) Context(ctx context.Context) *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+entityType}/entities:deleteEntitiesWithConditions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"entityType": c.entityType,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.entityTypes.entities.deleteEntitiesWithConditions" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes entities based on conditions specified in the request and not on entity id.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/entityTypes/{entityTypesId}/entities:deleteEntitiesWithConditions",
	//   "httpMethod": "POST",
	//   "id": "connectors.projects.locations.connections.entityTypes.entities.deleteEntitiesWithConditions",
	//   "parameterOrder": [
	//     "entityType"
	//   ],
	//   "parameters": {
	//     "conditions": {
	//       "description": "Required. Conditions to be used when deleting entities. From a proto standpoint, There are no restrictions on what can be passed using this field. The connector documentation should have information about what format of filters/conditions are supported. Note: If this conditions field is left empty, an exception is thrown. We don't want to consider 'empty conditions' to be a match-all case. Connector developers can determine and document what a match-all case constraint would be.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "entityType": {
	//       "description": "Required. Resource name of the Entity Type. Format: projects/{project}/locations/{location}/connections/{connection}/entityTypes/{type}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/connections/[^/]+/entityTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+entityType}/entities:deleteEntitiesWithConditions",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "connectors.projects.locations.connections.entityTypes.entities.get":

type ProjectsLocationsConnectionsEntityTypesEntitiesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a single entity row matching the entity type and entity id
// specified in the request.
//
//   - name: Resource name of the Entity Type. Format:
//     projects/{project}/locations/{location}/connections/{connection}/ent
//     ityTypes/{type}/entities/{id}.
func (r *ProjectsLocationsConnectionsEntityTypesEntitiesService) Get(name string) *ProjectsLocationsConnectionsEntityTypesEntitiesGetCall {
	c := &ProjectsLocationsConnectionsEntityTypesEntitiesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsEntityTypesEntitiesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsConnectionsEntityTypesEntitiesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesGetCall) Context(ctx context.Context) *ProjectsLocationsConnectionsEntityTypesEntitiesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsEntityTypesEntitiesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.entityTypes.entities.get" call.
// Exactly one of *Entity or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Entity.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesGetCall) Do(opts ...googleapi.CallOption) (*Entity, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Entity{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a single entity row matching the entity type and entity id specified in the request.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/entityTypes/{entityTypesId}/entities/{entitiesId}",
	//   "httpMethod": "GET",
	//   "id": "connectors.projects.locations.connections.entityTypes.entities.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Resource name of the Entity Type. Format: projects/{project}/locations/{location}/connections/{connection}/entityTypes/{type}/entities/{id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/connections/[^/]+/entityTypes/[^/]+/entities/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}",
	//   "response": {
	//     "$ref": "Entity"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "connectors.projects.locations.connections.entityTypes.entities.list":

type ProjectsLocationsConnectionsEntityTypesEntitiesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists entity rows of a particular entity type contained in the
// request. Note: 1. Currently, only max of one 'sort_by' column is
// supported. 2. If no 'sort_by' column is provided, the primary key of
// the table is used. If zero or more than one primary key is available,
// we default to the unpaginated list entities logic which only returns
// the first page. 3. The values of the 'sort_by' columns must uniquely
// identify an entity row, otherwise undefined behaviors may be observed
// during pagination. 4. Since transactions are not supported, any
// updates, inserts or deletes during pagination can lead to stale data
// being returned or other unexpected behaviors.
//
//   - parent: Resource name of the Entity Type. Format:
//     projects/{project}/locations/{location}/connections/{connection}/ent
//     ityTypes/{type}.
func (r *ProjectsLocationsConnectionsEntityTypesEntitiesService) List(parent string) *ProjectsLocationsConnectionsEntityTypesEntitiesListCall {
	c := &ProjectsLocationsConnectionsEntityTypesEntitiesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Conditions sets the optional parameter "conditions": Conditions to be
// used when listing entities. From a proto standpoint, There are no
// restrictions on what can be passed using this field. The connector
// documentation should have information about what format of
// filters/conditions are supported.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) Conditions(conditions string) *ProjectsLocationsConnectionsEntityTypesEntitiesListCall {
	c.urlParams_.Set("conditions", conditions)
	return c
}

// PageSize sets the optional parameter "pageSize": Number of entity
// rows to return. Defaults page size = 25. Max page size = 200.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) PageSize(pageSize int64) *ProjectsLocationsConnectionsEntityTypesEntitiesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token value
// if available from a previous request.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) PageToken(pageToken string) *ProjectsLocationsConnectionsEntityTypesEntitiesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// SortBy sets the optional parameter "sortBy": List of 'sort_by'
// columns to use when returning the results.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) SortBy(sortBy ...string) *ProjectsLocationsConnectionsEntityTypesEntitiesListCall {
	c.urlParams_.SetMulti("sortBy", append([]string{}, sortBy...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsEntityTypesEntitiesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsConnectionsEntityTypesEntitiesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) Context(ctx context.Context) *ProjectsLocationsConnectionsEntityTypesEntitiesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/entities")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.entityTypes.entities.list" call.
// Exactly one of *ListEntitiesResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListEntitiesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) Do(opts ...googleapi.CallOption) (*ListEntitiesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListEntitiesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists entity rows of a particular entity type contained in the request. Note: 1. Currently, only max of one 'sort_by' column is supported. 2. If no 'sort_by' column is provided, the primary key of the table is used. If zero or more than one primary key is available, we default to the unpaginated list entities logic which only returns the first page. 3. The values of the 'sort_by' columns must uniquely identify an entity row, otherwise undefined behaviors may be observed during pagination. 4. Since transactions are not supported, any updates, inserts or deletes during pagination can lead to stale data being returned or other unexpected behaviors.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/entityTypes/{entityTypesId}/entities",
	//   "httpMethod": "GET",
	//   "id": "connectors.projects.locations.connections.entityTypes.entities.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "conditions": {
	//       "description": "Conditions to be used when listing entities. From a proto standpoint, There are no restrictions on what can be passed using this field. The connector documentation should have information about what format of filters/conditions are supported.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Number of entity rows to return. Defaults page size = 25. Max page size = 200.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Page token value if available from a previous request.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Resource name of the Entity Type. Format: projects/{project}/locations/{location}/connections/{connection}/entityTypes/{type}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/connections/[^/]+/entityTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "sortBy": {
	//       "description": "List of 'sort_by' columns to use when returning the results.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/entities",
	//   "response": {
	//     "$ref": "ListEntitiesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) Pages(ctx context.Context, f func(*ListEntitiesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "connectors.projects.locations.connections.entityTypes.entities.patch":

type ProjectsLocationsConnectionsEntityTypesEntitiesPatchCall struct {
	s          *Service
	name       string
	entity     *Entity
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates an existing entity row matching the entity type and
// entity id specified in the request. The fields in the entity row that
// need to be modified are contained in the body of the request. All
// unspecified fields are left unchanged. The response message contains
// a `Entity` message object returned as a response by the external
// system.
//
//   - name: Output only. Resource name of the Entity. Format:
//     projects/{project}/locations/{location}/connections/{connection}/ent
//     ityTypes/{type}/entities/{id}.
func (r *ProjectsLocationsConnectionsEntityTypesEntitiesService) Patch(name string, entity *Entity) *ProjectsLocationsConnectionsEntityTypesEntitiesPatchCall {
	c := &ProjectsLocationsConnectionsEntityTypesEntitiesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.entity = entity
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsEntityTypesEntitiesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesPatchCall) Context(ctx context.Context) *ProjectsLocationsConnectionsEntityTypesEntitiesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsEntityTypesEntitiesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.entity)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.entityTypes.entities.patch" call.
// Exactly one of *Entity or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Entity.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesPatchCall) Do(opts ...googleapi.CallOption) (*Entity, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Entity{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an existing entity row matching the entity type and entity id specified in the request. The fields in the entity row that need to be modified are contained in the body of the request. All unspecified fields are left unchanged. The response message contains a `Entity` message object returned as a response by the external system.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/entityTypes/{entityTypesId}/entities/{entitiesId}",
	//   "httpMethod": "PATCH",
	//   "id": "connectors.projects.locations.connections.entityTypes.entities.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Resource name of the Entity. Format: projects/{project}/locations/{location}/connections/{connection}/entityTypes/{type}/entities/{id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/connections/[^/]+/entityTypes/[^/]+/entities/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}",
	//   "request": {
	//     "$ref": "Entity"
	//   },
	//   "response": {
	//     "$ref": "Entity"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "connectors.projects.locations.connections.entityTypes.entities.updateEntitiesWithConditions":

type ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall struct {
	s          *Service
	entityType string
	entity     *Entity
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// UpdateEntitiesWithConditions: Updates entities based on conditions
// specified in the request and not on entity id.
//
//   - entityType: Resource name of the Entity Type. Format:
//     projects/{project}/locations/{location}/connections/{connection}/ent
//     ityTypes/{type}.
func (r *ProjectsLocationsConnectionsEntityTypesEntitiesService) UpdateEntitiesWithConditions(entityType string, entity *Entity) *ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall {
	c := &ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.entityType = entityType
	c.entity = entity
	return c
}

// Conditions sets the optional parameter "conditions": Required.
// Conditions to be used when updating entities. From a proto
// standpoint, There are no restrictions on what can be passed using
// this field. The connector documentation should have information about
// what format of filters/conditions are supported. Note: If this
// conditions field is left empty, an exception is thrown. We don't want
// to consider 'empty conditions' to be a match-all case. Connector
// developers can determine and document what a match-all case
// constraint would be.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall) Conditions(conditions string) *ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall {
	c.urlParams_.Set("conditions", conditions)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall) Context(ctx context.Context) *ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.entity)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+entityType}/entities:updateEntitiesWithConditions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"entityType": c.entityType,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.entityTypes.entities.updateEntitiesWithConditions" call.
// Exactly one of *UpdateEntitiesWithConditionsResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *UpdateEntitiesWithConditionsResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall) Do(opts ...googleapi.CallOption) (*UpdateEntitiesWithConditionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UpdateEntitiesWithConditionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates entities based on conditions specified in the request and not on entity id.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/entityTypes/{entityTypesId}/entities:updateEntitiesWithConditions",
	//   "httpMethod": "POST",
	//   "id": "connectors.projects.locations.connections.entityTypes.entities.updateEntitiesWithConditions",
	//   "parameterOrder": [
	//     "entityType"
	//   ],
	//   "parameters": {
	//     "conditions": {
	//       "description": "Required. Conditions to be used when updating entities. From a proto standpoint, There are no restrictions on what can be passed using this field. The connector documentation should have information about what format of filters/conditions are supported. Note: If this conditions field is left empty, an exception is thrown. We don't want to consider 'empty conditions' to be a match-all case. Connector developers can determine and document what a match-all case constraint would be.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "entityType": {
	//       "description": "Required. Resource name of the Entity Type. Format: projects/{project}/locations/{location}/connections/{connection}/entityTypes/{type}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/connections/[^/]+/entityTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+entityType}/entities:updateEntitiesWithConditions",
	//   "request": {
	//     "$ref": "Entity"
	//   },
	//   "response": {
	//     "$ref": "UpdateEntitiesWithConditionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}
