---
date: 2025-06-08
slug: goreleaser-v2.10
categories: [announcements]
authors: [caarlos0]
---

# Announcing GoReleaser v2.10

This version introduces the new Homebrew Casks feature, an experimental MCP
server, plus many other small improvements.

<!-- more -->

## Homebrew Casks

Historically, the [`brews`][brews] section was kind of a hack.
In Homebrew, Formulas are supposed to be used to build something from source,
and then install it.
We were leveraging it to install something that was already built elsewhere.

But no more!
Thanks to the help of [Sean Molenaar](https://github.com/SMillerDev) from the
Homebrew team, this version introduces a new
[`homebrew_casks`][casks] section that does the
right thing!

You can follow the [migration guide][deprecations-brews] to learn how to
adjust your configuration, but, in most cases, you only need to rename `brews`
to `homebrew_casks` and that's it.

For instance, GoReleaser's own configuration:

=== "Before"

    ```yaml title=".goreleaser.yaml"
    brews:
      - repository:
          owner: goreleaser
          name: homebrew-tap
        directory: Formula
        goarm: "7"
        homepage: https://goreleaser.com
        description: Release engineering, simplified
        license: MIT
        test: |
          system "#{bin}/goreleaser -v"
        conflicts:
          - goreleaser-pro
        extra_install: |-
          bash_completion.install "completions/goreleaser.bash" => "goreleaser"
          zsh_completion.install "completions/goreleaser.zsh" => "_goreleaser"
          fish_completion.install "completions/goreleaser.fish"
          man1.install "manpages/goreleaser.1.gz"
    ```

=== "After"

    ```yaml title=".goreleaser.yaml"
    homebrew_casks:
      - repository:
          owner: goreleaser
          name: homebrew-tap
        homepage: https://goreleaser.com
        description: Release engineering, simplified
        license: MIT
        conflicts:
          - formula: goreleaser-pro
          - formula: goreleaser
          - cask: goreleaser-pro
        manpage: "manpages/goreleaser.1.gz"
        completions:
          bash: "completions/goreleaser.bash"
          zsh: "completions/goreleaser.zsh"
          fish: "completions/goreleaser.fish"
    ```

!!! danger "Signing and Notarizing"

    If you don't currently sign and notarize your binaries, you might also need to
    add a
    [post install hook to remove the quarantine bit][cask-notary].

All that being said, the old `brews` section is **deprecated** and should be
removed in our next major (v3, not planned date yet) unless someone finds a big
reason not to.

And again, thanks to Sean for all the help and feedback given! You rock!

## MCP server

As an experiment, we now ship a MCP server.
It doesn't do a lot - yet, but I think that, as AI grows, it might get more
features and become increasingly more useful.

You can use it with any client that supports MCP, for instance, for Claude
Desktop, you can add this to your `claude_desktop_config.json`:

```json
{
  "mcpServers": {
    "goreleaser": {
      "command": "goreleaser",
      "args": [ "mcp" ]
    }
}
```

Or, with [`mods` (running from `main`)](https://charm.sh/mods):

```yaml
mcp-servers:
  goreleaser:
    command: goreleaser
    args:
      - mcp
```

Or, you can add it to your tool of choice. Basically, just call `goreleaser mcp`
and that's it.

We're also very interested in other tools GoReleaser MCP can provide.
Feel free to hop in our
[discussion](https://github.com/orgs/goreleaser/discussions/5816) and give
whatever feedback or ideas you have!

## Other smaller changes

- **pro**: `npms` got a `url_template` field
- **pro**: improved error handling for
  [Cloudsmith][cloudsmith]
- **ko**: allow to specify the local domain for local registries
- **nfpm**: allows to set RPM's build host
- **sbom**: templeteable `disable` field
- **bun**, **deno**: fixed duplicated build flags
- **homebrew**, **nix**: support more archive formats

## Other news

- GoReleaser now has ~14.7k stars and 433 contributors! Thanks, everyone!
- We eventually discuss new features in our Discord server. 
  [Join the conversation][discord]!
- nFPM had new releases as well, 
  [check it out](https://github.com/goreleaser/nfpm/releases).

## Download

You can install or upgrade using your favorite package manager, or see the
full release notes and download the pre-compiled binaries from GitHub:

[:fontawesome-solid-download: Install][install]{ .md-button .md-button--primary }
[:fontawesome-brands-github: v2.10.0 (OSS)][oss-rel]{ .md-button }
[:fontawesome-brands-github: v2.10.0 (Pro)][pro-rel]{ .md-button }

### Upgrading with Homebrew

If you installed GoReleaser from our tap, this one time you'll need to:

=== "OSS"

    ```bash
    brew uninstall goreleaser/tap/goreleaser
    brew install --cask goreleaser/tap/goreleaser
    ```

=== "Pro"

    ```bash
    brew uninstall goreleaser/tap/goreleaser-pro
    brew install --cask goreleaser/tap/goreleaser-pro
    ```

## Helping out

You can help by reporting issues, contributing features, documentation
improvements, and bug fixes.
You can also sponsor the project, or get a GoReleaser Pro license.

[:material-professional-hexagon: Get the Pro license][pro]{ .md-button .md-button--primary }
[:simple-githubsponsors: Sponsor the project][sponsor]{ .md-button }

[sponsor]: https://goreleaser.com/sponsors
[pro]: https://goreleaser.com/pro
[install]: https://goreleaser.com/install
[pro-rel]: https://github.com/goreleaser/goreleaser-pro/releases/tag/v2.10.0
[oss-rel]: https://github.com/goreleaser/goreleaser/releases/tag/v2.10.0
[discord]: https://goreleaser.com/discord
[npm]: https://goreleaser.com/customization/npm
[cloudsmith]: https://goreleaser.com/customization/cloudsmith
[deprecations-brews]: https://goreleaser.com/deprecations/#brews
[snapshot]: https://goreleaser.com/customization/snapshots/
[brews]: https://goreleaser.com/customization/homebrew_formulas/
[casks]: https://goreleaser.com/customization/homebrew_casks/
[cask-notary]: https://goreleaser.com/customization/homebrew_casks/#signing-and-notarizing
