/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.forward;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.zip.Deflater;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.forward.PositionData;
import org.traccar.forward.PositionForwarder;
import org.traccar.forward.ResultHandler;
import org.traccar.helper.Checksum;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class PositionForwarderWialon
implements PositionForwarder {
    private final String version;
    private final boolean useCompression;
    private final DatagramSocket socket;
    private final InetAddress address;
    private final int port;

    public PositionForwarderWialon(Config config, ExecutorService executorService, String version, boolean useCompression) {
        this.version = version;
        this.useCompression = useCompression;
        try {
            URI url = new URI(config.getString(Keys.FORWARD_URL));
            this.address = InetAddress.getByName(url.getHost());
            this.port = url.getPort();
            this.socket = new DatagramSocket();
            executorService.submit(() -> {
                byte[] buffer = new byte[1024];
                while (!executorService.isShutdown()) {
                    try {
                        this.socket.receive(new DatagramPacket(buffer, buffer.length));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void forward(PositionData positionData, ResultHandler resultHandler) {
        DatagramPacket packet;
        String message;
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyy;HHmmss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Position position = positionData.getPosition();
        String uniqueId = positionData.getDevice().getUniqueId();
        Object payload = String.format("%s;%02d%.5f;%s;%03d%.5f;%s;%d;%d;%d;NA;NA;NA;NA;;%s;%s", dateFormat.format(position.getFixTime()), (int)Math.abs(position.getLatitude()), Math.abs(position.getLatitude()) % 1.0 * 60.0, position.getLatitude() >= 0.0 ? "N" : "S", (int)Math.abs(position.getLongitude()), Math.abs(position.getLongitude()) % 1.0 * 60.0, position.getLongitude() >= 0.0 ? "E" : "W", (int)UnitsConverter.kphFromKnots(position.getSpeed()), (int)position.getCourse(), (int)position.getAltitude(), position.getString("driverUniqueId", "NA"), PositionForwarderWialon.formatAttributes(position.getAttributes()));
        if (this.version.startsWith("2")) {
            payload = (String)payload + ";";
            ByteBuffer payloadBuffer = ByteBuffer.wrap(((String)payload).getBytes(StandardCharsets.US_ASCII));
            int checksum = Checksum.crc16(Checksum.CRC16_IBM, payloadBuffer);
            message = this.version + ";" + uniqueId + "#D#" + (String)payload + String.format("%04x", checksum) + "\r\n";
        } else {
            message = uniqueId + "#D#" + (String)payload + "\r\n";
        }
        byte[] buffer = message.getBytes();
        if (this.useCompression) {
            ByteBuf container = PositionForwarderWialon.compressData(buffer);
            packet = new DatagramPacket(container.array(), container.readableBytes(), this.address, this.port);
        } else {
            packet = new DatagramPacket(buffer, buffer.length, this.address, this.port);
        }
        try {
            this.socket.send(packet);
            resultHandler.onResult(true, null);
        }
        catch (IOException e) {
            resultHandler.onResult(false, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf compressData(byte[] data) {
        ByteBuf container;
        Deflater deflater = new Deflater();
        deflater.setInput(data);
        deflater.finish();
        ByteBuf compressedData = Unpooled.buffer((int)data.length);
        byte[] tempBuffer = new byte[1024];
        try {
            while (!deflater.finished()) {
                int count = deflater.deflate(tempBuffer);
                compressedData.writeBytes(tempBuffer, 0, count);
            }
            container = Unpooled.buffer((int)(3 + compressedData.readableBytes()));
            container.writeByte(255);
            container.writeShortLE(compressedData.readableBytes());
            container.writeBytes(compressedData);
        }
        finally {
            deflater.end();
            compressedData.release();
        }
        return container;
    }

    public static String formatAttributes(Map<String, Object> attributes) {
        if (attributes.isEmpty()) {
            return "NA";
        }
        return attributes.entrySet().stream().map(entry -> {
            Object value = entry.getValue();
            int type = value instanceof Double || value instanceof Float ? 2 : (value instanceof Number ? 1 : 3);
            return (String)entry.getKey() + ":" + type + ":" + String.valueOf(value);
        }).collect(Collectors.joining(","));
    }
}

