/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.collect.Maps;
import com.google.inject.OutOfScopeException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Map;

class ContinuingHttpServletRequest
extends HttpServletRequestWrapper {
    private final Map<String, Object> attributes = Maps.newHashMap();
    private final Cookie[] cookies;

    public ContinuingHttpServletRequest(HttpServletRequest request) {
        super(request);
        Cookie[] originalCookies = request.getCookies();
        if (originalCookies != null) {
            int numberOfCookies = originalCookies.length;
            this.cookies = new Cookie[numberOfCookies];
            for (int i = 0; i < numberOfCookies; ++i) {
                Cookie originalCookie = originalCookies[i];
                this.cookies[i] = originalCookie instanceof ImmutableCookie ? originalCookie : new ImmutableCookie(originalCookie);
            }
        } else {
            this.cookies = null;
        }
    }

    public HttpSession getSession() {
        throw new OutOfScopeException("Cannot access the session in a continued request");
    }

    public HttpSession getSession(boolean create) {
        throw new UnsupportedOperationException("Cannot access the session in a continued request");
    }

    public ServletInputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("Cannot access raw request on a continued request");
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    private static final class ImmutableCookie
    extends Cookie {
        public ImmutableCookie(Cookie original) {
            super(original.getName(), original.getValue());
            super.setMaxAge(original.getMaxAge());
            super.setPath(original.getPath());
            super.setComment(original.getComment());
            super.setSecure(original.getSecure());
            super.setValue(original.getValue());
            super.setVersion(original.getVersion());
            if (original.getDomain() != null) {
                super.setDomain(original.getDomain());
            }
        }

        public void setComment(String purpose) {
            throw new UnsupportedOperationException("Cannot modify cookies on a continued request");
        }

        public void setDomain(String pattern) {
            throw new UnsupportedOperationException("Cannot modify cookies on a continued request");
        }

        public void setMaxAge(int expiry) {
            throw new UnsupportedOperationException("Cannot modify cookies on a continued request");
        }

        public void setPath(String uri) {
            throw new UnsupportedOperationException("Cannot modify cookies on a continued request");
        }

        public void setSecure(boolean flag) {
            throw new UnsupportedOperationException("Cannot modify cookies on a continued request");
        }

        public void setValue(String newValue) {
            throw new UnsupportedOperationException("Cannot modify cookies on a continued request");
        }

        public void setVersion(int v) {
            throw new UnsupportedOperationException("Cannot modify cookies on a continued request");
        }
    }
}

