// Licensed to ClickHouse, Inc. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. ClickHouse, Inc. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated by make codegen DO NOT EDIT.
// source: lib/column/codegen/dynamic.tpl

package column

import (
	"database/sql"
	"encoding/json"
	"github.com/ClickHouse/ch-go/proto"
	"github.com/google/uuid"
	"github.com/paulmach/orb"
	"time"
)

// inferClickHouseTypeFromGoType takes a Go interface{} and converts it to a ClickHouse type.
// Returns empty string if type was not matched.
// This is best effort and does not work for all types.
// Optimally, users should provide a type using DynamicWithType.
func inferClickHouseTypeFromGoType(v any) string {
    switch v.(type) {
    {{- range . }}
    case {{ .GoType }}:
        return "{{ .ChType }}"
    case *{{ .GoType }}:
        return "{{ .ChType }}"
    {{- end }}
    {{- range . }}
    {{- if .SkipArray }}
    {{- else}}
    case []{{ .GoType }}:
        return "Array({{ .ChType }})"
    {{- end}}
    case []*{{ .GoType }}:
        return "Array({{ .ChType }})"
    {{- end }}
    {{- range . }}
    case map[string]{{ .GoType }}:
        return "Map(String, {{ .ChType }})"
    {{- end }}
    default:
        return ""
    }
}
