// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func TestCopyOrigFunctionSlice(t *testing.T) {
	src := []*otlpprofiles.Function{}
	dest := []*otlpprofiles.Function{}
	// Test CopyTo empty
	dest = CopyOrigFunctionSlice(dest, src)
	assert.Equal(t, []*otlpprofiles.Function{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestFunctionSlice()
	dest = CopyOrigFunctionSlice(dest, src)
	assert.Equal(t, GenerateOrigTestFunctionSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigFunctionSlice(dest, src)
	assert.Equal(t, GenerateOrigTestFunctionSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigFunctionSlice(dest, []*otlpprofiles.Function{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigFunctionSlice(dest, src)
	assert.Equal(t, GenerateOrigTestFunctionSlice(), dest)
}
