// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func TestCopyOrigLinkSlice(t *testing.T) {
	src := []*otlpprofiles.Link{}
	dest := []*otlpprofiles.Link{}
	// Test CopyTo empty
	dest = CopyOrigLinkSlice(dest, src)
	assert.Equal(t, []*otlpprofiles.Link{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestLinkSlice()
	dest = CopyOrigLinkSlice(dest, src)
	assert.Equal(t, GenerateOrigTestLinkSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigLinkSlice(dest, src)
	assert.Equal(t, GenerateOrigTestLinkSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigLinkSlice(dest, []*otlpprofiles.Link{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigLinkSlice(dest, src)
	assert.Equal(t, GenerateOrigTestLinkSlice(), dest)
}
