// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlplogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/logs/v1"
)

func CopyOrigResourceLogsSlice(dest, src []*otlplogs.ResourceLogs) []*otlplogs.ResourceLogs {
	var newDest []*otlplogs.ResourceLogs
	if cap(dest) < len(src) {
		newDest = make([]*otlplogs.ResourceLogs, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigResourceLogs()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigResourceLogs(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigResourceLogs()
		}
	}
	for i := range src {
		CopyOrigResourceLogs(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestResourceLogsSlice() []*otlplogs.ResourceLogs {
	orig := make([]*otlplogs.ResourceLogs, 5)
	orig[0] = NewOrigResourceLogs()
	orig[1] = GenTestOrigResourceLogs()
	orig[2] = NewOrigResourceLogs()
	orig[3] = GenTestOrigResourceLogs()
	orig[4] = NewOrigResourceLogs()
	return orig
}
