// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
)

func TestCopyOrigSpanSlice(t *testing.T) {
	src := []*otlptrace.Span{}
	dest := []*otlptrace.Span{}
	// Test CopyTo empty
	dest = CopyOrigSpanSlice(dest, src)
	assert.Equal(t, []*otlptrace.Span{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestSpanSlice()
	dest = CopyOrigSpanSlice(dest, src)
	assert.Equal(t, GenerateOrigTestSpanSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigSpanSlice(dest, src)
	assert.Equal(t, GenerateOrigTestSpanSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigSpanSlice(dest, []*otlptrace.Span{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigSpanSlice(dest, src)
	assert.Equal(t, GenerateOrigTestSpanSlice(), dest)
}
