/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.orchestration.template.wifi.validator;

import com.ubnt.C.A.o0OO;
import com.ubnt.data.WlanConf;
import com.ubnt.data.mdnsproxy.MdnsProxyCustom;
import com.ubnt.data.mdnsproxy.MdnsProxyCustomWithVlanIds;
import com.ubnt.data.mdnsproxy.MdnsProxyMode;
import com.ubnt.service.mdnsproxy.oOOO;
import com.ubnt.service.network.configuration.repository.B;
import com.ubnt.service.orchestration.dto.report.IssueDetailReportDto;
import com.ubnt.service.orchestration.template.wifi.validator.WifiOrchestrationWarning;
import jakarta.annotation.Nullable;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MdnsProxyWarningValidator {
    private final oOOO mdnsProxyService;
    private final B networkConfigCrudService;

    List<IssueDetailReportDto> \u00d800000(WlanConf wlanConf) {
        o0OO o0OO2 = o0OO.\u00d300000();
        if (wlanConf.isMdnsProxyEnabled()) {
            if (!this.mdnsProxyService.\u00d600000(wlanConf.getSiteId())) {
                o0OO2.String((Object)IssueDetailReportDto.builder().code(WifiOrchestrationWarning.MDNS_FILTERING_NOT_SUPPORTED).issueDetail("No Access Points on this site support mDNS Filtering. Setting mDNS Proxy to OFF.").build());
                wlanConf.setMdnsProxyMode(MdnsProxyMode.OFF);
                wlanConf.setMdnsProxyCustom(List.of());
            } else if (MdnsProxyMode.CUSTOM == wlanConf.getMdnsProxyMode()) {
                this.\u00f500000(wlanConf, (o0OO<IssueDetailReportDto>)o0OO2);
            }
        }
        return o0OO2.o00000();
    }

    private void \u00f500000(WlanConf wlanConf, o0OO<IssueDetailReportDto> o0OO2) {
        List<MdnsProxyCustomWithVlanIds> list = wlanConf.getMdnsProxyCustomWithVlanIds();
        List<MdnsProxyCustomWithVlanIds> list2 = list.stream().filter(mdnsProxyCustomWithVlanIds -> !mdnsProxyCustomWithVlanIds.vlanIds().isEmpty()).toList();
        if (this.if(list2)) {
            this.while(wlanConf, list2, list, o0OO2);
        }
    }

    private boolean if(List<MdnsProxyCustomWithVlanIds> list) {
        return !list.isEmpty();
    }

    private void while(WlanConf wlanConf, List<MdnsProxyCustomWithVlanIds> list, List<MdnsProxyCustomWithVlanIds> list2, o0OO<IssueDetailReportDto> o0OO2) {
        List<MdnsProxyCustom> list3 = list.stream().map(mdnsProxyCustomWithVlanIds -> this.new(wlanConf.getSiteId(), (MdnsProxyCustomWithVlanIds)mdnsProxyCustomWithVlanIds, o0OO2)).filter(Objects::nonNull).toList();
        if (this.\u00f800000(list3)) {
            o0OO2.String((Object)IssueDetailReportDto.builder().code(WifiOrchestrationWarning.MDNS_FILTERING_ALL_VLAN_IDS_NOT_FOUND).issueDetail("mDNS Proxy is set to CUSTOM but no valid vlan_id(s) with network found. Setting mDNS Proxy to OFF.").build());
            wlanConf.setMdnsProxyMode(MdnsProxyMode.OFF);
            wlanConf.setMdnsProxyCustom(List.of());
        } else {
            List<MdnsProxyCustom> list4 = Stream.concat(list2.stream().filter(mdnsProxyCustomWithVlanIds -> mdnsProxyCustomWithVlanIds.vlanIds().isEmpty()), list3.stream()).toList();
            wlanConf.setMdnsProxyCustom(list4);
        }
    }

    private boolean \u00f800000(List<MdnsProxyCustom> list) {
        return list.isEmpty();
    }

    @Nullable
    private MdnsProxyCustom new(String string, MdnsProxyCustomWithVlanIds mdnsProxyCustomWithVlanIds, o0OO<IssueDetailReportDto> o0OO2) {
        boolean bl = mdnsProxyCustomWithVlanIds.networkConfIds().stream().anyMatch(StringUtils::isBlank);
        if (bl) {
            List<Integer> list = mdnsProxyCustomWithVlanIds.vlanIds().stream().filter(n2 -> this.\u00d500000(string, (Integer)n2)).toList();
            if (this.\u00f400000(mdnsProxyCustomWithVlanIds.vlanIds(), list)) {
                return null;
            }
            o0OO2.String((Object)IssueDetailReportDto.builder().code(WifiOrchestrationWarning.MDNS_FILTERING_VLAN_ID_NOT_FOUND).issueDetail("mDNS Proxy is set to CUSTOM but not found vlan_id(s): " + String.valueOf(list)).build());
            return this.oO0000(mdnsProxyCustomWithVlanIds, list);
        }
        return mdnsProxyCustomWithVlanIds;
    }

    private boolean \u00d500000(String string, Integer n2) {
        return this.networkConfigCrudService.\u00d6O0000(string, n2).isEmpty();
    }

    private boolean \u00f400000(List<Integer> list, List<Integer> list2) {
        return list2.size() == list.size();
    }

    private MdnsProxyCustomWithVlanIds oO0000(MdnsProxyCustomWithVlanIds mdnsProxyCustomWithVlanIds, List<Integer> list) {
        List<String> list2 = mdnsProxyCustomWithVlanIds.networkConfIds().stream().filter(StringUtils::isNotBlank).toList();
        List<Integer> list3 = mdnsProxyCustomWithVlanIds.vlanIds().stream().filter(n2 -> !list.contains(n2)).toList();
        return mdnsProxyCustomWithVlanIds.toBuilder().networkConfIds(list2).vlanIds(list3).build();
    }

    @ConstructorProperties(value={"mdnsProxyService", "networkConfigCrudService"})
    @Generated
    public MdnsProxyWarningValidator(oOOO oOOO2, B b2) {
        this.mdnsProxyService = oOOO2;
        this.networkConfigCrudService = b2;
    }
}

