// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1beta1/reasoning_engine_execution_service.proto

package aiplatformpb

import (
	context "context"

	httpbody "google.golang.org/genproto/googleapis/api/httpbody"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ReasoningEngineExecutionService_QueryReasoningEngine_FullMethodName       = "/google.cloud.aiplatform.v1beta1.ReasoningEngineExecutionService/QueryReasoningEngine"
	ReasoningEngineExecutionService_StreamQueryReasoningEngine_FullMethodName = "/google.cloud.aiplatform.v1beta1.ReasoningEngineExecutionService/StreamQueryReasoningEngine"
)

// ReasoningEngineExecutionServiceClient is the client API for ReasoningEngineExecutionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ReasoningEngineExecutionServiceClient interface {
	// Queries using a reasoning engine.
	QueryReasoningEngine(ctx context.Context, in *QueryReasoningEngineRequest, opts ...grpc.CallOption) (*QueryReasoningEngineResponse, error)
	// Streams queries using a reasoning engine.
	StreamQueryReasoningEngine(ctx context.Context, in *StreamQueryReasoningEngineRequest, opts ...grpc.CallOption) (ReasoningEngineExecutionService_StreamQueryReasoningEngineClient, error)
}

type reasoningEngineExecutionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewReasoningEngineExecutionServiceClient(cc grpc.ClientConnInterface) ReasoningEngineExecutionServiceClient {
	return &reasoningEngineExecutionServiceClient{cc}
}

func (c *reasoningEngineExecutionServiceClient) QueryReasoningEngine(ctx context.Context, in *QueryReasoningEngineRequest, opts ...grpc.CallOption) (*QueryReasoningEngineResponse, error) {
	out := new(QueryReasoningEngineResponse)
	err := c.cc.Invoke(ctx, ReasoningEngineExecutionService_QueryReasoningEngine_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reasoningEngineExecutionServiceClient) StreamQueryReasoningEngine(ctx context.Context, in *StreamQueryReasoningEngineRequest, opts ...grpc.CallOption) (ReasoningEngineExecutionService_StreamQueryReasoningEngineClient, error) {
	stream, err := c.cc.NewStream(ctx, &ReasoningEngineExecutionService_ServiceDesc.Streams[0], ReasoningEngineExecutionService_StreamQueryReasoningEngine_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &reasoningEngineExecutionServiceStreamQueryReasoningEngineClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ReasoningEngineExecutionService_StreamQueryReasoningEngineClient interface {
	Recv() (*httpbody.HttpBody, error)
	grpc.ClientStream
}

type reasoningEngineExecutionServiceStreamQueryReasoningEngineClient struct {
	grpc.ClientStream
}

func (x *reasoningEngineExecutionServiceStreamQueryReasoningEngineClient) Recv() (*httpbody.HttpBody, error) {
	m := new(httpbody.HttpBody)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ReasoningEngineExecutionServiceServer is the server API for ReasoningEngineExecutionService service.
// All implementations should embed UnimplementedReasoningEngineExecutionServiceServer
// for forward compatibility
type ReasoningEngineExecutionServiceServer interface {
	// Queries using a reasoning engine.
	QueryReasoningEngine(context.Context, *QueryReasoningEngineRequest) (*QueryReasoningEngineResponse, error)
	// Streams queries using a reasoning engine.
	StreamQueryReasoningEngine(*StreamQueryReasoningEngineRequest, ReasoningEngineExecutionService_StreamQueryReasoningEngineServer) error
}

// UnimplementedReasoningEngineExecutionServiceServer should be embedded to have forward compatible implementations.
type UnimplementedReasoningEngineExecutionServiceServer struct {
}

func (UnimplementedReasoningEngineExecutionServiceServer) QueryReasoningEngine(context.Context, *QueryReasoningEngineRequest) (*QueryReasoningEngineResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryReasoningEngine not implemented")
}
func (UnimplementedReasoningEngineExecutionServiceServer) StreamQueryReasoningEngine(*StreamQueryReasoningEngineRequest, ReasoningEngineExecutionService_StreamQueryReasoningEngineServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamQueryReasoningEngine not implemented")
}

// UnsafeReasoningEngineExecutionServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ReasoningEngineExecutionServiceServer will
// result in compilation errors.
type UnsafeReasoningEngineExecutionServiceServer interface {
	mustEmbedUnimplementedReasoningEngineExecutionServiceServer()
}

func RegisterReasoningEngineExecutionServiceServer(s grpc.ServiceRegistrar, srv ReasoningEngineExecutionServiceServer) {
	s.RegisterService(&ReasoningEngineExecutionService_ServiceDesc, srv)
}

func _ReasoningEngineExecutionService_QueryReasoningEngine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryReasoningEngineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReasoningEngineExecutionServiceServer).QueryReasoningEngine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReasoningEngineExecutionService_QueryReasoningEngine_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReasoningEngineExecutionServiceServer).QueryReasoningEngine(ctx, req.(*QueryReasoningEngineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReasoningEngineExecutionService_StreamQueryReasoningEngine_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamQueryReasoningEngineRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ReasoningEngineExecutionServiceServer).StreamQueryReasoningEngine(m, &reasoningEngineExecutionServiceStreamQueryReasoningEngineServer{stream})
}

type ReasoningEngineExecutionService_StreamQueryReasoningEngineServer interface {
	Send(*httpbody.HttpBody) error
	grpc.ServerStream
}

type reasoningEngineExecutionServiceStreamQueryReasoningEngineServer struct {
	grpc.ServerStream
}

func (x *reasoningEngineExecutionServiceStreamQueryReasoningEngineServer) Send(m *httpbody.HttpBody) error {
	return x.ServerStream.SendMsg(m)
}

// ReasoningEngineExecutionService_ServiceDesc is the grpc.ServiceDesc for ReasoningEngineExecutionService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ReasoningEngineExecutionService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.ReasoningEngineExecutionService",
	HandlerType: (*ReasoningEngineExecutionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "QueryReasoningEngine",
			Handler:    _ReasoningEngineExecutionService_QueryReasoningEngine_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamQueryReasoningEngine",
			Handler:       _ReasoningEngineExecutionService_StreamQueryReasoningEngine_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/cloud/aiplatform/v1beta1/reasoning_engine_execution_service.proto",
}
