package main

import (
	"context"
	"fmt"
	"log"

	"github.com/owenthereal/tmux"
)

func main() {
	ctx := context.Background()

	t, err := tmux.Default()
	if err != nil {
		log.Fatal(err)
	}

	sessions, err := t.ListSessions(ctx)
	if err != nil {
		log.Fatal(err)
	}

	for _, s := range sessions {
		fmt.Println("Session: ", s.Name)
		windows, err := s.ListWindows(ctx)
		if err != nil {
			log.Fatal(err)
		}

		for _, w := range windows {
			fmt.Println("Window: ", w.Index)
			panes, err := w.ListPanes(ctx)
			if err != nil {
				log.Fatal(err)
			}

			for _, p := range panes {
				fmt.Println("Pane: ", p.Path)
			}
		}
	}
}
