// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	Retrieves the available dimension values for capacity metrics within a
//
// specified time range. This is useful for discovering what accounts, regions,
// instance families, and other dimensions have data available for filtering and
// grouping.
func (c *Client) GetCapacityManagerMetricDimensions(ctx context.Context, params *GetCapacityManagerMetricDimensionsInput, optFns ...func(*Options)) (*GetCapacityManagerMetricDimensionsOutput, error) {
	if params == nil {
		params = &GetCapacityManagerMetricDimensionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCapacityManagerMetricDimensions", params, optFns, c.addOperationGetCapacityManagerMetricDimensionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCapacityManagerMetricDimensionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCapacityManagerMetricDimensionsInput struct {

	//  The end time for the dimension query, in ISO 8601 format. Only dimensions with
	// data in this time range will be returned.
	//
	// This member is required.
	EndTime *time.Time

	//  The dimensions to group by when retrieving available dimension values. This
	// determines which dimension combinations are returned. Required parameter.
	//
	// This member is required.
	GroupBy []types.GroupBy

	//  The metric names to use as an additional filter when retrieving dimensions.
	// Only dimensions that have data for these metrics will be returned. Required
	// parameter with maximum size of 1 for v1.
	//
	// This member is required.
	MetricNames []types.Metric

	//  The start time for the dimension query, in ISO 8601 format. Only dimensions
	// with data in this time range will be returned.
	//
	// This member is required.
	StartTime *time.Time

	//  Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	//  Conditions to filter which dimension values are returned. Each filter
	// specifies a dimension, comparison operator, and values to match against.
	FilterBy []types.CapacityManagerCondition

	//  The maximum number of dimension combinations to return. Valid range is 1 to
	// 1000. Use with NextToken for pagination.
	MaxResults *int32

	//  The token for the next page of results. Use this value in a subsequent call to
	// retrieve additional dimension values.
	NextToken *string

	noSmithyDocumentSerde
}

type GetCapacityManagerMetricDimensionsOutput struct {

	//  The available dimension combinations that have data within the specified time
	// range and filters.
	MetricDimensionResults []types.CapacityManagerDimension

	//  The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCapacityManagerMetricDimensionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpGetCapacityManagerMetricDimensions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpGetCapacityManagerMetricDimensions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCapacityManagerMetricDimensions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetCapacityManagerMetricDimensionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCapacityManagerMetricDimensions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// GetCapacityManagerMetricDimensionsPaginatorOptions is the paginator options for
// GetCapacityManagerMetricDimensions
type GetCapacityManagerMetricDimensionsPaginatorOptions struct {
	//  The maximum number of dimension combinations to return. Valid range is 1 to
	// 1000. Use with NextToken for pagination.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetCapacityManagerMetricDimensionsPaginator is a paginator for
// GetCapacityManagerMetricDimensions
type GetCapacityManagerMetricDimensionsPaginator struct {
	options   GetCapacityManagerMetricDimensionsPaginatorOptions
	client    GetCapacityManagerMetricDimensionsAPIClient
	params    *GetCapacityManagerMetricDimensionsInput
	nextToken *string
	firstPage bool
}

// NewGetCapacityManagerMetricDimensionsPaginator returns a new
// GetCapacityManagerMetricDimensionsPaginator
func NewGetCapacityManagerMetricDimensionsPaginator(client GetCapacityManagerMetricDimensionsAPIClient, params *GetCapacityManagerMetricDimensionsInput, optFns ...func(*GetCapacityManagerMetricDimensionsPaginatorOptions)) *GetCapacityManagerMetricDimensionsPaginator {
	if params == nil {
		params = &GetCapacityManagerMetricDimensionsInput{}
	}

	options := GetCapacityManagerMetricDimensionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetCapacityManagerMetricDimensionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetCapacityManagerMetricDimensionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetCapacityManagerMetricDimensions page.
func (p *GetCapacityManagerMetricDimensionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetCapacityManagerMetricDimensionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetCapacityManagerMetricDimensions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetCapacityManagerMetricDimensionsAPIClient is a client that implements the
// GetCapacityManagerMetricDimensions operation.
type GetCapacityManagerMetricDimensionsAPIClient interface {
	GetCapacityManagerMetricDimensions(context.Context, *GetCapacityManagerMetricDimensionsInput, ...func(*Options)) (*GetCapacityManagerMetricDimensionsOutput, error)
}

var _ GetCapacityManagerMetricDimensionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetCapacityManagerMetricDimensions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCapacityManagerMetricDimensions",
	}
}
