// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package travelimpactmodel provides access to the Travel Impact Model API.
//
// For product documentation, see: https://developers.google.com/travel/impact-model
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/travelimpactmodel/v1"
//	...
//	ctx := context.Background()
//	travelimpactmodelService, err := travelimpactmodel.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	travelimpactmodelService, err := travelimpactmodel.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	travelimpactmodelService, err := travelimpactmodel.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package travelimpactmodel // import "google.golang.org/api/travelimpactmodel/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "travelimpactmodel:v1"
const apiName = "travelimpactmodel"
const apiVersion = "v1"
const basePath = "https://travelimpactmodel.googleapis.com/"
const basePathTemplate = "https://travelimpactmodel.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://travelimpactmodel.mtls.googleapis.com/"

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Flights = NewFlightsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Flights *FlightsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewFlightsService(s *Service) *FlightsService {
	rs := &FlightsService{s: s}
	return rs
}

type FlightsService struct {
	s *Service
}

// ComputeFlightEmissionsRequest: Input definition for the
// ComputeFlightEmissions request.
type ComputeFlightEmissionsRequest struct {
	// Flights: Required. Direct flights to return emission estimates for.
	Flights []*Flight `json:"flights,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Flights") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flights") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeFlightEmissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeFlightEmissionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComputeFlightEmissionsResponse: Output definition for the
// ComputeFlightEmissions response.
type ComputeFlightEmissionsResponse struct {
	// FlightEmissions: List of flight legs with emission estimates.
	FlightEmissions []*FlightWithEmissions `json:"flightEmissions,omitempty"`
	// ModelVersion: The model version under which emission estimates for all
	// flights in this response were computed.
	ModelVersion *ModelVersion `json:"modelVersion,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FlightEmissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FlightEmissions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeFlightEmissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeFlightEmissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComputeScope3FlightEmissionsRequest: A list of flight segments to request
// the Scope 3 emissions for.
type ComputeScope3FlightEmissionsRequest struct {
	// Flights: Required. Flights to return emission estimates for.
	Flights []*Scope3FlightSegment `json:"flights,omitempty"`
	// ModelVersion: Optional. The model version under which emission estimates for
	// all flights in this request were computed.
	ModelVersion *ModelVersion `json:"modelVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Flights") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flights") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeScope3FlightEmissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeScope3FlightEmissionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComputeScope3FlightEmissionsResponse: A list of flights with Scope 3
// emission estimates.
type ComputeScope3FlightEmissionsResponse struct {
	// FlightEmissions: List of flight segments with emission estimates.
	FlightEmissions []*Scope3FlightEmissions `json:"flightEmissions,omitempty"`
	// ModelVersion: The model version under which emission estimates for all
	// flights in this response were computed.
	ModelVersion *ModelVersion `json:"modelVersion,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FlightEmissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FlightEmissions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeScope3FlightEmissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeScope3FlightEmissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComputeTypicalFlightEmissionsRequest: A list of pair of airports (markets)
// to request the typical emissions for.
type ComputeTypicalFlightEmissionsRequest struct {
	// Markets: Required. Request the typical flight emissions estimates for this
	// market pair. A maximum of 1000 markets can be requested.
	Markets []*Market `json:"markets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Markets") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Markets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeTypicalFlightEmissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeTypicalFlightEmissionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComputeTypicalFlightEmissionsResponse: The response includes the emissions
// but also the model version.
type ComputeTypicalFlightEmissionsResponse struct {
	// ModelVersion: The model version under which typical flight emission
	// estimates for all flights in this response were computed.
	ModelVersion *ModelVersion `json:"modelVersion,omitempty"`
	// TypicalFlightEmissions: Market's Typical Flight Emissions requested.
	TypicalFlightEmissions []*TypicalFlightEmissions `json:"typicalFlightEmissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ModelVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeTypicalFlightEmissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeTypicalFlightEmissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Date: Represents a whole or partial calendar date, such as a birthday. The
// time of day and time zone are either specified elsewhere or are
// insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type Date struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Date) MarshalJSON() ([]byte, error) {
	type NoMethod Date
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EasaLabelMetadata: Metadata about the EASA Flight Emissions Label.
type EasaLabelMetadata struct {
	// LabelExpiryDate: The date when the label expires. The label can be displayed
	// until the end of this date.
	LabelExpiryDate *Date `json:"labelExpiryDate,omitempty"`
	// LabelIssueDate: The date when the label was issued.
	LabelIssueDate *Date `json:"labelIssueDate,omitempty"`
	// LabelVersion: Version of the label.
	LabelVersion string `json:"labelVersion,omitempty"`
	// SafDiscountPercentage: Sustainable Aviation Fuel (SAF) emissions discount
	// percentage applied to the label. It is a percentage as a decimal. The values
	// are in the interval [0,1]. For example, 0.0021 means 0.21%. This discount
	// and reduction in emissions are reported by the EASA label but they are not
	// included in the CO2e estimates distributed by this API.
	SafDiscountPercentage float64 `json:"safDiscountPercentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LabelExpiryDate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LabelExpiryDate") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EasaLabelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod EasaLabelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *EasaLabelMetadata) UnmarshalJSON(data []byte) error {
	type NoMethod EasaLabelMetadata
	var s1 struct {
		SafDiscountPercentage gensupport.JSONFloat64 `json:"safDiscountPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SafDiscountPercentage = float64(s1.SafDiscountPercentage)
	return nil
}

// EmissionsGramsPerPax: Grouped emissions per seating class results.
type EmissionsGramsPerPax struct {
	// Business: Emissions for one passenger in business class in grams. This field
	// is always computed and populated, regardless of whether the aircraft has
	// business class seats or not.
	Business int64 `json:"business,omitempty"`
	// Economy: Emissions for one passenger in economy class in grams. This field
	// is always computed and populated, regardless of whether the aircraft has
	// economy class seats or not.
	Economy int64 `json:"economy,omitempty"`
	// First: Emissions for one passenger in first class in grams. This field is
	// always computed and populated, regardless of whether the aircraft has first
	// class seats or not.
	First int64 `json:"first,omitempty"`
	// PremiumEconomy: Emissions for one passenger in premium economy class in
	// grams. This field is always computed and populated, regardless of whether
	// the aircraft has premium economy class seats or not.
	PremiumEconomy int64 `json:"premiumEconomy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Business") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Business") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EmissionsGramsPerPax) MarshalJSON() ([]byte, error) {
	type NoMethod EmissionsGramsPerPax
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Flight: All details related to a single request item for a direct flight
// emission estimates.
type Flight struct {
	// DepartureDate: Required. Date of the flight in the time zone of the origin
	// airport. Must be a date in the present or future.
	DepartureDate *Date `json:"departureDate,omitempty"`
	// Destination: Required. IATA airport code for flight destination, e.g. "JFK".
	Destination string `json:"destination,omitempty"`
	// FlightNumber: Required. Flight number, e.g. 324.
	FlightNumber int64 `json:"flightNumber,omitempty"`
	// OperatingCarrierCode: Required. IATA carrier code, e.g. "AA".
	OperatingCarrierCode string `json:"operatingCarrierCode,omitempty"`
	// Origin: Required. IATA airport code for flight origin, e.g. "LHR".
	Origin string `json:"origin,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DepartureDate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DepartureDate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Flight) MarshalJSON() ([]byte, error) {
	type NoMethod Flight
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FlightWithEmissions: Direct flight with emission estimates.
type FlightWithEmissions struct {
	// ContrailsImpactBucket: Optional. The significance of contrails warming
	// impact compared to the total CO2e emissions impact.
	//
	// Possible values:
	//   "CONTRAILS_IMPACT_UNSPECIFIED" - The contrails impact is unspecified.
	//   "CONTRAILS_IMPACT_NEGLIGIBLE" - The contrails impact is negligible
	// compared to the total CO2e emissions.
	//   "CONTRAILS_IMPACT_MODERATE" - The contrails impact is comparable to the
	// total CO2e emissions.
	//   "CONTRAILS_IMPACT_SEVERE" - The contrails impact is higher than the total
	// CO2e emissions impact.
	ContrailsImpactBucket string `json:"contrailsImpactBucket,omitempty"`
	// EasaLabelMetadata: Optional. Metadata about the EASA Flight Emissions Label.
	// Only set when the emissions data source is EASA.
	EasaLabelMetadata *EasaLabelMetadata `json:"easaLabelMetadata,omitempty"`
	// EmissionsGramsPerPax: Optional. Per-passenger emission estimate numbers.
	// Will not be present if emissions could not be computed. For the list of
	// reasons why emissions could not be computed, see ComputeFlightEmissions.
	EmissionsGramsPerPax *EmissionsGramsPerPax `json:"emissionsGramsPerPax,omitempty"`
	// Flight: Required. Matches the flight identifiers in the request. Note: all
	// IATA codes are capitalized.
	Flight *Flight `json:"flight,omitempty"`
	// Source: Optional. The source of the emissions data.
	//
	// Possible values:
	//   "SOURCE_UNSPECIFIED" - The source of the emissions data is unspecified.
	//   "TIM" - The emissions data is from the Travel Impact Model.
	//   "EASA" - The emissions data is from the EASA environmental labels.
	Source string `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContrailsImpactBucket") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContrailsImpactBucket") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FlightWithEmissions) MarshalJSON() ([]byte, error) {
	type NoMethod FlightWithEmissions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Market: A pair of airports.
type Market struct {
	// Destination: Required. IATA airport code for flight destination, e.g. "JFK".
	Destination string `json:"destination,omitempty"`
	// Origin: Required. IATA airport code for flight origin, e.g. "LHR".
	Origin string `json:"origin,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Destination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Destination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Market) MarshalJSON() ([]byte, error) {
	type NoMethod Market
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ModelVersion: Travel Impact Model version. For more information about the
// model versioning see GitHub
// (https://github.com/google/travel-impact-model/#versioning).
type ModelVersion struct {
	// Dated: Dated versions: Model datasets are recreated with refreshed input
	// data but no change to the algorithms regularly.
	Dated string `json:"dated,omitempty"`
	// Major: Major versions: Major changes to methodology (e.g. adding new data
	// sources to the model that lead to major output changes). Such changes will
	// be infrequent and announced well in advance. Might involve API version
	// changes, which will respect Google Cloud API guidelines
	// (https://cloud.google.com/endpoints/docs/openapi/versioning-an-api#backwards-incompatible)
	Major int64 `json:"major,omitempty"`
	// Minor: Minor versions: Changes to the model that, while being consistent
	// across schema versions, change the model parameters or implementation.
	Minor int64 `json:"minor,omitempty"`
	// Patch: Patch versions: Implementation changes meant to address bugs or
	// inaccuracies in the model implementation.
	Patch int64 `json:"patch,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dated") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dated") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ModelVersion) MarshalJSON() ([]byte, error) {
	type NoMethod ModelVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Scope3FlightEmissions: Scope 3 flight with emission estimates.
type Scope3FlightEmissions struct {
	// Flight: Required. Matches the flight identifiers in the request.
	Flight *Scope3FlightSegment `json:"flight,omitempty"`
	// Source: Optional. The source of the emissions data.
	//
	// Possible values:
	//   "SCOPE3_DATA_TYPE_UNSPECIFIED" - Unspecified data type.
	//   "TIM_EMISSIONS" - TIM-based emissions given origin, destination, carrier,
	// flight number, departure date, and year.
	//   "TYPICAL_FLIGHT_EMISSIONS" - Typical flight emissions given origin,
	// destination, and year.
	//   "DISTANCE_BASED_EMISSIONS" - Distance-based emissions based on the
	// distance traveled and year.
	Source string `json:"source,omitempty"`
	// TtwEmissionsGramsPerPax: Optional. Tank-to-wake flight emissions per
	// passenger based on the requested info.
	TtwEmissionsGramsPerPax int64 `json:"ttwEmissionsGramsPerPax,omitempty,string"`
	// WttEmissionsGramsPerPax: Optional. Well-to-tank flight emissions per
	// passenger based on the requested info.
	WttEmissionsGramsPerPax int64 `json:"wttEmissionsGramsPerPax,omitempty,string"`
	// WtwEmissionsGramsPerPax: Optional. Total flight emissions (sum of
	// well-to-tank and tank-to-wake) per passenger based on the requested info.
	// This is the total emissions and unless you have specific reasons for using
	// TTW or WTT emissions, you should use this number.
	WtwEmissionsGramsPerPax int64 `json:"wtwEmissionsGramsPerPax,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Flight") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flight") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Scope3FlightEmissions) MarshalJSON() ([]byte, error) {
	type NoMethod Scope3FlightEmissions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Scope3FlightSegment: Flight parameters with which the Scope 3 emissions are
// fetched.
type Scope3FlightSegment struct {
	// CabinClass: Required. The cabin class of the flight.
	//
	// Possible values:
	//   "CABIN_CLASS_UNSPECIFIED" - Unspecified cabin class.
	//   "ECONOMY" - Economy class.
	//   "PREMIUM_ECONOMY" - Premium economy class.
	//   "BUSINESS" - Business class.
	//   "FIRST" - First class.
	CabinClass string `json:"cabinClass,omitempty"`
	// CarrierCode: Optional. 2-character IATA carrier code
	// (https://www.iata.org/en/publications/directories/code-search/), e.g. `KE`.
	// This is required if specific flight matching is desired. Otherwise, this is
	// unused for typical flight and distance-based emissions models. This could be
	// both operating and marketing carrier code (i.e. codeshare is covered).
	CarrierCode string `json:"carrierCode,omitempty"`
	// DepartureDate: Required. Date of the flight in the time zone of the origin
	// airport. Only year is required for typical flight and distance-based
	// emissions models (month and day values are ignored and therefore, can be
	// either omitted, set to 0, or set to a valid date for those cases).
	// Correspondingly, if a specific date is not provided for TIM emissions, we
	// will fallback to typical flight (or distance-based) emissions.
	DepartureDate *Date `json:"departureDate,omitempty"`
	// Destination: Optional. 3-character IATA airport code
	// (https://www.iata.org/en/publications/directories/code-search/) for flight
	// destination, e.g. `ICN`. This is used to match specific flight if provided
	// alongside origin, carrier, and flight number. If there is no match, we will
	// first try to match the flight to a typical flight between the provided
	// origin and destination airports. Otherwise, we will use the distance-based
	// emissions model if the flight distance is provided.
	Destination string `json:"destination,omitempty"`
	// DistanceKm: Optional. Distance in kilometers, e.g. `2423`, from [1, 2.5e16)
	// km. This is used to match a flight to distance-based emissions when origin
	// and destination are not provided or there are no matching typical flights.
	DistanceKm int64 `json:"distanceKm,omitempty,string"`
	// FlightNumber: Optional. Up to 4-digit flight number
	// (https://en.wikipedia.org/wiki/Flight_number), e.g. `71`, from [1, 9999].
	// This is first used to match a specific flight if a flight number is
	// specified alongside origin, destination, and carrier. If a flight number is
	// not specified, we will first try to match the flight to a typical flight
	// between the provided origin and destination airports. If that fails and/or
	// origin & destination are not provided, we will use the distance-based
	// emissions model based on the flight distance provided.
	FlightNumber int64 `json:"flightNumber,omitempty"`
	// Origin: Optional. 3-character IATA airport code
	// (https://www.iata.org/en/publications/directories/code-search/) for flight
	// origin, e.g. `YVR`. This is used to match specific flight if provided
	// alongside destination, carrier, and flight number. If there is no match, we
	// will first try to match the flight to a typical flight between the provided
	// origin and destination airports. Otherwise, we will use the distance-based
	// emissions model if the flight distance is provided.
	Origin string `json:"origin,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CabinClass") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CabinClass") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Scope3FlightSegment) MarshalJSON() ([]byte, error) {
	type NoMethod Scope3FlightSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TypicalFlightEmissions: Typical flight emission estimates for a certain
// market
type TypicalFlightEmissions struct {
	// EmissionsGramsPerPax: Optional. Typical flight emissions per passenger for
	// requested market. Will not be present if a typical emissions could not be
	// computed. For the list of reasons why typical flight emissions could not be
	// computed, see GitHub
	// (https://github.com/google/travel-impact-model/blob/main/projects/typical_flight_emissions.md#step-7-validate-dataset).
	EmissionsGramsPerPax *EmissionsGramsPerPax `json:"emissionsGramsPerPax,omitempty"`
	// Market: Required. Matches the flight identifiers in the request. Note: all
	// IATA codes are capitalized.
	Market *Market `json:"market,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EmissionsGramsPerPax") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EmissionsGramsPerPax") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TypicalFlightEmissions) MarshalJSON() ([]byte, error) {
	type NoMethod TypicalFlightEmissions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type FlightsComputeFlightEmissionsCall struct {
	s                             *Service
	computeflightemissionsrequest *ComputeFlightEmissionsRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// ComputeFlightEmissions: Stateless method to retrieve emission estimates.
// Details on how emission estimates are computed are in GitHub
// (https://github.com/google/travel-impact-model) The response will contain
// all entries that match the input flight legs, in the same order. If there
// are no estimates available for a certain flight leg, the response will
// return the flight leg object with empty emission fields. The request will
// still be considered successful. Reasons for missing emission estimates
// include: * The flight is unknown to the server. * The input flight leg is
// missing one or more identifiers. * The flight date is in the past. * The
// aircraft type is not supported by the model. * Missing seat configuration.
// The request can contain up to 1000 flight legs. If the request has more than
// 1000 direct flights, if will fail with an INVALID_ARGUMENT error.
func (r *FlightsService) ComputeFlightEmissions(computeflightemissionsrequest *ComputeFlightEmissionsRequest) *FlightsComputeFlightEmissionsCall {
	c := &FlightsComputeFlightEmissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.computeflightemissionsrequest = computeflightemissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FlightsComputeFlightEmissionsCall) Fields(s ...googleapi.Field) *FlightsComputeFlightEmissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FlightsComputeFlightEmissionsCall) Context(ctx context.Context) *FlightsComputeFlightEmissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FlightsComputeFlightEmissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FlightsComputeFlightEmissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.computeflightemissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/flights:computeFlightEmissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "travelimpactmodel.flights.computeFlightEmissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "travelimpactmodel.flights.computeFlightEmissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *ComputeFlightEmissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FlightsComputeFlightEmissionsCall) Do(opts ...googleapi.CallOption) (*ComputeFlightEmissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ComputeFlightEmissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "travelimpactmodel.flights.computeFlightEmissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FlightsComputeScope3FlightEmissionsCall struct {
	s                                   *Service
	computescope3flightemissionsrequest *ComputeScope3FlightEmissionsRequest
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// ComputeScope3FlightEmissions: Stateless method to retrieve GHG emissions
// estimates for a set of flight segments for Scope 3 reporting. The response
// will contain all entries that match the input Scope3FlightSegment flight
// segments, in the same order provided. The estimates will be computed using
// the following cascading logic (using the first one that is available): 1.
// TIM-based emissions given origin, destination, carrier, flightNumber,
// departureDate, and cabinClass. 2. Typical flight emissions given origin,
// destination, year in departureDate, and cabinClass. 3. Distance-based
// emissions calculated using distanceKm, year in departureDate, and
// cabinClass. If there is a future flight requested in this calendar year, we
// do not support Tier 1 emissions and will fallback to Tier 2 or 3 emissions.
// If the requested future flight is in not in this calendar year, we will
// return an empty response. We recommend that for future flights,
// computeFlightEmissions API is used instead. If there are no estimates
// available for a certain flight with any of the three methods, the response
// will return a Scope3FlightEmissions object with empty emission fields. The
// request will still be considered successful. Generally, missing emissions
// estimates occur when the flight is unknown to the server (e.g. no specific
// flight exists, or typical flight emissions are not available for the
// requested pair). The request will fail with an `INVALID_ARGUMENT` error if:
// * The request contains more than 1,000 flight legs. * The input flight leg
// is missing one or more identifiers. For example, missing origin/destination
// without a valid distance for TIM_EMISSIONS or TYPICAL_FLIGHT_EMISSIONS type
// matching, or missing distance for a DISTANCE_BASED_EMISSIONS type matching
// (if you want to fallback to distance-based emissions or want a
// distance-based emissions estimate, you need to specify a distance). * The
// flight date is before 2019 (Scope 3 data is only available for 2019 and
// after). * The flight distance is 0 or lower. * Missing cabin class. Because
// the request is processed with fallback logic, it is possible that
// misconfigured requests return valid emissions estimates using fallback
// methods. For example, if a request has the wrong flight number but specifies
// the origin and destination, the request will still succeed, but the returned
// emissions will be based solely on the typical flight emissions. Similarly,
// if a request is missing the origin for a typical flight emissions request,
// but specifies a valid distance, the request could succeed based solely on
// the distance-based emissions. Consequently, one should check the source of
// the returned emissions (source) to confirm the results are as expected.
func (r *FlightsService) ComputeScope3FlightEmissions(computescope3flightemissionsrequest *ComputeScope3FlightEmissionsRequest) *FlightsComputeScope3FlightEmissionsCall {
	c := &FlightsComputeScope3FlightEmissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.computescope3flightemissionsrequest = computescope3flightemissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FlightsComputeScope3FlightEmissionsCall) Fields(s ...googleapi.Field) *FlightsComputeScope3FlightEmissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FlightsComputeScope3FlightEmissionsCall) Context(ctx context.Context) *FlightsComputeScope3FlightEmissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FlightsComputeScope3FlightEmissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FlightsComputeScope3FlightEmissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.computescope3flightemissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/flights:computeScope3FlightEmissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "travelimpactmodel.flights.computeScope3FlightEmissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "travelimpactmodel.flights.computeScope3FlightEmissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *ComputeScope3FlightEmissionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FlightsComputeScope3FlightEmissionsCall) Do(opts ...googleapi.CallOption) (*ComputeScope3FlightEmissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ComputeScope3FlightEmissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "travelimpactmodel.flights.computeScope3FlightEmissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FlightsComputeTypicalFlightEmissionsCall struct {
	s                                    *Service
	computetypicalflightemissionsrequest *ComputeTypicalFlightEmissionsRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// ComputeTypicalFlightEmissions: Retrieves typical flight emissions estimates
// between two airports, also known as a market. If there are no estimates
// available for a certain market, the response will return the market object
// with empty emission fields. The request will still be considered successful.
// Details on how the typical emissions estimates are computed are on GitHub
// (https://github.com/google/travel-impact-model/blob/main/projects/typical_flight_emissions.md).
// The request can contain up to 1000 markets. If the request has more than
// 1000 markets, it will fail with an INVALID_ARGUMENT error.
func (r *FlightsService) ComputeTypicalFlightEmissions(computetypicalflightemissionsrequest *ComputeTypicalFlightEmissionsRequest) *FlightsComputeTypicalFlightEmissionsCall {
	c := &FlightsComputeTypicalFlightEmissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.computetypicalflightemissionsrequest = computetypicalflightemissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FlightsComputeTypicalFlightEmissionsCall) Fields(s ...googleapi.Field) *FlightsComputeTypicalFlightEmissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FlightsComputeTypicalFlightEmissionsCall) Context(ctx context.Context) *FlightsComputeTypicalFlightEmissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FlightsComputeTypicalFlightEmissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FlightsComputeTypicalFlightEmissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.computetypicalflightemissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/flights:computeTypicalFlightEmissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "travelimpactmodel.flights.computeTypicalFlightEmissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "travelimpactmodel.flights.computeTypicalFlightEmissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *ComputeTypicalFlightEmissionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FlightsComputeTypicalFlightEmissionsCall) Do(opts ...googleapi.CallOption) (*ComputeTypicalFlightEmissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ComputeTypicalFlightEmissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "travelimpactmodel.flights.computeTypicalFlightEmissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
