// Code generated by smithy-go-codegen DO NOT EDIT.

package kinesis

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/kinesis/types"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the warm throughput configuration for the specified Amazon Kinesis Data
// Streams on-demand data stream. This operation allows you to proactively scale
// your on-demand data stream to a specified throughput level, enabling better
// performance for sudden traffic spikes.
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input
// parameter when you invoke this API.
//
// Updating the warm throughput is an asynchronous operation. Upon receiving the
// request, Kinesis Data Streams returns immediately and sets the status of the
// stream to UPDATING . After the update is complete, Kinesis Data Streams sets the
// status of the stream back to ACTIVE . Depending on the size of the stream, the
// scaling action could take a few minutes to complete. You can continue to read
// and write data to your stream while its status is UPDATING .
//
// This operation is only supported for data streams with the on-demand capacity
// mode in accounts that have MinimumThroughputBillingCommitment enabled.
// Provisioned capacity mode streams do not support warm throughput configuration.
//
// This operation has the following default limits. By default, you cannot do the
// following:
//
//   - Scale to more than 10 GiBps for an on-demand stream.
//
//   - This API has a call limit of 5 transactions per second (TPS) for each
//     Amazon Web Services account. TPS over 5 will initiate the
//     LimitExceededException .
//
// For the default limits for an Amazon Web Services account, see [Streams Limits] in the Amazon
// Kinesis Data Streams Developer Guide. To request an increase in the call rate
// limit, the shard limit for this API, or your overall shard limit, use the [limits form].
//
// [limits form]: https://console.aws.amazon.com/support/v1#/case/create?issueType=service-limit-increase&limitType=service-code-kinesis
// [Streams Limits]: https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html
func (c *Client) UpdateStreamWarmThroughput(ctx context.Context, params *UpdateStreamWarmThroughputInput, optFns ...func(*Options)) (*UpdateStreamWarmThroughputOutput, error) {
	if params == nil {
		params = &UpdateStreamWarmThroughputInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateStreamWarmThroughput", params, optFns, c.addOperationUpdateStreamWarmThroughputMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateStreamWarmThroughputOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateStreamWarmThroughputInput struct {

	// The target warm throughput in MB/s that the stream should be scaled to handle.
	// This represents the throughput capacity that will be immediately available for
	// write operations.
	//
	// This member is required.
	WarmThroughputMiBps *int32

	// The ARN of the stream to be updated.
	StreamARN *string

	// The name of the stream to be updated.
	StreamName *string

	noSmithyDocumentSerde
}

func (in *UpdateStreamWarmThroughputInput) bindEndpointParams(p *EndpointParameters) {

	p.StreamARN = in.StreamARN
	p.OperationType = ptr.String("control")
}

type UpdateStreamWarmThroughputOutput struct {

	// The ARN of the stream that was updated.
	StreamARN *string

	// The name of the stream that was updated.
	StreamName *string

	// Specifies the updated warm throughput configuration for your data stream.
	WarmThroughput *types.WarmThroughputObject

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateStreamWarmThroughputMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateStreamWarmThroughput{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateStreamWarmThroughput{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateStreamWarmThroughput"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateStreamWarmThroughputValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateStreamWarmThroughput(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateStreamWarmThroughput(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateStreamWarmThroughput",
	}
}
